/*
 * (C) Copyright Keith Visco 1998  All rights reserved.
 *
 * The software is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by 
 * you as a result of using the software. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or 
 * lost profits even if the Copyright owner has been advised of the 
 * possibility of their occurrence.  
 */
package com.kvisco.xsl;

import java.io.PrintWriter;
import java.util.Hashtable;
import com.kvisco.util.List;
import org.w3c.dom.*;

/**
 * Represents an XSLIf Object (xsl:if)
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class XSLOtherwise extends XSLObject 
    implements Conditional {
    
    /**
     * Creates a new XSLOtherwise object
    **/
    public XSLOtherwise(XSLStylesheet parentStylesheet) {
        super(parentStylesheet,XSLObject.OTHERWISE);
    } //-- XSLOtherwise        
        
    public BooleanResult evaluate(Node context, ProcessorState ps) 
        throws InvalidExprException 
    {
        return BooleanResult.TRUE_RESULT;
    } //-- evaluate
    
    
} //-- XSLOtherwise