/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The contents of this file are released under an Open Source 
 * Definition (OSD) compliant license; you may not use this file 
 * execpt in compliance with the license. Please see license.txt, 
 * distributed with this file. You may also obtain a copy of the
 * license at http://www.clc-marketing.com/xslp/license.txt
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 *
 * 
 */

package com.kvisco.xsl;

import com.kvisco.xml.HTMLPrinter;
import java.util.Hashtable;
import java.io.PrintWriter;
import org.w3c.dom.*;

/**
 * This class simply prints out the result tree as HTML and 
 * will not perform any special formatting for FOs.
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public class BasicHTMLFormatter extends Formatter {

    
      //----------------/
     //- Constructors -/
    //----------------/
    
    /**
     * Creates a new BasicHTMLFormatter
    **/
    public BasicHTMLFormatter() {
        super();
    } //-- DefaultFormatter

      //------------------/
     //- Public Methods -/
    //------------------/
    
    /**
     * Defined by Formatter. Processes the given set of nodes.
     * @param nodeList the set of nodes to process
     * @param output the PrintStream for IO during processing.
     * @see org.w3c.dom.NodeList
    **/
    public void process(Document document, PrintWriter output) {

        if (document == null) return;
        
        //-- Performance Testing
        //long stime = System.currentTimeMillis();
        
        HTMLPrinter printer = new HTMLPrinter(output);
        printer.setUnescapeCDATA(true);
        printer.setUseFormat(getIndentResult());
        printer.setUseEmptyElementShorthand(false);
        printer.setIndentSize(getIndentSize());
        printer.print(document.getDocumentElement());
        //-- Performance Testing
        //long etime = System.currentTimeMillis();
        //System.out.println("Formatter Time: " + (etime-stime) + "(ms)");
    } //-- process

} //-- BasicHTMLFormatter