/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.net.URIUtils;
import com.kvisco.util.List;
import com.kvisco.xml.parser.DOMPackage;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.NodeSet;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.XSLObject;
import com.kvisco.xsl.functions.FunctionCall;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DocumentFunctionCall
extends FunctionCall {
    public DocumentFunctionCall() {
        super("document");
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        if (list.size() < 1 || list.size() > 2) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        ExprResult exprResult = ((Expr)list.get(0)).evaluate(node, processorState);
        NodeSet nodeSet = new NodeSet();
        switch (exprResult.getResultType()) {
            case 2: {
                NodeSet nodeSet2 = (NodeSet)exprResult;
                int n = 0;
                while (n < nodeSet2.size()) {
                    String string = XSLObject.getNodeValue(nodeSet2.get(n));
                    Document document = this.getDocument(string, processorState);
                    if (document != null) {
                        nodeSet.add(document);
                    }
                    ++n;
                }
                break;
            }
            default: {
                String string = StringExpr.toStringResult(exprResult).toString();
                Document document = this.getDocument(string, processorState);
                if (document == null) break;
                nodeSet.add(document);
            }
        }
        return nodeSet;
    }

    private Document getDocument(String string, ProcessorState processorState) {
        if (string == null || string.length() == 0) {
            string = processorState.getStylesheetHref();
        }
        InputStream inputStream = null;
        try {
            inputStream = URIUtils.getInputStream(string, "");
        }
        catch (Exception exception) {
            return null;
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        DOMPackage dOMPackage = processorState.getDOMPackage();
        PrintWriter printWriter = new PrintWriter(System.out, true);
        return dOMPackage.readDocument(inputStreamReader, string, printWriter);
    }
}

