/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl;

import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import org.w3c.dom.Node;

public class OrExpr
implements Expr {
    private static String OR = " or ";
    private static String NULL = "null";
    private Expr leftExpr = null;
    private Expr rightExpr = null;

    public OrExpr(Expr expr, Expr expr2) {
        this.leftExpr = expr;
        this.rightExpr = expr2;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        ExprResult exprResult = null;
        if (this.leftExpr != null && (exprResult = this.leftExpr.evaluate(node, processorState)).booleanValue()) {
            return BooleanResult.TRUE_RESULT;
        }
        if (this.rightExpr != null && (exprResult = this.rightExpr.evaluate(node, processorState)).booleanValue()) {
            return BooleanResult.TRUE_RESULT;
        }
        return BooleanResult.FALSE_RESULT;
    }

    public short getExprType() {
        return 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.leftExpr != null) {
            stringBuffer.append(this.leftExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        stringBuffer.append(OR);
        if (this.rightExpr != null) {
            stringBuffer.append(this.rightExpr.toString());
        } else {
            stringBuffer.append(NULL);
        }
        return stringBuffer.toString();
    }
}

