/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.util;

import com.kvisco.util.List;

public class Tokenizer {
    public static final String[] DEFAULT_DELIMITERS = new String[]{" ", "\n", "\r", "\t"};
    private String[] delimiters;
    protected List tokens = new List();
    private int currentIndex = 0;
    private String ntoken = null;

    public Tokenizer(String string) {
        this.delimiters = DEFAULT_DELIMITERS;
        this.parsePattern(string);
    }

    public Tokenizer(String string, String[] stringArray) {
        this.delimiters = stringArray;
        this.parsePattern(string);
    }

    public void advance(int n) {
        int n2 = this.currentIndex + n;
        this.currentIndex = n2 >= 0 && n2 < this.tokens.size() ? n2 : this.tokens.size();
    }

    public int countTokens() {
        return this.tokens.size() - this.currentIndex;
    }

    public int getPosition() {
        return this.currentIndex;
    }

    public boolean hasMoreTokens() {
        return this.countTokens() > 0;
    }

    public boolean hasToken(String string) {
        return this.tokens.contains(string);
    }

    private int indexOfNearestToken(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < this.delimiters.length) {
            String string3 = this.delimiters[n2];
            int n3 = string.indexOf(string3);
            if (n3 >= 0) {
                if (n < 0 || n3 < n) {
                    n = n3;
                    string2 = string3;
                } else if (n3 == n && string3.length() > string2.length()) {
                    string2 = string3;
                }
            }
            ++n2;
        }
        this.ntoken = string2;
        return n;
    }

    public boolean isDelimiter(String string) {
        if (string != null) {
            int n = 0;
            while (n < this.delimiters.length) {
                if (string.equals(this.delimiters[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String lookAhead(int n) {
        int n2 = this.currentIndex + n;
        if (n2 >= 0 && n2 < this.tokens.size()) {
            return (String)this.tokens.get(n2);
        }
        return null;
    }

    public String nextToken() {
        if (this.currentIndex < this.tokens.size()) {
            return (String)this.tokens.get(this.currentIndex++);
        }
        return null;
    }

    private void parsePattern(String string) {
        if (string == null) {
            return;
        }
        int n = -1;
        while ((n = this.indexOfNearestToken(string)) >= 0) {
            if (n != 0) {
                this.tokens.add(string.substring(0, n));
            }
            this.tokens.add(this.ntoken);
            string = string.substring(n + this.ntoken.length());
        }
        if (string.length() > 0) {
            this.tokens.add(string);
        }
    }

    public String previousToken() {
        if (this.currentIndex > 0) {
            return (String)this.tokens.get(--this.currentIndex);
        }
        return null;
    }

    public void resetPosition() {
        this.currentIndex = 0;
    }

    public void setPosition(int n) {
        this.currentIndex = n >= 0 && n < this.tokens.size() ? n : (n < 0 ? 0 : this.tokens.size());
    }

    protected void setTokens(List list) {
        this.currentIndex = 0;
        this.tokens = list;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.tokens.size()) {
            stringBuffer.append(this.tokens.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }
}

