/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.source.holders;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.openxml.source.Source;
import org.openxml.source.holders.HolderImpl;

final class FileHolderImpl
extends HolderImpl {
    private long _lastModified;
    protected File _file;

    FileHolderImpl(File file, String string, Class clazz) throws IOException {
        super(file.toString(), string, clazz);
        int n;
        if (file == null || !file.exists() || !file.canRead()) {
            throw new IOException("Cannot access the source file '" + file.toString() + "'.");
        }
        this._file = file;
        this._uri = file.toString();
        this._lastModified = this._file.lastModified();
        if (this._docClass == null && (n = this._uri.lastIndexOf(46)) > 0) {
            String string2 = this._uri.substring(n);
            if (string2.equalsIgnoreCase(".htm") || string2.equalsIgnoreCase(".html")) {
                this._docClass = Source.DOCUMENT_HTML;
            } else if (string2.equalsIgnoreCase(".xml") || string2.equalsIgnoreCase(".dom")) {
                this._docClass = Source.DOCUMENT_XML;
            }
            if (string2.equalsIgnoreCase(".dtd")) {
                this._docClass = Source.DOCUMENT_DTD;
            }
        }
    }

    public boolean canCache() {
        return true;
    }

    public Reader getReader() throws IOException {
        return new BufferedReader(new FileReader(this._file));
    }

    public String getURI() {
        return this._file.toString();
    }

    public boolean hasModified() {
        try {
            return this._file.lastModified() > this._lastModified;
        }
        catch (Exception exception) {
            return true;
        }
    }
}

