/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public final class XMLStreamWriter
extends OutputStreamWriter {
    private char[] _buffer = new char[2048];
    private int _index = 0;
    private static final int BUFFER_SIZE = 2048;

    public XMLStreamWriter(OutputStream outputStream) throws IOException {
        this(outputStream, "UTF8");
    }

    public XMLStreamWriter(OutputStream outputStream, String string) throws IOException, UnsupportedEncodingException {
        super(outputStream, string != null ? string : "UTF8");
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            super.close();
            this._buffer = null;
        }
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this._index != 0) {
                super.write(this._buffer, 0, this._index);
                this._index = 0;
            }
            super.flush();
        }
    }

    public void newLine() throws IOException {
        this.write("\n");
    }

    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this._index >= 2048) {
                this.flush();
            }
            this._buffer[this._index++] = (char)n;
        }
    }

    public void write(String string, int n, int n2) throws IOException {
        this.write(string.toCharArray(), n, n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (n < 0) throw new IndexOutOfBoundsException("Index out of bounds.");
            if (n2 < 0) throw new IndexOutOfBoundsException("Index out of bounds.");
            if (n + n2 > cArray.length) {
                throw new IndexOutOfBoundsException("Index out of bounds.");
            }
            while (true) {
                if (n2 <= 0) {
                    return;
                }
                int n3 = n2;
                if (n3 > 2048 - this._index) {
                    n3 = 2048 - this._index;
                }
                System.arraycopy(cArray, n, this._buffer, this._index, n3);
                n += n3;
                n2 -= n3;
                this._index += n3;
                if (this._index != 2048) continue;
                this.flush();
            }
        }
    }
}

