/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentImpl;
import org.openxml.dom.ProcessingInstructionImpl;
import org.openxml.dom.iterator.InnerIterator;
import org.openxml.dom.iterator.NodeIteratorImpl;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.fi.NodeEx;
import org.w3c.dom.fi.NodeFilter;
import org.w3c.dom.fi.NodeIterator;

public abstract class NodeImpl
implements Node,
NodeEx,
Cloneable {
    public static final short ELEMENT_DECL_NODE = 13;
    public static final short ATTLIST_DECL_NODE = 14;
    public static final short PARAM_ENTITY_NODE = 15;
    NodeImpl _nextNode;
    NodeImpl _prevNode;
    NodeImpl _parent;
    DocumentImpl _ownerDocument;
    private String _nodeName;
    private String _nodeValue;
    private NodeImpl _firstChild;
    private NodeImpl _lastChild;
    private int _childsCount;
    private boolean _readOnly;
    private InnerIterator[] _iterators;

    protected NodeImpl(DocumentImpl documentImpl, String string, String string2, boolean bl) throws DOMException {
        if (string == null) {
            throw new NullPointerException("Argument 'name' is null.");
        }
        this._nodeName = string;
        this._ownerDocument = documentImpl;
        if (bl && string.length() > 0) {
            char c = string.charAt(0);
            if (!Character.isLetter(c) && c != '_' && c != ':') {
                throw new DOMExceptionImpl(5);
            }
            int n = 1;
            while (n < string.length()) {
                c = string.charAt(1);
                if (!Character.isLetterOrDigit(c) && c != '_' && c != ':' && c != '-' && c != '.') {
                    throw new DOMExceptionImpl(5);
                }
                ++n;
            }
        }
        if (string2 != null) {
            this.setNodeValue(string2);
        }
    }

    public final synchronized Node appendChild(Node node) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (!this.supportsChildern()) {
            throw new DOMExceptionImpl(3, "No childern supported by this node type.");
        }
        NodeImpl nodeImpl = this.castNewChild(node);
        Node node2 = node;
        synchronized (node2) {
            if (nodeImpl._parent != null) {
                if (nodeImpl._parent.isReadOnly()) {
                    throw new DOMExceptionImpl(7);
                }
                nodeImpl._parent.removeChild(nodeImpl);
            }
            if (nodeImpl instanceof DocumentFragment) {
                nodeImpl = nodeImpl._firstChild;
                while (nodeImpl != null) {
                    NodeImpl nodeImpl2 = nodeImpl._nextNode;
                    this.appendChild(nodeImpl);
                    nodeImpl = nodeImpl2;
                }
                Node node3 = node;
                Object var5_6 = null;
                return node3;
            }
            nodeImpl._parent = this;
            if (this._ownerDocument != null) {
                nodeImpl.setOwnerDocument(this._ownerDocument);
            }
            if (this._lastChild == null) {
                this._lastChild = nodeImpl;
                this._firstChild = nodeImpl;
                nodeImpl._prevNode = null;
                nodeImpl._nextNode = null;
            } else {
                this._lastChild._nextNode = nodeImpl;
                nodeImpl._prevNode = this._lastChild;
                nodeImpl._nextNode = null;
                this._lastChild = nodeImpl;
            }
            ++this._childsCount;
        }
        return node;
    }

    protected NodeImpl castNewChild(Node node) throws DOMException {
        if (node == null) {
            throw new DOMExceptionImpl(3, "Child reference is null.");
        }
        if (!(node instanceof NodeImpl)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        if (!(node instanceof Element || node instanceof CharacterData || node instanceof DocumentFragment || node instanceof EntityReference || node instanceof ProcessingInstructionImpl)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        return (NodeImpl)node;
    }

    protected final NodeImpl castOldChild(Node node) throws DOMException {
        if (node == null || !(node instanceof NodeImpl) || ((NodeImpl)node)._parent != this) {
            throw new DOMExceptionImpl(8, "Not a direct child of this node.");
        }
        return (NodeImpl)node;
    }

    protected synchronized void cloneInto(NodeImpl nodeImpl, boolean bl) {
        if (this.getClass() != nodeImpl.getClass()) {
            throw new IllegalArgumentException("Argument 'into' not same type as this node.");
        }
        nodeImpl._nodeName = this._nodeName;
        nodeImpl._nodeValue = this._nodeValue;
        nodeImpl._ownerDocument = this._ownerDocument;
        if (bl) {
            Node node = this.getFirstChild();
            while (node != null) {
                nodeImpl.appendChild(node.cloneNode(true));
                node = node.getNextSibling();
            }
        }
    }

    public abstract Node cloneNode(boolean var1);

    public synchronized NodeIterator createNodeIterator(boolean bl, int n, NodeFilter nodeFilter) {
        NodeIteratorImpl nodeIteratorImpl = new NodeIteratorImpl(this, bl, n, nodeFilter);
        InnerIterator innerIterator = nodeIteratorImpl.asInnerIterator();
        if (this._iterators == null) {
            this._iterators = new InnerIterator[1];
            this._iterators[0] = innerIterator;
        } else {
            int n2 = this._iterators.length;
            while (n2-- > 0) {
                if (this._iterators[n2] == innerIterator) break;
            }
            if (n2 < 0) {
                InnerIterator[] innerIteratorArray = new InnerIterator[this._iterators.length + 1];
                System.arraycopy(this._iterators, 0, innerIteratorArray, 0, this._iterators.length);
                innerIteratorArray[this._iterators.length] = innerIterator;
                this._iterators = innerIteratorArray;
            }
        }
        return nodeIteratorImpl;
    }

    public NodeIterator createTreeIterator(int n, NodeFilter nodeFilter) {
        return this.createNodeIterator(true, n, nodeFilter);
    }

    public synchronized boolean equals(Object object) {
        boolean bl;
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof NodeImpl) || object.getClass() != this.getClass()) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            NodeImpl nodeImpl = (NodeImpl)object;
            bl = this._nodeName.equals(nodeImpl._nodeName);
            if (bl) {
                String string = this.getNodeValue();
                String string2 = nodeImpl.getNodeValue();
                bl = string != null && string2 != null ? string.equals(string2) : string == null && string2 == null;
            }
            boolean bl2 = bl = this._childsCount == nodeImpl._childsCount;
            if (bl) {
                Node node = this.getFirstChild();
                Node node2 = nodeImpl.getFirstChild();
                while (bl && node != null && node2 != null) {
                    bl = node.equals(node2);
                    node = node.getNextSibling();
                    node2 = node2.getNextSibling();
                }
                if (bl) {
                    bl = node == null && node2 == null;
                }
            }
        }
        return bl;
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    final synchronized NodeImpl getChild(int n) {
        if (n < 0 || n > this._childsCount) {
            return null;
        }
        Node node = this.getFirstChild();
        while (node != null && n > 0) {
            node = node.getNextSibling();
            --n;
        }
        return (NodeImpl)node;
    }

    final int getChildCount() {
        return this._childsCount;
    }

    public final NodeList getChildNodes() {
        if (!this.supportsChildern()) {
            throw new DOMExceptionImpl(3, "No childern supported by this node type.");
        }
        return (NodeList)((Object)this.createNodeIterator(false, 65535, null));
    }

    public final Node getFirstChild() {
        return this._firstChild;
    }

    public final Node getLastChild() {
        return this._lastChild;
    }

    public Node getNextSibling() {
        return this._nextNode;
    }

    public final String getNodeName() {
        return this._nodeName;
    }

    public abstract short getNodeType();

    public final String getNodeValue() {
        return this._nodeValue;
    }

    public final Document getOwnerDocument() {
        if (this._ownerDocument != this) {
            return this._ownerDocument;
        }
        return null;
    }

    public Node getParentNode() {
        return this._parent;
    }

    public Node getPreviousSibling() {
        return this._prevNode;
    }

    public final boolean hasChildNodes() {
        return this._firstChild != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (!this.supportsChildern()) {
            throw new DOMExceptionImpl(3, "No childern supported by this node type.");
        }
        if (node2 == null) {
            return this.appendChild(node);
        }
        NodeImpl nodeImpl = this.castNewChild(node);
        NodeImpl nodeImpl2 = this.castOldChild(node2);
        Node node3 = node;
        synchronized (node3) {
            Node node4 = node2;
            synchronized (node4) {
                if (nodeImpl._parent != null) {
                    if (nodeImpl._parent.isReadOnly()) {
                        throw new DOMExceptionImpl(7);
                    }
                    nodeImpl._parent.removeChild(nodeImpl);
                }
                if (nodeImpl instanceof DocumentFragment) {
                    nodeImpl = nodeImpl._firstChild;
                    while (nodeImpl != null) {
                        NodeImpl nodeImpl3 = nodeImpl._nextNode;
                        this.insertBefore(nodeImpl, node2);
                        nodeImpl = nodeImpl3;
                    }
                    return node;
                }
                nodeImpl._parent = this;
                nodeImpl.setOwnerDocument(this._ownerDocument);
                if (this._firstChild == nodeImpl2) {
                    this._firstChild = nodeImpl;
                }
                if (nodeImpl2._prevNode != null) {
                    nodeImpl._prevNode = nodeImpl2._prevNode;
                    nodeImpl2._prevNode._nextNode = nodeImpl;
                }
                nodeImpl2._prevNode = nodeImpl;
                nodeImpl._nextNode = nodeImpl2;
                ++this._childsCount;
            }
            return node;
        }
    }

    public final boolean isReadOnly() {
        return this._readOnly;
    }

    public final synchronized void makeReadOnly() {
        this._readOnly = true;
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        while (nodeImpl != null) {
            nodeImpl.makeReadOnly();
            nodeImpl = (NodeImpl)nodeImpl.getNextSibling();
        }
    }

    protected void notifyIterators(Node node) {
        NodeImpl nodeImpl = this;
        while (nodeImpl != null) {
            if (nodeImpl._iterators != null) {
                int n = nodeImpl._iterators.length;
                while (n-- > 0) {
                    nodeImpl._iterators[n].removeNode(node);
                }
            }
            nodeImpl = nodeImpl._parent;
        }
    }

    public final synchronized Node removeChild(Node node) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (!this.supportsChildern()) {
            throw new DOMExceptionImpl(3, "No childern supported by this node type.");
        }
        NodeImpl nodeImpl = this.castOldChild(node);
        Node node2 = node;
        synchronized (node2) {
            this.notifyIterators(node);
            nodeImpl._parent = null;
            if (this._firstChild == nodeImpl) {
                this._firstChild = nodeImpl._nextNode;
            }
            if (this._lastChild == nodeImpl) {
                this._lastChild = nodeImpl._prevNode;
            }
            if (nodeImpl._prevNode != null) {
                nodeImpl._prevNode._nextNode = nodeImpl._nextNode;
            }
            if (nodeImpl._nextNode != null) {
                nodeImpl._nextNode._prevNode = nodeImpl._prevNode;
            }
            nodeImpl._prevNode = null;
            nodeImpl._nextNode = null;
            --this._childsCount;
        }
        return node;
    }

    public synchronized void removeInnerIterator(InnerIterator innerIterator) {
        int n = this._iterators.length;
        while (n-- > 0) {
            if (this._iterators[n] != innerIterator) continue;
            InnerIterator[] innerIteratorArray = new InnerIterator[this._iterators.length - 1];
            if (n > 0) {
                System.arraycopy(this._iterators, 0, innerIteratorArray, 0, n);
            }
            if (n < innerIteratorArray.length) {
                System.arraycopy(this._iterators, n + 1, innerIteratorArray, n, innerIteratorArray.length - n);
            }
            this._iterators = innerIteratorArray;
            return;
        }
    }

    public final synchronized Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (!this.supportsChildern()) {
            throw new DOMExceptionImpl(3, "No childern supported by this node type.");
        }
        if (node != null) {
            NodeImpl nodeImpl = this.castNewChild(node);
        }
        NodeImpl nodeImpl = this.castOldChild(node2);
        Node node3 = node2;
        synchronized (node3) {
            if (node != null) {
                Node node4 = node;
                synchronized (node4) {
                    this.insertBefore(node, node2);
                    this.removeChild(node2);
                }
            } else {
                this.removeChild(node2);
            }
        }
        return node2;
    }

    public void setNodeValue(String string) {
        if (this.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        this._nodeValue = string == null ? "" : string;
    }

    protected synchronized void setOwnerDocument(Document document) {
        if (document == null) {
            this._ownerDocument = null;
        } else {
            if (!(document instanceof DocumentImpl)) {
                throw new IllegalArgumentException("Argument 'owner' not of compatible DOM class.");
            }
            this._ownerDocument = (DocumentImpl)document;
        }
        Node node = this.getFirstChild();
        while (node != null) {
            ((NodeImpl)node).setOwnerDocument(document);
            node = node.getNextSibling();
        }
    }

    boolean supportsChildern() {
        return false;
    }
}

