/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import java.util.Dictionary;
import java.util.Enumeration;
import org.openxml.dom.AttlistDecl;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.ElementDeclImpl;
import org.openxml.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;

public final class NamedNodeMapImpl
implements NamedNodeMap {
    private Dictionary _dictionary;
    private NodeImpl _owner;

    NamedNodeMapImpl(NodeImpl nodeImpl, Dictionary dictionary) {
        if (nodeImpl == null || dictionary == null) {
            throw new NullPointerException("Argument 'owner' or 'dictionary' is null.");
        }
        this._dictionary = dictionary;
        this._owner = nodeImpl;
    }

    Enumeration elements() {
        return this._dictionary.elements();
    }

    public int getLength() {
        return this._dictionary.size();
    }

    public synchronized Node getNamedItem(String string) {
        return (Node)this._dictionary.get(string);
    }

    public synchronized Node item(int n) {
        Enumeration enumeration = this._dictionary.elements();
        while (enumeration.hasMoreElements()) {
            if (n == 0) {
                return (Node)enumeration.nextElement();
            }
            enumeration.nextElement();
            --n;
        }
        return null;
    }

    public synchronized Node removeNamedItem(String string) throws DOMException {
        if (this._owner.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        return (Node)this._dictionary.remove(string);
    }

    public synchronized Node setNamedItem(Node node) throws DOMException {
        if (this._owner.isReadOnly()) {
            throw new DOMExceptionImpl(7);
        }
        if (node == null || !(node instanceof NodeImpl)) {
            throw new DOMExceptionImpl(4);
        }
        if (!(node instanceof ElementDeclImpl || node instanceof AttlistDecl || node instanceof Notation || node instanceof Entity)) {
            throw new DOMExceptionImpl(4);
        }
        return this._dictionary.put(node.getNodeName(), node);
    }
}

