/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.openxml.DOMFactory;
import org.openxml.dom.EntityImpl;
import org.openxml.io.Parser;
import org.openxml.io.XMLStreamReader;
import org.openxml.parser.ErrorSinkHandler;
import org.openxml.parser.FatalParseException;
import org.openxml.parser.ParseException;
import org.openxml.parser.SourceLocation;
import org.openxml.parser.ValidityException;
import org.openxml.parser.WellFormedException;
import org.openxml.parser.XMLParser;
import org.openxml.source.Holder;
import org.openxml.source.Source;
import org.openxml.util.FastString;
import org.openxml.util.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class BaseParser
implements Parser,
ErrorSinkHandler {
    protected static final int EOF = -1;
    protected static final char LF = '\n';
    protected static final char CR = '\r';
    protected static final char SPACE = ' ';
    protected static final short TOKEN_EOF = -1;
    protected static final short TOKEN_TEXT = 0;
    protected static final short TOKEN_ENTITY_REF = 1;
    protected static final short TOKEN_OPEN_TAG = 2;
    protected static final short TOKEN_CLOSE_TAG = 3;
    protected static final short TOKEN_COMMENT = 4;
    protected static final short TOKEN_PI = 5;
    protected static final short TOKEN_CDATA = 6;
    protected static final short TOKEN_DTD = 7;
    protected static final short TOKEN_SECTION = 8;
    protected static final short TOKEN_SECTION_END = 9;
    protected static final short TOKEN_PE_REF = 10;
    protected int _curChar;
    protected FastString _tokenText = new FastString();
    protected Document _document;
    private char[] _pushBackBuffer = new char[64];
    private int _pushBackIndex;
    private Reader _reader;
    private short _mode;
    private int _lineNumber;
    private int _position;
    private String _sourceURI;
    private boolean _closed = false;
    private ParseException _lastException;
    private short _stopAtSeverity;
    private ErrorSinkHandler _errorSink;

    protected BaseParser(Reader reader, String string, short s, short s2) {
        this._reader = reader;
        this._mode = s;
        this._stopAtSeverity = s2;
        this._sourceURI = string;
    }

    protected final void advanceLineNumber(int n) {
        this._lineNumber += n;
    }

    protected final boolean canReadName(String string) throws IOException {
        int n = 0;
        while (n < string.length()) {
            if (this.readChar() != string.charAt(n)) {
                this.pushBack();
                while (n > 0) {
                    this.pushBack(string.charAt(--n));
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    protected final void close() {
        try {
            this._closed = true;
            this._reader.close();
        }
        catch (IOException iOException) {}
    }

    public final void error(Exception exception) throws ParseException {
        if (this._errorSink == null) {
            this._lastException = new FatalParseException((SourceLocation)this, this._lastException, exception);
            if (Log.DEBUG) {
                Log.info("Parser.error: Fatal at document [" + this.getSourceURI() + "] line " + this.getLineNumber());
                Log.info("Parser.error: Fatal: " + exception.getClass().getName() + ": " + exception.getMessage());
            }
            throw this._lastException;
        }
        this._errorSink.error(exception);
    }

    public final void error(short s, String string) throws ParseException {
        if (this._errorSink != null) {
            this._errorSink.error(s, string);
        } else if (s == 2) {
            this._lastException = new ValidityException(this, this._lastException, string);
            if (Log.DEBUG) {
                Log.info("Parser.error: Validity at document [" + this.getSourceURI() + "] line " + this.getLineNumber());
                Log.info("Parser.error: Validity: " + string);
            }
            if (this._stopAtSeverity == 2) {
                throw this._lastException;
            }
        } else if (s == 1) {
            this._lastException = new WellFormedException(this, this._lastException, string);
            if (Log.DEBUG) {
                Log.info("Parser.error: Well-formed at document [" + this.getSourceURI() + "] line " + this.getLineNumber());
                Log.info("Parser.error: Well-formed: " + string);
            }
            if (this._stopAtSeverity == 2 || this._stopAtSeverity == 1) {
                throw this._lastException;
            }
        } else {
            this._lastException = new FatalParseException((SourceLocation)this, this._lastException, string);
            if (Log.DEBUG) {
                Log.info("Parser.error: Fatal at document [" + this.getSourceURI() + "] line " + this.getLineNumber());
                Log.info("Parser.error: Fatal: " + string);
            }
            throw this._lastException;
        }
    }

    public ParseException getLastException() {
        return this._lastException;
    }

    public final int getLineNumber() {
        return this._lineNumber + 1;
    }

    protected final short getMode() {
        return this._mode;
    }

    protected final Reader getReader() {
        return this._reader;
    }

    public final int getSourcePosition() {
        return this._position;
    }

    public final String getSourceURI() {
        return this._sourceURI;
    }

    protected final boolean isClosed() {
        return this._closed;
    }

    protected final boolean isMode(short s) {
        return (this._mode & s) != 0;
    }

    protected final boolean isNamePart(int n, boolean bl) {
        if (bl) {
            return Character.isLetter((char)n) || n == 95 || n == 58;
        }
        return Character.isLetterOrDigit((char)n) || n == 95 || n == 58 || n == 45 || n == 46;
    }

    protected final boolean isSpace(int n) {
        return n == 32 || n == 10 || n == 13 || n == 9 || n == 12;
    }

    protected final boolean isTokenAllSpace() {
        int n = 0;
        while (n < this._tokenText.length()) {
            char c = this._tokenText.charAt(n);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t' && c != '\f') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public abstract Document parseDocument() throws ParseException;

    protected final boolean parseDocumentDecl(boolean bl) throws ParseException {
        boolean bl2 = false;
        String string = null;
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(this._tokenText.toString(), " \n\r\f\t");
        if (stringTokenizer.nextToken() != null && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.startsWith("version")) {
                if (string3.length() > 7 && string3.charAt(7) == '=') {
                    string = string3.length() > 8 ? string3.substring(8) : (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
                } else {
                    String string4 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                    if (string3 != null && string3.charAt(0) == '=') {
                        string = string3.length() > 1 ? string3.substring(1) : (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
                    }
                }
                String string5 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            }
            if (string3 != null && string3.startsWith("encoding")) {
                if (string3.length() > 8 && string3.charAt(8) == '=') {
                    string2 = string3.length() > 9 ? string3.substring(9) : (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
                } else {
                    String string6 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                    if (string3 != null && string3.charAt(0) == '=') {
                        string2 = string3.length() > 1 ? string3.substring(1) : (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
                    }
                }
                String string7 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            }
            if (bl && string3 != null && string3.startsWith("standalone")) {
                if (string3.length() > 10 && string3.charAt(10) == '=') {
                    string3 = string3.length() > 11 ? string3.substring(11) : (stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null);
                } else {
                    String string8 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                    if (string3 != null && string3.charAt(0) == '=') {
                        if (string3.length() > 1) {
                            string3 = string3.substring(1);
                        } else {
                            String string9 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
                        }
                    }
                }
                if (string3 != null) {
                    if ((string3 = string3.toLowerCase()).startsWith("\"yes\"") || string3.startsWith("'yes'")) {
                        bl2 = true;
                    } else if (string3.startsWith("\"no\"") || string3.startsWith("'no'")) {
                        bl2 = false;
                    } else {
                        string3 = null;
                    }
                }
                if (string3 == null) {
                    this.error((short)1, "Missing 'yes'|'no' value for standalone document declaration.");
                }
            }
        }
        if (bl && string == null) {
            this.error((short)1, "XML declaration missing mandatory version information.");
        } else if (!bl && string2 == null) {
            this.error((short)1, "External entity declaration missing mandatory encoding information.");
        }
        if (string != null && !string.equals("'1.0'") && !string.equals("\"1.0\"")) {
            this.error((short)1, "Only documents tagged XML version 1.0 are properly recognized by this parser.");
        }
        if (string2 != null) {
            char c = string2.charAt(0);
            if (string2.length() < 3 || c != '\'' && c != '\"' || string2.charAt(string2.length() - 1) != c) {
                this.error((short)1, "Encoding identifier not properly quoted.");
            } else {
                string2 = string2.substring(1, string2.length() - 2);
                this.setEncoding(string2);
            }
        }
        return bl2;
    }

    protected final EntityImpl parseGeneralEntity(EntityImpl entityImpl) throws ParseException {
        Reader reader = null;
        switch (entityImpl.getState()) {
            case 2: {
                return entityImpl;
            }
            case 3: {
                return null;
            }
            case 1: {
                this.error((short)1, "Entity '" + entityImpl.getNodeName() + "' contains circular reference.");
                return null;
            }
            case 0: {
                try {
                    XMLParser xMLParser;
                    if (entityImpl.isInternal()) {
                        reader = new StringReader(entityImpl.getInternal());
                        xMLParser = new XMLParser(this, reader, String.valueOf(this.getSourceURI()) + " Entity: " + entityImpl.getNodeName());
                    } else {
                        Source source = DOMFactory.newSource();
                        source.setURI(entityImpl.getSystemId());
                        source.setPublicId(entityImpl.getPublicId());
                        source.setDocClass(Source.DOCUMENT_XML);
                        Holder holder = DOMFactory.getHolderFinder().findHolder(source, false);
                        if (holder != null) {
                            reader = holder.getReader();
                        }
                        if (reader == null || holder == null) {
                            entityImpl.setState((short)3);
                            this.error((short)1, "External entity '" + entityImpl.getNodeName() + "' could not be found.");
                            return null;
                        }
                        xMLParser = new XMLParser(this, reader, source.toString());
                    }
                    entityImpl.setState((short)1);
                    xMLParser.parseEntity(entityImpl, entityImpl.isInternal());
                    entityImpl.setState((short)2);
                }
                catch (ParseException parseException) {
                    entityImpl.setState((short)3);
                    return null;
                }
                catch (IOException iOException) {
                    entityImpl.setState((short)3);
                    this.error((short)1, "External entity '" + entityImpl.getNodeName() + "' could not be found. Reason:" + iOException.getMessage());
                    return null;
                }
                return entityImpl;
            }
        }
        throw new IllegalStateException("Entity in illegal state.");
    }

    public abstract Node parseNode(Node var1) throws ParseException;

    protected final void pushBack() {
        this.pushBack(this._curChar);
    }

    protected final void pushBack(int n) {
        if (n != -1) {
            if (this._pushBackIndex == this._pushBackBuffer.length) {
                char[] cArray = new char[this._pushBackIndex * 2];
                System.arraycopy(cArray, this._pushBackIndex, this._pushBackBuffer, 0, this._pushBackIndex);
                this._pushBackBuffer = cArray;
            }
            this._pushBackBuffer[this._pushBackIndex] = (char)n;
            ++this._pushBackIndex;
        }
    }

    protected final int readChar() throws IOException {
        if (this._pushBackIndex > 0) {
            this._curChar = this._pushBackBuffer[--this._pushBackIndex];
        } else {
            this._curChar = this._reader.read();
            if (this._curChar != -1) {
                ++this._position;
            }
            if (this._curChar == 10 || this._curChar == 13) {
                if (this._curChar == 13) {
                    this._curChar = this._reader.read();
                    if (this._curChar != -1) {
                        ++this._position;
                    }
                    if (this._curChar != 10) {
                        this.pushBack();
                    }
                }
                this._curChar = 10;
                ++this._lineNumber;
            }
        }
        return this._curChar;
    }

    protected final int readTokenEntity() throws ParseException, IOException {
        this._tokenText.setLength(0);
        this.readChar();
        if (this._curChar == 35) {
            int n = this.readChar();
            if (n == 120 || n == 88) {
                if (Character.digit((char)this.readChar(), 16) >= 0) {
                    int n2 = 0;
                    while (Character.digit((char)this._curChar, 16) >= 0) {
                        n2 = (n2 << 4) + Character.digit((char)this._curChar, 16);
                        this.readChar();
                    }
                    if (this._curChar != 59) {
                        this.pushBack();
                        this.error((short)1, "Character reference terminated permaturely.");
                    }
                    this._tokenText.append((char)n2);
                    return 0;
                }
                this.pushBack();
                this.pushBack(n);
                this.pushBack(35);
                this._tokenText.append("&");
                return 0;
            }
            if (this._curChar >= 48 && this._curChar <= 57) {
                int n3 = 0;
                while (this._curChar >= 48 && this._curChar <= 57) {
                    n3 = n3 * 10 + Character.digit((char)this._curChar, 10);
                    this.readChar();
                }
                if (this._curChar != 59) {
                    this.pushBack();
                    this.error((short)1, "Character reference terminated permaturely.");
                }
                this._tokenText.append((char)n3);
                return 0;
            }
            this.pushBack();
            this.pushBack(35);
            this._tokenText.append("&");
            return 0;
        }
        this.pushBack();
        if (!this.readTokenName()) {
            this._tokenText.append('&');
            return 0;
        }
        this.readChar();
        if (this._curChar != 59) {
            this.pushBack();
            this.error((short)1, "Entity reference terminated permaturely.");
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    protected final int readTokenMarkup() throws ParseException, IOException {
        block26: {
            this._tokenText.setLength(0);
            this.readChar();
            if (this._curChar == 63) {
                this.readChar();
                while (this._curChar != -1) {
                    if (this._curChar == 63) {
                        if (this.readChar() == 62) {
                            return 5;
                        }
                        this._tokenText.append('?');
                        continue;
                    }
                    this._tokenText.append((char)this._curChar);
                    this.readChar();
                }
                if (this._curChar == -1) {
                    this.error((short)1, "Processing instruction terminated permaturely at end of file.");
                }
                return 5;
            }
            if (this._curChar != 33) break block26;
            this.readChar();
            if (this._curChar == 45) {
                if (this.readChar() != 45) {
                    this.pushBack();
                    this.pushBack(45);
                    this._tokenText.append('<');
                    return 0;
                }
                this.readChar();
                while (this._curChar != -1) {
                    if (this._curChar == 45) {
                        if (this.readChar() == 45) {
                            if (this.readChar() == 62) {
                                return 4;
                            }
                            this.pushBack();
                            this._curChar = 45;
                        }
                        if (!this.isMode((short)2)) continue;
                        this._tokenText.append('-');
                        continue;
                    }
                    if (this.isMode((short)2)) {
                        this._tokenText.append((char)this._curChar);
                    }
                    this.readChar();
                }
                if (this._curChar == -1) {
                    this.error((short)1, "Comment terminated permaturely at end of file.");
                }
                return 4;
            }
            if (this._curChar != 91) ** GOTO lbl81
            if (this.canReadName("CDATA[")) {
                this.readChar();
                while (this._curChar != -1) {
                    if (this._curChar == 93) {
                        if (this.readChar() == 93) {
                            if (this.readChar() == 62) {
                                return 6;
                            }
                            this._tokenText.append(']');
                        }
                        this._tokenText.append(']');
                        continue;
                    }
                    this._tokenText.append((char)this._curChar);
                    this.readChar();
                }
                if (this._curChar == -1) {
                    this.error((short)1, "CDATA section terminated permaturely at end of file.");
                }
                return 6;
            }
            return 8;
lbl-1000:
            // 1 sources

            {
                this._tokenText.append((char)this._curChar);
                this.readChar();
lbl81:
                // 2 sources

                ** while (this._curChar >= 65 && this._curChar <= 90)
            }
lbl82:
            // 1 sources

            this.pushBack();
            return 7;
        }
        if (this._curChar == 47) {
            this.readTokenName();
            this.readChar();
            while (this._curChar != -1 && this._curChar != 60 && this._curChar != 62) {
                this.readChar();
            }
            if (this._curChar == -1) {
                this.error((short)1, "Closing tag terminated permaturely at end of file.");
            }
            if (this._curChar == 60) {
                this.pushBack();
                this.error((short)1, "Closing tag terminated permaturely.");
            }
            return 3;
        }
        this.pushBack();
        if (this.readTokenName()) {
            while (this.isSpace(this.readChar())) {
            }
            this.pushBack();
            return 2;
        }
        this._tokenText.append('<');
        return 0;
    }

    protected final boolean readTokenName() throws IOException {
        this._tokenText.setLength(0);
        if (this.isNamePart(this.readChar(), true)) {
            this._tokenText.append((char)this._curChar);
            while (this.isNamePart(this.readChar(), false)) {
                this._tokenText.append((char)this._curChar);
            }
            this.pushBack();
            return true;
        }
        this.pushBack();
        return false;
    }

    protected final int readTokenPERef() throws ParseException, IOException {
        this._tokenText.setLength(0);
        if (!this.readTokenName()) {
            this._tokenText.append('%');
            return 0;
        }
        this.readChar();
        if (this._curChar != 59) {
            this.pushBack();
            this.error((short)1, "Parameter entity reference terminated permaturely.");
        }
        return 10;
    }

    protected final boolean readTokenQuoted() throws ParseException, IOException {
        this._tokenText.setLength(0);
        int n = this.readChar();
        if (n == 39 || n == 34) {
            StringBuffer stringBuffer = new StringBuffer(32);
            this.readChar();
            while (this._curChar != n && this._curChar != -1) {
                this._tokenText.append((char)this._curChar);
                this.readChar();
            }
            if (this._curChar == -1) {
                this.error((short)1, "Quoted identifier terminated prematurely.");
            }
            return true;
        }
        this.pushBack();
        return false;
    }

    protected final void setEncoding(String string) {
        if (this._reader instanceof XMLStreamReader) {
            this._reader = ((XMLStreamReader)this._reader).changeEncoding(string);
        }
    }

    public final void setErrorSink(ErrorSinkHandler errorSinkHandler) {
        this._errorSink = errorSinkHandler;
    }

    protected final String slicePITokenText() throws ParseException {
        if (this._tokenText.length() == 0) {
            return "";
        }
        int n = 0;
        char c = this._tokenText.charAt(0);
        if (this.isNamePart(c, true)) {
            n = 1;
            c = this._tokenText.charAt(n);
            while (n < this._tokenText.length() && this.isNamePart(c, false)) {
                c = this._tokenText.charAt(++n);
            }
        }
        if (n == 0 || n < this._tokenText.length() && !this.isSpace(c)) {
            this.error((short)1, "Target name in processing instruction is invalid.");
        }
        String string = this._tokenText.toString(0, n);
        while (n < this._tokenText.length() && this.isSpace(c)) {
            c = this._tokenText.charAt(++n);
        }
        this._tokenText.delete(0, n);
        return string;
    }
}

