/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Dictionary;
import java.util.Enumeration;
import org.openxml.DTDDocument;
import org.openxml.dom.EntityImpl;
import org.openxml.dom.ParamEntity;
import org.openxml.io.Printer;
import org.openxml.io.XMLStreamWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;

public final class DTDPrinter
extends Printer {
    public DTDPrinter(OutputStream outputStream, int n) throws IOException {
        this(new XMLStreamWriter(outputStream), n, 70, 4);
    }

    public DTDPrinter(OutputStream outputStream, String string, int n) throws IOException, UnsupportedEncodingException {
        this(new XMLStreamWriter(outputStream, string), n, 70, 4);
    }

    public DTDPrinter(Writer writer) throws IOException {
        this(writer, 0, 70, 4);
    }

    public DTDPrinter(Writer writer, int n) throws IOException {
        this(writer, n, 70, 4);
    }

    public DTDPrinter(Writer writer, int n, int n2, int n3) throws IOException {
        super(writer, n, n2, n3);
    }

    public void print(Document document) throws IOException {
        this.printDocument(document, new StringBuffer());
        this.flush();
    }

    public void print(DocumentFragment documentFragment) throws IOException {
        this.printDocument(documentFragment, new StringBuffer());
        this.flush();
    }

    public void print(Element element) throws IOException {
    }

    protected void printContent(DTDDocument dTDDocument, StringBuffer stringBuffer) throws IOException {
        Node node = dTDDocument.getFirstChild();
        while (node != null) {
            stringBuffer.setLength(0);
            if (node instanceof ParamEntity) {
                this.printEntity((ParamEntity)node, stringBuffer);
            } else if (node instanceof Entity) {
                this.printEntity((Entity)node, stringBuffer);
            } else if (node instanceof Notation) {
                this.printNotation((Notation)node, stringBuffer);
            } else if (node instanceof Comment || node instanceof ProcessingInstruction) {
                this.printNode(node);
            }
            if (!this.mode(2)) {
                this.breakLine();
            }
            node = node.getNextSibling();
        }
        this.breakLine();
    }

    protected void printDocument(Node node, StringBuffer stringBuffer) throws IOException {
        if (node instanceof Document) {
            stringBuffer.append("<?xml version=\"1.0\"");
            if (this.getEncoding() != null) {
                stringBuffer.append(" encoding=\"").append(this.getEncoding()).append('\"');
            }
            this.printPart(stringBuffer.append("?>"));
            this.breakLine();
        }
        stringBuffer.setLength(0);
        this.printSubset((DocumentType)node, stringBuffer);
    }

    protected void printElement(Element element, StringBuffer stringBuffer) throws IOException {
    }

    private void printEntity(ParamEntity paramEntity, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<!ENTITY % ").append(paramEntity.getNodeName());
        this.printPart(stringBuffer);
        this.printSpace();
        if (paramEntity.isInternal()) {
            String string = paramEntity.getInternal();
            stringBuffer.setLength(0);
            this.printPart(this.appendLiteral(stringBuffer, string));
        } else {
            String string = paramEntity.getPublicId();
            if (string != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("PUBLIC ");
                this.printPart(this.appendLiteral(stringBuffer, string));
                string = paramEntity.getSystemId();
                if (string != null) {
                    stringBuffer.setLength(0);
                    this.printSpace();
                    this.printPart(this.appendLiteral(stringBuffer, string));
                }
            } else {
                string = paramEntity.getSystemId();
                if (string != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("SYSTEM ");
                    this.printPart(this.appendLiteral(stringBuffer, string));
                }
            }
        }
        this.printPart('>');
        this.printBreak();
    }

    private void printEntity(Entity entity, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<!ENTITY ").append(entity.getNodeName());
        this.printPart(stringBuffer);
        this.printSpace();
        if (entity instanceof EntityImpl && ((EntityImpl)entity).isInternal()) {
            if (this.mode(32) && ((EntityImpl)entity).getState() == 2) {
                this.printPart('\"');
                int n = this.getMode();
                this.setMode(this.getMode() & 0xFFFFFFFE);
                Node node = entity.getFirstChild();
                while (node != null) {
                    this.printNode(node);
                    node = node.getNextSibling();
                }
                this.setMode(n);
                this.printPart('\"');
            } else {
                String string = ((EntityImpl)entity).getInternal();
                stringBuffer.setLength(0);
                this.printPart(this.appendLiteral(stringBuffer, string));
            }
        } else {
            String string = entity.getPublicId();
            if (string != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("PUBLIC ");
                this.printPart(this.appendLiteral(stringBuffer, string));
                string = entity.getSystemId();
                if (string != null) {
                    stringBuffer.setLength(0);
                    this.printSpace();
                    this.printPart(this.appendLiteral(stringBuffer, string));
                }
            } else {
                string = entity.getSystemId();
                if (string != null) {
                    stringBuffer.setLength(0);
                    stringBuffer.append("SYSTEM ");
                    this.printPart(this.appendLiteral(stringBuffer, string));
                }
            }
            if ((string = entity.getNotationName()) != null) {
                stringBuffer.setLength(0);
                stringBuffer.append("NDATA ");
                this.printSpace();
                this.printPart(this.appendLiteral(stringBuffer, string));
            }
        }
        this.printPart('>');
        this.printBreak();
    }

    private void printNotation(Notation notation, StringBuffer stringBuffer) throws IOException {
        stringBuffer.append("<!NOTATION ").append(notation.getNodeName());
        this.printPart(stringBuffer);
        this.printSpace();
        String string = notation.getPublicId();
        if (string != null) {
            stringBuffer.setLength(0);
            stringBuffer.append("PUBLIC ");
            this.printPart(this.appendLiteral(stringBuffer, string));
            string = notation.getSystemId();
            if (string != null) {
                stringBuffer.setLength(0);
                this.printSpace();
                this.printPart(this.appendLiteral(stringBuffer, string));
            }
        } else {
            string = notation.getSystemId();
            stringBuffer.setLength(0);
            stringBuffer.append("SYSTEM ");
            this.printPart(this.appendLiteral(stringBuffer, string));
        }
        this.printPart('>');
        this.printBreak();
    }

    protected void printSubset(DocumentType documentType, StringBuffer stringBuffer) throws IOException {
        DTDDocument dTDDocument = null;
        if (this.mode(32) && documentType instanceof DTDDocument && documentType.hasChildNodes()) {
            this.printContent((DTDDocument)documentType, stringBuffer);
        } else {
            int n;
            NamedNodeMap namedNodeMap;
            Dictionary dictionary;
            if (documentType instanceof DTDDocument) {
                dTDDocument = (DTDDocument)documentType;
            }
            if (dTDDocument != null && (dictionary = dTDDocument.getParamEntities()) != null) {
                Enumeration enumeration = dictionary.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.setLength(0);
                    this.printEntity((ParamEntity)enumeration.nextElement(), stringBuffer);
                    if (this.mode(2)) continue;
                    this.breakLine();
                }
            }
            if ((namedNodeMap = documentType.getEntities()) != null) {
                n = 0;
                while (n < namedNodeMap.getLength()) {
                    stringBuffer.setLength(0);
                    this.printEntity((Entity)namedNodeMap.item(n), stringBuffer);
                    if (!this.mode(2)) {
                        this.breakLine();
                    }
                    ++n;
                }
            }
            if ((namedNodeMap = documentType.getNotations()) != null) {
                n = 0;
                while (n < namedNodeMap.getLength()) {
                    stringBuffer.setLength(0);
                    this.printNotation((Notation)namedNodeMap.item(n), stringBuffer);
                    if (!this.mode(2)) {
                        this.breakLine();
                    }
                    ++n;
                }
            }
        }
    }
}

