package com.jtauber.fop.fo.flow;

// FOP
import com.jtauber.fop.fo.*;
import com.jtauber.fop.fo.properties.*;
import com.jtauber.fop.layout.FontState;
import com.jtauber.fop.layout.Area;
import com.jtauber.fop.apps.FOPException;

// Java
import java.util.Enumeration;

public class PageNumber extends FObj {

    public static class Maker extends FObj.Maker {
	public FObj make(FObj parent, PropertyList propertyList)
	    throws FOPException {
	    return new PageNumber(parent, propertyList);
	}
    }

    public static FObj.Maker maker() {
	return new PageNumber.Maker();
    }

    public PageNumber(FObj parent, PropertyList propertyList) {
	super(parent, propertyList);
	this.name = "fo:page-number";
    }

    public int layout(Area area) throws FOPException {
	String fontFamily = this.properties.get("font-family").getString();
	String fontStyle = this.properties.get("font-style").getString();
	String fontWeight = this.properties.get("font-weight").getString();
	int fontSize = this.properties.get("font-size").getLength().mvalue();
		
	FontState fs = new FontState(area.getFontInfo(), fontFamily,
				     fontStyle, fontWeight, fontSize);

	ColorType c = this.properties.get("color").getColorType();
	float red = c.red();
	float green = c.green();
	float blue = c.blue();

	int wrapOption = this.properties.get("wrap-option").getEnum();
	int whiteSpaceTreatment = this.properties.get("white-space-treatment").getEnum();
	//String p = doc.getPageNumber();
		
	//	doc.addText(fs, red, green, blue, wrapOption, whiteSpaceTreatment, p.toCharArray(), 0, p.length());
	return OK;
    }
}
