/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.pdf;

import com.jtauber.pdf.PDFFont;
import com.jtauber.pdf.PDFInfo;
import com.jtauber.pdf.PDFObject;
import com.jtauber.pdf.PDFPage;
import com.jtauber.pdf.PDFPages;
import com.jtauber.pdf.PDFResources;
import com.jtauber.pdf.PDFRoot;
import com.jtauber.pdf.PDFStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class PDFDocument {
    protected static final String pdfVersion = "1.2";
    protected int position = 0;
    protected Vector location = new Vector();
    protected int objectcount = 0;
    protected Vector objects = new Vector();
    protected int xref;
    protected PDFRoot root = this.makeRoot();
    protected PDFInfo info;
    protected PDFResources resources;

    public PDFDocument(String string) {
        this.info = this.makeInfo(string);
        this.resources = this.makeResources();
    }

    public PDFResources getResources() {
        return this.resources;
    }

    public PDFFont makeFont(String string, String string2, String string3) {
        PDFFont pDFFont = new PDFFont(++this.objectcount, string, string2, string3);
        this.objects.addElement(pDFFont);
        return pDFFont;
    }

    protected PDFInfo makeInfo(String string) {
        PDFInfo pDFInfo = new PDFInfo(++this.objectcount, string);
        this.objects.addElement(pDFInfo);
        return pDFInfo;
    }

    public PDFPage makePage(PDFResources pDFResources, PDFStream pDFStream, int n, int n2) {
        PDFPage pDFPage = new PDFPage(++this.objectcount, pDFResources, pDFStream, n, n2);
        this.objects.addElement(pDFPage);
        this.root.addPage(pDFPage);
        return pDFPage;
    }

    private PDFResources makeResources() {
        PDFResources pDFResources = new PDFResources(++this.objectcount);
        this.objects.addElement(pDFResources);
        return pDFResources;
    }

    protected PDFRoot makeRoot() {
        PDFRoot pDFRoot = new PDFRoot(++this.objectcount);
        this.objects.addElement(pDFRoot);
        PDFPages pDFPages = new PDFPages(++this.objectcount);
        this.objects.addElement(pDFPages);
        pDFRoot.setRootPages(pDFPages);
        return pDFRoot;
    }

    public PDFStream makeStream() {
        PDFStream pDFStream = new PDFStream(++this.objectcount);
        this.objects.addElement(pDFStream);
        return pDFStream;
    }

    public void output(PrintWriter printWriter) throws IOException {
        this.position += this.outputHeader(printWriter);
        int n = 1;
        while (n <= this.objectcount) {
            this.location.addElement(new Integer(this.position));
            PDFObject pDFObject = (PDFObject)this.objects.elementAt(n - 1);
            this.position += pDFObject.output(printWriter);
            ++n;
        }
        this.position += this.outputXref(printWriter);
        this.outputTrailer(printWriter);
        printWriter.flush();
    }

    protected int outputHeader(PrintWriter printWriter) throws IOException {
        String string = "%PDF-1.2\n";
        printWriter.write(string);
        return string.length();
    }

    protected void outputTrailer(PrintWriter printWriter) throws IOException {
        String string = "trailer\n<<\n/Size " + (this.objectcount + 1) + "\n/Root " + this.root.number + " " + this.root.generation + " R\n/Info " + this.info.number + " " + this.info.generation + " R\n>>\nstartxref\n" + this.xref + "\n%%EOF\n";
        printWriter.write(string);
    }

    private int outputXref(PrintWriter printWriter) throws IOException {
        this.xref = this.position;
        StringBuffer stringBuffer = new StringBuffer("xref\n0 " + (this.objectcount + 1) + "\n0000000000 65535 f \n");
        int n = 1;
        while (n < this.objectcount + 1) {
            String string = "0000000000";
            String string2 = this.location.elementAt(n - 1).toString();
            String string3 = String.valueOf(string.substring(string2.length())) + string2;
            stringBuffer = stringBuffer.append(String.valueOf(string3) + " 00000 n \n");
            ++n;
        }
        printWriter.write(stringBuffer.toString());
        return stringBuffer.length();
    }
}

