/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.fo.flow;

import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.fo.FObj;
import com.jtauber.fop.fo.PropertyList;
import com.jtauber.fop.fo.flow.ListItem;
import com.jtauber.fop.layout.Area;
import com.jtauber.fop.layout.BlockArea;
import com.jtauber.fop.layout.Box;
import com.jtauber.fop.layout.FontState;

public class ListBlock
extends FObj {
    FontState fs;
    int align;
    int alignLast;
    int breakBefore;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int provisionalDistanceBetweenStarts;
    int provisionalLabelSeparation;
    int spaceBetweenListRows = 0;

    public ListBlock(FObj fObj, PropertyList propertyList) {
        super(fObj, propertyList);
        this.name = "fo:list-block";
    }

    public int layout(Area area) throws FOPException {
        Object object;
        if (this.marker == -1000) {
            object = this.properties.get("font-family").getString();
            String string = this.properties.get("font-style").getString();
            String string2 = this.properties.get("font-weight").getString();
            int n = this.properties.get("font-size").getLength().mvalue();
            this.fs = new FontState(area.getFontInfo(), (String)object, string, string2, n);
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.provisionalDistanceBetweenStarts = this.properties.get("provisional-distance-between-starts").getLength().mvalue();
            this.provisionalLabelSeparation = this.properties.get("provisional-label-separation").getLength().mvalue();
            this.spaceBetweenListRows = 0;
            this.marker = 0;
            if (area instanceof BlockArea) {
                area.end();
            }
            if (this.spaceBefore != 0) {
                area.addDisplaySpace(this.spaceBefore);
            }
            if (this.isInListBody) {
                this.startIndent += this.bodyIndent + this.distanceBetweenStarts;
                this.bodyIndent = this.startIndent;
            }
        }
        object = new BlockArea(this.fs, area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, 0, this.align, this.alignLast, this.lineHeight);
        ((Area)object).setPage(area.getPage());
        ((BlockArea)object).start();
        int n = this.children.size();
        int n2 = this.marker;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.children.elementAt(n2);
            listItem.setDistanceBetweenStarts(this.provisionalDistanceBetweenStarts);
            listItem.setLabelSeparation(this.provisionalLabelSeparation);
            listItem.setBodyIndent(this.bodyIndent);
            int n3 = listItem.layout((Area)object);
            if (n3 != 1) {
                this.marker = n3 > 1 ? n2 + 1 : n2;
                ((BlockArea)object).end();
                area.addChild((Box)object);
                area.increaseHeight(((Area)object).getHeight());
                return n3;
            }
            ++n2;
        }
        ((BlockArea)object).end();
        area.addChild((Box)object);
        area.increaseHeight(((Area)object).getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj fObj, PropertyList propertyList) throws FOPException {
            return new ListBlock(fObj, propertyList);
        }
    }
}

