/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.layout;

import com.jtauber.fop.apps.FOPException;
import com.jtauber.fop.layout.FontInfo;
import com.jtauber.fop.layout.FontMetric;

public class FontState {
    protected FontInfo fontInfo;
    private String fontName;
    private int fontSize;
    private String fontFamily;
    private String fontStyle;
    private String fontWeight;
    private FontMetric metric;

    public FontState(FontInfo fontInfo, String string, String string2, String string3, int n) throws FOPException {
        this.fontInfo = fontInfo;
        this.fontFamily = string;
        this.fontStyle = string2;
        this.fontWeight = string3;
        this.fontSize = n;
        this.fontName = fontInfo.fontLookup(string, string2, string3);
        this.metric = fontInfo.getMetricsFor(this.fontName);
    }

    public int getAscender() {
        return this.fontSize * this.metric.getAscender() / 1000;
    }

    public int getCapHeight() {
        return this.fontSize * this.metric.getCapHeight() / 1000;
    }

    public int getDescender() {
        return this.fontSize * this.metric.getDescender() / 1000;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public String getFontWeight() {
        return this.fontWeight;
    }

    public int getXHeight() {
        return this.fontSize * this.metric.getXHeight() / 1000;
    }

    public int width(int n) {
        return this.fontSize * this.metric.width(n) / 1000;
    }
}

