/*
 * dfile.c - HP-UX file processing functions for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dfile.c,v 1.4 98/03/06 08:21:05 abe Exp $";
#endif


#include "lsof.h"


/*
 * get_max_fd() - get maximum file descriptor plus one
 */

int
get_max_fd()
{
	struct rlimit r;

	if (getrlimit(RLIMIT_NOFILE, &r))
	    return(-1);
	return(r.rlim_cur);
}


/*
 * print_dev() - print device
 */

char *
print_dev(lf)
	struct lfile *lf;		/* file whose device is to be printed */
{
	static char buf[128];

	(void) sprintf(buf, "%d,%#x", major(lf->dev), minor(lf->dev));
	return(buf);
}


/*
 * process_file() - process file
 */

void
process_file(fp)
	KA_T fp;			/* kernel file structure address */
{
	struct file f;
	int flag;

	if (kread((KA_T)fp, (char *)&f, sizeof(f))) {
	    (void) sprintf(Namech, "can't read file struct from %s",
		print_kptr(fp, (char *)NULL));
	    enter_nm(Namech);
	    return;
	}
	Lf->off = (SZOFFTYPE)f.f_offset;

	if (f.f_count) {

	/*
	 * Construct access code.
	 */
	    if ((flag = (f.f_flag & (FREAD | FWRITE))) == FREAD)
		Lf->access = 'r';
	    else if (flag == FWRITE)
		Lf->access = 'w';
	    else if (flag == (FREAD | FWRITE))
		Lf->access = 'u';
	/*
	 * Process structure by its type.
	 */
	    switch (f.f_type) {

#if	defined(DTYPE_LLA)
	    case DTYPE_LLA:
		if (!Selinet)
		    process_lla((KA_T)f.f_data);
		return;
#endif	/* DTYPE_LLA */

	    case DTYPE_VNODE:
		if (!Selinet)
		    process_node((KA_T)f.f_data);
		return;
	    case DTYPE_SOCKET:
		process_socket((KA_T)f.f_data);
		return;
	    default:
		if (!f.f_type || (f.f_ops && (KA_T)f.f_ops != Vnfops)) {
		    (void) sprintf(Namech, "%s file struct, ty=%#x, op=%#x",
			print_kptr(fp, (char *)NULL), f.f_type, f.f_ops);
		    enter_nm(Namech);
		    return;
		}
	    }
	}
	enter_nm("no more information");
}
