#include <sys/utsname.h>
#include <sys/vfs.h>
#include "loadmeter.h"

int fd, ud;

void Doinit(char *label)
{
struct utsname *host;
/* Dont bother checking for failure */
	fd = open("/proc/loadavg", O_RDONLY);
	ud = open("/proc/uptime", O_RDONLY);
	/* Get the hostname of the machine */
	if(label==NULL)
	{
		host = (void *)malloc(sizeof(struct utsname));
		uname(host);
		strcpy(hostname, host->nodename);
		free(host);
	}
	else
		strcpy(hostname, label);
}

/* Read /proc/loadavg and get 1&5 min load average numbers */
void GetLoadPoint(avg, oavg, davg, numps)
double *avg; /* 1 minute average */
double *oavg;	/* 5 minute average */
double *davg;	/* 15 minute average */
int *numps;
{
char buf[25];
int crap;

      lseek(fd, 0, 0);
      read(fd, buf, sizeof(buf)-1);
      sscanf(buf, "%lf %lf %lf %d/%d", avg, oavg, davg, &crap, numps);
      return;
}

void GetUptime(char *ut)
{
static char buf[35];
double uptime;
int hr=0, min=0, num;
char *plural = "";

      bzero(ut, 20);
      lseek(ud, 0, 0);
/* Read the /proc/uptime file */
      read(ud, buf, sizeof(buf)-1);
      sscanf(buf, "%lf", (double *)&uptime);
      sprintf(ut, "%s up ", hostname);
/* Convert uptime in secs to a readable format */
      if (uptime > 86400)
      {
      	num = (int) uptime/86400;
      	/* If > 1 day do the plural 'days' thang */
      	if (num > 1)
      		plural = "s";
      	sprintf(buf, "%d day%s, ", num, plural);
      	uptime = uptime - num * 86400;
      	strcat(ut, buf);
      }
      if(uptime > 3600)
      {
      	hr = (int) uptime / 3600;
      	uptime = uptime - hr * 3600;
      }
      min = (int) uptime/60;
      if(hr > 0)
      	sprintf(buf, "%d:%02d", hr, min);
      else
      	sprintf(buf, "%02d min", min);
      strcat(ut, buf);
      return;
}
void GetMemInfo()
{
FILE *meminfo;
char *what;
long use, stot, sfree, mtot, mfree, mcache, mbuf;

	meminfo = fopen("/proc/meminfo", "r");
	what = (void *)malloc(25);
	while(fscanf(meminfo, "%s %ld", what, &use) != EOF)
	{
		if(strncmp(what, "SwapTotal", 9) == 0)
			stot = use;
		else if(strncmp(what, "SwapFree", 8) == 0)
			sfree = use;
		else if(strncmp(what, "MemTotal", 8) == 0)
			mtot = use;
		else if(strncmp(what, "MemFree", 7) == 0)
			mfree = use;
		else if(strncmp(what, "MemShared", 8) == 0)
			mbuf = use;
		else if(strcmp(what, "Cached:") == 0)
			mcache = use;
	}
	memory.swaptotal = stot;
	memory.swapfree = sfree;
	memory.memtotal = mtot;
	memory.memfree = mfree;
	memory.cached = mcache;
	memory.shared = mbuf;
	sprintf(memory.muse, "Memory used: %ld%%", (mtot-mfree-mcache)*100/mtot);
	sprintf(memory.suse, "Swap used:   %ld%%", (stot-sfree)*100/stot);
	free(what);
	fclose(meminfo);
}

/*
   Disk usages are obtained by looking in /etc/mtab and
   calling statfs on each of the filsystem mount points
*/
void GetDiskUsage()
{
FILE *mtab;
struct statfs buf;
int which;
float kb;
static time_t tm=0;

	if(time(NULL) - tm < DUINTERVAL)
		return;
	mtab = fopen("/etc/mtab", "r");
	if(mtab == NULL)
	{
		printf("Cannot open /etc/mtab!\n");
		exit(1);
	}
	if(dosync)
		sync();
	which = 0;
	while(fscanf(mtab, "%s %s %s", dev, path, type) != EOF)
	{
		/* Only statfs() if the path contains '/' */
		if (strchr(dev, '/') == NULL)
			continue;
		if(statfs(path, &buf) != 0)
			continue;
		strcpy(usages[which].path, path);
		strcpy(usages[which].dev, dev);
		strcpy(usages[which].type, type);
		usages[which].blocks = buf.f_blocks;
		usages[which].bfree = buf.f_bavail;
		kb = (float)buf.f_bsize/1024;
		usages[which].blocks *= kb;
		usages[which].bfree *= kb;
		which++;
	}
	usages[which].blocks = 0;
	tm = time(NULL);
	fclose(mtab);
}
