/*
    Copyright (C) 1996, 1997  Ulric Eriksson <ulric@edu.stockholm.se>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* Fonts */
#define SIZE_MASK (7)
#define SIZE_8 (0)
#define SIZE_10 (1)
#define SIZE_12 (2)
#define SIZE_14 (3)
#define SIZE_18 (4)
#define SIZE_24 (5)
#define SIZE_20 (6)
#define SIZE_30 (7)

#define ITALIC (8)
#define BOLD (16)

#define FONT_MASK (96)
#define COURIER (0)
#define HELVETICA (32)
#define NEW_CENTURY (64)
#define TIMES (96)

#define INVERT (128)

#define BORDER_MASK (BORDER_LEFT | BORDER_RIGHT | BORDER_TOP | BORDER_BOTTOM)
#define BORDER_LEFT (256)
#define BORDER_RIGHT (512)
#define BORDER_TOP (1024)
#define BORDER_BOTTOM (2048)

#define HADJ_MASK (4096 | 8192)
#define HADJ_LEFT (4096)
#define HADJ_CENTER (8192)
#define HADJ_RIGHT (4096+8192)

#define VADJ_MASK (16384 | 32768)
#define VADJ_TOP (16384)
#define VADJ_CENTER (32768)
#define VADJ_BOTTOM (16384+32768)

/* First available bit is 65536 = 0x10000 = (1 << 16) */
#define FMT_SHIFT (16)
#define FMT_MASK (15<<FMT_SHIFT)
#define FMT_DEFAULT (0<<FMT_SHIFT)
#define FMT_INVISIBLE (1<<FMT_SHIFT)
#define FMT_INTEGER (2<<FMT_SHIFT)
#define FMT_SCIENTIFIC (3<<FMT_SHIFT)
#define FMT_FIXED (4<<FMT_SHIFT)
#define FMT_DATE (5<<FMT_SHIFT)
#define FMT_TIME (6<<FMT_SHIFT)
#define FMT_COMMA (7<<FMT_SHIFT)
#define FMT_PERCENT (8<<FMT_SHIFT)
#define FMT_HEX (9<<FMT_SHIFT)
#define FMT_CURRENCY (10<<FMT_SHIFT)
#define FMT_USER1 (11<<FMT_SHIFT)
#define FMT_USER2 (12<<FMT_SHIFT)
#define FMT_USER3 (13<<FMT_SHIFT)
#define FMT_USER4 (14<<FMT_SHIFT)
#define FMT_USER5 (15<<FMT_SHIFT)

/* black, red, green, blue, yellow, purple, cyan, white */
/* First available bit is 0x100000 = (1 << 20) */
#define COLOR_SHIFT (20)
#define COLOR_MASK (7<<COLOR_SHIFT)
#define COLOR_0 (0<<COLOR_SHIFT)
#define COLOR_1 (1<<COLOR_SHIFT)
#define COLOR_2 (2<<COLOR_SHIFT)
#define COLOR_3 (3<<COLOR_SHIFT)
#define COLOR_4 (4<<COLOR_SHIFT)
#define COLOR_5 (5<<COLOR_SHIFT)
#define COLOR_6 (6<<COLOR_SHIFT)
#define COLOR_7 (7<<COLOR_SHIFT)

#define MENU_FONT (SIZE_12 | BOLD | HELVETICA)
#define INPUT_FONT (SIZE_10 | HELVETICA)
#define STATUS_FONT (SIZE_10 | HELVETICA)
#define COLNUM_FONT (SIZE_10 | BOLD | HELVETICA)
#define ROWNUM_FONT (SIZE_10 | BOLD | HELVETICA)
#define CELL_FONT (SIZE_10 | HELVETICA)
#define TEXT_FONT (SIZE_10 | HELVETICA)
#define CELL_FORMAT (CELL_FONT | HADJ_LEFT | VADJ_CENTER)
#define TEXT_FORMAT (TEXT_FONT | HADJ_LEFT | VADJ_CENTER)

typedef struct s_siag_font {
  char *psfont;
  char *name;
  XFontStruct *font;
} siag_font;

extern siag_font fonts[128];

extern Font get_font(Display *, int);
extern XFontStruct *font_struct(Display *, int);
extern int font_height(Display *, int);
extern int font_ascent(Display *, int);
extern int font_descent(Display *, int);

typedef struct s_siag_color {
	char *name;
	unsigned long pixel;
} siag_color;

extern siag_color colors[8];

extern void init_color(Display *);
extern unsigned long get_color(Display *, int);

