/*
   Siag, Scheme In A Grid
   Copyright (C) 1996  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *    position.c
 *
 *      This module contains functions for determining positions within
 *      buffers.
 */

#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>

#include "../siag/calc.h"
/*#include "xsiag.h"
*/
/* kludge to make sure point and top are outside the protected area */
void prot_fixup(window * w)
{
	if (w->top.row < w->prot.row)
		w->top.row = w->prot.row;
	if (w->top.col < w->prot.col)
		w->top.col = w->prot.col;
	if (w->point_pos.row < w->prot.row)
		w->point_pos.row = w->prot.row;
	if (w->point_pos.col < w->prot.col)
		w->point_pos.col = w->prot.col;
}

position set_point(window * w, position p)
{
TRACEME((f,"set_point(%d,%d)",p.row,p.col));
	w->point_pos = p;
TRACEME((f,"\tset_point: point_pos=(%d,%d)",w->point_pos.row,w->point_pos.col));
	prot_fixup(w);
TRACEME((f,"\tset_point: point_pos=(%d,%d)",w->point_pos.row,w->point_pos.col));
	return w->point_pos;
}

position get_point(window * w)
{
	return w->point_pos;
}

position set_mark(window * w, position p)
{
	w->buf->mark_pos = p;
	prot_fixup(w);
	return w->buf->mark_pos;
}

position get_mark(window * w)
{
	return w->buf->mark_pos;
}

position set_top(window * w, position p)
{
	w->top = p;
	prot_fixup(w);
	return w->top;
}

position get_top(window * w)
{
	return w->top;
}

int inblock(window *w, int r, int c)
{
        return ((r >= w->blku.row) && (r <= w->blkl.row) &&
                (c >= w->blku.col) && (c <= w->blkl.col));
}                               /* inblock */

