/*
   Siag, Scheme In A Grid
   Copyright (C) 1996  Ulric Eriksson <ulric@edu.stockholm.se>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * fileio_txt.c
 */

/*

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "calc.h"
#include "types.h"
#include "../common/fonts.h"

#define START 0
#define INSIDE 1
#define OUTSIDE 2

#ifndef ABS
#define ABS(x) ((x)>0?(x):-(x))
#endif

extern char *getenv();
static char ifs[256];

static int col_last_changed(buffer *b, int row)
{
	int i;

	if (row > b->alloc_lines) return 0;
	for (i = b->alloc_cols[row]; i > 1; i--)
		if (ret_type(b, row, i) != EMPTY)
			break;
	return i;
}

static int save_csv(char *fn, buffer * buf)
/* Returns: 0 if successful, otherwise 1 */
{
	int i, j, lastcell, lr;
	FILE *fp;

	strcpy(ifs, ",");
	if (!ask_for_str("Field separator(s):", ifs))
		return 1;

	if ((fp = fopen(fn, "w")) == (FILE *) 0)
		return 1;

	lr = line_last_used(buf);

	for (i = 1; i <= lr; i++) {
		lastcell = col_last_changed(buf, i);
		for (j = 1; j <= lastcell; j++) {
			if (j > 1) fprintf(fp, "%c", ifs[0]);


			if (ret_type(buf, i, j) != ERROR) {
				fprintf(fp, "%s",
					ret_pvalue(NULL, buf, i, j, -1));
			}

		}
		fprintf(fp, "\n");
	}
	fclose(fp);
	return 0;
}				/* save */

static double value;
static char instring[256];
static int pi;
static int sf = (HELVETICA | SIZE_10);

static int only_space(char *p)
{
	while (*p && isspace(*p)) p++;
	return (*p == '\0');
}

static int guess_type(char *p)
{
	char *endp;

	if (!strcmp(p, "")) return EMPTY;

	value = strtod(p, &endp);
	if (only_space(endp)) return EXPRESSION;

	return LABEL;
}

static void print_cell(buffer *b, int r, int c, char *p)
{
	char *texti;
	cval value;
	value.number = 0;

	switch (guess_type(p)) {
	case EMPTY:
		break;
	case EXPRESSION:
		texti = p;
		ins_data(b, siod_interpreter, texti,
			value, EXPRESSION, r, c);
		ins_format(b, r, c, sf);
		break;
	default:	/* anything else is a label */
		texti = p;
		ins_data(b, siod_interpreter, texti,
			value, LABEL, r, c);
		ins_format(b, r, c, sf);
	}
}

static int row, col;

static void emit(buffer *b, int c)
{
	if (c == '\n') {
		if (pi > 0) print_cell(b, row, col, instring);
		pi = 0;
		row++;
		col = 1;
	} else if (strchr(ifs, c)) {
		if (pi > 0) print_cell(b, row, col, instring);
		pi = 0;
		col++;
	} else {
		instring[pi++] = c;
	}
	instring[pi] = 0;
}

static int load_csv(char *fn, buffer *buf)
/* Returns: 0 if successful, otherwise 1 */
{
	int i, j;
	FILE *fp;
	int state = START, nextc;
	cval value;
	value.number = 0;

	strcpy(ifs, ",");
	if (!ask_for_str("Field separator(s):", ifs))
		return 1;

	if ((fp = fopen(fn, "r")) == NULL)
		return 1;

	for (i = line_last_used(buf); i > 0; i--)
		for (j = col_last_changed(buf, i); j > 0; j--) {
			ins_data(buf, siod_interpreter, NULL,
				value, EMPTY, i, j);
			ins_format(buf, i, j, sf);
		}

	pi = 0;
	row = 1;
	col = 1;

	while ((nextc = getc(fp)) != EOF) {
		if (nextc == '\n') {
			emit(buf, nextc);
			state = START;
		} else if (isspace(nextc)) {
			emit(buf, nextc);
		} else {
			switch (state) {
			case START:
				if (nextc == '\"') state = INSIDE;
				else if (strchr(ifs, nextc))
					emit(buf, nextc);
				else {
					emit(buf, nextc);
					state = OUTSIDE;
				}
				break;
			case INSIDE:
				/* silently swallow extra IFS */
				if (strchr(ifs, nextc));
				else if (nextc == '\"') state = OUTSIDE;
				else emit(buf, nextc);
				break;
			case OUTSIDE:
				if (strchr(ifs, nextc)) state = START;
				emit(buf, nextc);
				break;
			}
		}
	}

	fclose(fp);
	return 0;
} /* load */

static int save_txt(char *fn, buffer *buf)
{
   	int i, j, lastcell, lr;
	FILE *fp;

	if ((fp = fopen(fn, "w")) == (FILE *) 0)
		return 1;

	lr = line_last_used(buf);

	for (i = 1; i <= lr; i++) {
		lastcell = col_last_changed(buf, i);
		for (j = 1; j <= lastcell; j++) {
			if (j > 1) fprintf(fp, " ");

			if (ret_type(buf, i, j) != ERROR) {
				fprintf(fp, "%s",
					ret_pvalue(NULL, buf, i, j, -1));
			}
		}
		fprintf(fp, "\n");
	}
	fclose(fp);
	return 0;
}

static int load_txt(char *fn, buffer *buf)
{
	int i, j;
	char *texti;
	FILE *fp;
	char b[256], *p;
	cval value;
	value.number = 0;

	if ((fp = fopen(fn, "r")) == NULL)
		return 1;

	for (i = line_last_used(buf); i > 0; i--)
		for (j = col_last_changed(buf, i); j > 0; j--) {
			ins_data(buf, siod_interpreter, NULL,
				value, EMPTY, i, j);
			ins_format(buf, i, j, sf);
		}

	pi = 0;
	i = 1;

	while (fgets(b, 250, fp) != NULL) {
		if ((p = strchr(b, '\n'))) *p = '\0';
		texti = b;
		ins_data(buf, siod_interpreter, texti,
			value, LABEL, i, 1);
		ins_format(buf, i++, 1, sf);
	}

	fclose(fp);
	return 0;
}

/* conservative file format guessing:
   Never match, text files vary too much
*/
static int myformat(char *fn)
{
	return 0;
}

void fileio_txt_init()
{
	register_format(load_csv, save_csv, myformat,
		"Comma Separated Value (*.csv)");
	register_format(load_txt, save_txt, myformat,
		"Text (*.txt)");
}

