#include <stdlib.h>
#include <ctype.h>

/* Case insensitive compare */
int cstrcasecmp(const char *p, const char *q)
{
	int c;

	while (!(c = toupper(*p)-toupper(*q)) && *p) {
		p++;
		q++;
	}
	return c;
}

/* Case insensitive compare, length limited */
int cstrncasecmp(const char *p, const char *q, size_t n)
{
	size_t i = 0;
	int c = 0;

	while ((i < n) && !(c = toupper(*p)-toupper(*q)) && *p) {
		p++;
		q++;
		i++;
	}
	return c;
}

