#
# mountnfs.sh	Now that TCP/IP is configured, mount the NFS file
#		systems in /etc/fstab if needed. If possible,
#		start the portmapper before mounting (this is needed for
#		Linux 2.1.x and up).
#
# Version:	@(#)mountnfs.sh  1.00  22-Jun-1998  miquels@cistron.nl
#

. /etc/default/rcS

if grep -q '^[[:space:]]*[-_0-9a-zA-Z.]\+:.*/.*[[:space:]]nfs' /etc/fstab
then
	#
	#	We could check here if all NFS filesystems have the
	#	'nolock' option, in that case we would not need to start the
	#	portmapper. But to do that we should rewrite this
	#	script in bash (using arrays) or perl.
	#
	if [ -x /sbin/portmap ]
	then
		echo -n "Starting portmapper... "
		start-stop-daemon --start --quiet --exec /sbin/portmap
		sleep 2
		echo "mounting remote filesystems..."
	else
		echo "Mounting remote filesystems..."
	fi
	mount -a -t nfs
fi

