Summary: Process monitoring utilities
Name: procps
Version: 1.2.7
Release: 1
Copyright: GPL
Group: Utilities/System
Source: ftp://tsx-11.mit.edu/pub/linux/sources/usr.bin/procps-1.2.7.tar.gz

%package X11
Group: X11/Utilities
Summary: X-based process monitoring utilities

%description
A package of utilities which report on the state of the system,
including the states of running processes, amount of memory available,
and currently-logged-in users.

%description X11
A package of X-based utilities which report on the state of the system.
These utilities generally provide graphical presentations of information
available from tools in the procps suite.

%prep
%setup

%build
PATH=/usr/X11R6/bin:$PATH

make CC="gcc $RPM_OPT_FLAGS" LDFLAGS=-s

%install
make install
# Since this is specific to Red Hat now, we'll leave this in the spec file.
# If others decide they like wmconfig, we'll move it to the install phase
# of the Makefile.
install -m 644 -o 0 -g 0 top.wmconfig /etc/X11/wmconfig/top

make -C xcpustate install.man

# xcpustate doesn't need to be setuid
if [ -x /usr/X11R6/bin/xcpustate ]; then
	chmod 555 /usr/X11R6/bin/xcpustate
fi

%post
# add libproc to the cache
/sbin/ldconfig
# ask ps to set up /etc/psdevtab if /proc is mounted
if [ -f /proc/uptime ] ; then
  /bin/ps </dev/null >/dev/null 2>&1
fi

%files
%doc NEWS BUGS TODO
/bin/ps
/lib/libproc.so.1.2.6
/usr/bin/free
/usr/bin/sessreg
/usr/bin/skill
/usr/bin/snice
/usr/bin/tload
/usr/bin/top
/usr/bin/uptime
/usr/bin/vmstat
/usr/bin/w
/usr/bin/watch
/usr/man/man1/free.1
/usr/man/man1/ps.1
/usr/man/man1/sessreg.1
/usr/man/man1/skill.1
/usr/man/man1/snice.1
/usr/man/man1/tload.1
/usr/man/man1/top.1
/usr/man/man1/uptime.1
/usr/man/man1/w.1
/usr/man/man1/watch.1
/usr/man/man8/psupdate.8
/usr/man/man8/vmstat.8
/usr/sbin/psupdate
%config(missingok) /etc/X11/wmconfig/top

%files X11
/usr/X11R6/bin/XConsole
/usr/X11R6/bin/xcpustate
/usr/X11R6/man/man1/xcpustate.1x
