#include <strstream.h>
#include <iostream.h>
#include <fstream.h>
#include <set.h>
#include <list.h>
#include <getopt.h>
#include <ctype.h>
#include <unistd.h>
#include <stdlib.h>
#include <values.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include "menu-method.h"
#include <sys/stat.h>

int show_time=0, verbose=0, dodebug=0;

map <String, func *, less<String> > func_data;

menuentry menu;
configinfo *config;
supportedinfo *supported;
int linenumber=-123456;

ofstream *genoutputfile;

struct option long_options[] = { 
  { "showtime", no_argument, &show_time, 1 }, 
  { "verbose", no_argument, &verbose, 1 }, 
  { "debug", no_argument, &dodebug, 1 }, 
  { "help", no_argument, NULL, 'h' }, 
  { "stdin", no_argument, NULL, 'f' }, 
  { NULL, 0, NULL, 0 } };

void usage(){
  cerr<<"menu-method: generate window-manager 'rc' files (or html docs)"<<endl
      <<"  menu-method gets the menuentries from standard in."<<endl
      <<"  Options to menu-method: "<<endl
      <<"     -h --help : this message"<<endl
      <<"     -d --debug: show debug info"<<endl
      <<"     -showtime : show timeing information"<<endl;
  exit(1);
}

int store_func(func *f){
  func_data[f->name()]=f;
}
int add_functions(){
  store_func(new prefix_func);
  store_func(new ifroot_func);

  store_func(new print_func);
  store_func(new add_func);
  store_func(new sub_func);
  store_func(new mult_func);
  store_func(new div_func);
  store_func(new ifempty_func);
  store_func(new ifnempty_func);
  store_func(new iffile_func);
  store_func(new ifelsefile_func);
  store_func(new ifelse_func);
  store_func(new catfile_func);

  store_func(new ifeq_func);
  store_func(new ifneq_func);
  store_func(new ifeqelse_func);

  store_func(new cond_surr_func);
  store_func(new esc_func);
  store_func(new escwith_func);
  store_func(new escfirst_func);
  store_func(new tolower_func);  
  store_func(new toupper_func);
  store_func(new replacewith_func);
  store_func(new cppesc_func);
  store_func(new parent_func);
  store_func(new basename_func);
  store_func(new entrycount_func);
  store_func(new entryindex_func);
}


bool empty_String(const String &s){
  if(s.length()&&(s!="none"))
    return false;
  else
    return true;
}


cat_str *get_eq_cat_str(parsestream &i){
  i.skip_space();
  i.skip_char('=');
  return new cat_str(i);
}

int check_dir(String s){
  String t;
  int i;
  if(dodebug)
    cerr<<"CHECK_DIR: "<<s<<endl;
  while(s.length()){
    i=s.index('/',1);
    if(i>=0){
      t=s.before('/', 1)+'/';
      for(; ((unsigned int)i<s.length()) && (s[i]=='/'); i++);
      s=s.after(i-1);
    } else {
      t=s;
      s="";
    }
    if(chdir(t)<0){
      if(dodebug)
	cerr<<"MKDIR "<<t<<endl;
      if(mkdir(t,0755))
	throw dir_createerror(t);
      if(chdir(t))
	throw dir_createerror(t);
    } else {
      if(dodebug)
	cerr<<" dir "<<t<<" already exists "<<endl;
    }
  }
  return !s.length();
}

void closegenoutput(){
  (*genoutputfile)<<config->postoutput();
  delete genoutputfile;
}
void genoutput(const String &s,
	       map<String, String, less<String> > &v){
  
  static String outputname="";
  const char *t;
  String name;
  String dir;

  name=config->prefix()+"/"+config->genmenu->soutput(v);
  if(dodebug)
    cerr<<"GENOUTPUT: name="<<name<<endl;
  if(!(name==outputname)){
    if(genoutputfile)
      closegenoutput();
    outputname=name;
    check_dir(String_parent(outputname));
    t=outputname;
    genoutputfile=new ofstream(t);
    (*genoutputfile)<<config->preoutput();    
  }
  (*genoutputfile)<<s;
}

/////////////////////////////////////////////////////
//  Construction:
//


cat_str::cat_str(parsestream &i){
  char c;
  c=i.get_char();
  i.put_back(c);
  try{
    while(1){
      i.skip_space();
      c=i.get_char();
      i.put_back(c);
      if(isalpha(c))
	v.push_back(new func_str(i));
      else if(c=='\"') 
	v.push_back(new const_str(i));
      else if(c=='$') 
	v.push_back(new var_str(i));
      else if(c==',')
	break;
      else if(c==')')
	break;
      else if(c=='\0')
	break;
      else
	throw char_unexpected(&i, c);
    }
  }catch(endofline p){};
}

const_str::const_str(parsestream &i){
  data=i.get_Stringconst();
}

var_str::var_str(parsestream &i){
  i.skip_char('$');
  var_name=i.get_name();
}

func_str::func_str(parsestream &i){
  char c;
  String name;
  map <String, func *, less<String> >::iterator j;

  name=i.get_name();
  j=func_data.find(name);
  if(j==func_data.end()){
    throw unknown_function(&i);
  } else
    f=(*j).second;

  i.skip_space();
  i.skip_char('(');
  do{
    i.skip_space();
    c=i.get_char();
    if(c==')')
      break;
    i.put_back(c);
    args.push_back(new cat_str(i));
    i.skip_space();
  } while((c=i.get_char())&&(c==','));
  i.put_back(c);
  i.skip_char(')');
  if(args.size()!=(unsigned int)f->nargs())
    throw narg_mismatch(&i, name);
}


/////////////////////////////////////////////////////
//  Output routines
//

ostream &const_str::output(ostream &o, 
			   map<String, String, less<String> > &/*menuentry*/){
  return o<<data;
}

String cat_str::soutput(map<String, String, less<String> > &menuentry){
  char buf[MAX_BUF];
  vector <str * >::iterator i;
  ostrstream s(buf,sizeof(buf));
  
  for(i=v.begin();i!=v.end();i++)
    (*i)->output(s,menuentry);
  s<<ends;
  
  return String(buf);
}
ostream &cat_str::output(ostream &o, 
			 map<String, String, less<String> > &menuentry){
  o<<soutput(menuentry);
  return o;
}
void cat_str::output(map<String, String, less<String> > &menuentry){
  genoutput(soutput(menuentry),menuentry);
}

ostream &var_str::output(ostream &o,
			 map<String, String, less<String> > &menuentry){
  return o<<menuentry[var_name];
}
ostream &func_str::output(ostream &o,
			 map<String, String, less<String> > &menuentry){
  return f->output(o,args,menuentry);
}

/////////////////////////////////////////////////////
//  Debug routines
//
ostream &const_str::debuginfo(ostream &o){
  return o<<"CONST_STR: "<<data<<endl;
}
ostream &cat_str::debuginfo(ostream &o){
  vector<str *>::iterator i;
  o<<"CAT_STR: "<<endl;
  for(i=v.begin();i!=v.end();i++){
    (*i)->debuginfo(o);
  }
  return o;
}
ostream &var_str::debuginfo(ostream &o){
  return o<<"VAR_STR: "<<var_name<<endl;
}
ostream &func_str::debuginfo(ostream &o){
  o<<"FUNC_STR: "<<f->name()<<" ("<<endl;
  vector<cat_str *>::iterator i;  
  for(i=args.begin();i!=args.end();i++){
    o<<", ";
    (*i)->debuginfo(o);
  }
  return o<<")"<<endl;
}


/////////////////////////////////////////////////////
//  Function definitions:
//

ostream &prefix_func::output(ostream &o, vector<cat_str *> &,
			     map<String, String, less<String> > &){

  return o<<config->prefix();
}
ostream &ifroot_func::output(ostream &o, vector<cat_str *> & args,
			     map<String, String, less<String> > &menuentry){
  if(getuid())
    args[1]->output(o,menuentry);
  else
    args[0]->output(o,menuentry);

  return o;
}

ostream &print_func::output(ostream &o, vector<cat_str *> &args,
			    map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(empty_String(s)){
    cerr<<"Zero-size argument to print function";
    throw informed_fatal();
  }
  return o<<s;
}
ostream &ifempty_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(empty_String(s))
    args[1]->output(o,menuentry);
  return o;
}
ostream &ifnempty_func::output(ostream &o, vector<cat_str *> &args,
			       map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  if(!empty_String(s))
    args[1]->output(o,menuentry);
  return o;
}
ostream &iffile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s);
  if(f)
    args[1]->output(o,menuentry);
  return o;
}
ostream &ifelsefile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s);
  if(f)
    args[1]->output(o,menuentry);
  else
    args[2]->output(o,menuentry);
  return o;
}
ostream &catfile_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  ifstream f(s);
  char c;

  while(f && f.get(c))
    o<<c;
  return o;
}

ostream &esc_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  return o<<escape_String(args[0]->soutput(menuentry),
			  args[1]->soutput(menuentry));
}
ostream &escwith_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<escapewith_String(args[0]->soutput(menuentry),
			      args[1]->soutput(menuentry),
			      args[2]->soutput(menuentry));
}
ostream &escfirst_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String esc=args[1]->soutput(menuentry);
  String t;
  int  i;

  for(i=0;(unsigned int)i!=s.length();i++){
    if(esc.length() && esc.contains(s[i])){
      t=s.before(i);
      t+=args[2]->soutput(menuentry);
      t+=s.after(i-1);
      break;
    }
    t+=s[i];
  }
  return o<<t;
}
ostream &tolower_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<tolower_String(args[0]->soutput(menuentry));
}
ostream &toupper_func::output(ostream &o, vector<cat_str *> &args,
				  map<String, String, less<String> > &menuentry){

  return o<<toupper_String(args[0]->soutput(menuentry));
}
ostream &replacewith_func::output(ostream &o, vector<cat_str *> &args,
				  map<String, String, less<String> > &menuentry){

  return o<<replacewith_String(args[0]->soutput(menuentry),
			       args[1]->soutput(menuentry),
			       args[2]->soutput(menuentry));
}
ostream &cppesc_func::output(ostream &o, vector<cat_str *> &args,
			      map<String, String, less<String> > &menuentry){

  return o<<cppesc_String(args[0]->soutput(menuentry));
}

ostream &add_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x+y);
}
ostream &sub_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x-y);
}
ostream &mult_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));

  return o<<itoString(x*y);
}
ostream &div_func::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  int x=Stringtoi(args[0]->soutput(menuentry));
  int y=Stringtoi(args[1]->soutput(menuentry));
  
  if(y)
    return o<<itoString(x/y);
  else
    return o<<"0";
}

ostream &ifelse_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  (!empty_String(s)) ?
    args[1]->output(o,menuentry)
    :
    args[2]->output(o,menuentry);
  return o;
}
ostream &ifeq_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(s==t)
    args[2]->output(o,menuentry);
  
  return o;
}
ostream &ifneq_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(!(s==t))
    args[2]->output(o,menuentry);
  
  return o;
}
ostream &ifeqelse_func::output(ostream &o, vector<cat_str *> &args,
			   map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t=args[1]->soutput(menuentry);
  if(s==t)
    args[2]->output(o,menuentry);
  else
    args[3]->output(o,menuentry);

  return o;
}

ostream &cond_surr_func::output(ostream &o, vector<cat_str *> &args,
				map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  if(!empty_String(s)){
    args[1]->output(o,menuentry);
    args[0]->output(o,menuentry);
    args[2]->output(o,menuentry);
  }
  return o;
}

ostream &parent_func::output(ostream &o, vector<cat_str *> &args,
			     map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);

  return o<<String_parent(s);
}

ostream &basename_func::output(ostream &o, vector<cat_str *> &args,
			       map<String, String, less<String> > &menuentry){

  String s=args[0]->soutput(menuentry);
  String t;
  int  i,p,q;
  
  for(i=0,p=-1,q=0;(unsigned int)i!=s.length();i++)
    if(s[i]=='/'){
      q=p;
      p=i;
    }
  if(p<0)
    return o;
  else
    return o<<s.at(q+1,p-q-1);
}
ostream &entrycount_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<menuentry[PRIVATE_ENTRYCOUNT_VAR];
}
ostream &entryindex_func::output(ostream &o, vector<cat_str *> &/*args*/,
				 map<String, String, less<String> > &menuentry){
  return o<<menuentry[PRIVATE_ENTRYINDEX_VAR];
}

/////////////////////////////////////////////////////
//  "defined" function (macro).
//

ostream &func_def::output(ostream &o, vector<cat_str *> &args,
			  map<String, String, less<String> > &menuentry){

  String t;
  unsigned int i;
  map<String, String, less<String> > local_menuentry=menuentry;

  for(i=0; i<args_name.size(); i++)
    local_menuentry[args_name[i]]=args[i]->soutput(menuentry);

  f->output(o,local_menuentry);
  return o;
}
func_def::func_def(parsestream &i){
  char c;

  n=i.get_name();
  i.skip_space();
  i.skip_char('(');
  do{
    i.skip_space();
    c=i.get_char();
    if(c==')')
      break;
    i.put_back(c);
    i.skip_char('$');
    args_name.push_back(i.get_name());
    i.skip_space();
  } while((c=i.get_char())&&(c==','));
  i.put_back(c);
  i.skip_char(')');
  i.skip_space();
  i.skip_char('=');
  f=new cat_str(i);
}

/////////////////////////////////////////////////////
//  Supported stuff
//

supportedinfo::supportedinfo(parsestream &i){
  linenumber=1;
  int prec=0;
  while(1){
    try{
      String name;
      i.skip_space();
      name=i.get_name();
      if(name=="endsupported")
	return;
      name=upcase(name);
      if(dodebug)
	cerr<<"SUPPORTED_CONSTRUCT: name="<<name<<endl;
      
      supinf inf;
      inf.c=get_eq_cat_str(i);
      inf.prec=prec++;
      sup[name]=inf;
      if(dodebug)
	sup[name].c->debuginfo(cerr);
      i.skip_line();   //read away the final newline
    }
    catch(endofline d){}
  }
}

void supportedinfo::subst(map<String, String, less<String> > vars){

  map<String, String, less<String> >::iterator i;
  map<String, supinf, less<String> >::iterator j;

  if((i=vars.find(NEEDS_VAR))==vars.end()){
    cerr<<"Undefined "NEEDS_VAR" variable in menuentries"<<endl;
    throw informed_fatal();
  }
  if((j=sup.find(upcase((*i).second)))==sup.end()){
    cerr<<"Unknown "NEEDS_VAR"=\""<<(*i).second<<"\""<<endl;
    throw informed_fatal();
  }
  genoutput((*j).second.c->soutput(vars), vars);
}
int supportedinfo::prec(String &name){
  map<String, supinf, less<String> >::iterator i;
  int p;
  if((i=sup.find(upcase(name)))==sup.end())
    p=MAXINT;
  else
    p=(*i).second.prec;
  if(dodebug)
    cerr<<"PREC: name="<<upcase(name)<<"="<<p<<endl;
  return p;
}

ostream &supportedinfo::debuginfo(ostream &o){
  map<String, supinf, less<String> >::iterator i;
  for(i=sup.begin();i!=sup.end();i++){
    o<<"SUPPORTED:** name="<<(*i).first<<", prec="
	<<(*i).second.prec<<" Def="<<endl;
    (*i).second.c->debuginfo(o);
  }
  return o;
}
/////////////////////////////////////////////////////
//  configinfo
//
configinfo::configinfo(parsestream &i){
  String errmsg("Parse error: String constant expected");
  linenumber=1;
  treew="c(m)";
  prerun=postrun=genmenu=hkexclude=startmenu=endmenu=submenutitle=NULL;
  preout="#Automatically generated file. Do not edit (see /usr/doc/menu/html/index.html)\n\n";
  roots="/Debian";
  try{
    while(1){
        String name;
        name=i.get_name();
	if(name=="supported"){
	  i.skip_line();
	  supported=new supportedinfo(i);
	}
	else if(name=="function")
	  store_func(new func_def(i));
	else if(name=="startmenu")
	  startmenu=get_eq_cat_str(i);
	else if(name=="endmenu")
	  endmenu=get_eq_cat_str(i);
	else if(name=="submenutitle")
	  submenutitle=get_eq_cat_str(i);
	else if(name=="hotkeyexclude")
	  hkexclude=get_eq_cat_str(i);
	else if(name=="genmenu")
	  genmenu=get_eq_cat_str(i);	
	else if(name=="postrun")
	  postrun=get_eq_cat_str(i);	
	else if(name=="prerun")
	  prerun=get_eq_cat_str(i);	

	else if(name=="compat"){
	  if((compt=i.get_eq_Stringconst())!="menu-1"){
	    cerr<<"Unknown compat mode "<<compt<<" in config file (only know of \""COMPAT_MODE"\"";
	    throw informed_fatal();
	  }
	}
	else if(name=="rcfile")
	  rcf=i.get_eq_Stringconst();
	else if(name=="examplercfile")
	  exrcf=i.get_eq_Stringconst();
	else if(name=="mainmenutitle")
	  mainmt=i.get_eq_Stringconst();
	else if(name=="rootsection")
	  roots=i.get_eq_Stringconst();
	else if(name=="rootprefix")
	  rootpref=i.get_eq_Stringconst();
	else if(name=="userprefix")
	  userpref=i.get_eq_Stringconst();
	else if(name=="treewalk")
	  treew=i.get_eq_Stringconst();
	else if(name=="postoutput")
	  postout=i.get_eq_Stringconst();
	else if(name=="preoutput")
	  preout=i.get_eq_Stringconst();
	else if(name=="command"){
	  system(i.get_eq_Stringconst());
	  exit(0);
	}
	else if(name=="hotkeycase"){
	  String s=i.get_eq_Stringconst();
	  if(s=="sensitive")
	    hotkeycase=1;
	  else if (s=="insensitive")
	    hotkeycase=0;
	  else {
	    cerr<<"install-menus hotkeycase can only be {,in}sensitive"<<endl;
	    throw informed_fatal();
	  }
	}
	else
	  throw unknown_ident(&i);
      i.skip_line();//read away final newline
    }
  }
  catch(endoffile){}
  
  check_config();
}
void configinfo::check_config(){
  if(!(genmenu && startmenu && endmenu)){
    cerr<<"At least one of genmenu, startmenu, endmenu"<<endl
	<<"is undefined in the config file. All of these have to be "<<endl
	<<"defined (although they may be equal to \"\")"<<endl;
    throw informed_fatal();
  }
}
String configinfo::prefix(){
  if(getuid())
    return String(getenv("HOME"))+"/"+userprefix();
  else
    return rootpref;
}

ostream &configinfo::debuginfo(ostream &o){
    o<<"Using compatibility with:"<<compt<<endl
     <<"mainmenutitle   : "<<mainmt   <<endl
     <<"rootsection     : "<<roots    <<endl
     <<"rcfile          : "<<rcf      <<endl
     <<"examplercfile   : "<<exrcf    <<endl
     <<"root-prefix     : "<<rootpref <<endl
     <<"user-prefix     : "<<userpref <<endl
     <<"startmenu       : "<<endl;
    if(startmenu)
      startmenu->debuginfo(o);
    o<<"endmenu         : "<<endl;
    if(endmenu)
      endmenu->debuginfo(o);
    o<<"genmenu         : "<<endl;
    if(genmenu)
      genmenu->debuginfo(o);
    o<<"submenutitle    : "<<endl;
    if(submenutitle)
      submenutitle->debuginfo(o);
  o<<"mainmenutitle   : "<<mainmt   <<endl
   <<"treewalk        : "<<treew    <<endl;
  return o;
}

/////////////////////////////////////////////////////
//  Menuentry
//

void menuentry::add_entry(String sec, String fullsec, 
			  map<String, String, less<String> > &v){
  if(dodebug)
    cerr<<"ADDENTRY: sec="<<sec<<", needs="<<v["needs"]<<endl;
  if(sec.length()!=0){
    String name;
    map <String, menuentry *, less<String> >::iterator i;
    if(sec.contains("/")){
      name=sec.before("/");
      sec=sec.after("/");
    }
    else{
      name=sec;
      sec="";
      if(!v[COMMAND_VAR].length()){
	vars[TITLE_VAR]=name;
	vars=v;
	vars[SECTION_VAR]=fullsec;
	return;
      }
    }
    if(dodebug)
      cerr<<"ADD_ENTRY: name="<<name<<", sec="<<sec<<endl;
    if((i=submenus.find(name))!=submenus.end()){
      if (!sec.length()){
	if((supported->prec(((*i).second)->vars[NEEDS_VAR]) >
	    supported->prec(v[NEEDS_VAR]))){
	  delete submenus[name];
	  submenus[name]=new menuentry;
	} else
	  return;
      }
    }else
      submenus[name]=new menuentry;
    submenus[name]->add_entry(sec, fullsec+"/"+name , v);
    if(!submenus[name]->vars[TITLE_VAR].length())
      submenus[name]->vars[TITLE_VAR]=name;
  } else 
    vars=v;
  vars[SECTION_VAR]=fullsec;
}
void menuentry::output(){
  String treew=config->treewalk();
  map <String, menuentry *, less<String> >::iterator i;

  for(unsigned int j=0;j<treew.length(); j++){
    bool children_too=false;
    switch(treew[j]){
    case 'c':
      for(i=submenus.begin(); i!=submenus.end(); i++)
	if((*i).second->submenus.size())
	  (*i).second->output();
      break;
    case '(':
      if(submenus.size())
	if(config->startmenu)
	  config->startmenu->output(vars);
      break;
    case ')':
      if(submenus.size())
	if(config->endmenu)
	  config->endmenu->output(vars);
      break;
    case 'M':
      children_too=true;
    case 'm':;
      for(i=submenus.begin(); i!=submenus.end(); i++)
        if((*i).second->vars[COMMAND_VAR].length())
          supported->subst((*i).second->vars);
        else{
	  if(config->submenutitle)
	    config->submenutitle->output((*i).second->vars);
          if(children_too)
            (*i).second->output();
        }
    }
  }
}

void menuentry::postprocess(){
  map <String, menuentry *, less<String> >::iterator i;
  int index;
  for(i=submenus.begin(), index=0; 
      i!=submenus.end(); 
      i++, index++){
    (*i).second->vars[PRIVATE_ENTRYINDEX_VAR]=itoString(index);
    if((*i).second->submenus.size())
      (*i).second->postprocess();
    else
      (*i).second->vars[PRIVATE_ENTRYCOUNT_VAR]="0";
  }
  generate_hotkeys();
  vars[PRIVATE_ENTRYCOUNT_VAR]=itoString(submenus.size());
}
char menuentry::hotkeyconv(char h){
  if (config->hotkeycase)
    return h;
  else
    return tolower(h);
}
void menuentry::generate_hotkeys(){
  unsigned int i,j;
  list<int>::iterator k, old_k;
  map <String, menuentry *, less<String> >::iterator subi;
  map <String, String, less<String> >::iterator l;
  vector<String> keys;
  list<int> todo;
  set<char, less<char> > used_chars;
  String s;
  char c;

  if(config->hkexclude)
    s=config->hkexclude->soutput(vars);
  for(i=0;i!=s.length();i++)
    used_chars.insert(hotkeyconv(s[i]));

  for(subi=submenus.begin(), i=0; subi!=submenus.end(); subi++, i++){
    todo.push_back(i);
    l=(*subi).second->vars.find(HOTKEY_VAR);
    if(l!=(*subi).second->vars.end())
      keys.push_back((*l).second);
    else
      keys.push_back('\0');
    keys[i]+=sort_hotkey((*subi).second->vars[TITLE_VAR]);
  }
  j=0;
  while(todo.size()){
    for(k=todo.begin();k!=todo.end();){
      i=*k; 
      old_k=k++;//k++ here, to be able to todo.erase(old_k) safely.
      if(j>=keys[i].length()){
	keys[i]='\0';
	todo.erase(old_k);  //no hotkey found -- give up on this entry.
	continue;
      }
      c=keys[i][j];
      if(c){
	if(used_chars.find(hotkeyconv(c))==used_chars.end()){
	  todo.erase(old_k); //found a hotkey for this entry.
	  keys[i]=c;
	  used_chars.insert(hotkeyconv(c));
	  continue;
	}
	else
	  keys[i][j]='\0';
      }
    }
    j++;
  }
  for(subi=submenus.begin(), i=0; subi!=submenus.end(); subi++, i++){
    c=keys[i][0];
    if(c){
      (*subi).second->vars[HOTKEY_VAR]=c;
    }
  }
}
/////////////////////////////////////////////////////
//  Misc
//

map <String, String, less<String> > read_vars(parsestream &i){
  map <String, String, less<String> > m;
  try{
    String name, val;
    while(1){
      name=i.get_name();
      val=i.get_eq_Stringconst();
      m[name]=val;
    } 
  }
  catch(endofline p){};
  return m;
}
void check_vars(parsestream &i,
		map <String, String, less<String> > &m){
  vector <String> need;
  map <String, String, less<String> >::iterator j;
  unsigned int k;

  need.push_back(SECTION_VAR);
  need.push_back(TITLE_VAR);
  need.push_back(NEEDS_VAR);

  for(k=0;k<need.size();k++){
    j=m.find(need[k]);
    if((j==m.end())||((*j).second==""))
      throw missing_tag(&i,need[k]);
  }
}
void read_input(parsestream &i){
  String s;
  try{
    while(1){
      map <String, String, less<String> > m;
      String sec;
      m=read_vars(i);
      check_vars(i,m);
      sec=m[SECTION_VAR]+'/';
      if(m.find(SORT_VAR)!=m.end())
	sec=sec+m[SORT_VAR]+":";
      sec=sec+replace(m[TITLE_VAR],'/','_');
      if(supported->prec(m[NEEDS_VAR])!=MAXINT)
	menu.add_entry(sec,config->rootsection(),m);
      i.skip_line();   //read away the final newline
    }
  }
  catch(endoffile p){}
}


void includemenus(String o, String i,
                  String rep, String m){
  //copy filename i to filename o, replacing the line
  //rep with menu-file m
  char buf[MAX_BUF];
  char c;
  bool changed=false;
  ifstream fi(i);
  ifstream fm(m);
  
  if(!fi){
    cerr<<"Cannot open file "<<i<<endl; throw informed_fatal();}
  if(!fm){
    cerr<<"Cannot open file "<<m<<endl; throw informed_fatal();}

  ofstream fo(o);

  if(!fo){
    cerr<<"Cannot open file "<<o<<endl; throw informed_fatal();}

  {
    while(fi.get(buf,sizeof(buf))){
      if(String(buf).contains(rep,0)){
	while(fm.get(buf,sizeof(buf))){
	  fo<<buf<<endl;
	  fm.get(c);
	}
	changed=true;
      }
      else
	fo<<buf<<endl;
      fi.get(c);
    }
  }
  if(!changed)
    cerr<<"Warning: String \""<<rep
	<<"\" didn't occur in example file "<<i<<endl;
}

int main(int argc, char **argv){
  int c, option_index;
  char script[MAX_BUF];

  String menudefname;
  
  try{
    if(argv[1])
      strcpy(script, argv[1]);
    else{
      cerr<<"install-menu: First parameter must be name of script"<<endl;
      throw informed_fatal();
    }

    while(1){
      c = getopt_long (argc, argv, "fdvh", long_options, &option_index);
      if(c==-1) 
	break;
      switch(c){
      case '?': 
	cerr<<"Try  --help for more information.\n"<<endl;
	throw informed_fatal();
      case 'd': dodebug=1; break;
      case 'v': verbose=1;break;
      case 'h': usage(); break;
      case 'f':break;
      }
    } while (c!=-1);

    add_functions();
    parsestream ps(script);
    if(!ps.good()){
      cerr<<"Cannot open script "<<script<< " for reading"<<endl;
      throw informed_fatal();
    }
    config=new configinfo(ps);
    if(dodebug){
      config->debuginfo(cerr);
      supported->debuginfo(cerr);
    }
    if(config->prerun)
      system(config->prerun->soutput(menu.vars));
    parsestream psscript(cin);
    read_input(psscript);
    if(menu.vars[TITLE_VAR]=="")
      menu.vars[TITLE_VAR]=config->mainmenutitle();
    menu.postprocess();
    menu.output();
    closegenoutput();
    if(config->rcfile().length()&&config->examplercfile().length())
      includemenus(config->prefix()+"/"+config->rcfile(),
		   config->prefix()+"/"+config->examplercfile(),
		   "include-menu-defs",
		   config->prefix()+"/"+config->genmenu->soutput(menu.vars));
    if(config->postrun)
      system(config->postrun->soutput(menu.vars));
    exit(0);
  }
  //yes, I know this _should_ be handled in one
  //"derived" exception handler, but gcc doesn't like those
  // (I'm getting internal compiler errors now quite often
  // already, and I remember having them even more frequenly
  // with the -frtty stuff -- _I_WANT_gcc-2.8_!).
  catch(endoffile p){        p.report(cerr); }
  catch(endofline p){        p.report(cerr); }
  catch(char_expected p){    p.report(cerr); }
  catch(char_unexpected p){  p.report(cerr); }
  catch(ident_expected p){   p.report(cerr); }
  catch(narg_mismatch p){    p.report(cerr); }
  catch(unknown_function p){ p.report(cerr); }
  catch(unknown_ident p){    p.report(cerr); }
  catch(ferror_open p){      p.report(cerr); }
  catch(missing_tag p){      p.report(cerr); }
  //catch(dir_createerror d){
  //  cerr<<": Cannot create directory "<<d.name<<endl;
  //}
  catch(informed_fatal){};

  cerr<<script<<": Aborting"<<endl;

  exit(1);
}
