#include <stdio.h>
#include <assert.h>
#include "dinstall.h"
#include "../busybox/internal.h"
#include <newt.h>
#include "lang.h"

int true (void) {
    return 0;
}

static char * find_root (void) {
    char * root_device;
    char * target_device;

    if ( (root_device=block_device( T_FILE("/"),NULL )) == NULL ) {
	return NULL;
    }
    if ( (target_device=block_device( T_FILE("/target"),NULL )) == NULL ) {
	free(root_device);
	return NULL;
    }
    if ( strcmp(root_device,target_device) ){
	free(root_device);
	return target_device;
    }
    free(root_device);
    free(target_device);
    root_device=strdup("");
    return root_device;
}

static int require_root(void) {
  if (!Root) {
    problemBox(MSG_REQUIRE_ROOT,MSG_REQUIRE_ROOT_T);
    return 1;
  }
  return 0;
}

#ifdef DO_EJECT
void eject_floppy(const char *device)
{
  sprintf( prtbuf,"eject %s",device );
  system( prtbuf );
}
#endif

int main_menu (void) {
    int (*next_action)(void);
    int (*alternate_action)(void);
    int (*alternate1_action)(void);
    int (*previous_action)(void);
    int (*previous1_action)(void);
    char *bufT,*bufN,*bufA,*bufA1,*bufP,*bufP1;

#define OPT_NULL	1000
#define OPT_Next	1001
#define OPT_Alternate	1002
#define OPT_Alternate1	1003
#define OPT_Previous	1004
#define OPT_Previous1	1005
#define OPT_A		1006
#define OPT_B		1007
#define OPT_C		1008
#define OPT_D		1009
#define OPT_E		1010
#define OPT_F		1011
#define OPT_G		1012
#define OPT_H		1013
#define OPT_I		1014
#define OPT_J		1015
#define OPT_L		1016
#define OPT_M		1017
#define OPT_N		1018
#define OPT_O		1019
#define OPT_P		1020
#define OPT_Q		1021
#define OPT_R		1022
#define OPT_S		1023
#define OPT_T		1024
#define OPT_Y		1025
#define OPT_Z		1026
    int *data, ans[]={ OPT_NULL, OPT_Next, OPT_Alternate, OPT_Alternate1, 
	OPT_Previous, OPT_Previous1, OPT_A, OPT_B, OPT_C, OPT_D, OPT_E, 
	OPT_F, OPT_G, OPT_H, OPT_I, OPT_J, OPT_L, OPT_M, OPT_N, OPT_O,
	OPT_P, OPT_Q, OPT_R, OPT_S , OPT_T, OPT_Y, OPT_Z }, width, height;
    newtComponent f1, t1, lb;

    char *found_root=NULL;
    struct stat statbuf;

    for (;;) {
/*
	# EZ: Already done with newtSetSuspendCallback?
    # Ignore interrupt in scripts, catch it in programs started by scripts.
	trap true 2 3
*/

	pleaseWaitBox(MSG_WAIT_STATE);

	if (Root) {
	    found_root = strdup(Root->name);
	} 

	fdisk_reread();

	if (found_root) {
	    Root = fdisk_find_partition(found_root);
	    free(found_root);
	    found_root=NULL;
	}

	if (! ( found_root = find_root() ) ){
	    if (Root) {
		sprintf(prtbuf,MSG_TROUBLE_ROOT_OK,Root->name); 
	    } else {
		sprintf(prtbuf,MSG_TROUBLE_ROOT_KO);
	    }
	    problemBox(prtbuf,MSG_PROBLEM);
	} else if ( ! Root ) {
	    Root = fdisk_find_partition(found_root);
	} else if (strcmp(Root->name, found_root)) {
	    sprintf(prtbuf,MSG_ROOT_CHANGED,Root->name,found_root);
	    problemBox(prtbuf,MSG_ROOT_CHANGED_T);
	    Root = fdisk_find_partition(found_root);
	}
	if (found_root) {
            free(found_root);
	    found_root=NULL;
        }

	newtPopWindow();

	/* start building  menu entries */

	next_action = alternate_action = alternate1_action = &true;
	previous_action = previous1_action = &true;
	bufA = bufA1 = bufP = bufP1 = "";

	if ( (! NAME_ISREG( T_FILE("/tmp/kbdconf"), &statbuf) ) &&
	     NAME_ISEXE( T_FILE("/bin/loadkmap"), &statbuf) ) {
	    next_action=configure_keyboard;
	    alternate_action=partition_disk;
	    bufT=MSG_KEY_NOT_CONFIGURED;
	    bufN=MSG_CONFIGURE_KEY;
	    bufA=MSG_PARTITION_DISK;
	} else if ( (swapon_partitions == NULL) && 
		    (fdisk_partitions_by_type[FSTYPE_SWAP] == NULL) &&
		    (noSwap == 0) ){
	/* No "Linux swap" partitions have been created. */
	    next_action=partition_disk;
	    alternate_action=no_swap;
	    bufT=MSG_NO_SWAP;
	    bufN=MSG_PARTITION_DISK;
	    bufA=MSG_DO_WITHOUT_SWAP;
	} else if (fdisk_partitions_by_type[FSTYPE_EXT2] == NULL) {
	/* No "Linux native" partitions have been created. */
	    next_action=partition_disk;
	    bufT=MSG_NO_LINUX;
	    bufN=MSG_PARTITION_DISK;
	} else if ( (swapon_partitions == NULL) && (noSwap == 0)) {
	/* The swap partition has not been initialized and activated. */
	    next_action=init_swap;
	    alternate_action=activate_swap;
	    alternate1_action=no_swap;
	    previous_action=partition_disk;
	    bufT=MSG_LINUX_AND_SWAP;
	    bufN=MSG_INITIALIZE_SWAP;
	    bufA=MSG_ACTIVATE_SWAP;
	    bufA1=MSG_DO_WITHOUT_SWAP;
	    bufP=MSG_PARTITION_DISK;
	} else if (! Root) {
	/* The root partition has not been mounted. */
	    next_action=init_linux;
	    alternate_action=mount_any;
	    bufT=MSG_NONE_MOUNTED;
	    bufN=MSG_INITIALIZE_LINUX;
	    bufA=MSG_MOUNT_LINUX;
	} else if ( (! NAME_ISREG(T_FILE("/target/vmlinuz"),&statbuf) ) || 
                    (! NAME_ISREG(T_FILE(
		    "/target/usr/lib/module_help/descr.gz"),&statbuf) ) ) {
            /* The operating system kernel and the modules */
            /* have not been installed. */
            next_action=extract_kernel_and_modules;
            alternate_action=init_linux;
            alternate1_action=mount_any;
            bufT=MSG_ROOT_MOUNTED;
            bufN=MSG_INSTALL_OS;
            bufA=MSG_INITIALIZE_LINUX;
            bufA1=MSG_MOUNT_LINUX;
	} else if (! NAME_ISREG( T_FILE("/target/etc/modules"),&statbuf) ) {
	/* The modules have not been configured. */
	    next_action=configure_drivers;
	    bufN=MSG_CONFIGURE_MODULES;
	  if(! NAME_ISREG( T_FILE("/target/etc/pcmcia.conf"), &statbuf) ) {
	    bufT=MSG_OS_INSTALLED_PCMCIA; 
	    alternate_action=configure_pcmcia;
	    bufA=MSG_CONFIGURE_PCMCIA;
	  } else {
	    bufT=MSG_OS_INSTALLED;
	  }
	} else if (! NAME_ISREG( T_FILE("/target/etc/hostname"),&statbuf) ) {
	/* The network has not been configured. */
	    next_action=configure_network;
	    bufT=MSG_NET_UNCONFIGURED; 
	    bufN=MSG_CONFIGURE_NET;
	} else if (! NAME_ISREG( T_FILE("/target/sbin/init"),&statbuf) ) {
	/* The base system has not been installed. */
	    next_action=extract_base;
	    bufT=MSG_MODULES_CONFIGURED;
	    bufN=MSG_INSTALL_BASE;
	} else if ( NAME_ISREG( T_FILE("/target/sbin/unconfigured.sh"),&statbuf) ) {
	/* The base system has not been configured. */
	    next_action=configure_base;
	    bufT=MSG_BASE_INSTALLED;
	    bufN=MSG_CONFIGURE_BASE;
	} else if ( notCreatedBootFloppy && notInstalledLILO ) {
	    next_action=make_bootable;
	    alternate_action=make_boot_floppy;
	    alternate1_action=reboot_system;
	    bufT=MSG_NO_BOOT;
	    bufN=MSG_DISK_BOOT;
	    bufA=MSG_FLOPPY_BOOT;
	    bufA1=MSG_REBOOT;
	} else if ( notCreatedBootFloppy ) {
	/* The boot floppy has not been created. */
	    next_action=make_boot_floppy;
	    alternate_action=reboot_system;
	    bufT=MSG_NO_BOOT_FLOPPY;
	    bufN=MSG_FLOPPY_BOOT;
	    bufA=MSG_REBOOT;
	} else {
	/* Nothing left to do but reboot the system. */
	    next_action=reboot_system;
	    bufT=MSG_MOMENT_OF_TRUTH;
	    bufN=MSG_REBOOT;
	}

	newtOpenWindow (2, 2, 76, 19, MSG_TITLE_MENU);
	t1 = newtTextbox (1, 0, 74, 4, NEWT_FLAG_WRAP);
	newtTextboxSetText(t1,bufT); 
        height=newtTextboxGetNumLines(t1);
        newtTextboxSetHeight(t1,height);
	width = 48;
	if(strlen(bufN) + 12 > width)
		width = strlen(bufN) + 12;
	if(strlen(bufP) + 12 > width)
		width = strlen(bufP) + 12;
	if(strlen(bufA) + 12 > width)
		width = strlen(bufA) + 12;
	if(strlen(bufA1) + 12 > width)
		width = strlen(bufA1) + 12;
	lb = newtListbox((68-width)/2,height, 19-height, NEWT_FLAG_DOBORDER | NEWT_FLAG_RETURNEXIT);
	sprintf(prtbuf,MSG_NEXT,bufN);
	newtListboxAddEntry(lb, prtbuf, &ans[1]);
	if (bufA[0]) {
	    sprintf(prtbuf,MSG_ALTERNATE,bufA);
	    newtListboxAddEntry(lb, prtbuf, &ans[2]);
	}
	if (bufA1[0]) {
	    sprintf(prtbuf,MSG_ALTERNATE1,bufA1);
	    newtListboxAddEntry(lb, prtbuf, &ans[3]);
	}
	if (bufP[0]) {
	    sprintf(prtbuf,MSG_PREVIOUS,bufP);
	    newtListboxAddEntry(lb, prtbuf, &ans[4]);
	}
	if (bufP1[0]) {
	    sprintf(prtbuf,MSG_PREVIOUS1,bufP1);
	    newtListboxAddEntry(lb, prtbuf, &ans[5]);
	}
	newtListboxAddEntry(lb, " ", &ans[0]);
	newtListboxAddEntry(lb,MSG_CONFIGURE_KEY,&ans[6]);
	newtListboxAddEntry(lb,MSG_PARTITION_DISK,&ans[7]);
	newtListboxAddEntry(lb,MSG_INITIALIZE_SWAP,&ans[8]);
	newtListboxAddEntry(lb,MSG_ACTIVATE_SWAP,&ans[9]);
	newtListboxAddEntry(lb,MSG_DO_WITHOUT_SWAP,&ans[10]);
	newtListboxAddEntry(lb,MSG_INITIALIZE_LINUX,&ans[11]);
	newtListboxAddEntry(lb,MSG_MOUNT_LINUX,&ans[12]);
	newtListboxAddEntry(lb,MSG_UMOUNT_LINUX,&ans[13]);
	newtListboxAddEntry(lb,MSG_INSTALL_OS,&ans[14]);
	newtListboxAddEntry(lb,MSG_INSTALL_BASE,&ans[15]);
	newtListboxAddEntry(lb,MSG_CONFIGURE_MODULES,&ans[16]);
	newtListboxAddEntry(lb,MSG_CONFIGURE_BASE,&ans[17]);
	newtListboxAddEntry(lb,MSG_CONFIGURE_NET,&ans[18]);
	newtListboxAddEntry(lb,MSG_DISK_BOOT,&ans[19]);
	newtListboxAddEntry(lb,MSG_FLOPPY_BOOT,&ans[20]);
	newtListboxAddEntry(lb,MSG_REBOOT,&ans[21]);
	newtListboxAddEntry(lb,MSG_VIEW_PARTITIONS,&ans[22]);
	newtListboxAddEntry(lb,MSG_EXECUTE_SHELL,&ans[23]);
	newtListboxAddEntry(lb,MSG_CONFIGURE_PCMCIA,&ans[24]);
#ifdef DO_EJECT
	newtListboxAddEntry(lb,MSG_EJECT_FLOPPY,&ans[25]);
#endif
	newtListboxAddEntry(lb,MSG_RESTART_DINSTALL,&ans[26]);

	f1 = newtForm(NULL, NULL, 0);
	newtFormAddComponents (f1 , t1, lb, NULL);

	do {
	    newtRunForm(f1);
	    data = newtListboxGetCurrent(lb);
	} while (*data == OPT_NULL);

	newtPopWindow();
	newtFormDestroy(f1);

	switch (*data) {
	    case OPT_Next: next_action(); break;
	    case OPT_Alternate: alternate_action(); break;
	    case OPT_Alternate1: alternate1_action(); break;
	    case OPT_Previous: previous_action(); break;
	    case OPT_Previous1: previous1_action(); break;
	    case OPT_NULL: break;
	    case OPT_A: configure_keyboard(); break;
	    case OPT_B: partition_disk(); break;
	    case OPT_C: init_swap(); break;
	    case OPT_D: activate_swap(); break;
	    case OPT_E: no_swap(); break;
	    case OPT_F: init_linux(); break;
	    case OPT_G: mount_any(); break;
	    case OPT_H: unmount_any(); break;
	    case OPT_I:
	      if (Root) { 
		extract_kernel_and_modules(); 
	      } else { require_root(); } break;
	    case OPT_J:
	      if (Root) { 
		extract_base();
	      } else { require_root(); } break;
	    case OPT_L:
	      if (Root) { 
		configure_drivers();
	      } else { require_root(); } break;
	    case OPT_M:
	      if (Root) { 
		configure_base(); 
	      } else { require_root(); } break;
	    case OPT_N:
	      if (Root) { 
		configure_network();
	      } else { require_root(); } break;
	    case OPT_O:
	      if (Root) { 
		make_bootable();
	      } else { require_root(); } break;
	    case OPT_P:
	      if (Root) { 
		make_boot_floppy();
	      } else { require_root(); } break;
	    case OPT_Q: reboot_system(); break;
	    case OPT_R: view_partitions(); break;
	    case OPT_S: interactive_shell(); break;
	    case OPT_T:
	      if (Root) {
		configure_pcmcia();
	    } else { require_root(); } break;
#ifdef DO_EJECT
	    case OPT_Y: do_eject(); break;
#endif
	    case OPT_Z: exit(-1);	/* restart dinstall */
	    default: assert(0);
	}
    }
    return 0;
}
