#!	/bin/sh
# Root Disk maker. Bruce Perens, December 1995
# Dale Scheetz, Sven Rudolph 1996, 1997
# Enrique Zanardi 1998
# Eric Delaunay, 1998 [sparc + net boot]
# This is free software under the GNU General Public License.

# Dumb GNU tar is broken at the moment.
set -e
#set -v
set -x

export LANG=C

first () {
	echo $1
}

last () {
	eval 'echo $'$#
}

# Abort on any non-zero return.
umask 022

if [ $# != 5 ]; then
echo "Usage: "$0" revision-extension archive blocks debian-version system" 1>&2
	cat 1>&2 << EOF

	revision-extension: the revision extension of the kernel.
	archive: the directory containing the Debian binary packages.
	blocks: the size of the floppy in 1K blocks, use 720, 1200, or 1440.
	debian-version: version of the Debian release.
	system: name of the target system.
EOF

	exit -1
fi

revext=$1

# Set this to the location of the package archive.
archive=$2

# Set to the number of blocks per floppy.
blocks=$3

#Set this to the Debian version
debianversion=$4

# Set this to the system
system=$5

# Set this to the block device for the floppy disk.
floppy=/var/tmp/floppy-image.$$

mnt=/var/tmp/mnt.rootdisk

if [ ! -d $archive/. ]; then
	echo "Error: "$archive": not a directory." 1>&2
	exit -1
fi

. common.sh

# To build a rootdisk for an other architecture we need the name
export arch="`dpkg --print-architecture`"

if [ "$arch" = "m68k" ]; then
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.0.6
elif [ "$arch" = "sparc" ]; then
	export ldlib=ld-linux.so.2
	libcso=unknown
	libcver=2.0.93
elif [ "$arch" = "alpha" ]; then
	export ldlib=ld-linux.so.2
	libcso=libc.so.6.1
	libcver=2.0.6
else # i386
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.0.7
fi
echo ld.so: $ldlib

# [ED] Hmm, either KVER should be passed to make or this call completely
#      removed.  BTW, make is called from the top Makefile (all_subdirs target)
#(cd utilities; make)

# Try to unmount anything that should not be mounted.
(umount $mnt; umount $floppy; true)2>/dev/null >/dev/null

# ED: kludge - add 800KB to the image size for sparc arch to hold the full libc6
if [ "$arch" = sparc ]; then
	blocks=`expr $blocks + 800`
	fstype=ext2
else
	fstype=minix
fi
# ED: don't make a floppy for net boot, just create an archive in
#     debian-$arch-root subdirectory
if [ "$revext" = net ]; then
	mnt="$mnt/debian-${arch}-root"
	mkdir -p $mnt
	fstype=nfs
else
	mkdir -p $mnt

	# Zero the entire disk, so that when I compress the raw disk image,
	# unused blocks will compress well.
	dd if=/dev/zero of=$floppy bs=1k count=${blocks}

	# Make a Minix/ext2 filesystem.
	case $fstype in
	minix)
		/sbin/mkfs.minix -n30 -i 850 $floppy ${blocks}
		;;
	ext2)
		mke2fs -F -i 2048 $floppy ${blocks}
		;;
	esac

	# Mount the disk.
	mount -t $fstype -o loop $floppy $mnt

	# get more space on ext2 fs
	[ $fstype = ext2 ] && rmdir $mnt/lost+found
fi

# Temporary directories
E=/var/tmp/extract-tmp-$$
R=/var/tmp/root-tmp-$$

# The home of the scripts used by this script.
scripts=`pwd`/scripts/rootdisk

exit=false

for i in \
	$scripts/EXTRACT_LIST_all \
	$scripts/EXTRACT_LIST_${arch} \
	$scripts/SMALL_BASE_LIST_all \
	$scripts/SMALL_BASE_LIST_${arch} \
	$scripts/LINKS \
	;do
	if [ ! -f $i ]; then
		echo "Can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1
fi

# A list of all the hard links to make to the "busybox" program.
LINKS="`grep -v '^#' $scripts/LINKS`"

# Expand the package names into full pathnames.
PACKAGE_PATHS=`make_paths \`cat $scripts/EXTRACT_LIST_all $scripts/EXTRACT_LIST_${arch}\``

if $exit; then
	exit -1
fi

if [ -d $E ]; then
	mv -f $E $E.old
	rm -f -r $E.old &
fi

mkdir -p -m 755 $E

for i in $PACKAGE_PATHS; do
	echo Extracting $i 1>&2
	dpkg-deb --extract $i $E
done

$scripts/strip_executables $E/bin/* $E/usr/bin/* $E/sbin/* $E/usr/sbin/* \
 $E/lib/* $E/usr/lib/*

# XXX: makedev should accept alternate location of config files
# Bug:
# MAKEDEV-C doesn't take an argument to select the config file, so we are
# currently using the installed ones in /etc.

mkdir -p $R/dev/inet
case "$arch" in
	i386)
		(cd $R/dev; /dev/MAKEDEV -I boot-floppies )
# [EZ] boot-floppies-i386 doesn't create devices for MCA ESDI hard disks (yet)
		(cd $R/dev; /dev/MAKEDEV -I ed )
		;;
	alpha)
		(cd $R/dev; /dev/MAKEDEV -I boot-floppies-i386 )
		;;
	*)
		(cd $R/dev; /dev/MAKEDEV -I boot-floppies )
		;;
esac
# add the NFSROOT device for net booting
[ "$revext" = net ] && mknod $R/dev/root b 0 1

#( cd $R/dev;  rm -f ippp* isdn* isdnctrl* vcs[2-6]? vcsa[2-6]? \
#	[pt]ty[qrs]* tty[3-6]? ttyI?? )

T=./tmp-$$
mkdir $T
(cd $scripts/prototype; tar clf - . --exclude CVS --exclude .tar-place-holder)\
  | (cd $T;tar xlpf -)
# fix etc/rc
sed -e "s/__FSTYPE__/$fstype/" < $scripts/prototype/etc/rc > $T/etc/rc

# create symlinks in tempdir (cvs doesn't preserve symlinks)
ln -sf ps $T/bin/uname
ln -sf ../bin/ps $T/sbin/lsmod
ln -sf ../bin/ps $T/sbin/lilo
ln -sf ../../bin/ps $T/usr/bin/emacs
ln -sf ../../bin/ps $T/usr/bin/grep
# superformat calls mformat automatically
ln -sf ../../bin/ps $T/usr/bin/mformat
ln -sf ../../bin/ps $T/usr/bin/vi
ln -sf ../tmp $T/var/

(cd $T; tar clf - . ) | (cd $R;tar xlpf -)
rm -rf $T

# Use tar to do the copying because it preserves hard links.
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST_all -cf -)|(cd $R;tar xlpf -)
(cd $E; tar --files-from=$scripts/SMALL_BASE_LIST_${arch} -cf -)|(cd $R;tar xlpf -)

# Create passwd and group from base-passwd master files
cp $E/usr/share/base-passwd/passwd.master $R/etc/passwd
cp $E/usr/share/base-passwd/group.master $R/etc/group

# Create conf.modules from the architecture-dependent one
for f in $E/etc/modutils/conf.${arch}.${system} \
		$E/etc/modutils/conf.${arch} \
		$E/etc/modutils/conf.generic; do
	if [ -f $f ]; then
		cp $f $R/etc/conf.modules
		break 
	fi
done

# ED: add a prototype for bootable floppy image on sparc architecture (SILO)
if [ "$arch" = sparc ]; then
	mkdir $R/usr/lib/dinstall
	cp silo1440k.gz $R/usr/lib/dinstall
	# superformat doesn't work at all.  Remove it actually (one have to
	# provide a formatted medium to create the rescue disk).
	rm -f $R/usr/bin/superformat
fi

if [ "$revext" = lowmem ]; then
	( cd $R; rm -f sbin/badblocks sbin/cfdisk sbin/e2fsck;
		rm -f sbin/fsck sbin/fsck.ext2 sbin/pnpdump sbin/route;
		rm -f sbin/ifconfig sbin/isapnp sbin/losetup;
		rm -rf etc/terminfo/a;
		rm -f bin/cpio bin/mount bin/umount;
		rm -f usr/bin/superformat;
	)
fi

# Copy the required libraries
LIBRARIES=""
EXECUTABLES="$R/bin/* $R/sbin/* $R/usr/bin/*"

#   ldconfig.new is statically linked
EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig.new%%g`

#   Look for the required libraries under $E
TMP=`LD_LIBRARY_PATH=$E/lib:$E/usr/lib ldd $EXECUTABLES 2>/dev/null | \
	awk -v E="^$E" -v L="/lib/$ldlib" -- '$3=="not" {print $1; next}; \
		($3!~E) && ($1!~L) {print $3}' | \
	sort -u`

#        awk -v E="^$E" -v L="$ldlib" -- '$3=="not" {print $1; next}; \
#		($3!~E) && ($1!~"/lib/"L) {print $3}' | \
#	sort -u`

#   ld-linux.so.2 is always linked with its full path, so ldd won't look
#   for it under $E. We have to do it 'by hand'
if [ ! -f $E/lib/$ldlib ]; then
	TMP="$TMP /lib/$ldlib"
fi

if [ ! -z "$TMP" ]; then
        echo "The following required libraries weren't extracted:"
        echo $TMP
        exit -1
fi

#   We have all the required libraries. Copy them under $R
TMP=`LD_LIBRARY_PATH=$E/lib:$E/usr/lib ldd $EXECUTABLES 2>/dev/null | \
        awk -- '{print $3}' |sort -u`
for i in $TMP; do 
	j=`echo $i |sed -e "s%^$E%.%g" -e "s%^/%./%" `
	LIBRARIES="$LIBRARIES $j" 
        if [ -L $i ]; then
                j=`ls -l $i |awk -v J=\`dirname $i\` -- '{print J"/"$NF}' | \
                        sed -e "s%^$E%.%g" -e "s%^/%./%" `
                LIBRARIES="$LIBRARIES $j"
        fi
done
# Add the resolver and DNS libraries
LIBRARIES="$LIBRARIES ./lib/libresolv-$libcver.so ./lib/libnss_dns-$libcver.so"
(cd $E; tar -cf - $LIBRARIES)|(cd $R ; tar xlpf -)

rm -f -r $E &

cp utilities/busybox/busybox $R/sbin/init
cp keymaps.tgz $R/etc/

$scripts/strip_executables $R/sbin/init

(cd $R; for j in ${LINKS}; do \
	if [ ! -f $j ]; then \
		ln sbin/init $j ; \
	fi; \
done; )

if [ "$revext" != lowmem ]; then
	(cd $R/sbin; ln e2fsck fsck.ext2)
	(cd $R/sbin; ln e2fsck fsck)
fi

(cd $R/bin; ln ash sh)
(cd $R/bin; ln ae edit)
# ED: this link is already in the sparc libc6 package [bug?]
if [ ! -f $R/lib/ld-linux.so.2 ]; then
	(cd $R/lib; ln `last ld-2.*.so` $ldlib)
fi

if [ "$revext" = lowmem ]; then
	touch $R/etc/revision_ext.$revext
fi

m4 $scripts/release_notes -D__debianversion__=$debianversion \
	-D__date__="`date '+%B %d, %Y'`" \
	-D__username__="`dpkg-parsechangelog | \
			awk -- '/^Maintainer/ {$1="" ; print $0}'`" \
	>$R/release_notes

# Kludge - remove when this is fixed.
if [ "$arch" = "m68k" ]; then
#We need a fdisk-wrapper...
  cp $scripts/fdisk-m68k $R/sbin/fdisk
fi

# ED: sparc partially supports library reduction (bug in the linker)
#     libslang is ok but not libc6 :-P

if [ ! "$arch" = sparc ]; then
	rm -f $R/lib/libc-$libcver.so $R/lib/$libcso
fi

SLVER=0.99.38
SLMAJ=0.99.38
rm -f $R/usr/lib/libslang.so.$SLVER $R/lib/libslang.so.$SLVER

EXECUTABLES="$R/bin/* $R/sbin/* $R/usr/bin/* $R/usr/sbin/* $R/lib/* $R/usr/lib/*"
#   ldconfig.new is statically linked
EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig.new%%g`

$scripts/generate_library libslang.so.$SLVER "-t /usr/lib/libslang$SLMAJ*_pic.a \
	/lib/$libcso" $R/lib/libslang.so.$SLVER $EXECUTABLES

EXECUTABLES="$EXECUTABLES $R/lib/libslang.so.$SLVER"

if [ ! "$arch" = sparc ]; then
	$scripts/generate_library $libcso "/usr/lib/libc_pic/soinit.so \
	    /usr/lib/libc_pic.a /usr/lib/libc_pic/sofini.so \
	    /usr/lib/libc_pic/interp.so $R/lib/$ldlib -e __libc_main" \
	    $R/lib/$libcso $EXECUTABLES
fi

/usr/sbin/chroot $R /sbin/ldconfig.new -v
rm -f $R/sbin/ldconfig.new &

# Replace symbolic links on the floppy with hard links! This saves one block
# per link.
(cd $R;find . -type l -printf '(cd `dirname %p`;if [ ! -d %l ]; then rm %f; if ln %l %f 2>/dev/null; then true; else ln -s %l %f ; fi; fi)\n') | (cd $R ;sh)

echo "root">$R/type.txt

#copy to floppy image

(cd $R; tar cf - .) | (cd $mnt; tar xpf -)

rm -f -r $R &

# Adjust the owner and permissions

chown -R root.root $mnt/*
chmod -R og=rX $mnt/*

if [ "$revext" = net ]; then
	# Archive the debian-$arch-root directory
	(cd $mnt/..; tar cf $mnt.tar `basename $mnt`)
	rm -f root.tar root.tar.gz
	mv $mnt.tar root.tar
	rm -fr `dirname $mnt` &				# clean up
	gzip -9 root.tar
	ls -l root.tar.gz
else
	# Umount the floppy and copy it to a compressed raw disk image file.
	df $mnt
	umount $mnt
	rmdir $mnt

	(rm -f root$revext.bin ;true)
	if [ "$revext" = lowmem ]; then
		cp $floppy root$revext.bin
	else
		gzip -9f <$floppy >root$revext.bin
	fi
	ls -l root$revext.bin
fi
rm -f $floppy
exit 0
