package LastLyX;
# This package is the last step in creating a LyX file. It:
#  - rejoins the lyx preamble to the rest of the file
#  - translates any remaining unknown commands (well, not yet -Ak 980131)
#  - creates a '.lyx' file

use strict;

sub last_lyx {
# Arg0 is input file name
# Arg1 is output file name (foo.lyx)
# Arg2 is a string containing the entire preamble

    my ($InFileName, $OutFileName, $LyXPreamble) = (shift, shift, shift);
    warn "Writing LyX file $OutFileName... \n";
    open (INFILE, "<$InFileName");
    open (OUTFILE, ">$OutFileName");

    # Print the preamble
    print OUTFILE $LyXPreamble;

    # Now print out the rest of the LyX file
    # In the future, we could buffer text, and then get rid of extra
    #     '\latex default \latex latex' or '\end_deeper \begin_deeper' pieces
    #     created by the translator
    while (<INFILE>) {
        print OUTFILE $_;
    }

    close INFILE; close OUTFILE;
    warn "Done writing LyX file!\n";
} # end sub last_lyx

1; # return true to main package
