# This makefile processes the jgraph example *.jgr files
# and produces *.jps files from them
#
# For more information, see the jagrph(1) man page

EXAMPLES = \
	acc.jps		\
	acc.eps		\
	alb.jps		\
	ad.jps		\
	bailey.jps	\
	ebars.jps	\
	ex1.jps		\
	ex2.jps		\
	g8.jps		\
	g8col.jps	\
	g9n10.jps	\
	gpaper.jps	\
	hypercube.jps	\
	mab2.jps	\
	nr.jps	\
	sin.jps		\
	sin1.jps	\
	sin2.jps	\
	sin3.jps	\
	tree1.jps	\
	tree2.jps	\
	wortman.jps


all: examples

examples: $(EXAMPLES)

clean:
	rm *.jps *.o

.SUFFIXES: .jgr .jps .eps

.jgr.jps:
	jgraph -P < $*.jgr > $*.jps

.jgr.eps:
	jgraph < $*.jgr > $*.eps

sin:	sin.o
	cc -o sin sin.o -lm

ad.jps: cube.eps disk.eps
bailey.jps: bailey.pts
ex2.jps: data.txt
mab2.jps: mab2.times
sin.jps: sin
sin2.jps: sin2.pts
sin3.jps: sin3.pts
tree1.jps: tree.awk
	( echo "4 3" | awk -f tree.awk ; echo "xaxis size 5.4" ) | \
           jgraph -P > tree1.jps
tree2.jps: tree.awk
	( echo "5 2" | awk -f tree.awk ; echo "xaxis size 5.4" ) | \
           jgraph -P > tree2.jps
