/*
 * hfsutils - tools for reading and writing Macintosh HFS volumes
 * Copyright (C) 1996 Robert Leslie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

void r_packcatkey(CatKeyRec *, char *, int *);
void r_unpackcatkey(char *, CatKeyRec *);

void r_packextkey(ExtKeyRec *, char *, int *);
void r_unpackextkey(char *, ExtKeyRec *);

int r_comparecatkeys(char *, char *);
int r_compareextkeys(char *, char *);

void r_packcatdata(CatDataRec *, char *, int *);
void r_unpackcatdata(char *, CatDataRec *);

void r_packextdata(ExtDataRec *, char *, int *);
void r_unpackextdata(char *, ExtDataRec *);

void r_makecatkey(CatKeyRec *, long, char *);
void r_makeextkey(ExtKeyRec *, int, long, unsigned int);

void r_unpackdirent(char *, CatDataRec *, hfsdirent *);
void r_packdirent(CatDataRec *, hfsdirent *);
