/*	
 *   xtel - Emulateur MINITEL sous X11
 *
 *   Copyright (C) 1991-1994  Lectra Systemes & Pierre Ficheux
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
static char rcsid[] = "$Id: xtel.c,v 1.10 1995/07/24 13:43:58 pierre Exp $";

/*
 * programme principal 
 */

#define EXTERN
#include "xtel.h"
#include <X11/Shell.h>

#include <malloc.h>
#include <sys/types.h>
#include <pwd.h>

#include "patchlevel.h"
#include "bitmaps/xtel.bit"

#ifndef NO_XPM
#include <X11/xpm.h>
#include "xtel.xpm"
#endif /* NO_XPM */

static Pixmap pixmap_icone = None;

/* liste des noms des boutons MINITEL */
struct definition_touche touches[] = {
                          {"videotex", "V"},
                          {"teleinfo_ascii", "A"},
                          {"teleinfo_fr", "F"},
			  {"blanc", NULL},
                          {"envoi", "A"},
			  {"retour", "B"},
			  {"repetition", "C"},
			  {"guide", "D"},
			  {"annulation",  "E"},
			  {"sommaire", "F"},
			  {"correction", "G"},
			  {"suite", "H"},
			  {"blanc", NULL},
			  {"connexion_fin", "I"},
			};

/*
 * Options (ressources) propres a XTEL
 *
 *	-serveur	*serveur		specifie la machine serveur
 *	-petite		*petiteFonte		taille de la fonte
 *	-ng		*nGris			force les niveaux de gris 
 *			*commandeImpression	comme son nom l'indique
 *			*nomService		nom du service tcp
 */
static Boolean defaultFalse = False;

#define XtNserveur	"serveur"
#define XtCServeur	"Serveur"

#define XtNpetiteFonte	"petiteFonte"
#define XtCPetiteFonte	"PetiteFonte"

#define XtNnGris	"nGris"
#define XtCNGris	"NGris"

#define XtNcommandeImpression 	"commandeImpression"
#define XtCCommandeImpression 	"CommandeImpression"

#define XtNnomService		"nomService"
#define XtCNomService		"NomService"

#define XtNboutonRaccrocher	"boutonRaccrocher"
#define XtCBoutonRaccrocher	"BoutonRaccrocher"

static XtResource ressources[] = {
    {
	XtNserveur,
	XtCServeur,
	XtRString, sizeof(String),
	XtOffsetOf(ressources_xtel, serveur),
	XtRString, "ondee"
	},
    {
	XtNnGris,
	XtCNGris,
	XtRBoolean, sizeof(Boolean),
	XtOffsetOf(ressources_xtel, nGris),
	XtRBoolean, (XtPointer) &defaultFalse
	},
    {
	XtNpetiteFonte,
	XtCPetiteFonte,
	XtRBoolean, sizeof(Boolean),
	XtOffsetOf(ressources_xtel, petiteFonte),
	XtRBoolean, (XtPointer) &defaultFalse
	},
    {
	XtNcommandeImpression,
	XtCCommandeImpression,
	XtRString, sizeof(String),
	XtOffsetOf(ressources_xtel, commandeImpression),
	XtRString, "lp %s"
	},
    {
	XtNnomService,
	XtCNomService,
	XtRString, sizeof(String),
	XtOffsetOf(ressources_xtel, nomService),
	XtRString, "xtel"
	},
    {
	XtNboutonRaccrocher,
	XtCBoutonRaccrocher,
	XtRBoolean, sizeof(Boolean),
	XtOffsetOf(ressources_xtel, boutonRaccrocher),
	XtRBoolean, (XtPointer) &defaultFalse
	},

  };

/*
 * Sauve l'ecran
 */
void sauve_l_ecran (w, pevent, params, nb_params)
Widget w;
XEvent *pevent;
String  *params;
Cardinal nb_params;
{
    videotexSauveEcran (ecran_minitel);
}

/* 
 * fonction d'init 
 */
void init_xtel ()
{
    videotexInit (ecran_minitel);
    clavier_minitel_valide (False);
    XFlush (XtDisplay(ecran_minitel));
}

#ifndef NO_XPM

/* Construction d'icone XPM, pique dans xpaint ! */
static void SetIconImage(w)
Widget w;
{
    static Pixmap	icon = None;
    Window		iconWindow;
    Screen		*screen = XtScreen(w);
    Display		*dpy = XtDisplay(w);
    XpmAttributes xpma;
	
    xpma.valuemask = XpmReturnInfos;

    /*
     **  Build the icon
     */
    iconWindow = XCreateSimpleWindow(dpy, RootWindowOfScreen(screen),
				     0, 0, /* x, y */
				     1, 1, 0,
				     BlackPixelOfScreen(screen),
				     BlackPixelOfScreen(screen));
    if (icon == None) {
	XpmCreatePixmapFromData(dpy, iconWindow,
				xtel_xpm, &icon, NULL, &xpma);
	XResizeWindow(dpy, iconWindow, xpma.width, xpma.height);
    }

    XSetWindowBackgroundPixmap(dpy, iconWindow, icon);
    XtVaSetValues(w, XtNiconWindow, iconWindow, NULL);
}

#endif /* NO_XPM */

/*
 * Programme principal
 */
main(argc, argv)
int argc;
char **argv;
{
    XWindowAttributes attrib;
    Widget topLevel;
    Arg args[10];
    unsigned char c;
    static char l;
    char titre_xtel[256];
    struct passwd *pw;

    if (prototype_xtel == 0) {
	if (PATCHLEVEL != 0)
	    printf ("XTEL %d.%dpl%d, Emulateur MINITEL (C)1991-95 LECTRA SYSTEMES\n", version_xtel, revision_xtel, PATCHLEVEL);
	else
	    printf ("XTEL %d.%d, Emulateur MINITEL (C)1991-95 LECTRA SYSTEMES\n", version_xtel, revision_xtel);
    }
    else {
	if (PATCHLEVEL != 0)
	    printf ("XTEL %d.%dpl%dp%d, Emulateur MINITEL (C)1991-95 LECTRA SYSTEMES\n", version_xtel, revision_xtel, PATCHLEVEL, prototype_xtel);
	else
	    printf ("XTEL %d.%dp%d, Emulateur MINITEL (C)1991-95 LECTRA SYSTEMES\n", version_xtel, revision_xtel, prototype_xtel);
    }

    taille_zone_enregistrement = 1000;
    mode_emulation = MODE_VIDEOTEX;

#ifdef NO_NETWORK
    unaddr.sun_family = AF_UNIX;
    strcpy (unaddr.sun_path, XTEL_UNIX_PATH);
#endif /* NO_NETWORK */

    /*
     * Allocation de la zone d'enregistrement par defaut
     */

    if ((zone_enregistrement = malloc (taille_zone_enregistrement)) == NULL) {
	perror ("malloc");
	exit (1);
    }

    if ((topLevel = init_toolkit (&argc, argv)) == NULL) {
	fprintf (stderr, "Erreur initialisation Toolkit, dommage...\n");
	exit (1);
    }

    sprintf (titre_xtel, "%s-%d.%d", xtel_basename(argv[0]), version_xtel, revision_xtel);
    XtVaSetValues (topLevel, XtNtitle, titre_xtel, XtNiconName, titre_xtel, NULL);

    /*
     * lecture des ressouces specifiques
     */
    XtGetApplicationResources (topLevel, &rsc_xtel, ressources, XtNumber(ressources), NULL, 0);

    /* 
     * Lecture des services disponibles 
     */
#ifdef NO_NETWORK
    if ((socket_xteld = socket (AF_UNIX, SOCK_STREAM, 0))  < 0) {
	perror ("socket");
	exit (1);
    }

    if (connect (socket_xteld, (struct sockaddr *)&unaddr, sizeof(unaddr)) < 0) {
	perror ("connect");
	exit (1);
    }
#else
    if ((socket_xteld = c_clientbyname(rsc_xtel.serveur, rsc_xtel.nomService)) < 0) {
	fprintf (stderr, "Erreur de connexion au serveur XTEL...\n");
	exit (1);
    }
#endif /* NO_NETWORK

    /* Transmet le nom d'utilisateur */
    if ((pw = getpwuid(getuid())) == NULL) {
	perror ("getpwuid");
	exit(1);
    }
    l = strlen (pw->pw_name);
    write (socket_xteld, &l, 1);
    write (socket_xteld, pw->pw_name, l);

    nb_services = 0;

    for(;;) {
	write (socket_xteld, CHAINE_COMMANDE_SERVICE_SUIVANT, 1);
	read (socket_xteld, &c, 1);

	if (c == VALEUR_REPONSE_PLUS_DE_SERVICE)
	    break;

	else { /* transmet la longueur de la chaine */
	    int longueur_chaine = c;

	    if (longueur_chaine != 0) {

		definition_services[nb_services].nom_service = (char *) calloc (1, longueur_chaine+1);
		read (socket_xteld, definition_services[nb_services].nom_service, longueur_chaine);

		definition_services[nb_services].nom_service[longueur_chaine] = 0;
		entree_compose[nb_services] = definition_services[nb_services].nom_service;

		write (socket_xteld, CHAINE_COMMANDE_NOM_UUCP, 1);
		read (socket_xteld, &c, 1);

		longueur_chaine = c;

		definition_services[nb_services].nom_uucp = (char *) calloc (1, longueur_chaine+1);
		read (socket_xteld, definition_services[nb_services].nom_uucp, longueur_chaine);

		definition_services[nb_services].nom_uucp[longueur_chaine] = 0;

#ifdef DEBUG
		printf ("%d %s %s\n", nb_services, definition_services[nb_services].nom_service ,definition_services[nb_services].nom_uucp);
#endif

		nb_services++;

	    }
	    else {
#ifdef DEBUG
		fprintf (stderr, "entree %d interdite\n", nb_services);
#endif
	    }
	}
    }

    close (socket_xteld);

    /*
     * Procedures 
     */
    nb_procedures = init_procedures();

    /* 
     * Initialisation des widgets 
     */
    if ((ecran_minitel = init_widgets (topLevel)) == NULL) {
	fprintf (stderr, "Erreur initialisation widgets\n");
	exit (1);
    }

    XtRealizeWidget(topLevel);

    /*
     * Contruction de l'icone
     */
    XtVaGetValues(topLevel, XtNiconPixmap, &pixmap_icone, NULL);
    if (pixmap_icone == None) {
#ifdef NO_XPM
	XtVaSetValues (topLevel, XtNiconPixmap, XCreateBitmapFromData(XtDisplay(topLevel), XtScreen(topLevel)->root,  xtel_bits, xtel_width, xtel_height), NULL);
#else
	SetIconImage (topLevel);
#endif /* NO_XPM */
    }

    XtAddCallback (ecran_minitel, XtNmodeCallback, (XtCallbackProc)selection_mode_emulation, (XtPointer)"A");
    init_xtel ();

    XtAddEventHandler (topLevel, LeaveWindowMask, False, (XtEventHandler)sauve_l_ecran, NULL);

    /* attente evenements */
    XtAppMainLoop (app_context);
 }










