/* This file has been change by Joe Kirby <kirby@utk.edu> in the following:
    .deb and .tgz have been added to the compression exclusion defaults
    core has been added to the file exclusion defaults
  7 Feb 1996
*/

/* Variables initialized */


#include "taper.h"

/* Note tape type must be first preference */
struct pref_template ap[] = {
    {"--tape-type",  'T', &tape_type, NULL, 'T', TRUE},
    {"--get-blksize", 'G', &get_blksize, NULL, 'Y', FALSE},
    {"--set-blksize",'S', &set_blksize, NULL, 'Y', FALSE},
    {"--fast-fsf",'Q',  &fast_fsf, NULL, 'Y', FALSE},
    {"--erase-tape", 'k', &erase_tape, NULL, 'Y', FALSE},	 
    {"--tape", 'f', tape, NULL, 'S', FALSE},
    {"--ntape",'n', ntape, NULL, 'S', FALSE},
    {"--both",'b',  tape, ntape, 'S', FALSE},
    {"--block-size", 'x', &block_size, NULL, 'I', FALSE},
    {"--taper-info-files", 'i', taper_info_files, NULL, 'S', TRUE},
    {"--taper-info-files", 'i', taper_info_files, NULL, 'S', TRUE},
    {"--restore-path", 'r', rel_path, NULL, 'S', TRUE},
    {"--exclude-compress", 'X', exclude_compress, NULL, 'S', TRUE},
    {"--exclude-files", 'F', exclude_files, NULL, 'S', TRUE},
    {"--exclude-dirs", 'R', exclude_dirs, NULL, 'S', TRUE},
    {"--log-file", 'l', log_file, NULL, 'S', TRUE},
    {"--limit-log-file", 'L', &log_file_size, NULL, 'I', TRUE},
    {"--volume-title", 'g', volume_title, NULL, 'S', TRUE},
    {"--archive-title", 't', archive_title, NULL, 'S'},
    {"--hard-links", 'h', &hard_links, NULL, 'Y', TRUE},
    {"--auto-descend", 'D', &auto_descend, NULL, 'Y', TRUE},
    {"--append", 'a', &append, NULL, 'Y', TRUE},
    {"--incremental-backup", 'u', &incremental, NULL, 'Y', TRUE},
    {"--prompt-dirs", 'z', &dir_selection, NULL, 'Y', TRUE},
    {"--overwrite", 'o', &ovrwrite, NULL, 'Y', TRUE},	 
    {"--recent-restore", 'w', &most_recent, NULL, 'Y', TRUE},	 
    {"--prompt-archive", 'e', &prompt_archive, NULL, 'Y', TRUE},	 
    {"--tape-overwrite", 'O', &tape_overwrite, NULL, 'Y', TRUE},      
    {"--sort-dirs", 'y', &sort_dir, NULL, 'Y', TRUE},      
    {"--strip-paths", 's', &ostrip, NULL, 'I', TRUE},
    {"--only-volume", 'q', &only_vol, NULL, 'I', TRUE},
    {"--compress-type", 'c', &compression, NULL, 'I', TRUE},
    {"--proc-device", 'j', &proc_dev, NULL, 'I', TRUE},
    {"--comp-head-start", 'H', &comp_head_start, NULL, 'I', TRUE},
    {"--log-level", 'm', &log_level, NULL, 'I', TRUE},
    {"--preference-file", 'p', NULL, NULL, 'P', TRUE},
    {"--version", 'v', NULL, NULL, 'v', TRUE},
    {"--archive-diff", 'A', &diff_id, NULL, 'A', TRUE},
    {"--print-dir", 'd', &pr_dir, NULL, 'd', TRUE},
    {"--unattended-file", 'U', NULL, NULL, 'U', TRUE},
    {"--memory-tight", 'M', &memory_tight, NULL, 'Y', TRUE},
    {"--color-title", '.', &color_title_foreground, &color_title_background, 'C', TRUE},
    {"--color-main", '.', &color_main_foreground, &color_main_background, 'C', TRUE},
    {"--color-dialog", '.', &color_dialog_foreground, &color_dialog_background, 'C', TRUE},
    {"--color-status", '.', &color_status_foreground, &color_status_background, 'C', TRUE},
    {"--color-directory", '.', &color_directory_foreground, &color_directory_background, 'C', TRUE},
    {"--color-on-volume", '.', &color_onvol_foreground, &color_onvol_background, 'C', TRUE},
    {"--color-selected", '.', &color_selected_foreground, &color_onvol_background, 'C', TRUE},
    {"--color-bottom", '.', &color_bottom_foreground, &color_bottom_background, 'C', TRUE},
    {"--color-help", '.', &color_help_foreground, &color_help_background, 'C', TRUE},
    {"--color-form", '.', &color_form_foreground, &color_form_background, 'C', TRUE},
    {NULL, ' ', NULL, NULL, ' ', TRUE}
};


struct err_temp errs[] = {
    {ERROR_ILLEGAL_DIR, "opening directory", FALSE, FALSE},
    {ERROR_GETINFO, "doing getinfo call", FALSE, FALSE},
    {ERROR_MEMORY, "Memory allocation error", TRUE, FALSE},
    {ERROR_USAGE, "", TRUE, TRUE},
    {ERROR_MAGIC, "Backup device contains unknown data", TRUE, FALSE},
    {ERROR_REWIND, "rewinding tape", FALSE, FALSE},
    {ERROR_NO_INFO, "No info file for this archive", TRUE, FALSE},
    {ERROR_CREATING_INFO, "creating info file", FALSE, FALSE},
    {ERROR_OPENING_BACKUP, "opening backup device", FALSE, FALSE},
    {ERROR_READING, "reading from backup device", FALSE, FALSE},
    {ERROR_WRITING, "writing to backup device", FALSE, FALSE},
    {ERROR_CONFIGURATION, "opening preferences file", FALSE, FALSE},
    {ERROR_OPENING_LOG, "opening log file", FALSE, FALSE},
    {ERROR_WRITING_INFO, "trying to write to info file", FALSE, FALSE},
    {ERROR_TRSIZE, "Illegal maximum transfer size", TRUE, FALSE},
    {ERROR_NEW_TAPE, "getting next tape in archive", FALSE, FALSE},
    {ERROR_EMPTY_ARCHIVE, "This tape is blank", TRUE, FALSE},
    {ERROR_TAPE_FSF, "doing fsf", FALSE, FALSE},
    {ERROR_WRITING_HEADER, "writing tape header", FALSE, FALSE},
    {ERROR_INFO_MISMATCH, "Mismatch between info filename and info file", TRUE, FALSE},
    {ERROR_READING_INFO, "reading from info file", FALSE, FALSE},
    {ERROR_CREATING_PREFS, "creating preference file", FALSE, FALSE},
    {ERROR_CREATING_COMLINE, "creating command line file", FALSE, FALSE},
    {ERROR_ERASING_TAPE, "erasing tape", FALSE, FALSE},
    {ERROR_OPENING_FLIST, "opening compression file list", FALSE, FALSE},
    {ERROR_CREATING_FIFO, "creating FIFO", FALSE, FALSE},
    {ERROR_OPENING_FIFO, "opening FIFO", FALSE, FALSE},
    {ERROR_UNABLE_FORK, "forking child", FALSE, FALSE},
    {ERROR_OPENING_SET, "opening file set", FALSE, FALSE},
    {ERROR_INFO_ISNT_DIR, "Info file directory is not a directory", TRUE, FALSE},
    {ERROR_OPENING_MAIL, "opening mail file", FALSE, FALSE},
    {ERROR_GETTING_BLKSIZE, "setting block size", FALSE, FALSE},
    {ERROR_SETTING_BLKSIZE, "getting block size", FALSE, FALSE},
    {ERROR_SETTING_SHARED_MEM, "setting up shared memory", FALSE, FALSE},
    {ERROR_NO_TAPE_TYPE, "Set tape drive using -T option", TRUE, TRUE},
    {ERROR_PREF_FORMAT, "Error in preference file format", TRUE, TRUE},
    {ERROR_ILLEGAL_TAPE_TYPE, "Illegal tape type", TRUE, TRUE},
    {ERROR_OPENING_PF, "opening /proc/filesystem", FALSE, FALSE},
    {ERROR_UNABLE_MOUNT, "Unable to mount device", TRUE, FALSE},
    {ERROR_UNABLE_UMOUNT, "umounting device", FALSE, FALSE},
    {ERROR_SKIPPING, "skipping volumes", FALSE, FALSE},
    {ERROR_RENAMING, "renaming file", FALSE, FALSE},
    {ERROR_INFO_FILE, "Error in info file format", TRUE, FALSE},
    {ERROR_NONE, "", TRUE, TRUE},
    {0, "", TRUE, TRUE}
};



/* Colours */
char color_title_foreground=COLOR_BLUE;
char color_title_background=COLOR_WHITE;
char color_main_foreground=COLOR_WHITE;
char color_main_background=COLOR_BLUE;
char color_dialog_foreground=COLOR_WHITE;
char color_dialog_background=COLOR_RED;
char color_status_foreground=COLOR_WHITE;
char color_status_background=COLOR_RED;
char color_selected_foreground=COLOR_WHITE;
char color_selected_background=COLOR_BLUE;
char color_directory_foreground=COLOR_BLACK;
char color_directory_background=COLOR_GREEN;
char color_onvol_foreground=COLOR_WHITE;
char color_onvol_background=COLOR_MAGENTA;
char color_bottom_foreground=COLOR_BLUE;
char color_bottom_background=COLOR_WHITE;
char color_help_foreground=COLOR_BLACK;
char color_help_background=COLOR_CYAN;
char color_form_foreground=COLOR_WHITE;
char color_form_background=COLOR_BLACK;


/* Misc variables that parent/children need to share */
struct shared_mems *shm;			 
#ifdef TRIPLE_BUFFER
int    shm_id;
#endif

/* Memory buffers */
int write_buffer_count;				 /* how many bytes in write buffer */
char   *write_buffer;				 /* write buffer */
#ifdef TRIPLE_BUFFER
int    wb_shm_id;
#endif

char *w_current_buffer;				 /* double buffer */
char *w_buffer_1, *w_buffer_2;			 /* stuff */
#ifdef TRIPLE_BUFFER
int wb1_shmid, wb2_shmid;
#endif
long w_cur_pos;					 /* pos in double buffer */

int read_buffer_count;				 /* how many bytes in read buffer */
char *read_buffer;				 /* read buffer */
int read_offset;				 /* position in read buffer */

int block_size;					 /* size of buffer */
UBYTE *cbuf;					 /* compression buffer */

char *tr_buffer;				 /* transfer buffer */
char *comp_buffer1;
char *comp_buffer2;

/* Common window variables */
WINDOW    *win_main, *title, *files, *selection, *bottom, *on_vol;
int       screen_ylen, screen_xlen;		 /* physical dims of screen */
int       screen_ylen_files, screen_ylen_selection;/* length of screens */
int       left_width, right_width;


/* Options */
int  append=1;
int  auto_descend=1;
int  hard_links=0;
int   lstrip, ostrip=99;
int  tape_overwrite=0;
int  compression=2;				/* Default is internal compression */
int  sort_dir=1;
char  archive_title[MAX_ARCHIVETITLE]={0};
char  volume_title[MAX_ARCHIVETITLE]={0};
char  exclude_compress[MAXNAMLEN]={".gz .gif .Z .zip .jpg .deb .tgz"};/* files to exclude in compression */
char  exclude_files[MAXNAMLEN]={".o ~ core"};	 /* files to exclude in archive */
char  exclude_dirs[MAXNAMLEN]={"/tmp /usr/tmp /var/tmp"};/* directories to exclude in archive */
int  unattended=0;				 /* for unattended back sets */
int  ovrwrite=1;
char  rel_path[MAXNAMLEN]={0};
int  incremental=1;
int  most_recent=1;
int  prompt_archive=1;				 
long  pr_dir=0;
_u32  diff_id=0;
int  no_windows=0;
char  taper_info_files[MAXNAMLEN]={0};
int  dir_selection=0;
char  log_file[MAXNAMLEN]={0};
int  log_level=2;
int  log_file_size=2;				 /* default is 2MB */
int   max_tr_size=DEFAULT_TR_SIZE;		 /* is used for reading/writing files to/from hard disk */
int   org_block_size;
dev_t proc_dev=1;				 /* device on which /proc is mounted */
int   only_vol=0;				 /* limit restore to volume */
int   comp_head_start=0;			 /* how much head start to give compression */
char  pref_file[MAXNAMLEN];			 /* file of preference file */
int   memory_tight=0;				 /* memory tight  */
int   have_rewind=-1;
int   have_fsf=-1;


/*  More options - these are all things that depend on type of tape drive used */
int tape_type=-1;
char tape[MAXNAMLEN]={-1};			 /* filename of rewinding tape device */
char ntape[MAXNAMLEN]={-1};			 /* filename of non-rewinding tape device */
int erase_tape=-1;				 /* these will all be */
int set_blksize=-1;				 /*   filled in with the default */
int get_blksize=-1;				 /*   applicable to the tape */
int fast_fsf=-1;				 /*   drive selected */
int  block_size=-1;				 /* is used for reading/writing data to/from tape device */


/* File counts and archive size counts */
long total_compressed;				 /* # file bytes in volume - compressed */
long total_uncompressed;			 /* # file bytes in volume - uncompressed */
long no_in_archive=0;				 /* # files in archive */
long no_sel=0;					 /* # files selected */
long total_selected=0;				 /* # bytes selected */
long no_vol_details;				 /* number of lines in vol_details */
long in_dir;
int vols_passed;				 /* number of volumes passed on this tape */

/* Temporary file that contains what we are going to mail */
char mailfn[MAXNAMLEN]={0};			 /* name of mail temp file */

/* File handles */
int lf=0;					 /* log file */
int mf=0;					 /* mail file */
int dv;

/* Stipped & Common pathnames */
char cf[MAXNAMLEN]={0};				 /* common pathname prefix */
char stripped_cf[MAXNAMLEN];			 /* portion of common pathname prefix that is not stripped */


/* Info files */
char *info;					 /* pointer to archive info */
char *cp;					 /* offset used into above */
struct tape_header tdh;				 /* headers for tape & */
struct info_file_header ifd;			 /* info file */


/* Memory allocation stuff for archive files, sel_files etc.. */
struct oa_file_entry *archive_files;		 /* files on archive */
long len_archive_files;				 /* length of files on archive */
struct oa_file_entry *sel_files;		 /* files selected by user */
long len_sel_files;
struct volume_tape_info *vt_info;		 /* which tape each volume is on */
struct dir_file_entry *dirs;			 /* restore directories */
char *vol_headers;				 /* volume headers */
char *vol_details;				 /* information about volumes */
long cur_af_size, cur_info_size, cur_sf_size;	 /* size of memory blocks */

/* Children */
pid_t backup_child=0;
pid_t restore_child=0;

/* Directories */
char original_cur_dir[MAXNAMLEN];
char cur_dir[MAXNAMLEN];


/* Window that shows what's on the archive */
select_details vol_sd;

