/* LOCKVC Version 2.0b (c) 1994,1995 by Matthias Straub */
/* Original code written by Matthias Straub */
/* V2.0b written by Lars Johannsen and Matthias Straub */
/* shadow-password option added by Ed Beaumont */
/* fixed-point math derived from a lockvc1.7-patch by Jeff Epler */
/* this file was released under GPL */
/* see COPYING for details */

		
#define MAXNUMSTARS 3000
#define SIZE 32768       
#define DIST 32768             /* should be a power of 2 for speed */
#define SCRX 320               /* .EQ. vga-mode */
#define SCRY 240               /* .EQ. vga-mode */
#define CONFIG "/etc/maxlock"  /* change if you don't like the filename */
#define UMODE 0                /* key-mode    */
#define SMODE 1                /* passwd-mode */
#define FPBITS 10
#define FM(x,y) (((x)*(y))>>FPBITS)
#define FM3(x,y,z) (((x)*(y)*(z))>>(2*FPBITS))
#define SIN(x) (sintab[(x)&1023])
#define COS(x) SIN(x+256)

void plotcfield(int);
void restore(int);
void create_atom(int nr, int start, int length);
void create_kegel(int nr, int start, int length, int radius, int hi);
void create_sphere( int nr, int start, int length, int radius);
void create_torus(int nr, int start, int length, int ra, int rb); 
void create_random(int nr, int start, int length);
void create_plain(int nr, int start, int length, int xlong, int  zlong);
void move_object(int nr, int start, int length, int xa, int ya, int za);

#define OBJS 9
#define MORPHS 15
#define MTIME 64

#define PLAIN 0
#define ATOM 1
#define RANDOM 2
#define SPHERE 3
#define TORUS 4
#define KEGEL 5
#define TORBALLS 6
#define FOURBALL 7
#define FOURTORUS 8

#ifdef SHADOW_PASSWD
  #include <shadow.h>
#endif
#include <sys/stat.h>
#include <pwd.h>
#include <signal.h>
#include <unistd.h> 
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <vga.h>
#include <termio.h>

int numstars;
int xr[MAXNUMSTARS];
int yr[MAXNUMSTARS];
int zr[MAXNUMSTARS];
int xo[OBJS] [MAXNUMSTARS];
int yo[OBJS] [MAXNUMSTARS];
int zo[OBJS] [MAXNUMSTARS];
int xmo[MORPHS] [MAXNUMSTARS];
int ymo[MORPHS] [MAXNUMSTARS];
int zmo[MORPHS] [MAXNUMSTARS];

int xbuf[2] [MAXNUMSTARS];
int ybuf[2] [MAXNUMSTARS];
int sintab[1024];
char page=1;
int offset=0; 
int IS11,IS12,IS13,IS21,IS22,IS23,IS31,IS32,IS33; 
int s,t,u;	 
int i;
int mtable;
char stride;
char buff[100];
char key[100];
char rkey[100];
char uName[100];
struct termios console;
#ifdef SHADOW_PASSWD
struct spwd *sword;
struct spwd *rpword;
char name[32];
#else
struct passwd *rpword;
#endif
struct passwd *pword;
int keymode;

void mksintab()
	{
        for(i=0;i<1024;i++)
	 {
               sintab[i]=(int)(sin(i*M_PI*2.0/1024)*1024);
       	 }
	}

void isconsole() /* vgalib1.2 */
     {
	struct stat chkbuf;
	int major, minor;
	int fd;
	
	fd = dup(2);
	fstat(fd, &chkbuf);
	major = chkbuf.st_rdev >> 8;
	minor = chkbuf.st_rdev & 0xff;
	
	if (major != 4 || minor >= 64)
	  {
	     printf("Not running in graphics-capable virtual console.\n");
	     exit(-1);
	  }
	close(fd);            
     }
             
void kickout() 
     {
	setuid(getuid());
	kill(-1,SIGTERM);
	sleep(2);
	kill(-1,SIGKILL);
	exit(0);
     }

void res_term()
     {
	tcsetattr(STDIN_FILENO, TCSANOW, &console);
     }

void invis_term()
     {
	struct termios terminal;
	tcgetattr(STDIN_FILENO, &console);
	terminal=console;
	terminal.c_lflag &= !(ECHO | ECHOCTL);
	tcsetattr(STDIN_FILENO, TCSANOW, &terminal);
     }

void domtable(int num,int from, int to)
     {
	int i;
	for(i=0;i<numstars;i++)
	    {
		xmo[num] [i]=(xo[to][i]-xo[from][i])/MTIME;
		ymo[num] [i]=(yo[to][i]-yo[from][i])/MTIME;
		zmo[num] [i]=(zo[to][i]-zo[from][i])/MTIME;
     	    }
     }

void initfield() 
     {
	
	create_plain(PLAIN,0,numstars,SIZE,SIZE);
	move_object(PLAIN,0,numstars,0,-SIZE/3,0);
	
	create_atom(ATOM,0,numstars);
	
	create_random(RANDOM,0,numstars);

	create_sphere(SPHERE,0,numstars,(SIZE/2));
	
	create_torus(TORUS,0,numstars,(SIZE/2),(SIZE/5));
	
	create_torus(FOURTORUS,0           ,numstars/4,SIZE/3,SIZE/6);
	create_torus(FOURTORUS,numstars/4  ,numstars/4,SIZE/3,SIZE/6);
	create_torus(FOURTORUS,numstars/2  ,numstars/4,SIZE/3,SIZE/6);
	create_torus(FOURTORUS,numstars/4*3,numstars/4,SIZE/3,SIZE/6);
	move_object(FOURTORUS,0           ,numstars/4,0,SIZE/3,0);
	move_object(FOURTORUS,numstars/4  ,numstars/4,0,SIZE/6,0);
	move_object(FOURTORUS,numstars/2  ,numstars/4,0,-SIZE/6,0);
	move_object(FOURTORUS,numstars/4*3,numstars/4,0,-SIZE/3,0);
	move_object(FOURTORUS,0           ,numstars  ,SIZE/2,0,0);
	
	create_kegel(KEGEL,0,numstars,(SIZE/2),SIZE);
	move_object(KEGEL,0,numstars,0,-SIZE/2,0);
	
	create_sphere(TORBALLS,0         ,numstars/4,SIZE/3);
	create_sphere(TORBALLS,numstars/4,numstars/4,SIZE/3);
	create_torus (TORBALLS,numstars/2,numstars/2,SIZE/2,SIZE/8);
	move_object(TORBALLS,0,numstars/4,0,-SIZE/3,0);
	move_object(TORBALLS,numstars/4,numstars/4,0,SIZE/3,0);
	
	create_sphere(FOURBALL,0           ,numstars/4,SIZE/3);
	create_sphere(FOURBALL,numstars/4  ,numstars/4,SIZE/3);
	create_sphere(FOURBALL,numstars/2  ,numstars/4,SIZE/3);
	create_sphere(FOURBALL,numstars/4*3,numstars/4,SIZE/3);
	move_object(FOURBALL,0           ,numstars/4,SIZE/2,0,0);
	move_object(FOURBALL,numstars/4  ,numstars/4,-SIZE/2,0,0);
	move_object(FOURBALL,numstars/2  ,numstars/4,0,SIZE/2,0);
	move_object(FOURBALL,numstars/4*3,numstars/4,0,-SIZE/2,0);
	
	/* morphtables */
	
	for (i=0;i<numstars;i++) 
	  {
	     xmo[0] [i]=0;
	     ymo[0] [i]=0;
	     zmo[0] [i]=0;
	  }
#define NOP 0 
	domtable(1,ATOM,PLAIN);
#define ATOM2PLAIN 1 
	domtable(2,PLAIN,RANDOM);
#define PLAIN2RANDOM 2
	domtable(3,RANDOM,PLAIN);
#define RANDOM2PLAIN 3
	domtable(4,PLAIN,SPHERE);
#define PLAIN2SPHERE 4
	domtable(5,SPHERE,PLAIN);
#define SPHERE2PLAIN 5
	domtable(6,SPHERE,TORUS);
#define SPHERE2TORUS 6
	domtable(7,TORUS,SPHERE);
#define TORUS2SPHERE 7
	domtable(8,SPHERE,KEGEL);
#define SPHERE2KEGEL 8
	domtable(9,KEGEL,TORBALLS);
#define KEGEL2TORBALLS 9
	domtable(10,TORBALLS,RANDOM);
#define TORBALLS2RANDOM 10
	domtable(11,SPHERE,FOURBALL);
#define SPHERE2FOURBALL 11
	domtable(12,FOURBALL,PLAIN);
#define FOURBALL2PLAIN 12
	domtable(13,FOURBALL,FOURTORUS);
#define FOURBALL2FOURTORUS 13
	domtable(14,FOURTORUS,FOURBALL);
#define FOURTORUS2FOURBALL 14	
	
	/* init */
	
	restore(ATOM);
     }

void initpalette() 
     {
	int j;
	for (j=0;j<32;j++)
	  {
	     vga_setpalette(j,2*j,2*j,2*j);
	     vga_setpalette(j+32,0,0,2*j);
	     vga_setpalette(j+64,0,2*j,2*j);
	     vga_setpalette(j+96,2*j,0,0);
	     vga_setpalette(j+128,2*j,2*j,2*j);
	     vga_setpalette(j+160,2*j,0,2*j);
	     vga_setpalette(j+192,0,2*j,0);
	     vga_setpalette(j+224,2*j,2*j,0);
	  }
     }

void plotfield(void)
     {
	int x2,y2,z2,base;
	
		
/* looks weird, doesn't it? */
/* it's just the */
/* product of 3 less */
/* spectacular matrices */
/* that's what one year */
/* linear algebra class */
/* was for */
       IS11 = FM(COS(s),COS(t));
       IS12 = FM(SIN(s),COS(t));
       IS13 = -SIN(t);
       IS21 = -FM(SIN(s),COS(u))+FM3(COS(s),SIN(t),SIN(u));
       IS22 = FM(COS(s),COS(u))+FM3(SIN(s),SIN(t),SIN(u));
       IS23 = FM(COS(t),SIN(u));
       IS31 = FM(SIN(s),SIN(u))+FM3(COS(s),SIN(t),COS(u));
       IS32 = -FM(COS(s),SIN(u))+FM3(SIN(s),SIN(t),COS(u));
       IS33 = FM(COS(t),COS(u));

	page=1-page;
	offset=SCRY-offset;
	vga_setdisplaystart((SCRY-offset)*SCRX); 
	vga_waitretrace();
	
	vga_setcolor(0);              
	for (i=0;i<numstars;i++)
	  {
	     x2=xbuf[page] [i];
	     y2=ybuf[page] [i];
	     if (x2<SCRX && y2 < (SCRY+offset) && x2>=0 && y2 >= offset)
	       {
		  vga_drawpixel(x2,y2);
	       }
	  }
	for(base=0;base<8;base++)
	  {
	    plotcfield(base);
	  }
   }

void plotcfield(int base)
   {
	int q,qq,x2,y2,z2,xl,yl;

	int cbase;
	cbase=16+base*32;
	for (i=base*numstars/8;i<((base+1)*numstars/8);i++) 
	  {
	     xr[i]+=xmo[mtable][i];
	     yr[i]+=ymo[mtable][i];
	     zr[i]+=zmo[mtable][i];
	     z2 = (IS13*xr[i]+IS23*yr[i]+IS33*zr[i])>>FPBITS;
	     if (z2!=DIST) q=(DIST-z2);
	     else q=1;
	     qq=q>>1;
	     x2 = (DIST*((int)(IS11*xr[i]+IS21*yr[i]+IS31*zr[i])>>FPBITS)+qq)/q;
	     y2 = (DIST*((int)(IS12*xr[i]+IS22*yr[i]+IS32*zr[i])>>FPBITS)+qq)/q;
	     xbuf[page][i]=((x2+128)/256)+SCRX/2;
	     ybuf[page][i]=SCRY/2-((y2+128)/256)+offset;
	     xl=xbuf[page][i];
	     yl=ybuf[page][i];
	     if (xl >=0 && xl <SCRX && yl >=offset && yl < (SCRY+offset) && z2<=DIST && z2>=-DIST)
	       {
		  vga_setcolor(cbase+(z2*16)/DIST);
		  vga_drawpixel(xl,yl);
	       }
	  }
     }

void checkkey()
     {
	if(vga_getkey()!=0 && vga_getkey()!=-1) 
	  {
	     vga_setmode(TEXT);
	     if(keymode==UMODE)
	       {
		  printf("\nEnter key to unlock: ");
		  gets(buff);
		  printf("\n");
		  if(strcmp(buff,key)==0)
		    {
		       memset(buff,0,strlen(buff));
		       memset(key,0,strlen(key));
		       res_term();
		       exit(0);
		    }
	       }
	     else 
	       {
		  printf("\n%s's password: ",uName);
		  gets(buff);
		  printf("\n");
		  if((strcmp(key,crypt(buff,key))==0)||strcmp(rkey,crypt(buff,rkey))==0)
		    {
		       memset(buff,0,strlen(buff));
		       res_term();
		       exit(0);
		    }
	       }
	     vga_setmode(G320x240x256);
	     initpalette();
	  }
     }


void update()
     {
	plotfield();
	checkkey();
     }

void sequence(int mseq,int stime, int rs, int rt, int ru)
	{
		  int j; 
		  mtable=mseq;
		  for (j=0;j<stime;j++)
		    {
		       update();
		       s+=rs;
		       t+=rt;
		       u+=ru;
		    }
	}

void restore(int what)
     {
	int j;
	for(j=0;j<numstars;j++)
	  {
	     xr[j]=xo[what][j];
	     yr[j]=yo[what][j];
	     zr[j]=zo[what][j];
	  }
     }

void main(int argc,char **argv)
     {
	int j;
	FILE *config;
	int maxtime;
	printf("\n---      VGA-Virtual-Console-Lock (c) by M.Straub '95 V2.0b     ---\n");
	printf(  "---      usage:   lockvc20b    [  < number of dots >  ]         ---\n"); 
	if(((config=fopen(CONFIG,"r"))!=NULL) && (getuid()!=0))
	  {
	     fscanf(config,"%i",&maxtime);
	     printf("---      locking-time is limited to %i minutes.			---\n",maxtime);
	     maxtime*=60;
	     alarm(maxtime);
	     signal(SIGALRM,kickout);
	     fclose(config);
	  }
	if(argc ==2)
	  {
	     numstars=atoi(argv[1]);
	     if(numstars<1 || numstars>MAXNUMSTARS) 
	       {printf("Number of dots must be between 1 and %d.\n",MAXNUMSTARS);exit(-1);}
	  }
	else 
	  {
	     numstars=500;
	     stride=9;
	  }
	if(((pword=getpwuid(getuid()))!=NULL) && (strlen(pword->pw_passwd)>0))
	  {
#ifdef SHADOW_PASSWD
	     if(setuid(0) != 0) printf("setuid failed. Bet setreuid will too....\n");
	     if(setreuid(0,0) != 0)
	       {
		  if(errno == EPERM)
		    printf("Program not SUIDed - shadow passwords wont work!\n");
		  else
		    printf("ERROR: Type %i returned from setuid()\n",errno);
		  vga_init();
		  isconsole();
		  invis_term();
		  do
		    {
		       printf("\nKey: ");
		       gets(key);
		       printf("\nAgain: ");
		       gets(buff);
		    } while(strcmp(key,buff)!=0);
		  keymode=UMODE;
	       }
	     else	
	       {
		  name[0]='\0';
		  strncpy(name,pword->pw_name, sizeof(char[32]));	
		  if((sword=getspnam(name))==NULL)
		    printf("getspnam() failed!\n");
		  strcpy(key,sword->sp_pwdp);
		  strcpy(uName,sword->sp_namp);
		  rpword=getspnam("root");
		  strcpy(rkey,rpword->sp_pwdp);
		  keymode=SMODE;
		  vga_init();
		  isconsole();
		  invis_term();
	       }
#else
	     strcpy(key,pword->pw_passwd);
	     strcpy(uName,pword->pw_name);
	     rpword=getpwuid(0);
	     strcpy(rkey,rpword->pw_passwd);
	     keymode=SMODE;
	     vga_init();
	     isconsole();
	     invis_term();
#endif
	  }
	else
	  {
	     vga_init();
	     isconsole();
	     invis_term();
	     do
	       {
		  printf("\nKey: ");
		  gets(key);
		  printf("\nAgain: ");
		  gets(buff);
	       } while(strcmp(key,buff)!=0);
	     keymode=UMODE;
	  }
	vga_lockvc();
	initfield ();
	mksintab();
	vga_setmode(G320x240x256); 
	signal(SIGINT,SIG_IGN);
	signal(SIGHUP,SIG_IGN);
	signal(SIGTERM,SIG_IGN);
	signal(SIGQUIT,SIG_IGN);
	signal(SIGABRT,SIG_IGN);
	initpalette();
	
	sequence(ATOM2PLAIN,MTIME,0,4,5);
	while(1)
	  {
	     sequence(NOP,300,0,4,5);
	     sequence(PLAIN2SPHERE,MTIME,0,4,5);
	     sequence(NOP,300,0,4,5);
	     sequence(SPHERE2TORUS,MTIME,0,4,5);
	     restore(TORUS);
	     sequence(NOP,400,0,4,5);
	     sequence(TORUS2SPHERE,MTIME,0,4,5);
	     restore(SPHERE);
	     sequence(NOP,100,0,4,3);
	     sequence(SPHERE2FOURBALL,MTIME,0,4,5);
	     sequence(NOP,400,0,4,5);
	     sequence(FOURBALL2FOURTORUS,MTIME,0,4,5);
	     restore(FOURTORUS);
	     sequence(NOP,50,0,4,5);
	     sequence(NOP,60,-1,4,6);
	     sequence(NOP,70,-2,4,7);
	     sequence(NOP,80,-3,4,8);
	     sequence(NOP,90,-4,4,9);
	     sequence(NOP,80,-3,4,8);
	     sequence(NOP,70,-2,4,7);
	     sequence(NOP,60,-1,4,6);
	     sequence(FOURTORUS2FOURBALL,MTIME,0,4,5);
	     sequence(NOP,200,0,4,5);
	     sequence(FOURBALL2PLAIN,MTIME,0,4,5);
	     sequence(PLAIN2SPHERE,MTIME,0,4,3);
	     restore(SPHERE);
	     sequence(NOP,300,0,4,3);
	     sequence(SPHERE2KEGEL,MTIME,0,4,3);
	     sequence(NOP,300,0,4,3);
	     sequence(KEGEL2TORBALLS,MTIME,0,4,5);
	     sequence(NOP,200,0,4,5);
	     sequence(TORBALLS2RANDOM,MTIME,0,4,5);
	     restore(RANDOM);
	     sequence(RANDOM2PLAIN,MTIME,0,4,5);
	  }
     }


/* Object creation routines */


/* creating a plain in object nr, starting at point start using length 
   points, having length xlong and width zlong and no height */

void create_plain(int nr, int start, int length, int xlong, int  zlong) { 

       	for (i=start;i<(start+length);i++) 
	  {
	  xo[nr][i]=-xlong+((2*xlong)/(int)sqrt(length))*((i-start)%(int)sqrt(length));
	  yo[nr][i]= 0;
   	  zo[nr][i]=-zlong+(2*zlong)/(int)sqrt(length)*((i-start)/(int)sqrt(length));
	  }
        } 
/* end create_plain */	


/* create a random field in object nr */

void create_random(int nr, int start, int length) {

        for (i=start;i<length;i++)
	  {
	     xo[nr] [i]=SIZE-random()%(SIZE<<1);
	     yo[nr] [i]=SIZE-random()%(SIZE<<1);
	     zo[nr] [i]=random()%SIZE-SIZE/2;
	  }
	} 
/* end create_random */


/* atomize field */

void create_atom(int nr, int start, int length) {

        for (i=start;i<length;i++)
	  {
	     xo[nr][i]=0;
	     yo[nr][i]=0;
	     zo[nr][i]=0;
	  }
	}
/* end create_atom */

/* simple sphere */

void create_sphere( int nr, int start, int length, int radius) {

	  int j,n,k;
   	  float w,w1,w2;

	  n=(int) sqrt(length);

     		w=2*M_PI/n;
     	 	k=start;

     		for (j=0;j<n;j++)
      		 {
      		 w1=j*w;
      		 w2=0;
       	 	   for (i=0;i<n;i++)
        		{
        		yo[nr] [k]=cos(w2)*radius;
        		zo[nr] [k]=cos(w1)*radius*sin(w2);
        		xo[nr] [k]=sin(w1)*radius*sin(w2);
        		k++;
        		w2+=(w/2.0);
        		}
      		 }
     	
   	 for (;k<(start+length);k++) { yo[nr][k]=-radius;
				       xo[nr][k]=0;
				       zo[nr][k]=0; }
	
	}
/* Sphere end */

/* create a torus with inner radius rb and ring-radius ra */
 
void create_torus(int nr, int start, int length, int ra, int rb) { 

	  int j,n,k,r;
   	  float w,w1,w2;

	     n=(int) (sqrt(length/2));
	     w=M_PI/n;
	     k=start;

	     for (j=0;j<2*n;j++)
	      {
	      w1=j*w;
	      w2=0;
	        for (i=0;i<n;i++)
        	{
	        yo[nr][k]=cos(w2)*rb;
	        r=(ra)+rb*sin(w2);

	        zo[nr][k]=cos(w1)*r;
	        xo[nr][k]=sin(w1)*r;

	        k++;
	        w2+=(w*2);
        	}
      	      }
     	 for (j=k-1;k<start+length;k++) { 
           yo[nr][k]=yo[nr][j];
           xo[nr][k]=xo[nr][j];
           zo[nr][k]=zo[nr][j]; 
	 }
	}
/* Torus end */


/* Kegel begin */

void create_kegel(int nr, int start, int length, int radius, int hi) 
     {
	int j,n,k,r;
	float w,w1,w2;
	
	n=(int)(sqrt(length));
	
	w=M_PI*2/n;
	k=start;
     	for (j=0;j<n;j++)
	  {
	     r=j*radius/n;
	     w2=0;
	     for (i=0;i<n;i++)
	       {
		  xo[nr] [k]=(int)(r*sin(w2));
		  zo[nr] [k]=(int)(r*cos(w2));
		  yo[nr] [k]=((k-start)*hi)/length;
		  w2+=w;
		  k++;
	       }
	  }
	for (;k<length+start;k++) { yo[nr][k]=0;xo[nr][k]=0;zo[nr][k]=0; }
     }
/*Kegel end */

/* Move an object */

void move_object(int nr, int start, int length, int xa, int ya, int za) 
	
	{
	
	for (i=start;i<start+length;i++) {
	      xo[nr][i]+=xa;
	      yo[nr][i]+=ya;
	      zo[nr][i]+=za;
	}
}
/* end move */
