
/* remrip.c V1.0 - Copyright (C) 1993/94/95/96 Jim Geuther */

/*
 *
 * Function:	Remove Isolated Pixels.
 * Author: 	Jim GEUTHER
 * Date:    	18-May-96
 * Environment: Personal Power System 850 + AIX V4.1.3.0
 *
 * This Gimp plugin will remove isolated pixels. A pixel is considered
 * an isolated pixel, when it is surrounded by less then threshold
 * nr of different colors.
 *
 * This filter works on colormap indexed images and rgb images.
 *
 * Processing options:
 *
 * threshold - If a pixel is surrounded by less or equal the threshold
 * number of different colored pixels, the pixel will be replaced with
 * color which surrounds it most frequently.
 *
 * History:
 * V1.00	Jim GEUTHER, ported from ImageKnife (Amiga) to Gimp (AIX)
 *
 */
 
/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "gimp.h"

/*#define	_DEBUG */

#ifdef	_DEBUG
#define	NULLP()	printf("%s.%ld: NULLPOINTER\n",__FILE__,__LINE__)
#define	DPRINTF(x) printf("%s.%ld: %s",__FILE__,__LINE__,x)
#else
#define	NULLP()	
#define	DPRINTF(x)
#endif

/* Declare a local function.
 */
 
static void scale_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);
static void ripit(Image, Image,long threshold);

static char *prog_name;
static long rip_threshold=6;	/* threshold for max colors */
int dialog_ID;

int
main (argc, argv)
     int argc;
     char **argv;
{

Image input, output;
int 	scale_ID;
long	process, diff;
long	type;
void	*data;
static int one=1;

 /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = output = 0;
      data=gimp_get_params();
      if(data) rip_threshold=((int *)data)[0];
      /* This is a regular filter. What that means is that it operates
       *  on the input image. Output is put into the ouput image. The
       *  filter should not worry, or even care where these images come
       *  from. The only guarantee is that they are the same size and
       *  depth.
       */
      input = gimp_get_input_image (0);

      /* If input image is available and the input is color, then do some
       *  work. (Bleed). Then update the output image.
       */
      if (input)
	{
		type = gimp_image_type( input );
	  switch ( type )
	    {

    	    case GRAY_IMAGE:
	    case RGB_IMAGE:
	      gimp_message("remrip: can only operate on indexed images");
	      break;
	    case INDEXED_IMAGE:
		dialog_ID = gimp_new_dialog ("Remove Isolated Pixels");
	      	scale_ID = gimp_new_scale( dialog_ID, DEFAULT, 1, 8, rip_threshold,0 );
			
		gimp_add_callback( dialog_ID, scale_ID, scale_callback, &rip_threshold);
	      	gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
	      	gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
	      
	      if (gimp_show_dialog (dialog_ID))
		{
			gimp_set_params(sizeof(int), &rip_threshold );
#ifdef	OBSOLETE		
		  if( output = gimp_new_image( 0, gimp_image_width(input),
		  		gimp_image_height(input), gimp_image_type(input) ) ) {
		      gimp_set_image_colors(output,gimp_image_cmap(input),
		      				gimp_image_colors(input));
#else
		if( output = gimp_get_output_image( 0 ) ) {
#endif			
		      	gimp_display_image( output );
		      	ripit(input,output,rip_threshold);
		      	gimp_update_image (output);
		    }

		}

	      break;
	    default:
	      gimp_message ("remrip: cannot operate on unknown image types");
	      break;
	    }
	}

      /* Free both images.
       */
      if (input)
	gimp_free_image (input);
      if (output)
	gimp_free_image (output);

      /* Quit
       */
      gimp_quit ();
    }

  return 0;
}

static void
scale_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}


static void
ripit(input, output, threshold)
     Image input, output;
     long threshold;
{
  long width, height;
  long channels, rowstride, colors;
  unsigned char *src_row, *dest_row;
  unsigned char *src, *dest, *cmap, *cptr, *cur_row, *prev_row, *next_row;
int x1, y1, x2, y2;
  int left, right, row, col, ix;
  int top, bottom;
  long sum1, sum2;
  long sum, scale;
  int cur_progress;
  int max_progress;
	long c,cc;
int	pens[8],pencnt[8],mypen;

long	diffpens,found,count;

  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   *
   * This filter will use only x1 and y1 as starting coordinates.
   *
   */
gimp_image_area (input, &x1, &y1, &x2, &y2);
colors   = gimp_image_colors( input ); 
cmap	 = gimp_image_cmap( input );
width    = gimp_image_width (input);
height   = gimp_image_height (input);
channels = gimp_image_channels (input);
rowstride = width * channels;

left = (x1 == 0);
right = (x2 == width);
top = (y1 == 0);
bottom = (y2 == height);

if (x1 == 0) x1++;
if (y1 == 0) y1++;
if (x2 == width) x2--;
if (y2 == height) y2--;

x1 *= channels;
x2 *= channels;

prev_row = gimp_image_data (input);
prev_row += (y1 - 1) * rowstride;
cur_row = prev_row + rowstride;
next_row = cur_row + rowstride;

dest = gimp_image_data (output);

if (top) {
	for (col = 0; col < rowstride; col++) *dest++ = 0;
} else {
      dest += y1 * rowstride;
    }

cur_progress = 0;
max_progress = y2 - y1;

for (row = y1; row < y2; ++row) {
	if (left) {
		for (col = 0; col < channels; col++) *dest++ = 0;
        } else { dest += x1;
        }

	for (col = x1; col < (x2 < (width-2) ? x2 : x2-1 ); col++) {
		/* Determine number of different colored pixels */
		mypen=cur_row[col];
		pens[0]=prev_row[col-1];
		pens[1]=prev_row[col];
		pens[2]=prev_row[col+1];
		pens[3]=cur_row[col-1];
		pens[4]=cur_row[col+1];
		pens[5]=next_row[col-1];
		pens[6]=next_row[col];
		pens[7]=next_row[col+1];
		for(ix=0;ix<8;ix++) pencnt[ix]=0;
		/* Count nr of same pens */
		for(ix=0;ix<8;ix++)
		{
			if(pens[ix]==pens[0])
			{
				if(ix!=0)
					pencnt[0]+=1;
			}
			else
			if(pens[ix]==pens[1])
			{
				if(ix!=1)
				pencnt[1]+=1;
			}
			else
			if(pens[ix]==pens[2])
			{
				if(ix!=2)
					pencnt[2]+=1;
			}
			else
			if(pens[ix]==pens[3])
			{
				if(ix!=3)
					pencnt[3]+=1;
			}
			else
			if(pens[ix]==pens[4])
			{
				if(ix!=4)
					pencnt[4]+=1;
			}
			else
			if(pens[ix]==pens[5])
			{
				if(ix!=5)
					pencnt[5]+=1;
			}
			else
			if(pens[ix]==pens[6])
			{
				if(ix!=6)
					pencnt[6]+=1;
			}
			else
			if(pens[ix]==pens[7])
			{
				if(ix!=7)
					pencnt[7]+=1;
			}
		}

		diffpens=0;
		for(ix=0;ix<8;ix++)
		{
			if(pencnt[ix]!=0)
			{
				diffpens+=1;
			}
		}

		if( diffpens <= threshold )
		{
			/* Find pen with highest nr of occurencies */
			for(ix=0,diffpens= -1;ix<8;ix++)
			{
				if( pencnt[ix]>diffpens)
				{
					diffpens=pencnt[ix];
					found=ix;
				}
			}
			/*
			** Must always copy to destination image
			** because brush processing doesnot seem to
			** copy a to b
			*/
			*dest++=pens[found];
			count++;
		}
		else
		{

			*dest++=mypen;
			count++;

		}
	  
        }
      if (right)
        {
          for (col = col; col < rowstride; col++)
            *dest++ = 0;
        }
      else
        {
          dest += rowstride - x2;
        }

      prev_row = cur_row;
      cur_row = next_row;
      next_row += rowstride;

	if ((++cur_progress % 10) == 0) gimp_do_progress (cur_progress, max_progress);	

    }

  /* And write the last row, zeros again. */
  if (bottom)
    for (col = 0; col < rowstride; col++)
      *dest++ = 0;
      
return;    	
}

/* Agree, I don't like my coding style? either 	*/
/* Feel free to optimize this code!		*/





