# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;

#include <malloc.h>
#include <stdio.h>
#include <string.h>

/* #define DEBUG */

FILE *out = NULL;

char buf[2048], sectname[256], labeltxt[256];
char firstname[256], outname[256];
char ssectname[256], Tmp1[4096], Tmp2[256], headname[256];
char urlname[256], Headbuf[4096], refname[256];

int filenum = 1;
int tmpfn;
int secnr = 0;
int ssecnr;
int current;
int skipnewline = 0;

#define CHAPTER 1
#define SECTION 2
#define SUBSECT 3

int getstr( char *str, int n )
  {
    int i;
#ifdef DEBUG
    fprintf( stderr, "DEBUG: yytext: <<%s>>\n", yytext );
#endif
    if( strlen( yytext ) == n )
      return 0;
    strncpy( str, yytext+n, yyleng-n);
    str[ yyleng-n ] = 0;
    return 1;
  }

struct lprec
  {
    char *label;
    int fileno;
    struct lprec *next;
  };

typedef struct lprec lprec;

lprec *putlp();
lprec *getlp();

lprec *lp_table = (lprec *)0;
lprec *tmplp;

lprec *
putlp( char *lbl, int fn )
  {
    lprec *ptr;
    ptr = (lprec *) malloc (sizeof (lprec));
    ptr->label = (char *) malloc (strlen (lbl) +1 );
    strcpy( ptr->label, lbl );
    ptr->fileno = fn;
    ptr->next = (struct lprec *)lp_table;
    lp_table = ptr;
    return ptr;
  }

lprec *
getlp( char *lbl )
  {
    lprec *ptr;
    for (ptr = lp_table; ptr != (lprec *) 0;
	 ptr = (lprec *)ptr->next)
      if (strcmp (ptr->label,lbl) == 0)
	return ptr;
    return 0;
  }

# define SECT 2
# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{

    skipnewline=1;
    getstr( urlname, 7 ); 
    sprintf( Headbuf, "<a href=\"%s\"> ", urlname);
}
break;
case 2:
{
    sprintf( Tmp1, " %s </a>", urlname);
    strcat (Headbuf, Tmp1);
}
break;
case 3:
{

    skipnewline=0;
    if (out) {
       fprintf( out, "%s", Headbuf);
    } else {
       printf( "%s", Headbuf);
    }
    strcpy (Headbuf,"");
}
break;
case 4:
	{

strcpy( sectname, yytext+9 );
printf( "<title>%s</title>\n<h1>%s</h1>\n",
       sectname, sectname );
}
break;
case 5:
	{

    skipnewline=1;
    getstr( headname, 8 ); 
    sprintf( Headbuf, "<h3> %s ", headname);
}
break;
case 6:
{

  if (out) {
    fprintf( out, "%s", Headbuf );
    strcpy(Headbuf, "");
    switch (current){
    case CHAPTER:
        current=0;
        break;
    case SECTION:
        current=0;
        fprintf( out, "</h1>\n<p> <a href=\"%s.html#toc%d\"> Contents of this section</a></p>\n",firstname,secnr);
        break;
    case SUBSECT:
        current=0;
        fprintf( out, "</h2>\n");
        break;
    default:
        current=0;
	fprintf( out, "</h3>\n");
        break;
    }
  } else {
    printf("%s", Headbuf );
    strcpy(Headbuf, "");
    switch (current){
    case CHAPTER:
        current=0;
        break;
    case SECTION:
        current=0;
        printf("</h1>\n<p> <a href=\"%s.html#toc%d\"> Contents of this section</a></p>\n",firstname,secnr);
        break;
    case SUBSECT:
        current=0;
        printf("</h2>\n");
        break;
    default:
        current=0;
        printf("</h3>\n");
        break;
    }
  }
  skipnewline=0;
}
break;
case 7:
	{ 

    skipnewline=1;
    getstr( sectname, 8 ) ;
    if( out ) 
      {
	fclose( out );
      }
    current=SECTION;
    secnr++;
    ssecnr=0;
    sprintf( outname, "%s-%d.html", firstname, filenum++ );
    out = fopen( outname, "w" );
    fprintf( out, "<title>%s</title>\n", sectname );
    sprintf( Headbuf, "<h1>%d <a name=\"s%d\"> %s ",secnr, secnr, sectname );
    fprintf( stdout, "<p><h2><a name=\"toc%d\">",secnr);
    fprintf( stdout, "%d. <a href=\"%s\">%s</a></h2>\n<ul>\n", secnr, outname,
	    sectname );
}
break;
case 8:
         { 

    skipnewline=1;
    getstr( ssectname, 9 ) ;
    current=SUBSECT;
    ssecnr++;
    sprintf( Headbuf, "<h2>%d.%d <A Name=\"ss%d.%d\"> %s ",secnr, ssecnr, secnr, ssecnr, ssectname );
    fprintf( stdout, "<h4><a href=\"%s#ss%d.%d\">%d.%d %s</a></h4>\n", outname, secnr, ssecnr, secnr, ssecnr,
            ssectname );
}
break;
case 9:
	{

getstr( sectname, 9 );
sectname[ yyleng-14 ] = 0;
printf( "<h1>%s</h1>\n", sectname );
}
break;
case 10:
;
break;
case 11:
{

if (filenum>=3) {
  sprintf(Tmp1,"%s-%d.html",firstname, (filenum - 2));
} else {
  sprintf(Tmp1,"%s.html",firstname);
}
sprintf(Tmp2,"%s-%d.html",firstname, (filenum ));
fprintf(out, "<p><a href=\"%s\"> Next </a> Chapter, <a href=\"%s\"> Previous </a> Chapter</p>",
                   Tmp2, Tmp1);
sprintf(Tmp2,"%s.html",firstname);
fprintf(out, "<p>Table of contents of <a href=\"%s#toc%d\">this chapter</a>,\n",Tmp2, filenum-1 );
fprintf(out, " General <a href=\"%s#toc\">table of contents</a></p>\n",Tmp2);
fprintf(out, "<p><a href=\"%s\"> Top </a> of the document,\n <a href=\"#0\"> Beginning of this Chapter</a></p>",
                   Tmp2);
fprintf(stdout,"</ul>\n");
fclose(out); out = NULL;
}
break;
case 12:
      {
}
break;
case 13:
{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      strcpy( labeltxt, sectname );
    }
}
break;
case 14:
	{
  
  strcpy( sectname, yytext+9 );
  if (!getlp( sectname ))
    {
      fprintf( stderr, "Problem with @@label!\n" );
    } 
  else
    {
      if( skipnewline ) {
        sprintf( Tmp1, "<a name=\"%s\"> %s", sectname, Headbuf);
	strcpy (Headbuf, Tmp1);
	strcpy (Tmp1,"");
      } else if( out ) {
        fprintf( out, "<A Name=\"%s\"> ", sectname );
      } else {
	printf( "<A Name=\"%s\"> ", sectname );
      }
    }
}
break;
case 15:
{

#ifdef DEBUG
fprintf( stderr, "DEBUG: yytext = <<%s>>\n", yytext );
#endif
if (sscanf( yytext, "<@@labelp>%[^#]#%d", sectname, &tmpfn ) != 2)
{
  fprintf( stderr, "Problem with @@labelp!\n" );
#ifdef DEBUG
fprintf( stderr, "DEBUG: sectname = <<%s>>\n", sectname );
fprintf( stderr, "DEBUG: tmpfn = <<%d>>\n", tmpfn );
#endif
} else
putlp( sectname, tmpfn );

}
break;
case 16:
          {

strcpy( refname, yytext+7 );
if (!(tmplp = getlp( refname )))
{
  fprintf( stderr, "Problem with @@ref!\n" );
  skipnewline++;
} else {
  
  if(tmplp->fileno==secnr) {
    sprintf( Tmp1, "<a href=\"#%s\"> ", refname );
  } else if(tmplp->fileno==0) {
    sprintf( Tmp1, "<a href=\"%s.html#%s\"> ", firstname, refname );
  } else { 
    sprintf( Tmp1, "<a href=\"%s-%d.html#%s\"> ", firstname, tmplp->fileno,
              refname );
  }

  if(skipnewline) {
     strcat( Headbuf, Tmp1);
  } else {
     strcpy( Headbuf, Tmp1);
  }
  skipnewline++ ;
}
}
break;
case 17:
{

   sprintf( Tmp1," %s </a> ", refname );
   strcat ( Headbuf, Tmp1);
}
break;
case 18:
{

   switch (skipnewline) {
   case 1:
     if (out) {
        fprintf( out, "%s", Headbuf );
     } else { 
        printf( "%s", Headbuf);
     }
     break;
   case 2:
     break;
   default:
     fprintf( stderr, "Problem with @@endref!\n" );
     break;
   }
   skipnewline--;
}
break;
case 19:
	{ 

getstr( sectname, 0 );

if( out ) 
{
  fclose( out );
}
sprintf( outname, "%s-%d.html", firstname, filenum++ );
out = fopen( outname, "w" );
fprintf( out, "<title>%s</title>\n", sectname );
if( strlen( labeltxt ))
{
  fprintf( out, "<A Name=\"%s\">\n", labeltxt );
  labeltxt[0] = 0;
}
fprintf( out, "<h1>%s</h1> ", sectname );
fprintf( stdout, "<h2><a href=\"%s\">%s</a></h2>\n", outname,
	sectname );

BEGIN(0);
}
break;
case 20:
		{

if (skipnewline) {
    strcat(Headbuf, yytext );
  } else if( out ) {
    fprintf( out, "%s", yytext );
  } else {
    ECHO;
  }
}
break;
case 21:
		{

if(!skipnewline) {
  if( out )
  {
    fprintf( out, "%s", yytext );
  }
  else
  {
    ECHO;
  }
}
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */

void
main( int argc, char **argv )
{
  if( argc >= 2 )
    {
      strncpy( firstname, argv[1], 256 );
    }
  else
    {
      strcpy( firstname, "$$" );
    }

  secnr=0;
  yylex();

  if( out ) fclose( out );      

  exit( 0 );
}
int yyvstop[] = {
0,

20,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
0,

21,
0,

20,
0,

19,
21,
0,

20,
-19,
0,

20,
-19,
0,

20,
0,

19,
0,

20,
-19,
0,

20,
0,

20,
-19,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-16,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-1,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-16,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-1,
-19,
0,

20,
-19,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
-5,
0,

20,
0,

16,
0,

20,
0,

20,
-7,
0,

20,
0,

20,
0,

1,
0,

20,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-5,
-19,
0,

20,
-19,
0,

16,
19,
0,

20,
-19,
0,

20,
-7,
-19,
0,

20,
-19,
0,

20,
-19,
0,

1,
19,
0,

20,
-19,
0,

20,
-9,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

20,
0,

5,
0,

20,
-14,
0,

20,
0,

20,
0,

7,
0,

20,
-8,
0,

20,
-4,
0,

20,
0,

20,
-9,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-19,
0,

5,
19,
0,

20,
-13,
-14,
-19,
0,

20,
-19,
0,

20,
-19,
0,

7,
19,
0,

20,
-8,
-19,
0,

20,
-4,
-19,
0,

20,
-19,
0,

9,
0,

20,
0,

20,
0,

20,
-18,
0,

20,
0,

20,
0,

20,
-3,
0,

14,
0,

20,
-15,
0,

20,
-17,
0,

8,
0,

4,
0,

20,
-2,
0,

9,
19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-18,
-19,
0,

20,
-19,
0,

20,
-19,
0,

20,
-3,
-19,
0,

13,
14,
19,
0,

20,
-15,
-19,
0,

20,
-17,
-19,
0,

8,
19,
0,

4,
19,
0,

20,
-2,
-19,
0,

20,
0,

20,
-6,
0,

18,
0,

20,
-11,
0,

20,
0,

3,
0,

15,
0,

17,
0,

2,
0,

20,
-19,
0,

20,
-6,
-19,
0,

18,
19,
0,

20,
-11,
-19,
0,

20,
-19,
0,

3,
19,
0,

15,
19,
0,

17,
19,
0,

2,
19,
0,

20,
-10,
0,

6,
0,

11,
0,

20,
-12,
0,

20,
-10,
-19,
0,

6,
19,
0,

11,
19,
0,

20,
-12,
-19,
0,

10,
0,

12,
0,

10,
19,
0,

12,
19,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,5,	0,0,	
4,9,	0,0,	7,5,	9,9,	
0,0,	14,5,	16,5,	1,6,	
3,8,	4,8,	5,0,	7,0,	
9,12,	11,0,	14,0,	16,0,	
17,5,	18,5,	19,5,	20,0,	
23,5,	0,0,	22,5,	0,0,	
15,9,	17,0,	18,0,	19,0,	
21,5,	23,0,	29,9,	22,0,	
39,5,	15,12,	37,5,	33,5,	
32,0,	21,0,	35,5,	29,12,	
36,5,	39,0,	34,0,	37,0,	
33,0,	38,0,	40,5,	35,0,	
0,0,	36,0,	55,0,	50,5,	
0,0,	0,0,	0,0,	40,0,	
0,0,	2,7,	0,0,	4,10,	
50,0,	10,13,	13,15,	51,5,	
52,0,	7,11,	53,0,	11,14,	
76,76,	56,0,	57,0,	60,9,	
51,0,	0,0,	81,81,	68,0,	
0,0,	76,107,	0,0,	91,91,	
60,12,	69,0,	73,0,	81,112,	
96,96,	0,0,	79,0,	70,0,	
91,123,	0,0,	75,0,	71,0,	
72,0,	96,128,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,44,	
0,0,	0,0,	80,0,	14,16,	
26,43,	14,17,	24,41,	28,45,	
14,18,	16,32,	20,36,	30,48,	
14,19,	25,42,	19,35,	41,59,	
31,49,	18,34,	14,20,	14,21,	
14,22,	14,23,	15,24,	32,50,	
15,25,	17,33,	22,39,	15,26,	
21,37,	34,52,	29,46,	15,27,	
37,55,	23,40,	33,51,	35,53,	
38,56,	15,28,	15,29,	15,30,	
15,31,	36,54,	21,38,	42,60,	
29,47,	43,61,	44,62,	39,57,	
45,63,	46,64,	47,65,	48,66,	
49,67,	40,58,	52,74,	54,5,	
55,78,	53,75,	56,79,	58,0,	
59,83,	51,69,	50,68,	61,89,	
54,0,	62,90,	51,70,	64,93,	
57,80,	60,84,	65,94,	63,9,	
66,95,	67,96,	60,85,	69,99,	
51,71,	51,72,	70,100,	51,73,	
63,12,	68,98,	71,101,	72,102,	
60,86,	60,87,	73,104,	60,88,	
75,106,	74,5,	77,0,	78,0,	
79,110,	80,111,	82,0,	83,114,	
84,115,	72,103,	74,0,	85,116,	
86,117,	87,118,	88,120,	89,121,	
90,122,	92,124,	93,125,	94,126,	
95,127,	97,129,	98,0,	58,81,	
99,0,	100,0,	101,0,	87,119,	
54,76,	103,0,	102,0,	104,0,	
105,105,	67,97,	106,5,	110,0,	
108,5,	109,109,	111,0,	113,0,	
114,145,	105,137,	115,146,	106,0,	
63,91,	108,0,	109,141,	116,147,	
117,148,	118,149,	119,150,	120,151,	
121,121,	124,155,	122,9,	78,109,	
125,125,	126,157,	127,158,	129,159,	
130,130,	121,152,	74,105,	122,12,	
131,0,	125,156,	132,0,	134,0,	
135,0,	130,160,	133,0,	58,82,	
136,0,	138,138,	98,130,	139,0,	
54,77,	142,142,	140,0,	143,143,	
144,0,	146,174,	138,167,	147,175,	
148,176,	145,145,	142,170,	110,142,	
143,171,	77,108,	111,143,	149,177,	
63,92,	82,113,	145,173,	106,138,	
150,178,	151,179,	153,153,	154,181,	
155,182,	157,157,	159,185,	161,0,	
158,158,	163,163,	162,0,	153,180,	
164,0,	165,0,	157,183,	99,131,	
100,132,	158,184,	163,188,	122,153,	
166,166,	168,168,	101,133,	102,134,	
103,135,	174,195,	133,163,	175,196,	
136,166,	166,191,	168,192,	139,168,	
169,169,	104,136,	140,169,	172,172,	
144,172,	176,176,	177,198,	178,199,	
186,0,	169,193,	113,144,	179,179,	
172,194,	181,181,	176,197,	182,182,	
108,140,	106,139,	185,185,	190,0,	
179,200,	195,208,	181,201,	199,211,	
182,202,	187,187,	189,189,	185,203,	
132,162,	135,165,	162,187,	196,196,	
164,189,	198,198,	187,205,	189,206,	
0,0,	122,154,	131,161,	204,204,	
196,209,	207,207,	198,210,	208,208,	
211,211,	134,164,	0,0,	0,0,	
204,212,	0,0,	207,213,	0,0,	
208,214,	211,215,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
186,204,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	190,207,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	161,186,	0,0,	0,0,	
0,0,	0,0,	0,0,	165,190,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		yyvstop+1,
yycrank+-1,	yysvec+1,	yyvstop+3,
yycrank+-2,	yysvec+1,	yyvstop+5,
yycrank+-3,	0,		yyvstop+8,
yycrank+-4,	yysvec+1,	yyvstop+11,
yycrank+0,	0,		yyvstop+13,
yycrank+-5,	0,		yyvstop+15,
yycrank+0,	0,		yyvstop+17,
yycrank+-6,	0,		yyvstop+20,
yycrank+-1,	yysvec+9,	yyvstop+23,
yycrank+-7,	yysvec+7,	yyvstop+26,
yycrank+0,	0,		yyvstop+28,
yycrank+-2,	yysvec+9,	yyvstop+30,
yycrank+-8,	0,		yyvstop+33,
yycrank+-27,	0,		yyvstop+35,
yycrank+-9,	0,		yyvstop+38,
yycrank+-19,	0,		yyvstop+40,
yycrank+-20,	0,		yyvstop+42,
yycrank+-21,	0,		yyvstop+44,
yycrank+-13,	yysvec+18,	yyvstop+46,
yycrank+-31,	0,		yyvstop+48,
yycrank+-25,	0,		yyvstop+50,
yycrank+-23,	0,		yyvstop+52,
yycrank+-6,	yysvec+9,	yyvstop+54,
yycrank+-7,	yysvec+9,	yyvstop+57,
yycrank+-7,	yysvec+9,	yyvstop+60,
yycrank+-6,	yysvec+9,	yyvstop+63,
yycrank+-10,	yysvec+9,	yyvstop+66,
yycrank+-33,	0,		yyvstop+69,
yycrank+-10,	yysvec+9,	yyvstop+72,
yycrank+-6,	yysvec+9,	yyvstop+75,
yycrank+-30,	yysvec+19,	yyvstop+78,
yycrank+-38,	0,		yyvstop+80,
yycrank+-36,	yysvec+19,	yyvstop+82,
yycrank+-41,	0,		yyvstop+84,
yycrank+-43,	0,		yyvstop+86,
yycrank+-37,	0,		yyvstop+88,
yycrank+-39,	yysvec+18,	yyvstop+90,
yycrank+-35,	0,		yyvstop+92,
yycrank+-49,	0,		yyvstop+94,
yycrank+-22,	yysvec+9,	yyvstop+96,
yycrank+-47,	yysvec+9,	yyvstop+99,
yycrank+-52,	yysvec+9,	yyvstop+102,
yycrank+-52,	yysvec+9,	yyvstop+105,
yycrank+-50,	yysvec+9,	yyvstop+108,
yycrank+-54,	yysvec+9,	yyvstop+111,
yycrank+-53,	yysvec+9,	yyvstop+114,
yycrank+-39,	yysvec+9,	yyvstop+117,
yycrank+-48,	yysvec+9,	yyvstop+120,
yycrank+-54,	0,		yyvstop+123,
yycrank+-66,	0,		yyvstop+125,
yycrank+-58,	yysvec+33,	yyvstop+127,
yycrank+-60,	yysvec+18,	yyvstop+129,
yycrank+-158,	0,		yyvstop+131,
yycrank+-44,	yysvec+39,	yyvstop+133,
yycrank+-63,	yysvec+37,	yyvstop+135,
yycrank+-64,	yysvec+40,	yyvstop+137,
yycrank+-153,	yysvec+54,	yyvstop+139,
yycrank+-52,	yysvec+9,	yyvstop+141,
yycrank+-74,	0,		yyvstop+144,
yycrank+-67,	yysvec+9,	yyvstop+147,
yycrank+-68,	yysvec+9,	yyvstop+150,
yycrank+-174,	0,		yyvstop+153,
yycrank+-55,	yysvec+9,	yyvstop+156,
yycrank+-75,	yysvec+9,	yyvstop+159,
yycrank+-68,	yysvec+9,	yyvstop+162,
yycrank+-115,	yysvec+63,	yyvstop+165,
yycrank+-69,	yysvec+39,	yyvstop+168,
yycrank+-75,	yysvec+16,	yyvstop+170,
yycrank+-81,	yysvec+18,	yyvstop+172,
yycrank+-85,	yysvec+18,	yyvstop+174,
yycrank+-86,	yysvec+21,	yyvstop+176,
yycrank+-76,	yysvec+23,	yyvstop+178,
yycrank+-192,	0,		yyvstop+180,
yycrank+-84,	yysvec+40,	yyvstop+182,
yycrank+-71,	0,		yyvstop+184,
yycrank+-184,	yysvec+19,	yyvstop+187,
yycrank+-185,	yysvec+74,	yyvstop+189,
yycrank+-80,	yysvec+39,	yyvstop+191,
yycrank+-96,	yysvec+18,	yyvstop+193,
yycrank+-77,	0,		yyvstop+195,
yycrank+-188,	yysvec+19,	yyvstop+198,
yycrank+-83,	yysvec+9,	yyvstop+200,
yycrank+-96,	yysvec+9,	yyvstop+203,
yycrank+-102,	yysvec+9,	yyvstop+206,
yycrank+-103,	yysvec+9,	yyvstop+209,
yycrank+-104,	yysvec+29,	yyvstop+212,
yycrank+-92,	yysvec+9,	yyvstop+215,
yycrank+-145,	yysvec+9,	yyvstop+218,
yycrank+-100,	yysvec+9,	yyvstop+221,
yycrank+-82,	0,		yyvstop+224,
yycrank+-112,	yysvec+9,	yyvstop+228,
yycrank+-148,	yysvec+9,	yyvstop+231,
yycrank+-95,	yysvec+9,	yyvstop+234,
yycrank+-111,	yysvec+9,	yyvstop+237,
yycrank+-87,	0,		yyvstop+240,
yycrank+-116,	yysvec+9,	yyvstop+244,
yycrank+-204,	yysvec+74,	yyvstop+247,
yycrank+-206,	yysvec+19,	yyvstop+249,
yycrank+-207,	yysvec+19,	yyvstop+251,
yycrank+-208,	yysvec+36,	yyvstop+253,
yycrank+-212,	yysvec+37,	yyvstop+255,
yycrank+-211,	yysvec+18,	yyvstop+257,
yycrank+-213,	yysvec+40,	yyvstop+259,
yycrank+-223,	0,		yyvstop+261,
yycrank+-225,	0,		yyvstop+264,
yycrank+0,	0,		yyvstop+266,
yycrank+-227,	0,		yyvstop+268,
yycrank+-228,	0,		yyvstop+270,
yycrank+-217,	yysvec+74,	yyvstop+273,
yycrank+-220,	yysvec+74,	yyvstop+275,
yycrank+0,	0,		yyvstop+277,
yycrank+-221,	yysvec+108,	yyvstop+279,
yycrank+-170,	yysvec+9,	yyvstop+281,
yycrank+-137,	yysvec+9,	yyvstop+284,
yycrank+-142,	yysvec+9,	yyvstop+287,
yycrank+-138,	yysvec+9,	yyvstop+290,
yycrank+-142,	yysvec+9,	yyvstop+293,
yycrank+-141,	yysvec+9,	yyvstop+296,
yycrank+-135,	yysvec+9,	yyvstop+299,
yycrank+-243,	0,		yyvstop+302,
yycrank+-245,	0,		yyvstop+306,
yycrank+0,	0,		yyvstop+309,
yycrank+-136,	yysvec+9,	yyvstop+312,
yycrank+-247,	0,		yyvstop+315,
yycrank+-187,	yysvec+9,	yyvstop+319,
yycrank+-188,	yysvec+9,	yyvstop+322,
yycrank+0,	0,		yyvstop+325,
yycrank+-142,	yysvec+9,	yyvstop+328,
yycrank+-251,	0,		yyvstop+331,
yycrank+-246,	yysvec+50,	yyvstop+334,
yycrank+-248,	yysvec+33,	yyvstop+336,
yycrank+-252,	yysvec+74,	yyvstop+338,
yycrank+-249,	yysvec+39,	yyvstop+340,
yycrank+-250,	yysvec+37,	yyvstop+342,
yycrank+-254,	yysvec+74,	yyvstop+344,
yycrank+0,	0,		yyvstop+346,
yycrank+-264,	0,		yyvstop+348,
yycrank+-257,	yysvec+74,	yyvstop+351,
yycrank+-260,	yysvec+74,	yyvstop+353,
yycrank+0,	0,		yyvstop+355,
yycrank+-268,	0,		yyvstop+357,
yycrank+-270,	0,		yyvstop+360,
yycrank+-262,	yysvec+74,	yyvstop+363,
yycrank+-276,	0,		yyvstop+365,
yycrank+-161,	yysvec+9,	yyvstop+369,
yycrank+-175,	yysvec+9,	yyvstop+372,
yycrank+-214,	yysvec+9,	yyvstop+375,
yycrank+-167,	yysvec+9,	yyvstop+378,
yycrank+-189,	yysvec+9,	yyvstop+381,
yycrank+-227,	yysvec+9,	yyvstop+384,
yycrank+0,	0,		yyvstop+387,
yycrank+-289,	0,		yyvstop+390,
yycrank+-229,	yysvec+9,	yyvstop+395,
yycrank+-230,	yysvec+9,	yyvstop+398,
yycrank+0,	0,		yyvstop+401,
yycrank+-292,	0,		yyvstop+404,
yycrank+-295,	0,		yyvstop+408,
yycrank+-232,	yysvec+9,	yyvstop+412,
yycrank+0,	0,		yyvstop+415,
yycrank+-285,	yysvec+39,	yyvstop+417,
yycrank+-288,	yysvec+74,	yyvstop+419,
yycrank+-296,	0,		yyvstop+421,
yycrank+-290,	yysvec+74,	yyvstop+424,
yycrank+-291,	yysvec+39,	yyvstop+426,
yycrank+-307,	0,		yyvstop+428,
yycrank+0,	0,		yyvstop+431,
yycrank+-308,	0,		yyvstop+433,
yycrank+-319,	0,		yyvstop+436,
yycrank+0,	0,		yyvstop+439,
yycrank+0,	0,		yyvstop+441,
yycrank+-322,	0,		yyvstop+443,
yycrank+0,	0,		yyvstop+446,
yycrank+-197,	yysvec+9,	yyvstop+449,
yycrank+-253,	yysvec+9,	yyvstop+452,
yycrank+-324,	0,		yyvstop+455,
yycrank+-264,	yysvec+9,	yyvstop+459,
yycrank+-211,	yysvec+9,	yyvstop+462,
yycrank+-330,	0,		yyvstop+465,
yycrank+0,	0,		yyvstop+469,
yycrank+-332,	0,		yyvstop+473,
yycrank+-334,	0,		yyvstop+477,
yycrank+0,	0,		yyvstop+481,
yycrank+0,	0,		yyvstop+484,
yycrank+-337,	0,		yyvstop+487,
yycrank+-318,	yysvec+74,	yyvstop+491,
yycrank+-344,	0,		yyvstop+493,
yycrank+0,	0,		yyvstop+496,
yycrank+-345,	0,		yyvstop+498,
yycrank+-329,	yysvec+74,	yyvstop+501,
yycrank+0,	0,		yyvstop+503,
yycrank+0,	0,		yyvstop+505,
yycrank+0,	0,		yyvstop+507,
yycrank+0,	0,		yyvstop+509,
yycrank+-279,	yysvec+9,	yyvstop+511,
yycrank+-350,	0,		yyvstop+514,
yycrank+0,	0,		yyvstop+518,
yycrank+-352,	0,		yyvstop+521,
yycrank+-281,	yysvec+9,	yyvstop+525,
yycrank+0,	0,		yyvstop+528,
yycrank+0,	0,		yyvstop+531,
yycrank+0,	0,		yyvstop+534,
yycrank+0,	0,		yyvstop+537,
yycrank+-358,	0,		yyvstop+540,
yycrank+0,	0,		yyvstop+543,
yycrank+0,	0,		yyvstop+545,
yycrank+-360,	0,		yyvstop+547,
yycrank+-362,	0,		yyvstop+550,
yycrank+0,	0,		yyvstop+554,
yycrank+0,	0,		yyvstop+557,
yycrank+-363,	0,		yyvstop+560,
yycrank+0,	0,		yyvstop+564,
yycrank+0,	0,		yyvstop+566,
yycrank+0,	0,		yyvstop+568,
yycrank+0,	0,		yyvstop+571,
0,	0,	0};
struct yywork *yytop = yycrank+407;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,1,1,1,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
