#!	/bin/sh

# LILO Minix bootdisk maker. Bruce Perens, July 1995
# This is free software under the GNU General Public License.

# Copy this script to your hard disk, place a scratch floppy in the "a" drive,
# cd to a kernel source directory such as /usr/src/linux, and run this script.

# A scratch floppy must be in /dev/fd0, I must be able to mount it on /mnt,
# the kernel I want to write is in arch/i386/boot/zImage,
# and lilo files must be installed under /boot .

# Abort on any non-zero return.
set -ev

# Zero the entire disk, so that when I compress the raw disk image,
# unused blocks will compress well.
dd if=/dev/zero of=/dev/fd0 bs=10k count=120

# Make a Minix filesystem, and mount it.
mkfs -t minix -i 100 /dev/fd0 1200
mount -t minix /dev/fd0 /mnt

# Create the necessary files and directories to run LILO with the floppy
# as its "root filesystem".
mkdir /mnt/boot /mnt/dev /mnt/etc
mknod /mnt/dev/fd0 b 2 0
cp lilo_floppy.sh /mnt/lilo_floppy.sh
cp /boot/boot.b /mnt/boot/boot.b
cp arch/i386/boot/zImage /mnt/boot/vmlinuz

# Set the kernel up to run normal VGA, with the root as /dev/fd0, and
# a 1440K ramdisk.
rdev -R /mnt/boot/vmlinuz 0
rdev -r /mnt/boot/vmlinuz 1440
rdev -v /mnt/boot/vmlinuz -1
rdev /mnt/boot/vmlinuz /dev/fd0

# Configure LILO
cat >/mnt/etc/lilo.conf <<END1
prompt
verbose=1
linear
compact
message=/debian.txt
map=/boot/map
boot=/dev/fd0
install=/boot/boot.b
image=/boot/vmlinuz
label=linux
ramdisk=1440
root=/dev/fd0
vga=normal
read-write
END1

# Install the greeting message.
cat >/mnt/debian.txt <<END2




            Welcome to Debian GNU/Linux 0.93 Release 6!

  This is the Debian GNU/Linux Boot Disk.  On most systems, you can go
ahead and press <ENTER> to begin installation.  You will probably want
to try doing that before you try anything else.  You MUST have at least
four megabytes of RAM to install Debian GNU/Linux!
  On a few systems, you may need to specify a parameter at the "boot:"
prompt in order to boot the system.  For example, Linux may not be able
to "autodetect" your hardware, and you will need to explicitly specify
its location or type for it to be recognized.  To specify a parameter,
refer to the table below.  Prepend the word "linux" to the parameter(s)
that you need.  For example, when your 1.44 MB (3.5") floppy drive is
your second drive (i.e., your boot drive is the 5.25"), you would type
"linux root=/dev/fd1" at the "boot:" prompt.

HARDWARE                               PARAMETER TO SPECIFY
1.2 MB (5.25") boot drive (floppy)     root=/dev/fd1
IBM PS/1 or ValuePoint (IDE disk)      hd=<cylinders>,<heads>,<sectors>
IBM ThinkPad                           floppy=thinkpad

END2

# Run LILO, using the configuration files on the floppy, not /etc/lilo.conf .
lilo -r /mnt
# Remove the boot block backup, I won't need it.
rm -f /boot/boot.0200

# Make a compressed raw disk image.
umount /dev/fd0
(rm -f /tmp/lilo_floppy /tmp/lilo_floppy.gz; exit 0)
dd if=/dev/fd0 of=/tmp/lilo_floppy bs=10k count=120
gzip /tmp/lilo_floppy
ls -l /tmp/lilo_floppy.gz
