/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
 

/********************************************************************/
/*                                                                  */
/* EDITING of simple textfiles                                      */
/*                                                                  */
/********************************************************************/

#include "cf.defs.h"
#include "cf.extern.h"

/********************************************************************/
/* EDIT Data structure routines                                     */
/********************************************************************/

EditFileExists(file)

char *file;

{ struct Edit *ptr;

for (ptr=VEDITLIST; ptr != NULL; ptr=ptr->next)
   {
   if (strcmp(ptr->fname,file) == 0)
      {
      return true;
      }
   }
return false;
}

/********************************************************************/

InstallEditFile(file,edit,data)

char *file,*edit,*data;

{ char *filename,*datstring,*spe;
  struct Edit *ptr;

if ( ! IsDefinedClass(CLASSBUFF))
   {
   if (DEBUG || D1) printf("Not installing Edit no match\n");
   return;
   }

VBUFF[0]=NULL;                         /* Expand any variables */
ExpandVarstring(file,VBUFF,"");

if (DEBUG || D1) 
   {
   printf(">>Storing Edit: %s.%s.%s\n",VBUFF,edit,data);
   }

if ((ptr = (struct Edit *)malloc(sizeof(struct Edit))) == NULL)
   {
   FatalError("Memory Allocation failed for InstallEditFile() #1");
   }

if ((filename = malloc(strlen(VBUFF)+1)) == NULL)
   {
   FatalError("Memory Allocation failed for InstallEditFile() #2");
   }

if ((spe = malloc(strlen(CLASSBUFF)+1)) == NULL)
   {
   FatalError("Memory Allocation failed for InstallEditFile() #3");
   }

if (VEDITLISTTOP == NULL)                 /* First element in the list */
   {
   VEDITLIST = ptr;
   }
else
   {
   VEDITLISTTOP->next = ptr;
   }

strcpy (filename,VBUFF);
strcpy (spe,CLASSBUFF);

ptr->classes=spe;
ptr->fname=filename;
ptr->next = NULL;
ptr->actions = NULL;
VEDITLISTTOP = ptr;
AddEditAction(file,edit,data);
}

/********************************************************************/

AddEditAction(file,edit,data)

char *file,*edit,*data;

{ struct Edit *ptr;
  struct Edlist *top,*new;
  char varbuff[bufsize];
  char *datstring;

if (DEBUG || D2)
   {
   printf("AddEditAction(%s,%s,%s)\n",file,edit,data);
   }

for (ptr = VEDITLIST; ptr != NULL; ptr=ptr->next)
   {
   varbuff[0] = NULL;
   ExpandVarstring(file,varbuff,"");

   if (strcmp(ptr->fname,varbuff) == 0)
      {
      if ((new = (struct Edlist *)malloc(sizeof(struct Edlist))) == NULL)
         {
         FatalError("Memory Allocation failed for AddEditAction() #1");
         }

      if (ptr->actions == NULL)
         {
         ptr->actions = new;
         }
      else
         {
         for (top = ptr->actions; top->next != NULL; top=top->next)
            {
            }
         top->next = new;
         }

      VBUFF[0]=NULL;                         /* Expand any variables */
      ExpandVarstring(data,VBUFF,"");

      if ((datstring = malloc(strlen(VBUFF)+1)) == NULL)
         {
         FatalError("Memory Allocation failed for AddEditAction() #1");
         }

      strcpy(datstring,VBUFF);
      new->data = datstring;
      new->next = NULL;

      if ((new->code = EditActionsToCode(edit)) == NoEdit)
         {
         yyerror("Unknown edit action");
         }

      return;
      }
   }

printf("cfengine: software error - no file matched installing %s edit\n",file);
}

/********************************************************************/

enum editnames EditActionsToCode(edit)

char *edit;

{ int i;

if (DEBUG || D2)
   {
   printf("EditActionsToCode(%s)\n",edit);
   }

for (i = 0; VEDITNAMES[i] != NULL; i++)
   {
   if (strcmp(VEDITNAMES[i],edit) == 0)
      {
      return (enum editnames) i;
      }
   }

return (NoEdit);
}

/********************************************************************/

