/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA

*/
 


/*******************************************************************/
/*                                                                 */
/*  GLOBAL class default variables for cfengine                    */
/*  These variables are what needs to be modified if you add or    */
/*  modify class definitions...                                    */
/*                                                                 */
/*******************************************************************/

#include "cf.defs.h"

/*********************************************************************/

char *CLASSTEXT[] =   /* If you change here change enum classes too! */
   {
   "",                                              /* see cf.defs.h */
   "<soft>",
   "faculty",
   "site",
   "domain",
   "sysadm",
   "netmask",
   "mountpath",
   "homepat",
   "addclasses",
   "timezone",
   "sensiblesize",
   "sensiblecount",
   "editfilesize",
   "actionsequence",
   "access",
   "nfstype",
   "sun4",
   "ultrix",
   "hpux",
   "aix",
   "linux",
   "solaris",
   "osf",
   "sun3",
   "irix",
   "unused1",
   "unused2",
   "unused3",
   NULL
   };

/*********************************************************************/

char *CLASSATTRIBUTES[clssattr][attr] = /* Used to match the softclass */
   {                            /* from uname. Only as many characters */
   "-","-","-",                 /* as appear here are matched. The     */
   "-","-","-",                 /* fields are sysname and machine which*/
   "-","-","-",                 /* actually gives the architecture!    */
   "-","-","-",                 /* * and ? are wildcards - is blank    */
   "-","-","-",
   "-","-","-",
   "-","-","-",                    /* remember to change cf.defs.h !!  */
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "-","-","-",
   "sunos","sun4?","4*",
   "ultrix","risc","4*",
   "hp-ux","9000*","*",
   "aix","*","2",
   "linux","i?86","*",
   "sunos","sun4?","5*",
   "osf1","alpha","*",
   "sunos","sun3","4*",
   "irix","ip22","5*",
   "unused1","blah","blah",
   "unused2","blah","blah",
   "unused3","blah","blah",
   NULL,NULL,NULL
   };

/*********************************************************************/

char *MOUNTCOMM[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "/etc/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/etc/mount -t nfs 2<&1",
   "/sbin/mount -va 2<&1",        /* not sure about these */
   "/usr/sbin/mount -a 2>&1",
   "/usr/sbin/mount -va 2<&1",
   "/etc/mount -va 2<&1",
   "/sbin/mount -va 2<&1",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VUNMOUNTCOMM[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "/etc/umount",
   "/etc/umount",
   "/etc/umount",
   "/etc/umount",
   "/sbin/umount",        /* not sure about these */
   "/etc/umount",
   "/usr/sbin/umount",
   "/etc/umount",
   "/sbin/umount",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };



/*********************************************************************/

char *VMOUNTOPTS[clssattr] =
   {
   "",                                              /* see cf.defs.h */
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "defaults",        /* not sure about these */
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "bg,hard,intr",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VIFDEV[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "le0",
   "ln0",
   "lan0",
   "en0",
   "eth0",    
   "le0",
   "ln0",
   "le0",
   "ec0",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };


/*********************************************************************/

char *VRESOLVCONF[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",    
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/etc/resolv.conf",
   "/usr/etc/resolv.conf",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };



/*********************************************************************/

char *VFSTAB[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/checklist",
   "/etc/filesystems",
   "/etc/fstab",    
   "/etc/vfstab",
   "/etc/fstab",
   "/etc/fstab",
   "/etc/fstab",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VMAILDIR[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/var/spool/mail",
   "/usr/spool/mail",
   "/usr/mail",
   "/var/spool/mail",
   "/usr/spool/mail",    
   "/var/mail",
   "/usr/spool/mail",
   "/var/spool/mail",
   "/usr/mail",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };

/*********************************************************************/

char *VNETSTAT[clssattr] =
   {
   "-",
   "-",                                              /* see cf.defs.h */
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "-",
   "/usr/ucb/netstat -rn",
   "/usr/ucb/netstat -rn",
   "/usr/bin/netstat -rn",
   "/usr/bin/netstat -rn",
   "/bin/netstat -rn",    
   "/usr/ucb/netstat -rn",
   "/usr/sbin/netstat -rn",
   "/usr/ucb/netstat -rn",
   "/usr/etc/netstat -rn",
   "unused-blah",
   "unused-blah",
   "unused-blah",
   NULL
   };


