
/* cfengine for GNU
 
        Copyright (C) 1995
        Free Software Foundation, Inc.
 
   This file is part of GNU cfengine - written and maintained 
   by Mark Burgess, Dept of Computing and Engineering, Oslo College,
   Dept. of Theoretical physics, University of Oslo
 
   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
 

/*******************************************************************/
/*                                                                 */
/*  HEADER for cfengine                                            */
/*                                                                 */
/*******************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/utsname.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/param.h>
#include <sys/mount.h>
#include <errno.h>
#include <dirent.h>
#include <signal.h>

extern int errno;

/* Do this for ease of configuration from the Makefile */

#ifdef HPuUX
#define HPUX
#endif

#ifdef SunOS
#define SUN4
#endif

/* end of patch */

#ifdef AIX
#include <sys/statfs.h>
#endif

#ifdef SOLARIS
#include <sys/statvfs.h>
#define bcopy(fr,to,n) memcpy(to,fr,n)  /* Eliminate ucblib */
#endif

#include <unistd.h>
#include <malloc.h>
#include <fcntl.h>

#if (! defined(ULTRIX)) && (! defined(OSF))
# include <sys/vfs.h>
#endif

#ifdef SUN4
# include <sys/dirent.h> 
#endif

#ifdef HPUX
# include <sys/dirent.h>
#endif

#include <utime.h>      /* use utime not utimes for portability */
#include <pwd.h>
#include <grp.h>
#include <time.h>
#include <sys/time.h>

#ifdef SOLARIS
# include <sys/sockio.h>
#endif

#ifdef INET
# include <sys/socket.h>
# include <sys/ioctl.h>
# include <net/if.h>
# include <netinet/in.h>
# include <arpa/inet.h>
# include <netdb.h>
# ifndef LINUX
# include <sys/protosw.h>
# include <net/route.h>
# endif
#endif

#ifdef LINUX
# include <linux/route.h>
# include <linux/in.h>
#endif

#define true  1
#define false 0
#define bufsize 1024
#define buffer_margin 10
#define maxvarsize 128
#define maxargs 30
#define clssattr 30         /* increase this for each new class added */
#define attr 3
#define varnames 18         /* increase for every internal $(variable) class */

#define hashtablesize 119   /* prime number */
#define macroalphabet 60    /* a-z, A-Z plus a bit */


#ifdef DEBIAN
# define LOCKFILE "/var/run/cfengine.pid"
# define LOGFILE "/var/spool/cfengine/cfengine.log"
#else
# define LOCKFILE "/etc/cfengine.pid"
# define LOGFILE  "/etc/cfengine.log"
#endif

#define CFINPUTSVAR "CFINPUTS"

#define INFINITERECURSE -99

/*******************************************************************/

enum actions
   {
   none,
   control,
   groups,
   processes,
   resolve,
   services,
   files,
   tidy,
   homeservers,
   binservers,
   mailserver,
   required,
   mountables,
   links,
   import,
   shellcommands,
   disable,
   makepath,
   ignore,
   broadcast,
   defaultroute,
   misc_mounts,
   editfiles,
   unmount
   };

/*******************************************************************/

enum classes
   {
   empty,
   soft,
   faculty,
   site,
   domain,
   sysadm,
   netmask,
   mountpath,
   homepat,
   addclasses,
   timezon,
   sensiblesize,
   sensiblecount,
   editfilesize,
   actionsequence,
   accesss,
   nfstype,
   sun4,
   ultrx,
   hp,
   aix,
   linuxx,
   solaris,
   osf,
   sun3,
   irix,
   unused1,
   unused2,
   unused3
   };


/*******************************************************************/

enum fileactions
   {
   warnall,
   warnplain,
   warndirs,
   fixall,
   fixplain,
   fixdirs,
   touch,
   linkchildren
   };

/*******************************************************************/

enum fileattr
   {
   frecurse,
   fmode,
   fowner,
   fgroup,
   fage,
   faction,
   fpattern,
   flinks,
   ftype,
   fbad
   };


/*******************************************************************/

enum itemtypes
   {
   simple,
   netgroup,
   deletion,
   groupdeletion
   };


/*********************************************************************/

enum vnames 
   {
   fac,
   sit,
   host,
   binserv,
   sysad,
   dom,
   timez,
   netmsk,
   nfstp,
   ssize,
   scount,
   esize,
   actseq,
   mpat,
   hpat,
   adclass,
   acess
   };

/*******************************************************************/

enum resc
   {
   rmountcom,
   runmountcom,
   rethernet,
   rmountopts,
   runused,
   rfstab,
   rmaildir,
   rnetstat
   };

/*******************************************************************/

enum aseq
   {
   mkpaths,
   lnks,
   simplelnks,
   childlnks,
   chkmail,
   requir,
   tidyf,
   shellcom,
   chkfiles,
   disabl,
   mountresc,
   edfil,
   mountall,
   umnt,
   resolv,
   procs,
   netconfig,
   tzone,
   mountinfo,
   non
   };

enum aseq EvaluateAction();

/*******************************************************************/

enum editnames
   {
   NoEdit,
   DeleteLinesStarting,
   DeleteLinesContaining,
   AppendIfNoSuchLine,
   PrependIfNoSuchLine,
   WarnIfNoSuchLine,
   WarnIfLineMatching,
   WarnIfLineStarting,
   WarnIfLineContaining,
   WarnIfNoLineStarting,
   WarnIfNoLineContaining,
   HashCommentLinesContaining,
   HashCommentLinesStarting,
   HashCommentLinesMatching,
   SlashCommentLinesContaining,
   SlashCommentLinesStarting,
   SlashCommentLinesMatching,
   PercentCommentLinesContaining,
   PercentCommentLinesStarting,
   PercentCommentLinesMatching
   };

enum editnames EditActionsToCode();

/*******************************************************************/

enum actions ActionStringToCode();
enum classes ClassStringToCode();
enum vnames ScanVariable();

typedef char flag;
char ToLower();

/*******************************************************************/

struct Item
   {
   char *name;
   char *classes;
   struct Item *next;
   };

struct Item *LocateNextItemContaining();

/*******************************************************************/

struct Mountables
   {
   char *filesystem;
   struct Mountables *next;
   };

/*******************************************************************/

struct Tidy
   {
   char   *path;
   int    recurse;
   char   *wild;
   short  age;
   char   travlinks;
   char   *classes;
   struct Tidy *next;
   };


/*******************************************************************/

struct Mounted
   {
   char *name;
   char *on;
   char *options;
   char *type;
   };

/*******************************************************************/

struct MiscMount
   {
   char *from;
   char *onto;
   char *options;
   char *classes;
   struct MiscMount *next;
   };

/*******************************************************************/

struct File
   {
   char   *path;
   enum   fileactions action;
   mode_t plus;
   mode_t minus;
   int    recurse;
   char   travlinks;
   struct UidList *uid;
   struct GidList *gid;
   char   *classes;
   struct File *next;
   };

/*******************************************************************/

struct UidList
   {
   int uid;
   struct UidList *next;
   };

struct UidList *MakeUidList();

/*******************************************************************/

struct GidList
   {
   int gid;
   struct GidList *next;
   };

struct GidList *MakeGidList();

/*******************************************************************/

struct Link
   {
   char *from;
   char *to;
   char *classes;
   short force;
   struct Link *next;
   };

/*******************************************************************/

struct Edit
   {
   char *fname;
   struct Edlist *actions;
   char *classes;
   struct Edit *next;
   };

/*******************************************************************/

struct Edlist
   {
   enum editnames code;
   char *data;
   struct Edlist *next;
   };

/*******************************************************************/
/* Ultrix doesn't have these from sys/stat.h                       */
/*******************************************************************/

#ifndef S_ISLNK

# define S_ISLNK(m)      (((m)&S_IFMT) == S_IFLNK)

#endif


/********************************************************************/
/* Misc. prototypes                                                 */
/********************************************************************/

char *GetMacroValue();



