<?php

/**
 * Various SAML 2 constants.
 *
 * @package simpleSAMLphp
 * @version $Id$
 */
class SAML2_Const
{
    /**
     * Password authentication context.
     */
    const AC_PASSWORD = 'urn:oasis:names:tc:SAML:2.0:ac:classes:Password';

    /**
     * Unspecified authentication context.
     */
    const AC_UNSPECIFIED = 'urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified';

    /**
     * The URN for the HTTP-POST binding.
     */
    const BINDING_HTTP_POST = 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST';

    /**
     * The URN for the HTTP-Redirect binding.
     */
    const BINDING_HTTP_REDIRECT = 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect';

    /**
     * The URN for the HTTP-ARTIFACT binding.
     */
    const BINDING_HTTP_ARTIFACT = 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact';

    /**
     * The URN for the SOAP binding.
     */
    const BINDING_SOAP = 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP';

    /**
     * The URN for the Holder-of-Key Web Browser SSO Profile binding
     */
    const BINDING_HOK_SSO = 'urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser';

    /**
     * Bearer subject confirmation method.
     */
    const CM_BEARER = 'urn:oasis:names:tc:SAML:2.0:cm:bearer';

    /**
    * Holder-of-Key subject confirmation method.
    */
    const CM_HOK = 'urn:oasis:names:tc:SAML:2.0:cm:holder-of-key';

    /**
     * No claim as to principal consent is being made.
     */
    const CONSENT_UNSPECIFIED = 'urn:oasis:names:tc:SAML:2.0:consent:unspecified';

    /**
     * Indicates that a principal’s consent has been obtained by the issuer of the message.
     */
    const CONSENT_OBTAINED = 'urn:oasis:names:tc:SAML:2.0:consent:obtained';

    /**
     * Indicates that a principal’s consent has been obtained by the issuer of the message at some point prior to
     * the action that initiated the message.
     */
    const CONSENT_PRIOR = 'urn:oasis:names:tc:SAML:2.0:consent:prior';

    /**
     * Indicates that a principal’s consent has been implicitly obtained by the issuer of the message during the
     * action that initiated the message, as part of a broader indication of consent.
     * Implicit consent is typically more proximal to the action in time and presentation than prior consent,
     * such as part of a session of activities.
     */
    const CONSENT_IMPLICIT = 'urn:oasis:names:tc:SAML:2.0:consent:current-implicit';

    /**
     * Indicates that a principal’s consent has been explicitly obtained by the issuer of the message during the
     * action that initiated the message.
     */
    const CONSENT_EXPLICIT = 'urn:oasis:names:tc:SAML:2.0:consent:current-explicit';

    /**
     * Indicates that the issuer of the message did not obtain consent.
     */
    const CONSENT_UNAVAILABLE = 'urn:oasis:names:tc:SAML:2.0:consent:unavailable';

    /**
     * Indicates that the issuer of the message does not believe that they need to obtain or report consent.
     */
    const CONSENT_INAPPLICABLE = 'urn:oasis:names:tc:SAML:2.0:consent:inapplicable';

    /**
     * The interpretation of the attribute name is left to individual implementations.
     */
    const NAMEFORMAT_UNSPECIFIED = 'urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified';

    /**
     * The attribute name follows the convention for URI references [RFC 2396], for example as used in XACML
     * [XACML] attribute identifiers. The interpretation of the URI content or naming scheme is application-
     * specific. See [SAMLProf] for attribute profiles that make use of this identifier.
     */
    const NAMEFORMAT_URI = 'urn:oasis:names:tc:SAML:2.0:attrname-format:uri';

    /**
     * The class of strings acceptable as the attribute name MUST be drawn from the set of values belonging to
     * the primitive type xs:Name as defined in [Schema2] Section 3.3.6. See [SAMLProf] for attribute profiles
     * that make use of this identifier.
     */
    const NAMEFORMAT_BASIC = 'urn:oasis:names:tc:SAML:2.0:attrname-format:basic';

    /**
     * Unspecified NameID format.
     */
    const NAMEID_UNSPECIFIED = 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified';

    /**
     * Persistent NameID format.
     */
    const NAMEID_PERSISTENT = 'urn:oasis:names:tc:SAML:2.0:nameid-format:persistent';

    /**
     * Transient NameID format.
     */
    const NAMEID_TRANSIENT = 'urn:oasis:names:tc:SAML:2.0:nameid-format:transient';

    /**
     * Encrypted NameID format.
     */
    const NAMEID_ENCRYPTED = 'urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted';

    /**
     * The namespace for the SOAP protocol.
     */
    const NS_SOAP = 'http://schemas.xmlsoap.org/soap/envelope/';

    /**
     * The namespace for the SAML 2 protocol.
     */
    const NS_SAMLP = 'urn:oasis:names:tc:SAML:2.0:protocol';

    /**
     * The namespace for the SAML 2 assertions.
     */
    const NS_SAML = 'urn:oasis:names:tc:SAML:2.0:assertion';

    /**
     * The namespace for the SAML 2 metadata.
     */
    const NS_MD = 'urn:oasis:names:tc:SAML:2.0:metadata';

    /**
     * The namespace fox XML schema.
     */
    const NS_XS = 'http://www.w3.org/2001/XMLSchema';

    /**
     * The namespace for XML schema instance.
     */
    const NS_XSI = 'http://www.w3.org/2001/XMLSchema-instance';

    /**
     * The namespace for the SAML 2 HoK Web Browser SSO Profile.
     */
    const NS_HOK = 'urn:oasis:names:tc:SAML:2.0:profiles:holder-of-key:SSO:browser';

    /**
     * Top-level status code indicating successful processing of the request.
     */
    const STATUS_SUCCESS = 'urn:oasis:names:tc:SAML:2.0:status:Success';

    /**
     * Top-level status code indicating that there was a problem with the request.
     */
    const STATUS_REQUESTER = 'urn:oasis:names:tc:SAML:2.0:status:Requester';

    /**
     * Top-level status code indicating that there was a problem generating the response.
     */
    const STATUS_RESPONDER = 'urn:oasis:names:tc:SAML:2.0:status:Responder';

    /**
     * Top-level status code indicating that the request was from an unsupported version of the SAML protocol.
     */
    const STATUS_VERSION_MISMATCH = 'urn:oasis:names:tc:SAML:2.0:status:VersionMismatch';

    /**
     * Second-level status code for NoPassive errors.
     */
    const STATUS_NO_PASSIVE = 'urn:oasis:names:tc:SAML:2.0:status:NoPassive';

    /**
     * Second-level status code for PartialLogout.
     */
    const STATUS_PARTIAL_LOGOUT = 'urn:oasis:names:tc:SAML:2.0:status:PartialLogout';

    /**
     * Second-level status code for ProxyCountExceeded.
     */
    const STATUS_PROXY_COUNT_EXCEEDED = 'urn:oasis:names:tc:SAML:2.0:status:ProxyCountExceeded';

}
