#ifndef __KVIEWPART_IFACE_H
#define __KVIEWPART_IFACE_H

#include <qstringlist.h>
#include <kparts/part.h>

/**
 * This class adds just the fileFormats() method to the ReadOnlyPart.
 */
class KViewPart_Iface : public KParts::ReadOnlyPart
{
  Q_OBJECT
public:
  KViewPart_Iface(QObject *parent, const char *name)
    : KParts::ReadOnlyPart(parent, name) {}

  virtual ~KViewPart_Iface() {}

  // Returns a description of the current page size, for use in the
  // statusbar of the kviewshell that embeds this KViewPart.
  virtual QString pageSizeDescription(void) = 0;

public slots:
  virtual void slotSetFullPage(bool fullpage) = 0;
  virtual QStringList fileFormats() = 0;
};

#endif
