(* This file is generated by Why3's Coq driver *)
(* Beware! Only edit allowed sections below    *)
Require Import BuiltIn.
Require BuiltIn.
Require int.Int.
Require int.Abs.
Require int.MinMax.
Require int.ComputerDivision.
Require map.Map.
Require map.Occ.
Require map.MapPermut.

(* Why3 assumption *)
Definition unit := unit.

Axiom qtmark : Type.
Parameter qtmark_WhyType : WhyType qtmark.
Existing Instance qtmark_WhyType.

(* Why3 assumption *)
Inductive array (a:Type) :=
  | mk_array : Z -> (map.Map.map Z a) -> array a.
Axiom array_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (array a).
Existing Instance array_WhyType.
Implicit Arguments mk_array [[a]].

(* Why3 assumption *)
Definition elts {a:Type} {a_WT:WhyType a} (v:(array a)): (map.Map.map Z a) :=
  match v with
  | (mk_array x x1) => x1
  end.

(* Why3 assumption *)
Definition length {a:Type} {a_WT:WhyType a} (v:(array a)): Z :=
  match v with
  | (mk_array x x1) => x
  end.

(* Why3 assumption *)
Definition get {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z): a :=
  (map.Map.get (elts a1) i).

(* Why3 assumption *)
Definition set {a:Type} {a_WT:WhyType a} (a1:(array a)) (i:Z) (v:a): (array
  a) := (mk_array (length a1) (map.Map.set (elts a1) i v)).

(* Why3 assumption *)
Definition make {a:Type} {a_WT:WhyType a} (n:Z) (v:a): (array a) :=
  (mk_array n (map.Map.const v: (map.Map.map Z a))).

Axiom elt : Type.
Parameter elt_WhyType : WhyType elt.
Existing Instance elt_WhyType.

Parameter le: elt -> elt -> Prop.

Axiom Refl : forall (x:elt), (le x x).

Axiom Trans : forall (x:elt) (y:elt) (z:elt), (le x y) -> ((le y z) -> (le x
  z)).

Axiom Total : forall (x:elt) (y:elt), (le x y) \/ (le y x).

(* Why3 assumption *)
Definition sorted_sub (a:(array elt)) (l:Z) (u:Z): Prop := forall (i1:Z)
  (i2:Z), ((l <= i1)%Z /\ ((i1 <= i2)%Z /\ (i2 < u)%Z)) -> (le (get a i1)
  (get a i2)).

(* Why3 assumption *)
Definition sorted (a:(array elt)): Prop := forall (i1:Z) (i2:Z),
  ((0%Z <= i1)%Z /\ ((i1 <= i2)%Z /\ (i2 < (length a))%Z)) -> (le (get a i1)
  (get a i2)).

(* Why3 assumption *)
Inductive ref (a:Type) :=
  | mk_ref : a -> ref a.
Axiom ref_WhyType : forall (a:Type) {a_WT:WhyType a}, WhyType (ref a).
Existing Instance ref_WhyType.
Implicit Arguments mk_ref [[a]].

(* Why3 assumption *)
Definition contents {a:Type} {a_WT:WhyType a} (v:(ref a)): a :=
  match v with
  | (mk_ref x) => x
  end.

(* Why3 assumption *)
Definition map_eq_sub {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z): Prop := forall (i:Z), ((l <= i)%Z /\
  (i < u)%Z) -> ((map.Map.get a1 i) = (map.Map.get a2 i)).

(* Why3 assumption *)
Definition array_eq_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)) (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\ (((0%Z <= l)%Z /\
  (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\ (u <= (length a1))%Z) /\
  (map_eq_sub (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition array_eq {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (map_eq_sub (elts a1) (elts a2)
  0%Z (length a1)).

(* Why3 assumption *)
Definition exchange {a:Type} {a_WT:WhyType a} (a1:(map.Map.map Z a))
  (a2:(map.Map.map Z a)) (l:Z) (u:Z) (i:Z) (j:Z): Prop := ((l <= i)%Z /\
  (i < u)%Z) /\ (((l <= j)%Z /\ (j < u)%Z) /\ (((map.Map.get a1
  i) = (map.Map.get a2 j)) /\ (((map.Map.get a1 j) = (map.Map.get a2 i)) /\
  forall (k:Z), ((l <= k)%Z /\ (k < u)%Z) -> ((~ (k = i)) -> ((~ (k = j)) ->
  ((map.Map.get a1 k) = (map.Map.get a2 k))))))).

Axiom exchange_set : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(map.Map.map Z a)) (l:Z) (u:Z) (i:Z) (j:Z), ((l <= i)%Z /\
  (i < u)%Z) -> (((l <= j)%Z /\ (j < u)%Z) -> (exchange a1
  (map.Map.set (map.Map.set a1 i (map.Map.get a1 j)) j (map.Map.get a1 i)) l
  u i j)).

(* Why3 assumption *)
Definition exchange1 {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (i:Z) (j:Z): Prop := ((length a1) = (length a2)) /\ (exchange (elts a1)
  (elts a2) 0%Z (length a1) i j).

(* Why3 assumption *)
Definition permut {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (l:Z) (u:Z): Prop := ((length a1) = (length a2)) /\ (((0%Z <= l)%Z /\
  (l <= (length a1))%Z) /\ (((0%Z <= u)%Z /\ (u <= (length a1))%Z) /\
  (map.MapPermut.permut (elts a1) (elts a2) l u))).

(* Why3 assumption *)
Definition permut_sub {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array a))
  (l:Z) (u:Z): Prop := (map_eq_sub (elts a1) (elts a2) 0%Z l) /\ ((permut a1
  a2 l u) /\ (map_eq_sub (elts a1) (elts a2) u (length a1))).

(* Why3 assumption *)
Definition permut_all {a:Type} {a_WT:WhyType a} (a1:(array a)) (a2:(array
  a)): Prop := ((length a1) = (length a2)) /\ (map.MapPermut.permut (elts a1)
  (elts a2) 0%Z (length a1)).

Axiom exchange_permut_sub : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (i:Z) (j:Z) (l:Z) (u:Z), (exchange1 a1
  a2 i j) -> (((l <= i)%Z /\ (i < u)%Z) -> (((l <= j)%Z /\ (j < u)%Z) ->
  ((0%Z <= l)%Z -> ((u <= (length a1))%Z -> (permut_sub a1 a2 l u))))).

Axiom permut_sub_weakening : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (l1:Z) (u1:Z) (l2:Z) (u2:Z),
  (permut_sub a1 a2 l1 u1) -> (((0%Z <= l2)%Z /\ (l2 <= l1)%Z) ->
  (((u1 <= u2)%Z /\ (u2 <= (length a1))%Z) -> (permut_sub a1 a2 l2 u2))).

Axiom exchange_permut_all : forall {a:Type} {a_WT:WhyType a},
  forall (a1:(array a)) (a2:(array a)) (i:Z) (j:Z), (exchange1 a1 a2 i j) ->
  (permut_all a1 a2).

(* Why3 goal *)
Theorem WP_parameter_bottom_up_mergesort : forall (a:Z) (a1:(map.Map.map Z
  elt)), (0%Z <= a)%Z -> forall (tmp:Z) (tmp1:(map.Map.map Z elt)),
  ((0%Z <= tmp)%Z /\ ((tmp = a) /\ forall (i:Z), ((0%Z <= i)%Z /\
  (i < tmp)%Z) -> ((map.Map.get tmp1 i) = (map.Map.get a1 i)))) ->
  forall (len:Z) (a2:(map.Map.map Z elt)), let a3 := (mk_array a a2) in
  (((1%Z <= len)%Z /\ ((permut_all (mk_array a a1) a3) /\ forall (k:Z),
  let l := (k * len)%Z in (((0%Z <= l)%Z /\ (l < a)%Z) -> (sorted_sub a3 l
  (ZArith.BinInt.Z.min a (l + len)%Z))))) -> ((len < a)%Z -> forall (i:Z)
  (lo:Z) (a4:(map.Map.map Z elt)), let a5 := (mk_array a a4) in
  ((((0%Z <= lo)%Z /\ (lo = ((2%Z * i)%Z * len)%Z)) /\ ((permut_all a3 a5) /\
  ((forall (k:Z), let l := (k * len)%Z in (((lo <= l)%Z /\ (l < a)%Z) ->
  (sorted_sub a5 l (ZArith.BinInt.Z.min a (l + len)%Z)))) /\ forall (k:Z),
  let l := (k * (2%Z * len)%Z)%Z in (((0%Z <= l)%Z /\ (l < lo)%Z) ->
  (sorted_sub a5 l (ZArith.BinInt.Z.min a (l + (2%Z * len)%Z)%Z)))))) ->
  ((~ (lo < (a - len)%Z)%Z) -> ((forall (k:Z), let l :=
  (k * (2%Z * len)%Z)%Z in (((0%Z <= l)%Z /\ (l < a)%Z) ->
  ((l = ((k * 2%Z)%Z * len)%Z) /\ (((l < lo)%Z -> (sorted_sub a5 l
  (ZArith.BinInt.Z.min a (l + (2%Z * len)%Z)%Z))) /\ ((lo <= l)%Z ->
  ((sorted_sub a5 l (ZArith.BinInt.Z.min a (l + len)%Z)) /\
  ((((ZArith.BinInt.Z.min a (l + (2%Z * len)%Z)%Z) = (ZArith.BinInt.Z.min a (l + len)%Z)) /\
  ((ZArith.BinInt.Z.min a (l + len)%Z) = a)) /\ (sorted_sub a5 l
  (ZArith.BinInt.Z.min a (l + (2%Z * len)%Z)%Z))))))))) -> forall (len1:Z),
  (len1 = (2%Z * len)%Z) -> forall (k:Z), let l := (k * len1)%Z in
  (((0%Z <= l)%Z /\ (l < a)%Z) -> (sorted_sub a5 l
  (ZArith.BinInt.Z.min a (l + len1)%Z)))))))).
intros a a1 h1 tmp tmp1 (h2,(h3,h4)) len a2 a3 (h5,(h6,h7)) h8 i lo a4 a5
((h9,h10),(h11,(h12,h13))) h14 h15 len1 h16 k l (h17,h18).
subst l len1.
destruct (h15 k); clear h15; intuition.
assert (case: (k * (2 * len) < lo \/ lo <= k * (2 * len))%Z) by omega.
destruct case; intuition.
Qed.

