#!/usr/bin/python3
# -*- coding: utf-8 -*-

#  Copyright © 2015  B. Clausius <barcc@gmx.de>
#
#  This program is free software: you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation, either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.


def lines():
    template_1 = '''
Fields:
  solved = [True]
  type = ['Cube']
  sizes = [(3, 3, 3)]
  selection_mode = ['quadrant', 'simple']
  mirror_faces = [False, True]
Conditions:
Limits:
Initial:
  State: solved=True, type='Cube', sizes=(3, 3, 3), selection_mode='simple', mirror_faces=False
Transition: set_settings_draw 'selection_nick', 'quadrant'
  State:
         selection_mode='quadrant'
Transition: set_settings_draw 'selection_nick', 'simple'
  State:
         selection_mode='simple'
Transition: set_settings_draw 'mirror_faces', False
  State:
         mirror_faces=False
Transition: set_settings_draw 'mirror_faces', True
  State:
         mirror_faces=True
Transition: direct_selectmodel 'Cube', (3,)
'''.strip()
    template_2 = '''
            direct_selectmodel {!r}, {!r}
'''.strip('\n')
    template_3 = '''
  State: solved=True, type='Cube', sizes=(3, 3, 3)
         solved=True, type='Cube', sizes=(3, 3, 3)
'''.strip('\n')
    template_4 = '''
                      type={!r}, sizes={!r}
'''.strip('\n')
    
    from pybiklib.model import Model
    Model.load_index()
    
    tslist = []
    for mtype, sizesdict in Model.cache_index['sizes'].items():
        for normsizes, (internsizes, unused_file) in sizesdict.items():
            tslist.append((mtype, normsizes, internsizes))
    import random
    #tslist.sort()
    random.shuffle(tslist)
    tslist.append(('Cube', (3,), (3, 3, 3)))
            
    yield from template_1.splitlines()
    for mtype, normsizes, internsizes in tslist:
        yield from template_2.format(mtype, normsizes).splitlines()
    yield from template_3.splitlines()
    for mtype, normsizes, internsizes in tslist:
        yield from template_4.format(mtype, internsizes).splitlines()
        
def main():
    import sys
    sys.path.insert(0, '.')
    for line in lines():
        print(line)
        
    
if __name__ == '__main__':
    main()
    

