///////////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2012-2018 DreamWorks Animation LLC
//
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
//
// Redistributions of source code must retain the above copyright
// and license notice and the following restrictions and disclaimer.
//
// *     Neither the name of DreamWorks Animation nor the names of
// its contributors may be used to endorse or promote products derived
// from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// IN NO EVENT SHALL THE COPYRIGHT HOLDERS' AND CONTRIBUTORS' AGGREGATE
// LIABILITY FOR ALL CLAIMS REGARDLESS OF THEIR BASIS EXCEED US$250.00.
//
///////////////////////////////////////////////////////////////////////////

#include "QuantizedUnitVec.h"

namespace openvdb {
OPENVDB_USE_VERSION_NAMESPACE
namespace OPENVDB_VERSION_NAME {
namespace math {

// The table below is generated as follows:
//
// uint16_t xbits, ybits;
// double x, y, z, w;
// for (uint16_t b = 0; b < 8192; ++b) {
//     xbits = uint16_t((b & MASK_XSLOT) >> 7);
//     ybits = b & MASK_YSLOT;
//     if ((xbits + ybits) > 126) {
//         xbits = uint16_t(127 - xbits);
//         ybits = uint16_t(127 - ybits);
//     }
//     x = double(xbits);
//     y = double(ybits);
//     z = double(126 - xbits - ybits);
//     w = 1.0 / std::sqrt(x*x + y*y + z*z);
//     sNormalizationWeights[b] = float(w);
// }

float QuantizedUnitVec::sNormalizationWeights[8192] = {
    0.007936508395f, 0.007999744266f, 0.008063467219f, 0.008127664216f,
    0.008192319423f, 0.008257416077f, 0.008322936483f, 0.008388860151f,
    0.008455166593f, 0.008521833457f, 0.008588834666f, 0.008656143211f,
    0.008723732084f, 0.00879156962f, 0.008859624155f, 0.008927859366f,
    0.008996240795f, 0.009064726532f, 0.009133277461f, 0.009201847948f,
    0.00927039329f, 0.009338863194f, 0.009407208301f, 0.009475374594f,
    0.009543305263f, 0.009610942565f, 0.009678225033f, 0.009745089337f,
    0.009811468422f, 0.009877296165f, 0.009942499921f, 0.01000700705f,
    0.01007074397f, 0.01013363153f, 0.01019559242f, 0.01025654469f,
    0.01031640731f, 0.01037509646f, 0.01043252647f, 0.01048861258f,
    0.01054326911f, 0.01059640758f, 0.01064794231f, 0.01069778763f,
    0.01074585691f, 0.01079206541f, 0.01083632838f, 0.01087856572f,
    0.01091869641f, 0.01095664315f, 0.01099232957f, 0.01102568675f,
    0.01105664484f, 0.01108513959f, 0.01111111138f, 0.01113450434f,
    0.01115526911f, 0.01117335912f, 0.01118873432f, 0.01120136213f,
    0.01121121366f, 0.01121826563f, 0.01122250315f, 0.0112239169f,
    0.01122250315f, 0.01121826563f, 0.01121121366f, 0.01120136213f,
    0.01118873432f, 0.01117335912f, 0.01115526911f, 0.01113450434f,
    0.01111111138f, 0.01108513959f, 0.01105664484f, 0.01102568675f,
    0.01099232957f, 0.01095664315f, 0.01091869641f, 0.01087856572f,
    0.01083632838f, 0.01079206541f, 0.01074585691f, 0.01069778763f,
    0.01064794231f, 0.01059640758f, 0.01054326911f, 0.01048861258f,
    0.01043252647f, 0.01037509646f, 0.01031640731f, 0.01025654469f,
    0.01019559242f, 0.01013363153f, 0.01007074397f, 0.01000700705f,
    0.009942499921f, 0.009877296165f, 0.009811468422f, 0.009745089337f,
    0.009678225033f, 0.009610942565f, 0.009543305263f, 0.009475374594f,
    0.009407208301f, 0.009338863194f, 0.00927039329f, 0.009201847948f,
    0.009133277461f, 0.009064726532f, 0.008996240795f, 0.008927859366f,
    0.008859624155f, 0.00879156962f, 0.008723732084f, 0.008656143211f,
    0.008588834666f, 0.008521833457f, 0.008455166593f, 0.008388860151f,
    0.008322936483f, 0.008257416077f, 0.008192319423f, 0.008127664216f,
    0.008063467219f, 0.007999744266f, 0.007936508395f, 0.007873771712f,
    0.007999744266f, 0.008063991554f, 0.008128738031f, 0.008193968795f,
    0.008259668946f, 0.008325820789f, 0.008392404765f, 0.008459401317f,
    0.008526788093f, 0.00859454181f, 0.008662636392f, 0.008731043898f,
    0.008799735457f, 0.008868678473f, 0.008937839419f, 0.009007181972f,
    0.00907666795f, 0.009146256372f, 0.009215905331f, 0.009285567328f,
    0.009355195798f, 0.009424740449f, 0.009494146332f, 0.009563359432f,
    0.009632320143f, 0.009700968862f, 0.009769240394f, 0.00983707048f,
    0.00990438927f, 0.009971125983f, 0.01003720704f, 0.01010255609f,
    0.01016709674f, 0.01023074798f, 0.01029342785f, 0.01035505254f,
    0.01041553635f, 0.01047479361f, 0.01053273678f, 0.01058927551f,
    0.01064432319f, 0.01069778763f, 0.01074958127f, 0.01079961471f,
    0.01084779948f, 0.01089404803f, 0.01093827467f, 0.0109803956f,
    0.01102032885f, 0.01105799619f, 0.01109332126f, 0.0111262314f,
    0.01115665678f, 0.01118453499f, 0.01120980456f, 0.01123241056f,
    0.01125230361f, 0.01126943901f, 0.01128377859f, 0.01129528973f,
    0.01130394638f, 0.01130972803f, 0.01131262258f, 0.01131262258f,
    0.01130972803f, 0.01130394638f, 0.01129528973f, 0.01128377859f,
    0.01126943901f, 0.01125230361f, 0.01123241056f, 0.01120980456f,
    0.01118453499f, 0.01115665678f, 0.0111262314f, 0.01109332126f,
    0.01105799619f, 0.01102032885f, 0.0109803956f, 0.01093827467f,
    0.01089404803f, 0.01084779948f, 0.01079961471f, 0.01074958127f,
    0.01069778763f, 0.01064432319f, 0.01058927551f, 0.01053273678f,
    0.01047479361f, 0.01041553635f, 0.01035505254f, 0.01029342785f,
    0.01023074798f, 0.01016709674f, 0.01010255609f, 0.01003720704f,
    0.009971125983f, 0.00990438927f, 0.00983707048f, 0.009769240394f,
    0.009700968862f, 0.009632320143f, 0.009563359432f, 0.009494146332f,
    0.009424740449f, 0.009355195798f, 0.009285567328f, 0.009215905331f,
    0.009146256372f, 0.00907666795f, 0.009007181972f, 0.008937839419f,
    0.008868678473f, 0.008799735457f, 0.008731043898f, 0.008662636392f,
    0.00859454181f, 0.008526788093f, 0.008459401317f, 0.008392404765f,
    0.008325820789f, 0.008259668946f, 0.008193968795f, 0.008128738031f,
    0.008063991554f, 0.007999744266f, 0.007936008275f, 0.007936508395f,
    0.008063467219f, 0.008128738031f, 0.008194519207f, 0.008260795847f,
    0.008327552117f, 0.008394770324f, 0.008462429978f, 0.008530510589f,
    0.008598989807f, 0.008667841554f, 0.008737040684f, 0.008806557395f,
    0.008876360953f, 0.008946419694f, 0.009016696364f, 0.009087154642f,
    0.009157754481f, 0.009228453971f, 0.009299207479f, 0.009369968437f,
    0.009440686554f, 0.009511308745f, 0.009581780061f, 0.00965204183f,
    0.009722034447f, 0.009791694582f, 0.009860955179f, 0.009929747321f,
    0.009998000227f, 0.01006564032f, 0.01013259124f, 0.01019877382f,
    0.01026410609f, 0.01032850612f, 0.01039188914f, 0.01045416761f,
    0.01051525306f, 0.01057505608f, 0.01063348539f, 0.01069044974f,
    0.01074585691f, 0.01079961471f, 0.01085163094f, 0.0109018134f,
    0.01095007174f, 0.01099631656f, 0.01104046032f, 0.0110824164f,
    0.01112210099f, 0.01115943585f, 0.01119434182f, 0.01122674625f,
    0.01125658024f, 0.01128377859f, 0.01130828168f, 0.01133003552f,
    0.01134899072f, 0.01136510447f, 0.01137833856f, 0.01138866507f,
    0.0113960579f, 0.01140050031f, 0.01140198205f, 0.01140050031f,
    0.0113960579f, 0.01138866507f, 0.01137833856f, 0.01136510447f,
    0.01134899072f, 0.01133003552f, 0.01130828168f, 0.01128377859f,
    0.01125658024f, 0.01122674625f, 0.01119434182f, 0.01115943585f,
    0.01112210099f, 0.0110824164f, 0.01104046032f, 0.01099631656f,
    0.01095007174f, 0.0109018134f, 0.01085163094f, 0.01079961471f,
    0.01074585691f, 0.01069044974f, 0.01063348539f, 0.01057505608f,
    0.01051525306f, 0.01045416761f, 0.01039188914f, 0.01032850612f,
    0.01026410609f, 0.01019877382f, 0.01013259124f, 0.01006564032f,
    0.009998000227f, 0.009929747321f, 0.009860955179f, 0.009791694582f,
    0.009722034447f, 0.00965204183f, 0.009581780061f, 0.009511308745f,
    0.009440686554f, 0.009369968437f, 0.009299207479f, 0.009228453971f,
    0.009157754481f, 0.009087154642f, 0.009016696364f, 0.008946419694f,
    0.008876360953f, 0.008806557395f, 0.008737040684f, 0.008667841554f,
    0.008598989807f, 0.008530510589f, 0.008462429978f, 0.008394770324f,
    0.008327552117f, 0.008260795847f, 0.008194519207f, 0.008128738031f,
    0.008063467219f, 0.007998720743f, 0.007999744266f, 0.007999744266f,
    0.008127664216f, 0.008193968795f, 0.008260795847f, 0.008328129537f,
    0.008395953104f, 0.008464248851f, 0.008532994427f, 0.008602170274f,
    0.008671752177f, 0.008741713129f, 0.008812026121f, 0.008882662281f,
    0.008953588083f, 0.00902477093f, 0.009096172638f, 0.009167755023f,
    0.009239477105f, 0.009311294183f, 0.009383158758f, 0.009455023333f,
    0.009526834823f, 0.00959853828f, 0.009670076892f, 0.009741389193f,
    0.009812413715f, 0.009883082472f, 0.009953328408f, 0.01002307981f,
    0.01009226125f, 0.01016079728f, 0.01022860687f, 0.01029560994f,
    0.01036172081f, 0.01042685378f, 0.01049092133f, 0.01055383217f,
    0.01061549596f, 0.01067581866f, 0.01073470619f, 0.01079206541f,
    0.01084779948f, 0.0109018134f, 0.01095401309f, 0.01100430358f,
    0.01105259173f, 0.01109878626f, 0.01114279591f, 0.01118453499f,
    0.0112239169f, 0.01126086153f, 0.01129528973f, 0.01132712793f,
    0.01135630626f, 0.01138276048f, 0.01140643191f, 0.01142726559f,
    0.01144521404f, 0.01146023627f, 0.01147229597f, 0.01148136612f,
    0.0114874253f, 0.01149045862f, 0.01149045862f, 0.0114874253f,
    0.01148136612f, 0.01147229597f, 0.01146023627f, 0.01144521404f,
    0.01142726559f, 0.01140643191f, 0.01138276048f, 0.01135630626f,
    0.01132712793f, 0.01129528973f, 0.01126086153f, 0.0112239169f,
    0.01118453499f, 0.01114279591f, 0.01109878626f, 0.01105259173f,
    0.01100430358f, 0.01095401309f, 0.0109018134f, 0.01084779948f,
    0.01079206541f, 0.01073470619f, 0.01067581866f, 0.01061549596f,
    0.01055383217f, 0.01049092133f, 0.01042685378f, 0.01036172081f,
    0.01029560994f, 0.01022860687f, 0.01016079728f, 0.01009226125f,
    0.01002307981f, 0.009953328408f, 0.009883082472f, 0.009812413715f,
    0.009741389193f, 0.009670076892f, 0.00959853828f, 0.009526834823f,
    0.009455023333f, 0.009383158758f, 0.009311294183f, 0.009239477105f,
    0.009167755023f, 0.009096172638f, 0.00902477093f, 0.008953588083f,
    0.008882662281f, 0.008812026121f, 0.008741713129f, 0.008671752177f,
    0.008602170274f, 0.008532994427f, 0.008464248851f, 0.008395953104f,
    0.008328129537f, 0.008260795847f, 0.008193968795f, 0.008127664216f,
    0.008061895147f, 0.008063467219f, 0.008063991554f, 0.008063467219f,
    0.008192319423f, 0.008259668946f, 0.008327552117f, 0.008395953104f,
    0.008464855142f, 0.008534237742f, 0.008604080416f, 0.008674361743f,
    0.008745054714f, 0.008816135116f, 0.008887572214f, 0.008959336206f,
    0.009031393565f, 0.009103707969f, 0.009176243097f, 0.009248957038f,
    0.009321806021f, 0.009394746274f, 0.009467727505f, 0.009540699422f,
    0.009613607079f, 0.009686394595f, 0.009759000503f, 0.009831363335f,
    0.0099034179f, 0.009975093417f, 0.01004632004f, 0.01011702232f,
    0.0101871239f, 0.01025654469f, 0.01032520272f, 0.01039301138f,
    0.010459885f, 0.0105257323f, 0.01059046388f, 0.0106539838f,
    0.01071619987f, 0.01077701338f, 0.01083632838f, 0.01089404803f,
    0.01095007174f, 0.01100430358f, 0.01105664484f, 0.01110699773f,
    0.01115526911f, 0.01120136213f, 0.01124518644f, 0.01128665265f,
    0.01132567506f, 0.01136216894f, 0.0113960579f, 0.01142726559f,
    0.01145572308f, 0.01148136612f, 0.01150413603f, 0.01152398065f,
    0.01154085156f, 0.0115547115f, 0.01156552508f, 0.0115732681f,
    0.01157792099f, 0.0115794735f, 0.01157792099f, 0.0115732681f,
    0.01156552508f, 0.0115547115f, 0.01154085156f, 0.01152398065f,
    0.01150413603f, 0.01148136612f, 0.01145572308f, 0.01142726559f,
    0.0113960579f, 0.01136216894f, 0.01132567506f, 0.01128665265f,
    0.01124518644f, 0.01120136213f, 0.01115526911f, 0.01110699773f,
    0.01105664484f, 0.01100430358f, 0.01095007174f, 0.01089404803f,
    0.01083632838f, 0.01077701338f, 0.01071619987f, 0.0106539838f,
    0.01059046388f, 0.0105257323f, 0.010459885f, 0.01039301138f,
    0.01032520272f, 0.01025654469f, 0.0101871239f, 0.01011702232f,
    0.01004632004f, 0.009975093417f, 0.0099034179f, 0.009831363335f,
    0.009759000503f, 0.009686394595f, 0.009613607079f, 0.009540699422f,
    0.009467727505f, 0.009394746274f, 0.009321806021f, 0.009248957038f,
    0.009176243097f, 0.009103707969f, 0.009031393565f, 0.008959336206f,
    0.008887572214f, 0.008816135116f, 0.008745054714f, 0.008674361743f,
    0.008604080416f, 0.008534237742f, 0.008464855142f, 0.008395953104f,
    0.008327552117f, 0.008259668946f, 0.008192319423f, 0.008125517517f,
    0.008127664216f, 0.008128738031f, 0.008128738031f, 0.008127664216f,
    0.008257416077f, 0.008325820789f, 0.008394770324f, 0.008464248851f,
    0.008534237742f, 0.008604717441f, 0.008675667457f, 0.008747061715f,
    0.00881887693f, 0.008891084231f, 0.008963654749f, 0.009036554955f,
    0.00910975039f, 0.009183204733f, 0.009256878868f, 0.009330729023f,
    0.009404712357f, 0.00947877951f, 0.00955288019f, 0.009626962245f,
    0.009700968862f, 0.009774839506f, 0.009848512709f, 0.009921924211f,
    0.009995004162f, 0.01006768085f, 0.01013988163f, 0.01021152735f,
    0.01028253883f, 0.01035283227f, 0.0104223229f, 0.01049092133f,
    0.01055853814f, 0.01062507927f, 0.01069044974f, 0.0107545536f,
    0.01081729215f, 0.01087856572f, 0.01093827467f, 0.01099631656f,
    0.01105259173f, 0.01110699773f, 0.01115943585f, 0.01120980456f,
    0.01125800703f, 0.01130394638f, 0.01134752948f, 0.01138866507f,
    0.01142726559f, 0.01146324724f, 0.01149653178f, 0.01152704284f,
    0.0115547115f, 0.0115794735f, 0.01160127111f, 0.01162005402f,
    0.01163577568f, 0.01164839976f, 0.01165789459f, 0.0116642369f,
    0.01166741177f, 0.01166741177f, 0.0116642369f, 0.01165789459f,
    0.01164839976f, 0.01163577568f, 0.01162005402f, 0.01160127111f,
    0.0115794735f, 0.0115547115f, 0.01152704284f, 0.01149653178f,
    0.01146324724f, 0.01142726559f, 0.01138866507f, 0.01134752948f,
    0.01130394638f, 0.01125800703f, 0.01120980456f, 0.01115943585f,
    0.01110699773f, 0.01105259173f, 0.01099631656f, 0.01093827467f,
    0.01087856572f, 0.01081729215f, 0.0107545536f, 0.01069044974f,
    0.01062507927f, 0.01055853814f, 0.01049092133f, 0.0104223229f,
    0.01035283227f, 0.01028253883f, 0.01021152735f, 0.01013988163f,
    0.01006768085f, 0.009995004162f, 0.009921924211f, 0.009848512709f,
    0.009774839506f, 0.009700968862f, 0.009626962245f, 0.00955288019f,
    0.00947877951f, 0.009404712357f, 0.009330729023f, 0.009256878868f,
    0.009183204733f, 0.00910975039f, 0.009036554955f, 0.008963654749f,
    0.008891084231f, 0.00881887693f, 0.008747061715f, 0.008675667457f,
    0.008604717441f, 0.008534237742f, 0.008464248851f, 0.008394770324f,
    0.008325820789f, 0.008257416077f, 0.00818957109f, 0.008192319423f,
    0.008193968795f, 0.008194519207f, 0.008193968795f, 0.008192319423f,
    0.008322936483f, 0.008392404765f, 0.008462429978f, 0.008532994427f,
    0.008604080416f, 0.008675667457f, 0.008747731335f, 0.008820248768f,
    0.008893193677f, 0.008966536261f, 0.009040246718f, 0.009114289656f,
    0.009188630618f, 0.009263231419f, 0.009338049218f, 0.009413041174f,
    0.009488161653f, 0.009563359432f, 0.009638582356f, 0.009713775478f,
    0.009788879193f, 0.009863832965f, 0.009938570671f, 0.01001302525f,
    0.01008712593f, 0.01016079728f, 0.01023396198f, 0.01030653995f,
    0.01037844829f, 0.01044960041f, 0.01051990688f, 0.01058927551f,
    0.0106576141f, 0.01072482392f, 0.01079080813f, 0.01085546613f,
    0.01091869641f, 0.0109803956f, 0.01104046032f, 0.01109878626f,
    0.01115526911f, 0.01120980456f, 0.01126228925f, 0.01131262258f,
    0.01136070304f, 0.01140643191f, 0.01144971419f, 0.01149045862f,
    0.01152857486f, 0.01156397816f, 0.01159659028f, 0.01162633486f,
    0.01165314391f, 0.01167695317f, 0.01169770677f, 0.0117153544f,
    0.0117298523f, 0.011741166f, 0.01174926758f, 0.0117541356f,
    0.01175575983f, 0.0117541356f, 0.01174926758f, 0.011741166f,
    0.0117298523f, 0.0117153544f, 0.01169770677f, 0.01167695317f,
    0.01165314391f, 0.01162633486f, 0.01159659028f, 0.01156397816f,
    0.01152857486f, 0.01149045862f, 0.01144971419f, 0.01140643191f,
    0.01136070304f, 0.01131262258f, 0.01126228925f, 0.01120980456f,
    0.01115526911f, 0.01109878626f, 0.01104046032f, 0.0109803956f,
    0.01091869641f, 0.01085546613f, 0.01079080813f, 0.01072482392f,
    0.0106576141f, 0.01058927551f, 0.01051990688f, 0.01044960041f,
    0.01037844829f, 0.01030653995f, 0.01023396198f, 0.01016079728f,
    0.01008712593f, 0.01001302525f, 0.009938570671f, 0.009863832965f,
    0.009788879193f, 0.009713775478f, 0.009638582356f, 0.009563359432f,
    0.009488161653f, 0.009413041174f, 0.009338049218f, 0.009263231419f,
    0.009188630618f, 0.009114289656f, 0.009040246718f, 0.008966536261f,
    0.008893193677f, 0.008820248768f, 0.008747731335f, 0.008675667457f,
    0.008604080416f, 0.008532994427f, 0.008462429978f, 0.008392404765f,
    0.008322936483f, 0.008254040033f, 0.008257416077f, 0.008259668946f,
    0.008260795847f, 0.008260795847f, 0.008259668946f, 0.008257416077f,
    0.008388860151f, 0.008459401317f, 0.008530510589f, 0.008602170274f,
    0.008674361743f, 0.008747061715f, 0.008820248768f, 0.008893896826f,
    0.00896797888f, 0.009042463265f, 0.00911732018f, 0.009192512371f,
    0.009268003516f, 0.0093437545f, 0.00941972062f, 0.009495858103f,
    0.009572117589f, 0.009648446925f, 0.009724793024f, 0.009801096283f,
    0.009877296165f, 0.009953328408f, 0.01002912689f, 0.01010461897f,
    0.01017973199f, 0.01025438774f, 0.01032850612f, 0.01040200423f,
    0.01047479361f, 0.01054678671f, 0.01061788946f, 0.01068800688f,
    0.0107570421f, 0.01082489453f, 0.01089146268f, 0.01095664315f,
    0.01102032885f, 0.0110824164f, 0.01114279591f, 0.01120136213f,
    0.01125800703f, 0.01131262258f, 0.01136510447f, 0.01141534653f,
    0.01146324724f, 0.01150870696f, 0.01155162696f, 0.01159191411f,
    0.01162947994f, 0.0116642369f, 0.01169610675f, 0.01172501314f,
    0.01175088901f, 0.01177367195f, 0.0117933061f, 0.01180974208f,
    0.01182294171f, 0.01183286961f, 0.01183950249f, 0.01184282266f,
    0.01184282266f, 0.01183950249f, 0.01183286961f, 0.01182294171f,
    0.01180974208f, 0.0117933061f, 0.01177367195f, 0.01175088901f,
    0.01172501314f, 0.01169610675f, 0.0116642369f, 0.01162947994f,
    0.01159191411f, 0.01155162696f, 0.01150870696f, 0.01146324724f,
    0.01141534653f, 0.01136510447f, 0.01131262258f, 0.01125800703f,
    0.01120136213f, 0.01114279591f, 0.0110824164f, 0.01102032885f,
    0.01095664315f, 0.01089146268f, 0.01082489453f, 0.0107570421f,
    0.01068800688f, 0.01061788946f, 0.01054678671f, 0.01047479361f,
    0.01040200423f, 0.01032850612f, 0.01025438774f, 0.01017973199f,
    0.01010461897f, 0.01002912689f, 0.009953328408f, 0.009877296165f,
    0.009801096283f, 0.009724793024f, 0.009648446925f, 0.009572117589f,
    0.009495858103f, 0.00941972062f, 0.0093437545f, 0.009268003516f,
    0.009192512371f, 0.00911732018f, 0.009042463265f, 0.00896797888f,
    0.008893896826f, 0.008820248768f, 0.008747061715f, 0.008674361743f,
    0.008602170274f, 0.008530510589f, 0.008459401317f, 0.008388860151f,
    0.008318902925f, 0.008322936483f, 0.008325820789f, 0.008327552117f,
    0.008328129537f, 0.008327552117f, 0.008325820789f, 0.008322936483f,
    0.008455166593f, 0.008526788093f, 0.008598989807f, 0.008671752177f,
    0.008745054714f, 0.00881887693f, 0.008893193677f, 0.00896797888f,
    0.009043202735f, 0.009118835442f, 0.009194843471f, 0.00927118957f,
    0.009347835556f, 0.009424740449f, 0.009501857683f, 0.009579141624f,
    0.009656541049f, 0.009734002873f, 0.009811468422f, 0.009888879955f,
    0.009966172278f, 0.01004327927f, 0.01012013014f, 0.01019665226f,
    0.01027276739f, 0.01034839638f, 0.01042345539f, 0.01049785595f,
    0.0105715096f, 0.01064432319f, 0.01071619987f, 0.01078704093f,
    0.01085674576f, 0.01092521101f, 0.01099232957f, 0.01105799619f,
    0.01112210099f, 0.01118453499f, 0.01124518644f, 0.01130394638f,
    0.01136070304f, 0.01141534653f, 0.01146776881f, 0.01151786372f,
    0.01156552508f, 0.01161065139f, 0.01165314391f, 0.01169290766f,
    0.0117298523f, 0.01176389214f, 0.01179494616f, 0.01182294171f,
    0.01184780896f, 0.01186948828f, 0.01188792568f, 0.0119030755f,
    0.01191489771f, 0.01192336436f, 0.01192845311f, 0.01193015091f,
    0.01192845311f, 0.01192336436f, 0.01191489771f, 0.0119030755f,
    0.01188792568f, 0.01186948828f, 0.01184780896f, 0.01182294171f,
    0.01179494616f, 0.01176389214f, 0.0117298523f, 0.01169290766f,
    0.01165314391f, 0.01161065139f, 0.01156552508f, 0.01151786372f,
    0.01146776881f, 0.01141534653f, 0.01136070304f, 0.01130394638f,
    0.01124518644f, 0.01118453499f, 0.01112210099f, 0.01105799619f,
    0.01099232957f, 0.01092521101f, 0.01085674576f, 0.01078704093f,
    0.01071619987f, 0.01064432319f, 0.0105715096f, 0.01049785595f,
    0.01042345539f, 0.01034839638f, 0.01027276739f, 0.01019665226f,
    0.01012013014f, 0.01004327927f, 0.009966172278f, 0.009888879955f,
    0.009811468422f, 0.009734002873f, 0.009656541049f, 0.009579141624f,
    0.009501857683f, 0.009424740449f, 0.009347835556f, 0.00927118957f,
    0.009194843471f, 0.009118835442f, 0.009043202735f, 0.00896797888f,
    0.008893193677f, 0.00881887693f, 0.008745054714f, 0.008671752177f,
    0.008598989807f, 0.008526788093f, 0.008455166593f, 0.00838414114f,
    0.008388860151f, 0.008392404765f, 0.008394770324f, 0.008395953104f,
    0.008395953104f, 0.008394770324f, 0.008392404765f, 0.008388860151f,
    0.008521833457f, 0.00859454181f, 0.008667841554f, 0.008741713129f,
    0.008816135116f, 0.008891084231f, 0.008966536261f, 0.009042463265f,
    0.009118835442f, 0.009195621125f, 0.009272783995f, 0.009350287728f,
    0.009428090416f, 0.009506150149f, 0.009584420361f, 0.00966285076f,
    0.009741389193f, 0.009819980711f, 0.009898564778f, 0.009977078997f,
    0.01005545817f, 0.01013363153f, 0.01021152735f, 0.0102890674f,
    0.01036617346f, 0.01044276077f, 0.01051874273f, 0.01059402898f,
    0.01066852547f, 0.01074213628f, 0.01081476174f, 0.01088629849f,
    0.01095664315f, 0.01102568675f, 0.01109332126f, 0.01115943585f,
    0.0112239169f, 0.01128665265f, 0.01134752948f, 0.01140643191f,
    0.01146324724f, 0.01151786372f, 0.01157016866f, 0.01162005402f,
    0.01166741177f, 0.01171213947f, 0.0117541356f, 0.0117933061f,
    0.0118295569f, 0.01186280511f, 0.01189296879f, 0.01191997528f,
    0.01194375753f, 0.01196425594f, 0.01198141929f, 0.01199520286f,
    0.01200557221f, 0.01201249938f, 0.01201596763f, 0.01201596763f,
    0.01201249938f, 0.01200557221f, 0.01199520286f, 0.01198141929f,
    0.01196425594f, 0.01194375753f, 0.01191997528f, 0.01189296879f,
    0.01186280511f, 0.0118295569f, 0.0117933061f, 0.0117541356f,
    0.01171213947f, 0.01166741177f, 0.01162005402f, 0.01157016866f,
    0.01151786372f, 0.01146324724f, 0.01140643191f, 0.01134752948f,
    0.01128665265f, 0.0112239169f, 0.01115943585f, 0.01109332126f,
    0.01102568675f, 0.01095664315f, 0.01088629849f, 0.01081476174f,
    0.01074213628f, 0.01066852547f, 0.01059402898f, 0.01051874273f,
    0.01044276077f, 0.01036617346f, 0.0102890674f, 0.01021152735f,
    0.01013363153f, 0.01005545817f, 0.009977078997f, 0.009898564778f,
    0.009819980711f, 0.009741389193f, 0.00966285076f, 0.009584420361f,
    0.009506150149f, 0.009428090416f, 0.009350287728f, 0.009272783995f,
    0.009195621125f, 0.009118835442f, 0.009042463265f, 0.008966536261f,
    0.008891084231f, 0.008816135116f, 0.008741713129f, 0.008667841554f,
    0.00859454181f, 0.008521833457f, 0.008449732326f, 0.008455166593f,
    0.008459401317f, 0.008462429978f, 0.008464248851f, 0.008464855142f,
    0.008464248851f, 0.008462429978f, 0.008459401317f, 0.008455166593f,
    0.008588834666f, 0.008662636392f, 0.008737040684f, 0.008812026121f,
    0.008887572214f, 0.008963654749f, 0.009040246718f, 0.00911732018f,
    0.009194843471f, 0.009272783995f, 0.009351104498f, 0.009429766797f,
    0.00950872805f, 0.009587943554f, 0.00966736488f, 0.009746940807f,
    0.009826615453f, 0.00990633294f, 0.009986029007f, 0.01006564032f,
    0.01014509797f, 0.01022432931f, 0.01030325703f, 0.01038180385f,
    0.010459885f, 0.01053741388f, 0.01061430015f, 0.01069044974f,
    0.01076576579f, 0.01084014867f, 0.01091349311f, 0.01098569483f,
    0.01105664484f, 0.0111262314f, 0.01119434182f, 0.01126086153f,
    0.01132567506f, 0.01138866507f, 0.01144971419f, 0.01150870696f,
    0.01156552508f, 0.01162005402f, 0.01167218015f, 0.01172179077f,
    0.01176877879f, 0.01181303803f, 0.01185446698f, 0.01189296879f,
    0.01192845311f, 0.0119608324f, 0.01199002843f, 0.01201596763f,
    0.01203858573f, 0.01205782313f, 0.01207363233f, 0.01208597142f,
    0.01209480781f, 0.01210011914f, 0.01210189145f, 0.01210011914f,
    0.01209480781f, 0.01208597142f, 0.01207363233f, 0.01205782313f,
    0.01203858573f, 0.01201596763f, 0.01199002843f, 0.0119608324f,
    0.01192845311f, 0.01189296879f, 0.01185446698f, 0.01181303803f,
    0.01176877879f, 0.01172179077f, 0.01167218015f, 0.01162005402f,
    0.01156552508f, 0.01150870696f, 0.01144971419f, 0.01138866507f,
    0.01132567506f, 0.01126086153f, 0.01119434182f, 0.0111262314f,
    0.01105664484f, 0.01098569483f, 0.01091349311f, 0.01084014867f,
    0.01076576579f, 0.01069044974f, 0.01061430015f, 0.01053741388f,
    0.010459885f, 0.01038180385f, 0.01030325703f, 0.01022432931f,
    0.01014509797f, 0.01006564032f, 0.009986029007f, 0.00990633294f,
    0.009826615453f, 0.009746940807f, 0.00966736488f, 0.009587943554f,
    0.00950872805f, 0.009429766797f, 0.009351104498f, 0.009272783995f,
    0.009194843471f, 0.00911732018f, 0.009040246718f, 0.008963654749f,
    0.008887572214f, 0.008812026121f, 0.008737040684f, 0.008662636392f,
    0.008588834666f, 0.008515651338f, 0.008521833457f, 0.008526788093f,
    0.008530510589f, 0.008532994427f, 0.008534237742f, 0.008534237742f,
    0.008532994427f, 0.008530510589f, 0.008526788093f, 0.008521833457f,
    0.008656143211f, 0.008731043898f, 0.008806557395f, 0.008882662281f,
    0.008959336206f, 0.009036554955f, 0.009114289656f, 0.009192512371f,
    0.00927118957f, 0.009350287728f, 0.009429766797f, 0.00950958766f,
    0.009589706548f, 0.009670076892f, 0.009750646539f, 0.009831363335f,
    0.00991217047f, 0.009993007407f, 0.01007380895f, 0.01015450899f,
    0.01023503393f, 0.01031531021f, 0.01039525773f, 0.01047479361f,
    0.01055383217f, 0.01063228305f, 0.01071005128f, 0.01078704093f,
    0.01086314954f, 0.01093827467f, 0.01101230737f, 0.01108513959f,
    0.01115665678f, 0.01122674625f, 0.01129528973f, 0.01136216894f,
    0.01142726559f, 0.01149045862f, 0.01155162696f, 0.01161065139f,
    0.01166741177f, 0.01172179077f, 0.01177367195f, 0.01182294171f,
    0.01186948828f, 0.01191320643f, 0.0119539937f, 0.01199175231f,
    0.01202639099f, 0.01205782313f, 0.01208597142f, 0.01211076323f,
    0.01213213522f, 0.01215003151f, 0.01216440555f, 0.01217522006f,
    0.0121824462f, 0.01218606345f, 0.01218606345f, 0.0121824462f,
    0.01217522006f, 0.01216440555f, 0.01215003151f, 0.01213213522f,
    0.01211076323f, 0.01208597142f, 0.01205782313f, 0.01202639099f,
    0.01199175231f, 0.0119539937f, 0.01191320643f, 0.01186948828f,
    0.01182294171f, 0.01177367195f, 0.01172179077f, 0.01166741177f,
    0.01161065139f, 0.01155162696f, 0.01149045862f, 0.01142726559f,
    0.01136216894f, 0.01129528973f, 0.01122674625f, 0.01115665678f,
    0.01108513959f, 0.01101230737f, 0.01093827467f, 0.01086314954f,
    0.01078704093f, 0.01071005128f, 0.01063228305f, 0.01055383217f,
    0.01047479361f, 0.01039525773f, 0.01031531021f, 0.01023503393f,
    0.01015450899f, 0.01007380895f, 0.009993007407f, 0.00991217047f,
    0.009831363335f, 0.009750646539f, 0.009670076892f, 0.009589706548f,
    0.00950958766f, 0.009429766797f, 0.009350287728f, 0.00927118957f,
    0.009192512371f, 0.009114289656f, 0.009036554955f, 0.008959336206f,
    0.008882662281f, 0.008806557395f, 0.008731043898f, 0.008656143211f,
    0.008581873029f, 0.008588834666f, 0.00859454181f, 0.008598989807f,
    0.008602170274f, 0.008604080416f, 0.008604717441f, 0.008604080416f,
    0.008602170274f, 0.008598989807f, 0.00859454181f, 0.008588834666f,
    0.008723732084f, 0.008799735457f, 0.008876360953f, 0.008953588083f,
    0.009031393565f, 0.00910975039f, 0.009188630618f, 0.009268003516f,
    0.009347835556f, 0.009428090416f, 0.00950872805f, 0.009589706548f,
    0.009670981206f, 0.009752500802f, 0.009834215976f, 0.009916068986f,
    0.009998000227f, 0.01007994823f, 0.01016184594f, 0.01024362259f,
    0.01032520272f, 0.01040650904f, 0.0104874596f, 0.01056796685f,
    0.01064794231f, 0.01072729193f, 0.0108059179f, 0.01088371873f,
    0.01096059103f, 0.0110364249f, 0.01111111138f, 0.01118453499f,
    0.01125658024f, 0.01132712793f, 0.0113960579f, 0.01146324724f,
    0.01152857486f, 0.01159191411f, 0.01165314391f, 0.01171213947f,
    0.01176877879f, 0.01182294171f, 0.01187450811f, 0.01192336436f,
    0.01196939778f, 0.01201249938f, 0.01205256768f, 0.01208950393f,
    0.01212321594f, 0.0121536199f, 0.0121806385f, 0.01220420003f,
    0.01222424489f, 0.01224071812f, 0.01225357689f, 0.01226278674f,
    0.01226832252f, 0.01227016933f, 0.01226832252f, 0.01226278674f,
    0.01225357689f, 0.01224071812f, 0.01222424489f, 0.01220420003f,
    0.0121806385f, 0.0121536199f, 0.01212321594f, 0.01208950393f,
    0.01205256768f, 0.01201249938f, 0.01196939778f, 0.01192336436f,
    0.01187450811f, 0.01182294171f, 0.01176877879f, 0.01171213947f,
    0.01165314391f, 0.01159191411f, 0.01152857486f, 0.01146324724f,
    0.0113960579f, 0.01132712793f, 0.01125658024f, 0.01118453499f,
    0.01111111138f, 0.0110364249f, 0.01096059103f, 0.01088371873f,
    0.0108059179f, 0.01072729193f, 0.01064794231f, 0.01056796685f,
    0.0104874596f, 0.01040650904f, 0.01032520272f, 0.01024362259f,
    0.01016184594f, 0.01007994823f, 0.009998000227f, 0.009916068986f,
    0.009834215976f, 0.009752500802f, 0.009670981206f, 0.009589706548f,
    0.00950872805f, 0.009428090416f, 0.009347835556f, 0.009268003516f,
    0.009188630618f, 0.00910975039f, 0.009031393565f, 0.008953588083f,
    0.008876360953f, 0.008799735457f, 0.008723732084f, 0.008648370393f,
    0.008656143211f, 0.008662636392f, 0.008667841554f, 0.008671752177f,
    0.008674361743f, 0.008675667457f, 0.008675667457f, 0.008674361743f,
    0.008671752177f, 0.008667841554f, 0.008662636392f, 0.008656143211f,
    0.00879156962f, 0.008868678473f, 0.008946419694f, 0.00902477093f,
    0.009103707969f, 0.009183204733f, 0.009263231419f, 0.0093437545f,
    0.009424740449f, 0.009506150149f, 0.009587943554f, 0.009670076892f,
    0.009752500802f, 0.009835166857f, 0.009918019176f, 0.01000100002f,
    0.01008404791f, 0.01016709674f, 0.01025007758f, 0.01033291686f,
    0.01041553635f, 0.01049785595f, 0.01057978906f, 0.01066124719f,
    0.01074213628f, 0.01082235854f, 0.0109018134f, 0.0109803956f,
    0.01105799619f, 0.01113450434f, 0.01120980456f, 0.01128377859f,
    0.01135630626f, 0.01142726559f, 0.01149653178f, 0.01156397816f,
    0.01162947994f, 0.01169290766f, 0.0117541356f, 0.01181303803f,
    0.01186948828f, 0.01192336436f, 0.0119745452f, 0.01202291343f,
    0.01206835546f, 0.01211076323f, 0.01215003151f, 0.01218606345f,
    0.01221876871f, 0.0122480616f, 0.01227386575f, 0.01229611505f,
    0.01231474802f, 0.01232971624f, 0.01234097779f, 0.01234850287f,
    0.01235227007f, 0.01235227007f, 0.01234850287f, 0.01234097779f,
    0.01232971624f, 0.01231474802f, 0.01229611505f, 0.01227386575f,
    0.0122480616f, 0.01221876871f, 0.01218606345f, 0.01215003151f,
    0.01211076323f, 0.01206835546f, 0.01202291343f, 0.0119745452f,
    0.01192336436f, 0.01186948828f, 0.01181303803f, 0.0117541356f,
    0.01169290766f, 0.01162947994f, 0.01156397816f, 0.01149653178f,
    0.01142726559f, 0.01135630626f, 0.01128377859f, 0.01120980456f,
    0.01113450434f, 0.01105799619f, 0.0109803956f, 0.0109018134f,
    0.01082235854f, 0.01074213628f, 0.01066124719f, 0.01057978906f,
    0.01049785595f, 0.01041553635f, 0.01033291686f, 0.01025007758f,
    0.01016709674f, 0.01008404791f, 0.01000100002f, 0.009918019176f,
    0.009835166857f, 0.009752500802f, 0.009670076892f, 0.009587943554f,
    0.009506150149f, 0.009424740449f, 0.0093437545f, 0.009263231419f,
    0.009183204733f, 0.009103707969f, 0.00902477093f, 0.008946419694f,
    0.008868678473f, 0.00879156962f, 0.008715113625f, 0.008723732084f,
    0.008731043898f, 0.008737040684f, 0.008741713129f, 0.008745054714f,
    0.008747061715f, 0.008747731335f, 0.008747061715f, 0.008745054714f,
    0.008741713129f, 0.008737040684f, 0.008731043898f, 0.008723732084f,
    0.008859624155f, 0.008937839419f, 0.009016696364f, 0.009096172638f,
    0.009176243097f, 0.009256878868f, 0.009338049218f, 0.00941972062f,
    0.009501857683f, 0.009584420361f, 0.00966736488f, 0.009750646539f,
    0.009834215976f, 0.009918019176f, 0.01000200026f, 0.01008609962f,
    0.01017025113f, 0.01025438774f, 0.01033843681f, 0.0104223229f,
    0.01050596405f, 0.01058927551f, 0.01067216974f, 0.0107545536f,
    0.01083632838f, 0.01091739535f, 0.01099764649f, 0.01107697561f,
    0.01115526911f, 0.01123241056f, 0.01130828168f, 0.01138276048f,
    0.01145572308f, 0.01152704284f, 0.01159659028f, 0.0116642369f,
    0.0117298523f, 0.0117933061f, 0.01185446698f, 0.01191320643f,
    0.01196939778f, 0.01202291343f, 0.01207363233f, 0.01212143432f,
    0.01216620672f, 0.01220783778f, 0.0122462241f, 0.01228126884f,
    0.01231288072f, 0.01234097779f, 0.01236548461f, 0.01238633506f,
    0.01240347326f, 0.01241685264f, 0.01242643595f, 0.01243219618f,
    0.01243411843f, 0.01243219618f, 0.01242643595f, 0.01241685264f,
    0.01240347326f, 0.01238633506f, 0.01236548461f, 0.01234097779f,
    0.01231288072f, 0.01228126884f, 0.0122462241f, 0.01220783778f,
    0.01216620672f, 0.01212143432f, 0.01207363233f, 0.01202291343f,
    0.01196939778f, 0.01191320643f, 0.01185446698f, 0.0117933061f,
    0.0117298523f, 0.0116642369f, 0.01159659028f, 0.01152704284f,
    0.01145572308f, 0.01138276048f, 0.01130828168f, 0.01123241056f,
    0.01115526911f, 0.01107697561f, 0.01099764649f, 0.01091739535f,
    0.01083632838f, 0.0107545536f, 0.01067216974f, 0.01058927551f,
    0.01050596405f, 0.0104223229f, 0.01033843681f, 0.01025438774f,
    0.01017025113f, 0.01008609962f, 0.01000200026f, 0.009918019176f,
    0.009834215976f, 0.009750646539f, 0.00966736488f, 0.009584420361f,
    0.009501857683f, 0.00941972062f, 0.009338049218f, 0.009256878868f,
    0.009176243097f, 0.009096172638f, 0.009016696364f, 0.008937839419f,
    0.008859624155f, 0.008782071993f, 0.00879156962f, 0.008799735457f,
    0.008806557395f, 0.008812026121f, 0.008816135116f, 0.00881887693f,
    0.008820248768f, 0.008820248768f, 0.00881887693f, 0.008816135116f,
    0.008812026121f, 0.008806557395f, 0.008799735457f, 0.00879156962f,
    0.008927859366f, 0.009007181972f, 0.009087154642f, 0.009167755023f,
    0.009248957038f, 0.009330729023f, 0.009413041174f, 0.009495858103f,
    0.009579141624f, 0.00966285076f, 0.009746940807f, 0.009831363335f,
    0.009916068986f, 0.01000100002f, 0.01008609962f, 0.01017130353f,
    0.01025654469f, 0.01034175418f, 0.01042685378f, 0.01051176619f,
    0.01059640758f, 0.01068068855f, 0.01076451875f, 0.01084779948f,
    0.01093043014f, 0.01101230737f, 0.01109332126f, 0.01117335912f,
    0.01125230361f, 0.01133003552f, 0.01140643191f, 0.01148136612f,
    0.0115547115f, 0.01162633486f, 0.01169610675f, 0.01176389214f,
    0.0118295569f, 0.01189296879f, 0.0119539937f, 0.01201249938f,
    0.01206835546f, 0.01212143432f, 0.01217161212f, 0.01221876871f,
    0.01226278674f, 0.01230355818f, 0.01234097779f, 0.01237494871f,
    0.01240538247f, 0.01243219618f, 0.01245531905f, 0.01247468684f,
    0.01249024551f, 0.01250195317f, 0.01250977721f, 0.01251369435f,
    0.01251369435f, 0.01250977721f, 0.01250195317f, 0.01249024551f,
    0.01247468684f, 0.01245531905f, 0.01243219618f, 0.01240538247f,
    0.01237494871f, 0.01234097779f, 0.01230355818f, 0.01226278674f,
    0.01221876871f, 0.01217161212f, 0.01212143432f, 0.01206835546f,
    0.01201249938f, 0.0119539937f, 0.01189296879f, 0.0118295569f,
    0.01176389214f, 0.01169610675f, 0.01162633486f, 0.0115547115f,
    0.01148136612f, 0.01140643191f, 0.01133003552f, 0.01125230361f,
    0.01117335912f, 0.01109332126f, 0.01101230737f, 0.01093043014f,
    0.01084779948f, 0.01076451875f, 0.01068068855f, 0.01059640758f,
    0.01051176619f, 0.01042685378f, 0.01034175418f, 0.01025654469f,
    0.01017130353f, 0.01008609962f, 0.01000100002f, 0.009916068986f,
    0.009831363335f, 0.009746940807f, 0.00966285076f, 0.009579141624f,
    0.009495858103f, 0.009413041174f, 0.009330729023f, 0.009248957038f,
    0.009167755023f, 0.009087154642f, 0.009007181972f, 0.008927859366f,
    0.008849211037f, 0.008859624155f, 0.008868678473f, 0.008876360953f,
    0.008882662281f, 0.008887572214f, 0.008891084231f, 0.008893193677f,
    0.008893896826f, 0.008893193677f, 0.008891084231f, 0.008887572214f,
    0.008882662281f, 0.008876360953f, 0.008868678473f, 0.008859624155f,
    0.008996240795f, 0.00907666795f, 0.009157754481f, 0.009239477105f,
    0.009321806021f, 0.009404712357f, 0.009488161653f, 0.009572117589f,
    0.009656541049f, 0.009741389193f, 0.009826615453f, 0.00991217047f,
    0.009998000227f, 0.01008404791f, 0.01017025113f, 0.01025654469f,
    0.01034285966f, 0.01042912249f, 0.01051525306f, 0.01060117036f,
    0.01068678591f, 0.01077201031f, 0.01085674576f, 0.01094089262f,
    0.01102434658f, 0.01110699773f, 0.01118873432f, 0.01126943901f,
    0.01134899072f, 0.01142726559f, 0.01150413603f, 0.0115794735f,
    0.01165314391f, 0.01172501314f, 0.01179494616f, 0.01186280511f,
    0.01192845311f, 0.01199175231f, 0.01205256768f, 0.01211076323f,
    0.01216620672f, 0.01221876871f, 0.01226832252f, 0.01231474802f,
    0.01235792786f, 0.01239775307f, 0.01243411843f, 0.01246692892f,
    0.01249609515f, 0.01252153981f, 0.0125431912f, 0.01256099064f,
    0.01257488597f, 0.01258483995f, 0.0125908237f, 0.01259282045f,
    0.0125908237f, 0.01258483995f, 0.01257488597f, 0.01256099064f,
    0.0125431912f, 0.01252153981f, 0.01249609515f, 0.01246692892f,
    0.01243411843f, 0.01239775307f, 0.01235792786f, 0.01231474802f,
    0.01226832252f, 0.01221876871f, 0.01216620672f, 0.01211076323f,
    0.01205256768f, 0.01199175231f, 0.01192845311f, 0.01186280511f,
    0.01179494616f, 0.01172501314f, 0.01165314391f, 0.0115794735f,
    0.01150413603f, 0.01142726559f, 0.01134899072f, 0.01126943901f,
    0.01118873432f, 0.01110699773f, 0.01102434658f, 0.01094089262f,
    0.01085674576f, 0.01077201031f, 0.01068678591f, 0.01060117036f,
    0.01051525306f, 0.01042912249f, 0.01034285966f, 0.01025654469f,
    0.01017025113f, 0.01008404791f, 0.009998000227f, 0.00991217047f,
    0.009826615453f, 0.009741389193f, 0.009656541049f, 0.009572117589f,
    0.009488161653f, 0.009404712357f, 0.009321806021f, 0.009239477105f,
    0.009157754481f, 0.00907666795f, 0.008996240795f, 0.008916495368f,
    0.008927859366f, 0.008937839419f, 0.008946419694f, 0.008953588083f,
    0.008959336206f, 0.008963654749f, 0.008966536261f, 0.00896797888f,
    0.00896797888f, 0.008966536261f, 0.008963654749f, 0.008959336206f,
    0.008953588083f, 0.008946419694f, 0.008937839419f, 0.008927859366f,
    0.009064726532f, 0.009146256372f, 0.009228453971f, 0.009311294183f,
    0.009394746274f, 0.00947877951f, 0.009563359432f, 0.009648446925f,
    0.009734002873f, 0.009819980711f, 0.00990633294f, 0.009993007407f,
    0.01007994823f, 0.01016709674f, 0.01025438774f, 0.01034175418f,
    0.01042912249f, 0.01051641535f, 0.01060355362f, 0.01069044974f,
    0.01077701338f, 0.01086314954f, 0.0109487595f, 0.01103373803f,
    0.01111797616f, 0.01120136213f, 0.01128377859f, 0.01136510447f,
    0.01144521404f, 0.01152398065f, 0.01160127111f, 0.01167695317f,
    0.01175088901f, 0.01182294171f, 0.01189296879f, 0.0119608324f,
    0.01202639099f, 0.01208950393f, 0.01215003151f, 0.01220783778f,
    0.01226278674f, 0.01231474802f, 0.01236359403f, 0.01240920182f,
    0.01245145593f, 0.01249024551f, 0.01252546813f, 0.01255702879f,
    0.01258483995f, 0.01260882709f, 0.01262892038f, 0.01264506485f,
    0.01265721396f, 0.0126653323f, 0.01266939752f, 0.01266939752f,
    0.0126653323f, 0.01265721396f, 0.01264506485f, 0.01262892038f,
    0.01260882709f, 0.01258483995f, 0.01255702879f, 0.01252546813f,
    0.01249024551f, 0.01245145593f, 0.01240920182f, 0.01236359403f,
    0.01231474802f, 0.01226278674f, 0.01220783778f, 0.01215003151f,
    0.01208950393f, 0.01202639099f, 0.0119608324f, 0.01189296879f,
    0.01182294171f, 0.01175088901f, 0.01167695317f, 0.01160127111f,
    0.01152398065f, 0.01144521404f, 0.01136510447f, 0.01128377859f,
    0.01120136213f, 0.01111797616f, 0.01103373803f, 0.0109487595f,
    0.01086314954f, 0.01077701338f, 0.01069044974f, 0.01060355362f,
    0.01051641535f, 0.01042912249f, 0.01034175418f, 0.01025438774f,
    0.01016709674f, 0.01007994823f, 0.009993007407f, 0.00990633294f,
    0.009819980711f, 0.009734002873f, 0.009648446925f, 0.009563359432f,
    0.00947877951f, 0.009394746274f, 0.009311294183f, 0.009228453971f,
    0.009146256372f, 0.009064726532f, 0.008983888663f, 0.008996240795f,
    0.009007181972f, 0.009016696364f, 0.00902477093f, 0.009031393565f,
    0.009036554955f, 0.009040246718f, 0.009042463265f, 0.009043202735f,
    0.009042463265f, 0.009040246718f, 0.009036554955f, 0.009031393565f,
    0.00902477093f, 0.009016696364f, 0.009007181972f, 0.008996240795f,
    0.009133277461f, 0.009215905331f, 0.009299207479f, 0.009383158758f,
    0.009467727505f, 0.00955288019f, 0.009638582356f, 0.009724793024f,
    0.009811468422f, 0.009898564778f, 0.009986029007f, 0.01007380895f,
    0.01016184594f, 0.01025007758f, 0.01033843681f, 0.01042685378f,
    0.01051525306f, 0.01060355362f, 0.01069167163f, 0.0107795177f,
    0.01086699776f, 0.01095401309f, 0.01104046032f, 0.0111262314f,
    0.01121121366f, 0.01129528973f, 0.01137833856f, 0.01146023627f,
    0.01154085156f, 0.01162005402f, 0.01169770677f, 0.01177367195f,
    0.01184780896f, 0.01191997528f, 0.01199002843f, 0.01205782313f,
    0.01212321594f, 0.01218606345f, 0.0122462241f, 0.01230355818f,
    0.01235792786f, 0.01240920182f, 0.01245725155f, 0.01250195317f,
    0.0125431912f, 0.01258085575f, 0.01261484437f, 0.01264506485f,
    0.01267143246f, 0.01269387174f, 0.01271232124f, 0.01272672601f,
    0.01273704506f, 0.0127432486f, 0.01274531893f, 0.0127432486f,
    0.01273704506f, 0.01272672601f, 0.01271232124f, 0.01269387174f,
    0.01267143246f, 0.01264506485f, 0.01261484437f, 0.01258085575f,
    0.0125431912f, 0.01250195317f, 0.01245725155f, 0.01240920182f,
    0.01235792786f, 0.01230355818f, 0.0122462241f, 0.01218606345f,
    0.01212321594f, 0.01205782313f, 0.01199002843f, 0.01191997528f,
    0.01184780896f, 0.01177367195f, 0.01169770677f, 0.01162005402f,
    0.01154085156f, 0.01146023627f, 0.01137833856f, 0.01129528973f,
    0.01121121366f, 0.0111262314f, 0.01104046032f, 0.01095401309f,
    0.01086699776f, 0.0107795177f, 0.01069167163f, 0.01060355362f,
    0.01051525306f, 0.01042685378f, 0.01033843681f, 0.01025007758f,
    0.01016184594f, 0.01007380895f, 0.009986029007f, 0.009898564778f,
    0.009811468422f, 0.009724793024f, 0.009638582356f, 0.00955288019f,
    0.009467727505f, 0.009383158758f, 0.009299207479f, 0.009215905331f,
    0.009133277461f, 0.009051349014f, 0.009064726532f, 0.00907666795f,
    0.009087154642f, 0.009096172638f, 0.009103707969f, 0.00910975039f,
    0.009114289656f, 0.00911732018f, 0.009118835442f, 0.009118835442f,
    0.00911732018f, 0.009114289656f, 0.00910975039f, 0.009103707969f,
    0.009096172638f, 0.009087154642f, 0.00907666795f, 0.009064726532f,
    0.009201847948f, 0.009285567328f, 0.009369968437f, 0.009455023333f,
    0.009540699422f, 0.009626962245f, 0.009713775478f, 0.009801096283f,
    0.009888879955f, 0.009977078997f, 0.01006564032f, 0.01015450899f,
    0.01024362259f, 0.01033291686f, 0.0104223229f, 0.01051176619f,
    0.01060117036f, 0.01069044974f, 0.0107795177f, 0.01086828113f,
    0.01095664315f, 0.01104449946f, 0.01113174483f, 0.01121826563f,
    0.01130394638f, 0.01138866507f, 0.01147229597f, 0.0115547115f,
    0.01163577568f, 0.0117153544f, 0.0117933061f, 0.01186948828f,
    0.01194375753f, 0.01201596763f, 0.01208597142f, 0.0121536199f,
    0.01221876871f, 0.01228126884f, 0.01234097779f, 0.01239775307f,
    0.01245145593f, 0.01250195317f, 0.01254911628f, 0.01259282045f,
    0.01263295114f, 0.01266939752f, 0.01270206179f, 0.01273085084f,
    0.01275568269f, 0.01277648844f, 0.01279320568f, 0.01280578785f,
    0.01281419583f, 0.01281840634f, 0.01281840634f, 0.01281419583f,
    0.01280578785f, 0.01279320568f, 0.01277648844f, 0.01275568269f,
    0.01273085084f, 0.01270206179f, 0.01266939752f, 0.01263295114f,
    0.01259282045f, 0.01254911628f, 0.01250195317f, 0.01245145593f,
    0.01239775307f, 0.01234097779f, 0.01228126884f, 0.01221876871f,
    0.0121536199f, 0.01208597142f, 0.01201596763f, 0.01194375753f,
    0.01186948828f, 0.0117933061f, 0.0117153544f, 0.01163577568f,
    0.0115547115f, 0.01147229597f, 0.01138866507f, 0.01130394638f,
    0.01121826563f, 0.01113174483f, 0.01104449946f, 0.01095664315f,
    0.01086828113f, 0.0107795177f, 0.01069044974f, 0.01060117036f,
    0.01051176619f, 0.0104223229f, 0.01033291686f, 0.01024362259f,
    0.01015450899f, 0.01006564032f, 0.009977078997f, 0.009888879955f,
    0.009801096283f, 0.009713775478f, 0.009626962245f, 0.009540699422f,
    0.009455023333f, 0.009369968437f, 0.009285567328f, 0.009201847948f,
    0.009118835442f, 0.009133277461f, 0.009146256372f, 0.009157754481f,
    0.009167755023f, 0.009176243097f, 0.009183204733f, 0.009188630618f,
    0.009192512371f, 0.009194843471f, 0.009195621125f, 0.009194843471f,
    0.009192512371f, 0.009188630618f, 0.009183204733f, 0.009176243097f,
    0.009167755023f, 0.009157754481f, 0.009146256372f, 0.009133277461f,
    0.00927039329f, 0.009355195798f, 0.009440686554f, 0.009526834823f,
    0.009613607079f, 0.009700968862f, 0.009788879193f, 0.009877296165f,
    0.009966172278f, 0.01005545817f, 0.01014509797f, 0.01023503393f,
    0.01032520272f, 0.01041553635f, 0.01050596405f, 0.01059640758f,
    0.01068678591f, 0.01077701338f, 0.01086699776f, 0.01095664315f,
    0.01104584709f, 0.01113450434f, 0.01122250315f, 0.01130972803f,
    0.0113960579f, 0.01148136612f, 0.01156552508f, 0.01164839976f,
    0.0117298523f, 0.01180974208f, 0.01188792568f, 0.01196425594f,
    0.01203858573f, 0.01211076323f, 0.0121806385f, 0.0122480616f,
    0.01231288072f, 0.01237494871f, 0.01243411843f, 0.01249024551f,
    0.0125431912f, 0.01259282045f, 0.01263900381f, 0.0126816174f,
    0.01272054669f, 0.01275568269f, 0.0127869295f, 0.01281419583f,
    0.01283740439f, 0.01285648718f, 0.01287138835f, 0.01288206317f,
    0.01288848184f, 0.01289062295f, 0.01288848184f, 0.01288206317f,
    0.01287138835f, 0.01285648718f, 0.01283740439f, 0.01281419583f,
    0.0127869295f, 0.01275568269f, 0.01272054669f, 0.0126816174f,
    0.01263900381f, 0.01259282045f, 0.0125431912f, 0.01249024551f,
    0.01243411843f, 0.01237494871f, 0.01231288072f, 0.0122480616f,
    0.0121806385f, 0.01211076323f, 0.01203858573f, 0.01196425594f,
    0.01188792568f, 0.01180974208f, 0.0117298523f, 0.01164839976f,
    0.01156552508f, 0.01148136612f, 0.0113960579f, 0.01130972803f,
    0.01122250315f, 0.01113450434f, 0.01104584709f, 0.01095664315f,
    0.01086699776f, 0.01077701338f, 0.01068678591f, 0.01059640758f,
    0.01050596405f, 0.01041553635f, 0.01032520272f, 0.01023503393f,
    0.01014509797f, 0.01005545817f, 0.009966172278f, 0.009877296165f,
    0.009788879193f, 0.009700968862f, 0.009613607079f, 0.009526834823f,
    0.009440686554f, 0.009355195798f, 0.00927039329f, 0.009186304174f,
    0.009201847948f, 0.009215905331f, 0.009228453971f, 0.009239477105f,
    0.009248957038f, 0.009256878868f, 0.009263231419f, 0.009268003516f,
    0.00927118957f, 0.009272783995f, 0.009272783995f, 0.00927118957f,
    0.009268003516f, 0.009263231419f, 0.009256878868f, 0.009248957038f,
    0.009239477105f, 0.009228453971f, 0.009215905331f, 0.009201847948f,
    0.009338863194f, 0.009424740449f, 0.009511308745f, 0.00959853828f,
    0.009686394595f, 0.009774839506f, 0.009863832965f, 0.009953328408f,
    0.01004327927f, 0.01013363153f, 0.01022432931f, 0.01031531021f,
    0.01040650904f, 0.01049785595f, 0.01058927551f, 0.01068068855f,
    0.01077201031f, 0.01086314954f, 0.01095401309f, 0.01104449946f,
    0.01113450434f, 0.0112239169f, 0.01131262258f, 0.01140050031f,
    0.0114874253f, 0.0115732681f, 0.01165789459f, 0.011741166f,
    0.01182294171f, 0.0119030755f, 0.01198141929f, 0.01205782313f,
    0.01213213522f, 0.01220420003f, 0.01227386575f, 0.01234097779f,
    0.01240538247f, 0.01246692892f, 0.01252546813f, 0.01258085575f,
    0.01263295114f, 0.0126816174f, 0.01272672601f, 0.01276815403f,
    0.01280578785f, 0.01283952035f, 0.01286925655f, 0.0128949089f,
    0.01291640475f, 0.01293367799f, 0.01294667926f, 0.01295536757f,
    0.0129597187f, 0.0129597187f, 0.01295536757f, 0.01294667926f,
    0.01293367799f, 0.01291640475f, 0.0128949089f, 0.01286925655f,
    0.01283952035f, 0.01280578785f, 0.01276815403f, 0.01272672601f,
    0.0126816174f, 0.01263295114f, 0.01258085575f, 0.01252546813f,
    0.01246692892f, 0.01240538247f, 0.01234097779f, 0.01227386575f,
    0.01220420003f, 0.01213213522f, 0.01205782313f, 0.01198141929f,
    0.0119030755f, 0.01182294171f, 0.011741166f, 0.01165789459f,
    0.0115732681f, 0.0114874253f, 0.01140050031f, 0.01131262258f,
    0.0112239169f, 0.01113450434f, 0.01104449946f, 0.01095401309f,
    0.01086314954f, 0.01077201031f, 0.01068068855f, 0.01058927551f,
    0.01049785595f, 0.01040650904f, 0.01031531021f, 0.01022432931f,
    0.01013363153f, 0.01004327927f, 0.009953328408f, 0.009863832965f,
    0.009774839506f, 0.009686394595f, 0.00959853828f, 0.009511308745f,
    0.009424740449f, 0.009338863194f, 0.009253707714f, 0.00927039329f,
    0.009285567328f, 0.009299207479f, 0.009311294183f, 0.009321806021f,
    0.009330729023f, 0.009338049218f, 0.0093437545f, 0.009347835556f,
    0.009350287728f, 0.009351104498f, 0.009350287728f, 0.009347835556f,
    0.0093437545f, 0.009338049218f, 0.009330729023f, 0.009321806021f,
    0.009311294183f, 0.009299207479f, 0.009285567328f, 0.00927039329f,
    0.009407208301f, 0.009494146332f, 0.009581780061f, 0.009670076892f,
    0.009759000503f, 0.009848512709f, 0.009938570671f, 0.01002912689f,
    0.01012013014f, 0.01021152735f, 0.01030325703f, 0.01039525773f,
    0.0104874596f, 0.01057978906f, 0.01067216974f, 0.01076451875f,
    0.01085674576f, 0.0109487595f, 0.01104046032f, 0.01113174483f,
    0.01122250315f, 0.01131262258f, 0.01140198205f, 0.01149045862f,
    0.01157792099f, 0.0116642369f, 0.01174926758f, 0.01183286961f,
    0.01191489771f, 0.01199520286f, 0.01207363233f, 0.01215003151f,
    0.01222424489f, 0.01229611505f, 0.01236548461f, 0.01243219618f,
    0.01249609515f, 0.01255702879f, 0.01261484437f, 0.01266939752f,
    0.01272054669f, 0.01276815403f, 0.01281209197f, 0.01285223942f,
    0.01288848184f, 0.01292071585f, 0.01294884924f, 0.0129727982f,
    0.01299249288f, 0.01300787181f, 0.01301889122f, 0.01302551571f,
    0.01302772667f, 0.01302551571f, 0.01301889122f, 0.01300787181f,
    0.01299249288f, 0.0129727982f, 0.01294884924f, 0.01292071585f,
    0.01288848184f, 0.01285223942f, 0.01281209197f, 0.01276815403f,
    0.01272054669f, 0.01266939752f, 0.01261484437f, 0.01255702879f,
    0.01249609515f, 0.01243219618f, 0.01236548461f, 0.01229611505f,
    0.01222424489f, 0.01215003151f, 0.01207363233f, 0.01199520286f,
    0.01191489771f, 0.01183286961f, 0.01174926758f, 0.0116642369f,
    0.01157792099f, 0.01149045862f, 0.01140198205f, 0.01131262258f,
    0.01122250315f, 0.01113174483f, 0.01104046032f, 0.0109487595f,
    0.01085674576f, 0.01076451875f, 0.01067216974f, 0.01057978906f,
    0.0104874596f, 0.01039525773f, 0.01030325703f, 0.01021152735f,
    0.01012013014f, 0.01002912689f, 0.009938570671f, 0.009848512709f,
    0.009759000503f, 0.009670076892f, 0.009581780061f, 0.009494146332f,
    0.009407208301f, 0.009320996702f, 0.009338863194f, 0.009355195798f,
    0.009369968437f, 0.009383158758f, 0.009394746274f, 0.009404712357f,
    0.009413041174f, 0.00941972062f, 0.009424740449f, 0.009428090416f,
    0.009429766797f, 0.009429766797f, 0.009428090416f, 0.009424740449f,
    0.00941972062f, 0.009413041174f, 0.009404712357f, 0.009394746274f,
    0.009383158758f, 0.009369968437f, 0.009355195798f, 0.009338863194f,
    0.009475374594f, 0.009563359432f, 0.00965204183f, 0.009741389193f,
    0.009831363335f, 0.009921924211f, 0.01001302525f, 0.01010461897f,
    0.01019665226f, 0.0102890674f, 0.01038180385f, 0.01047479361f,
    0.01056796685f, 0.01066124719f, 0.0107545536f, 0.01084779948f,
    0.01094089262f, 0.01103373803f, 0.0111262314f, 0.01121826563f,
    0.01130972803f, 0.01140050031f, 0.01149045862f, 0.0115794735f,
    0.01166741177f, 0.0117541356f, 0.01183950249f, 0.01192336436f,
    0.01200557221f, 0.01208597142f, 0.01216440555f, 0.01224071812f,
    0.01231474802f, 0.01238633506f, 0.01245531905f, 0.01252153981f,
    0.01258483995f, 0.01264506485f, 0.01270206179f, 0.01275568269f,
    0.01280578785f, 0.01285223942f, 0.0128949089f, 0.01293367799f,
    0.01296843402f, 0.01299907733f, 0.01302551571f, 0.01304767188f,
    0.01306547876f, 0.01307888143f, 0.01308783889f, 0.01309232507f,
    0.01309232507f, 0.01308783889f, 0.01307888143f, 0.01306547876f,
    0.01304767188f, 0.01302551571f, 0.01299907733f, 0.01296843402f,
    0.01293367799f, 0.0128949089f, 0.01285223942f, 0.01280578785f,
    0.01275568269f, 0.01270206179f, 0.01264506485f, 0.01258483995f,
    0.01252153981f, 0.01245531905f, 0.01238633506f, 0.01231474802f,
    0.01224071812f, 0.01216440555f, 0.01208597142f, 0.01200557221f,
    0.01192336436f, 0.01183950249f, 0.0117541356f, 0.01166741177f,
    0.0115794735f, 0.01149045862f, 0.01140050031f, 0.01130972803f,
    0.01121826563f, 0.0111262314f, 0.01103373803f, 0.01094089262f,
    0.01084779948f, 0.0107545536f, 0.01066124719f, 0.01056796685f,
    0.01047479361f, 0.01038180385f, 0.0102890674f, 0.01019665226f,
    0.01010461897f, 0.01001302525f, 0.009921924211f, 0.009831363335f,
    0.009741389193f, 0.00965204183f, 0.009563359432f, 0.009475374594f,
    0.009388119914f, 0.009407208301f, 0.009424740449f, 0.009440686554f,
    0.009455023333f, 0.009467727505f, 0.00947877951f, 0.009488161653f,
    0.009495858103f, 0.009501857683f, 0.009506150149f, 0.00950872805f,
    0.00950958766f, 0.00950872805f, 0.009506150149f, 0.009501857683f,
    0.009495858103f, 0.009488161653f, 0.00947877951f, 0.009467727505f,
    0.009455023333f, 0.009440686554f, 0.009424740449f, 0.009407208301f,
    0.009543305263f, 0.009632320143f, 0.009722034447f, 0.009812413715f,
    0.0099034179f, 0.009995004162f, 0.01008712593f, 0.01017973199f,
    0.01027276739f, 0.01036617346f, 0.010459885f, 0.01055383217f,
    0.01064794231f, 0.01074213628f, 0.01083632838f, 0.01093043014f,
    0.01102434658f, 0.01111797616f, 0.01121121366f, 0.01130394638f,
    0.0113960579f, 0.0114874253f, 0.01157792099f, 0.01166741177f,
    0.01175575983f, 0.01184282266f, 0.01192845311f, 0.01201249938f,
    0.01209480781f, 0.01217522006f, 0.01225357689f, 0.01232971624f,
    0.01240347326f, 0.01247468684f, 0.0125431912f, 0.01260882709f,
    0.01267143246f, 0.01273085084f, 0.0127869295f, 0.01283952035f,
    0.01288848184f, 0.01293367799f, 0.01297498215f, 0.01301227603f,
    0.0130454516f, 0.01307440922f, 0.01309906319f, 0.01311933808f,
    0.01313517336f, 0.01314651966f, 0.01315334067f, 0.01315561775f,
    0.01315334067f, 0.01314651966f, 0.01313517336f, 0.01311933808f,
    0.01309906319f, 0.01307440922f, 0.0130454516f, 0.01301227603f,
    0.01297498215f, 0.01293367799f, 0.01288848184f, 0.01283952035f,
    0.0127869295f, 0.01273085084f, 0.01267143246f, 0.01260882709f,
    0.0125431912f, 0.01247468684f, 0.01240347326f, 0.01232971624f,
    0.01225357689f, 0.01217522006f, 0.01209480781f, 0.01201249938f,
    0.01192845311f, 0.01184282266f, 0.01175575983f, 0.01166741177f,
    0.01157792099f, 0.0114874253f, 0.0113960579f, 0.01130394638f,
    0.01121121366f, 0.01111797616f, 0.01102434658f, 0.01093043014f,
    0.01083632838f, 0.01074213628f, 0.01064794231f, 0.01055383217f,
    0.010459885f, 0.01036617346f, 0.01027276739f, 0.01017973199f,
    0.01008712593f, 0.009995004162f, 0.0099034179f, 0.009812413715f,
    0.009722034447f, 0.009632320143f, 0.009543305263f, 0.009455023333f,
    0.009475374594f, 0.009494146332f, 0.009511308745f, 0.009526834823f,
    0.009540699422f, 0.00955288019f, 0.009563359432f, 0.009572117589f,
    0.009579141624f, 0.009584420361f, 0.009587943554f, 0.009589706548f,
    0.009589706548f, 0.009587943554f, 0.009584420361f, 0.009579141624f,
    0.009572117589f, 0.009563359432f, 0.00955288019f, 0.009540699422f,
    0.009526834823f, 0.009511308745f, 0.009494146332f, 0.009475374594f,
    0.009610942565f, 0.009700968862f, 0.009791694582f, 0.009883082472f,
    0.009975093417f, 0.01006768085f, 0.01016079728f, 0.01025438774f,
    0.01034839638f, 0.01044276077f, 0.01053741388f, 0.01063228305f,
    0.01072729193f, 0.01082235854f, 0.01091739535f, 0.01101230737f,
    0.01110699773f, 0.01120136213f, 0.01129528973f, 0.01138866507f,
    0.01148136612f, 0.0115732681f, 0.0116642369f, 0.0117541356f,
    0.01184282266f, 0.01193015091f, 0.01201596763f, 0.01210011914f,
    0.0121824462f, 0.01226278674f, 0.01234097779f, 0.01241685264f,
    0.01249024551f, 0.01256099064f, 0.01262892038f, 0.01269387174f,
    0.01275568269f, 0.01281419583f, 0.01286925655f, 0.01292071585f,
    0.01296843402f, 0.01301227603f, 0.01305211708f, 0.01308783889f,
    0.01311933808f, 0.01314651966f, 0.01316929981f, 0.01318760961f,
    0.01320139226f, 0.0132106049f, 0.01321521774f, 0.01321521774f,
    0.0132106049f, 0.01320139226f, 0.01318760961f, 0.01316929981f,
    0.01314651966f, 0.01311933808f, 0.01308783889f, 0.01305211708f,
    0.01301227603f, 0.01296843402f, 0.01292071585f, 0.01286925655f,
    0.01281419583f, 0.01275568269f, 0.01269387174f, 0.01262892038f,
    0.01256099064f, 0.01249024551f, 0.01241685264f, 0.01234097779f,
    0.01226278674f, 0.0121824462f, 0.01210011914f, 0.01201596763f,
    0.01193015091f, 0.01184282266f, 0.0117541356f, 0.0116642369f,
    0.0115732681f, 0.01148136612f, 0.01138866507f, 0.01129528973f,
    0.01120136213f, 0.01110699773f, 0.01101230737f, 0.01091739535f,
    0.01082235854f, 0.01072729193f, 0.01063228305f, 0.01053741388f,
    0.01044276077f, 0.01034839638f, 0.01025438774f, 0.01016079728f,
    0.01006768085f, 0.009975093417f, 0.009883082472f, 0.009791694582f,
    0.009700968862f, 0.009610942565f, 0.009521651082f, 0.009543305263f,
    0.009563359432f, 0.009581780061f, 0.00959853828f, 0.009613607079f,
    0.009626962245f, 0.009638582356f, 0.009648446925f, 0.009656541049f,
    0.00966285076f, 0.00966736488f, 0.009670076892f, 0.009670981206f,
    0.009670076892f, 0.00966736488f, 0.00966285076f, 0.009656541049f,
    0.009648446925f, 0.009638582356f, 0.009626962245f, 0.009613607079f,
    0.00959853828f, 0.009581780061f, 0.009563359432f, 0.009543305263f,
    0.009678225033f, 0.009769240394f, 0.009860955179f, 0.009953328408f,
    0.01004632004f, 0.01013988163f, 0.01023396198f, 0.01032850612f,
    0.01042345539f, 0.01051874273f, 0.01061430015f, 0.01071005128f,
    0.0108059179f, 0.0109018134f, 0.01099764649f, 0.01109332126f,
    0.01118873432f, 0.01128377859f, 0.01137833856f, 0.01147229597f,
    0.01156552508f, 0.01165789459f, 0.01174926758f, 0.01183950249f,
    0.01192845311f, 0.01201596763f, 0.01210189145f, 0.01218606345f,
    0.01226832252f, 0.01234850287f, 0.01242643595f, 0.01250195317f,
    0.01257488597f, 0.01264506485f, 0.01271232124f, 0.01277648844f,
    0.01283740439f, 0.0128949089f, 0.01294884924f, 0.01299907733f,
    0.0130454516f, 0.01308783889f, 0.01312611811f, 0.01316017378f,
    0.01318990346f, 0.01321521774f, 0.01323603839f, 0.01325230021f,
    0.01326395292f, 0.01327095926f, 0.01327329688f, 0.01327095926f,
    0.01326395292f, 0.01325230021f, 0.01323603839f, 0.01321521774f,
    0.01318990346f, 0.01316017378f, 0.01312611811f, 0.01308783889f,
    0.0130454516f, 0.01299907733f, 0.01294884924f, 0.0128949089f,
    0.01283740439f, 0.01277648844f, 0.01271232124f, 0.01264506485f,
    0.01257488597f, 0.01250195317f, 0.01242643595f, 0.01234850287f,
    0.01226832252f, 0.01218606345f, 0.01210189145f, 0.01201596763f,
    0.01192845311f, 0.01183950249f, 0.01174926758f, 0.01165789459f,
    0.01156552508f, 0.01147229597f, 0.01137833856f, 0.01128377859f,
    0.01118873432f, 0.01109332126f, 0.01099764649f, 0.0109018134f,
    0.0108059179f, 0.01071005128f, 0.01061430015f, 0.01051874273f,
    0.01042345539f, 0.01032850612f, 0.01023396198f, 0.01013988163f,
    0.01004632004f, 0.009953328408f, 0.009860955179f, 0.009769240394f,
    0.009678225033f, 0.009587943554f, 0.009610942565f, 0.009632320143f,
    0.00965204183f, 0.009670076892f, 0.009686394595f, 0.009700968862f,
    0.009713775478f, 0.009724793024f, 0.009734002873f, 0.009741389193f,
    0.009746940807f, 0.009750646539f, 0.009752500802f, 0.009752500802f,
    0.009750646539f, 0.009746940807f, 0.009741389193f, 0.009734002873f,
    0.009724793024f, 0.009713775478f, 0.009700968862f, 0.009686394595f,
    0.009670076892f, 0.00965204183f, 0.009632320143f, 0.009610942565f,
    0.009745089337f, 0.00983707048f, 0.009929747321f, 0.01002307981f,
    0.01011702232f, 0.01021152735f, 0.01030653995f, 0.01040200423f,
    0.01049785595f, 0.01059402898f, 0.01069044974f, 0.01078704093f,
    0.01088371873f, 0.0109803956f, 0.01107697561f, 0.01117335912f,
    0.01126943901f, 0.01136510447f, 0.01146023627f, 0.0115547115f,
    0.01164839976f, 0.011741166f, 0.01183286961f, 0.01192336436f,
    0.01201249938f, 0.01210011914f, 0.01218606345f, 0.01227016933f,
    0.01235227007f, 0.01243219618f, 0.01250977721f, 0.01258483995f,
    0.01265721396f, 0.01272672601f, 0.01279320568f, 0.01285648718f,
    0.01291640475f, 0.0129727982f, 0.01302551571f, 0.01307440922f,
    0.01311933808f, 0.01316017378f, 0.01319679338f, 0.013229087f,
    0.01325695775f, 0.01328031812f, 0.01329909544f, 0.01331323106f,
    0.01332267933f, 0.01332741138f, 0.01332741138f, 0.01332267933f,
    0.01331323106f, 0.01329909544f, 0.01328031812f, 0.01325695775f,
    0.013229087f, 0.01319679338f, 0.01316017378f, 0.01311933808f,
    0.01307440922f, 0.01302551571f, 0.0129727982f, 0.01291640475f,
    0.01285648718f, 0.01279320568f, 0.01272672601f, 0.01265721396f,
    0.01258483995f, 0.01250977721f, 0.01243219618f, 0.01235227007f,
    0.01227016933f, 0.01218606345f, 0.01210011914f, 0.01201249938f,
    0.01192336436f, 0.01183286961f, 0.011741166f, 0.01164839976f,
    0.0115547115f, 0.01146023627f, 0.01136510447f, 0.01126943901f,
    0.01117335912f, 0.01107697561f, 0.0109803956f, 0.01088371873f,
    0.01078704093f, 0.01069044974f, 0.01059402898f, 0.01049785595f,
    0.01040200423f, 0.01030653995f, 0.01021152735f, 0.01011702232f,
    0.01002307981f, 0.009929747321f, 0.00983707048f, 0.009745089337f,
    0.009653841145f, 0.009678225033f, 0.009700968862f, 0.009722034447f,
    0.009741389193f, 0.009759000503f, 0.009774839506f, 0.009788879193f,
    0.009801096283f, 0.009811468422f, 0.009819980711f, 0.009826615453f,
    0.009831363335f, 0.009834215976f, 0.009835166857f, 0.009834215976f,
    0.009831363335f, 0.009826615453f, 0.009819980711f, 0.009811468422f,
    0.009801096283f, 0.009788879193f, 0.009774839506f, 0.009759000503f,
    0.009741389193f, 0.009722034447f, 0.009700968862f, 0.009678225033f,
    0.009811468422f, 0.00990438927f, 0.009998000227f, 0.01009226125f,
    0.0101871239f, 0.01028253883f, 0.01037844829f, 0.01047479361f,
    0.0105715096f, 0.01066852547f, 0.01076576579f, 0.01086314954f,
    0.01096059103f, 0.01105799619f, 0.01115526911f, 0.01125230361f,
    0.01134899072f, 0.01144521404f, 0.01154085156f, 0.01163577568f,
    0.0117298523f, 0.01182294171f, 0.01191489771f, 0.01200557221f,
    0.01209480781f, 0.0121824462f, 0.01226832252f, 0.01235227007f,
    0.01243411843f, 0.01251369435f, 0.0125908237f, 0.0126653323f,
    0.01273704506f, 0.01280578785f, 0.01287138835f, 0.01293367799f,
    0.01299249288f, 0.01304767188f, 0.01309906319f, 0.01314651966f,
    0.01318990346f, 0.013229087f, 0.01326395292f, 0.0132943932f,
    0.01332031563f, 0.01334163733f, 0.01335829217f, 0.01337022707f,
    0.01337740291f, 0.01337979734f, 0.01337740291f, 0.01337022707f,
    0.01335829217f, 0.01334163733f, 0.01332031563f, 0.0132943932f,
    0.01326395292f, 0.013229087f, 0.01318990346f, 0.01314651966f,
    0.01309906319f, 0.01304767188f, 0.01299249288f, 0.01293367799f,
    0.01287138835f, 0.01280578785f, 0.01273704506f, 0.0126653323f,
    0.0125908237f, 0.01251369435f, 0.01243411843f, 0.01235227007f,
    0.01226832252f, 0.0121824462f, 0.01209480781f, 0.01200557221f,
    0.01191489771f, 0.01182294171f, 0.0117298523f, 0.01163577568f,
    0.01154085156f, 0.01144521404f, 0.01134899072f, 0.01125230361f,
    0.01115526911f, 0.01105799619f, 0.01096059103f, 0.01086314954f,
    0.01076576579f, 0.01066852547f, 0.0105715096f, 0.01047479361f,
    0.01037844829f, 0.01028253883f, 0.0101871239f, 0.01009226125f,
    0.009998000227f, 0.00990438927f, 0.009811468422f, 0.009719279595f,
    0.009745089337f, 0.009769240394f, 0.009791694582f, 0.009812413715f,
    0.009831363335f, 0.009848512709f, 0.009863832965f, 0.009877296165f,
    0.009888879955f, 0.009898564778f, 0.00990633294f, 0.00991217047f,
    0.009916068986f, 0.009918019176f, 0.009918019176f, 0.009916068986f,
    0.00991217047f, 0.00990633294f, 0.009898564778f, 0.009888879955f,
    0.009877296165f, 0.009863832965f, 0.009848512709f, 0.009831363335f,
    0.009812413715f, 0.009791694582f, 0.009769240394f, 0.009745089337f,
    0.009877296165f, 0.009971125983f, 0.01006564032f, 0.01016079728f,
    0.01025654469f, 0.01035283227f, 0.01044960041f, 0.01054678671f,
    0.01064432319f, 0.01074213628f, 0.01084014867f, 0.01093827467f,
    0.0110364249f, 0.01113450434f, 0.01123241056f, 0.01133003552f,
    0.01142726559f, 0.01152398065f, 0.01162005402f, 0.0117153544f,
    0.01180974208f, 0.0119030755f, 0.01199520286f, 0.01208597142f,
    0.01217522006f, 0.01226278674f, 0.01234850287f, 0.01243219618f,
    0.01251369435f, 0.01259282045f, 0.01266939752f, 0.0127432486f,
    0.01281419583f, 0.01288206317f, 0.01294667926f, 0.01300787181f,
    0.01306547876f, 0.01311933808f, 0.01316929981f, 0.01321521774f,
    0.01325695775f, 0.0132943932f, 0.01332741138f, 0.01335590892f,
    0.01337979734f, 0.01339900028f, 0.0134134572f, 0.01342312153f,
    0.01342796069f, 0.01342796069f, 0.01342312153f, 0.0134134572f,
    0.01339900028f, 0.01337979734f, 0.01335590892f, 0.01332741138f,
    0.0132943932f, 0.01325695775f, 0.01321521774f, 0.01316929981f,
    0.01311933808f, 0.01306547876f, 0.01300787181f, 0.01294667926f,
    0.01288206317f, 0.01281419583f, 0.0127432486f, 0.01266939752f,
    0.01259282045f, 0.01251369435f, 0.01243219618f, 0.01234850287f,
    0.01226278674f, 0.01217522006f, 0.01208597142f, 0.01199520286f,
    0.0119030755f, 0.01180974208f, 0.0117153544f, 0.01162005402f,
    0.01152398065f, 0.01142726559f, 0.01133003552f, 0.01123241056f,
    0.01113450434f, 0.0110364249f, 0.01093827467f, 0.01084014867f,
    0.01074213628f, 0.01064432319f, 0.01054678671f, 0.01044960041f,
    0.01035283227f, 0.01025654469f, 0.01016079728f, 0.01006564032f,
    0.009971125983f, 0.009877296165f, 0.009784192778f, 0.009811468422f,
    0.00983707048f, 0.009860955179f, 0.009883082472f, 0.0099034179f,
    0.009921924211f, 0.009938570671f, 0.009953328408f, 0.009966172278f,
    0.009977078997f, 0.009986029007f, 0.009993007407f, 0.009998000227f,
    0.01000100002f, 0.01000200026f, 0.01000100002f, 0.009998000227f,
    0.009993007407f, 0.009986029007f, 0.009977078997f, 0.009966172278f,
    0.009953328408f, 0.009938570671f, 0.009921924211f, 0.0099034179f,
    0.009883082472f, 0.009860955179f, 0.00983707048f, 0.009811468422f,
    0.009942499921f, 0.01003720704f, 0.01013259124f, 0.01022860687f,
    0.01032520272f, 0.0104223229f, 0.01051990688f, 0.01061788946f,
    0.01071619987f, 0.01081476174f, 0.01091349311f, 0.01101230737f,
    0.01111111138f, 0.01120980456f, 0.01130828168f, 0.01140643191f,
    0.01150413603f, 0.01160127111f, 0.01169770677f, 0.0117933061f,
    0.01188792568f, 0.01198141929f, 0.01207363233f, 0.01216440555f,
    0.01225357689f, 0.01234097779f, 0.01242643595f, 0.01250977721f,
    0.0125908237f, 0.01266939752f, 0.01274531893f, 0.01281840634f,
    0.01288848184f, 0.01295536757f, 0.01301889122f, 0.01307888143f,
    0.01313517336f, 0.01318760961f, 0.01323603839f, 0.01328031812f,
    0.01332031563f, 0.01335590892f, 0.01338698901f, 0.0134134572f,
    0.01343523059f, 0.0134522384f, 0.01346442662f, 0.01347175613f,
    0.01347420178f, 0.01347175613f, 0.01346442662f, 0.0134522384f,
    0.01343523059f, 0.0134134572f, 0.01338698901f, 0.01335590892f,
    0.01332031563f, 0.01328031812f, 0.01323603839f, 0.01318760961f,
    0.01313517336f, 0.01307888143f, 0.01301889122f, 0.01295536757f,
    0.01288848184f, 0.01281840634f, 0.01274531893f, 0.01266939752f,
    0.0125908237f, 0.01250977721f, 0.01242643595f, 0.01234097779f,
    0.01225357689f, 0.01216440555f, 0.01207363233f, 0.01198141929f,
    0.01188792568f, 0.0117933061f, 0.01169770677f, 0.01160127111f,
    0.01150413603f, 0.01140643191f, 0.01130828168f, 0.01120980456f,
    0.01111111138f, 0.01101230737f, 0.01091349311f, 0.01081476174f,
    0.01071619987f, 0.01061788946f, 0.01051990688f, 0.0104223229f,
    0.01032520272f, 0.01022860687f, 0.01013259124f, 0.01003720704f,
    0.009942499921f, 0.009848512709f, 0.009877296165f, 0.00990438927f,
    0.009929747321f, 0.009953328408f, 0.009975093417f, 0.009995004162f,
    0.01001302525f, 0.01002912689f, 0.01004327927f, 0.01005545817f,
    0.01006564032f, 0.01007380895f, 0.01007994823f, 0.01008404791f,
    0.01008609962f, 0.01008609962f, 0.01008404791f, 0.01007994823f,
    0.01007380895f, 0.01006564032f, 0.01005545817f, 0.01004327927f,
    0.01002912689f, 0.01001302525f, 0.009995004162f, 0.009975093417f,
    0.009953328408f, 0.009929747321f, 0.00990438927f, 0.009877296165f,
    0.01000700705f, 0.01010255609f, 0.01019877382f, 0.01029560994f,
    0.01039301138f, 0.01049092133f, 0.01058927551f, 0.01068800688f,
    0.01078704093f, 0.01088629849f, 0.01098569483f, 0.01108513959f,
    0.01118453499f, 0.01128377859f, 0.01138276048f, 0.01148136612f,
    0.0115794735f, 0.01167695317f, 0.01177367195f, 0.01186948828f,
    0.01196425594f, 0.01205782313f, 0.01215003151f, 0.01224071812f,
    0.01232971624f, 0.01241685264f, 0.01250195317f, 0.01258483995f,
    0.0126653323f, 0.0127432486f, 0.01281840634f, 0.01289062295f,
    0.0129597187f, 0.01302551571f, 0.01308783889f, 0.01314651966f,
    0.01320139226f, 0.01325230021f, 0.01329909544f, 0.01334163733f,
    0.01337979734f, 0.0134134572f, 0.01344251167f, 0.01346686855f,
    0.01348644961f, 0.01350119151f, 0.01351104677f, 0.01351598185f,
    0.01351598185f, 0.01351104677f, 0.01350119151f, 0.01348644961f,
    0.01346686855f, 0.01344251167f, 0.0134134572f, 0.01337979734f,
    0.01334163733f, 0.01329909544f, 0.01325230021f, 0.01320139226f,
    0.01314651966f, 0.01308783889f, 0.01302551571f, 0.0129597187f,
    0.01289062295f, 0.01281840634f, 0.0127432486f, 0.0126653323f,
    0.01258483995f, 0.01250195317f, 0.01241685264f, 0.01232971624f,
    0.01224071812f, 0.01215003151f, 0.01205782313f, 0.01196425594f,
    0.01186948828f, 0.01177367195f, 0.01167695317f, 0.0115794735f,
    0.01148136612f, 0.01138276048f, 0.01128377859f, 0.01118453499f,
    0.01108513959f, 0.01098569483f, 0.01088629849f, 0.01078704093f,
    0.01068800688f, 0.01058927551f, 0.01049092133f, 0.01039301138f,
    0.01029560994f, 0.01019877382f, 0.01010255609f, 0.01000700705f,
    0.00991217047f, 0.009942499921f, 0.009971125983f, 0.009998000227f,
    0.01002307981f, 0.01004632004f, 0.01006768085f, 0.01008712593f,
    0.01010461897f, 0.01012013014f, 0.01013363153f, 0.01014509797f,
    0.01015450899f, 0.01016184594f, 0.01016709674f, 0.01017025113f,
    0.01017130353f, 0.01017025113f, 0.01016709674f, 0.01016184594f,
    0.01015450899f, 0.01014509797f, 0.01013363153f, 0.01012013014f,
    0.01010461897f, 0.01008712593f, 0.01006768085f, 0.01004632004f,
    0.01002307981f, 0.009998000227f, 0.009971125983f, 0.009942499921f,
    0.01007074397f, 0.01016709674f, 0.01026410609f, 0.01036172081f,
    0.010459885f, 0.01055853814f, 0.0106576141f, 0.0107570421f,
    0.01085674576f, 0.01095664315f, 0.01105664484f, 0.01115665678f,
    0.01125658024f, 0.01135630626f, 0.01145572308f, 0.0115547115f,
    0.01165314391f, 0.01175088901f, 0.01184780896f, 0.01194375753f,
    0.01203858573f, 0.01213213522f, 0.01222424489f, 0.01231474802f,
    0.01240347326f, 0.01249024551f, 0.01257488597f, 0.01265721396f,
    0.01273704506f, 0.01281419583f, 0.01288848184f, 0.0129597187f,
    0.01302772667f, 0.01309232507f, 0.01315334067f, 0.0132106049f,
    0.01326395292f, 0.01331323106f, 0.01335829217f, 0.01339900028f,
    0.01343523059f, 0.01346686855f, 0.01349381451f, 0.01351598185f,
    0.01353329886f, 0.01354570966f, 0.01355317142f, 0.01355566178f,
    0.01355317142f, 0.01354570966f, 0.01353329886f, 0.01351598185f,
    0.01349381451f, 0.01346686855f, 0.01343523059f, 0.01339900028f,
    0.01335829217f, 0.01331323106f, 0.01326395292f, 0.0132106049f,
    0.01315334067f, 0.01309232507f, 0.01302772667f, 0.0129597187f,
    0.01288848184f, 0.01281419583f, 0.01273704506f, 0.01265721396f,
    0.01257488597f, 0.01249024551f, 0.01240347326f, 0.01231474802f,
    0.01222424489f, 0.01213213522f, 0.01203858573f, 0.01194375753f,
    0.01184780896f, 0.01175088901f, 0.01165314391f, 0.0115547115f,
    0.01145572308f, 0.01135630626f, 0.01125658024f, 0.01115665678f,
    0.01105664484f, 0.01095664315f, 0.01085674576f, 0.0107570421f,
    0.0106576141f, 0.01055853814f, 0.010459885f, 0.01036172081f,
    0.01026410609f, 0.01016709674f, 0.01007074397f, 0.009975093417f,
    0.01000700705f, 0.01003720704f, 0.01006564032f, 0.01009226125f,
    0.01011702232f, 0.01013988163f, 0.01016079728f, 0.01017973199f,
    0.01019665226f, 0.01021152735f, 0.01022432931f, 0.01023503393f,
    0.01024362259f, 0.01025007758f, 0.01025438774f, 0.01025654469f,
    0.01025654469f, 0.01025438774f, 0.01025007758f, 0.01024362259f,
    0.01023503393f, 0.01022432931f, 0.01021152735f, 0.01019665226f,
    0.01017973199f, 0.01016079728f, 0.01013988163f, 0.01011702232f,
    0.01009226125f, 0.01006564032f, 0.01003720704f, 0.01000700705f,
    0.01013363153f, 0.01023074798f, 0.01032850612f, 0.01042685378f,
    0.0105257323f, 0.01062507927f, 0.01072482392f, 0.01082489453f,
    0.01092521101f, 0.01102568675f, 0.0111262314f, 0.01122674625f,
    0.01132712793f, 0.01142726559f, 0.01152704284f, 0.01162633486f,
    0.01172501314f, 0.01182294171f, 0.01191997528f, 0.01201596763f,
    0.01211076323f, 0.01220420003f, 0.01229611505f, 0.01238633506f,
    0.01247468684f, 0.01256099064f, 0.01264506485f, 0.01272672601f,
    0.01280578785f, 0.01288206317f, 0.01295536757f, 0.01302551571f,
    0.01309232507f, 0.01315561775f, 0.01321521774f, 0.01327095926f,
    0.01332267933f, 0.01337022707f, 0.0134134572f, 0.0134522384f,
    0.01348644961f, 0.01351598185f, 0.01354074106f, 0.01356064621f,
    0.01357563306f, 0.01358565222f, 0.01359067019f, 0.01359067019f,
    0.01358565222f, 0.01357563306f, 0.01356064621f, 0.01354074106f,
    0.01351598185f, 0.01348644961f, 0.0134522384f, 0.0134134572f,
    0.01337022707f, 0.01332267933f, 0.01327095926f, 0.01321521774f,
    0.01315561775f, 0.01309232507f, 0.01302551571f, 0.01295536757f,
    0.01288206317f, 0.01280578785f, 0.01272672601f, 0.01264506485f,
    0.01256099064f, 0.01247468684f, 0.01238633506f, 0.01229611505f,
    0.01220420003f, 0.01211076323f, 0.01201596763f, 0.01191997528f,
    0.01182294171f, 0.01172501314f, 0.01162633486f, 0.01152704284f,
    0.01142726559f, 0.01132712793f, 0.01122674625f, 0.0111262314f,
    0.01102568675f, 0.01092521101f, 0.01082489453f, 0.01072482392f,
    0.01062507927f, 0.0105257323f, 0.01042685378f, 0.01032850612f,
    0.01023074798f, 0.01013363153f, 0.01003720704f, 0.01007074397f,
    0.01010255609f, 0.01013259124f, 0.01016079728f, 0.0101871239f,
    0.01021152735f, 0.01023396198f, 0.01025438774f, 0.01027276739f,
    0.0102890674f, 0.01030325703f, 0.01031531021f, 0.01032520272f,
    0.01033291686f, 0.01033843681f, 0.01034175418f, 0.01034285966f,
    0.01034175418f, 0.01033843681f, 0.01033291686f, 0.01032520272f,
    0.01031531021f, 0.01030325703f, 0.0102890674f, 0.01027276739f,
    0.01025438774f, 0.01023396198f, 0.01021152735f, 0.0101871239f,
    0.01016079728f, 0.01013259124f, 0.01010255609f, 0.01007074397f,
    0.01019559242f, 0.01029342785f, 0.01039188914f, 0.01049092133f,
    0.01059046388f, 0.01069044974f, 0.01079080813f, 0.01089146268f,
    0.01099232957f, 0.01109332126f, 0.01119434182f, 0.01129528973f,
    0.0113960579f, 0.01149653178f, 0.01159659028f, 0.01169610675f,
    0.01179494616f, 0.01189296879f, 0.01199002843f, 0.01208597142f,
    0.0121806385f, 0.01227386575f, 0.01236548461f, 0.01245531905f,
    0.0125431912f, 0.01262892038f, 0.01271232124f, 0.01279320568f,
    0.01287138835f, 0.01294667926f, 0.01301889122f, 0.01308783889f,
    0.01315334067f, 0.01321521774f, 0.01327329688f, 0.01332741138f,
    0.01337740291f, 0.01342312153f, 0.01346442662f, 0.01350119151f,
    0.01353329886f, 0.01356064621f, 0.01358314604f, 0.01360072289f,
    0.01361331902f, 0.0136208944f, 0.01362342201f, 0.0136208944f,
    0.01361331902f, 0.01360072289f, 0.01358314604f, 0.01356064621f,
    0.01353329886f, 0.01350119151f, 0.01346442662f, 0.01342312153f,
    0.01337740291f, 0.01332741138f, 0.01327329688f, 0.01321521774f,
    0.01315334067f, 0.01308783889f, 0.01301889122f, 0.01294667926f,
    0.01287138835f, 0.01279320568f, 0.01271232124f, 0.01262892038f,
    0.0125431912f, 0.01245531905f, 0.01236548461f, 0.01227386575f,
    0.0121806385f, 0.01208597142f, 0.01199002843f, 0.01189296879f,
    0.01179494616f, 0.01169610675f, 0.01159659028f, 0.01149653178f,
    0.0113960579f, 0.01129528973f, 0.01119434182f, 0.01109332126f,
    0.01099232957f, 0.01089146268f, 0.01079080813f, 0.01069044974f,
    0.01059046388f, 0.01049092133f, 0.01039188914f, 0.01029342785f,
    0.01019559242f, 0.01009843498f, 0.01013363153f, 0.01016709674f,
    0.01019877382f, 0.01022860687f, 0.01025654469f, 0.01028253883f,
    0.01030653995f, 0.01032850612f, 0.01034839638f, 0.01036617346f,
    0.01038180385f, 0.01039525773f, 0.01040650904f, 0.01041553635f,
    0.0104223229f, 0.01042685378f, 0.01042912249f, 0.01042912249f,
    0.01042685378f, 0.0104223229f, 0.01041553635f, 0.01040650904f,
    0.01039525773f, 0.01038180385f, 0.01036617346f, 0.01034839638f,
    0.01032850612f, 0.01030653995f, 0.01028253883f, 0.01025654469f,
    0.01022860687f, 0.01019877382f, 0.01016709674f, 0.01013363153f,
    0.01025654469f, 0.01035505254f, 0.01045416761f, 0.01055383217f,
    0.0106539838f, 0.0107545536f, 0.01085546613f, 0.01095664315f,
    0.01105799619f, 0.01115943585f, 0.01126086153f, 0.01136216894f,
    0.01146324724f, 0.01156397816f, 0.0116642369f, 0.01176389214f,
    0.01186280511f, 0.0119608324f, 0.01205782313f, 0.0121536199f,
    0.0122480616f, 0.01234097779f, 0.01243219618f, 0.01252153981f,
    0.01260882709f, 0.01269387174f, 0.01277648844f, 0.01285648718f,
    0.01293367799f, 0.01300787181f, 0.01307888143f, 0.01314651966f,
    0.0132106049f, 0.01327095926f, 0.01332741138f, 0.01337979734f,
    0.01342796069f, 0.01347175613f, 0.01351104677f, 0.01354570966f,
    0.01357563306f, 0.01360072289f, 0.0136208944f, 0.01363608148f,
    0.01364623569f, 0.01365132071f, 0.01365132071f, 0.01364623569f,
    0.01363608148f, 0.0136208944f, 0.01360072289f, 0.01357563306f,
    0.01354570966f, 0.01351104677f, 0.01347175613f, 0.01342796069f,
    0.01337979734f, 0.01332741138f, 0.01327095926f, 0.0132106049f,
    0.01314651966f, 0.01307888143f, 0.01300787181f, 0.01293367799f,
    0.01285648718f, 0.01277648844f, 0.01269387174f, 0.01260882709f,
    0.01252153981f, 0.01243219618f, 0.01234097779f, 0.0122480616f,
    0.0121536199f, 0.01205782313f, 0.0119608324f, 0.01186280511f,
    0.01176389214f, 0.0116642369f, 0.01156397816f, 0.01146324724f,
    0.01136216894f, 0.01126086153f, 0.01115943585f, 0.01105799619f,
    0.01095664315f, 0.01085546613f, 0.0107545536f, 0.0106539838f,
    0.01055383217f, 0.01045416761f, 0.01035505254f, 0.01025654469f,
    0.01015869901f, 0.01019559242f, 0.01023074798f, 0.01026410609f,
    0.01029560994f, 0.01032520272f, 0.01035283227f, 0.01037844829f,
    0.01040200423f, 0.01042345539f, 0.01044276077f, 0.010459885f,
    0.01047479361f, 0.0104874596f, 0.01049785595f, 0.01050596405f,
    0.01051176619f, 0.01051525306f, 0.01051641535f, 0.01051525306f,
    0.01051176619f, 0.01050596405f, 0.01049785595f, 0.0104874596f,
    0.01047479361f, 0.010459885f, 0.01044276077f, 0.01042345539f,
    0.01040200423f, 0.01037844829f, 0.01035283227f, 0.01032520272f,
    0.01029560994f, 0.01026410609f, 0.01023074798f, 0.01019559242f,
    0.01031640731f, 0.01041553635f, 0.01051525306f, 0.01061549596f,
    0.01071619987f, 0.01081729215f, 0.01091869641f, 0.01102032885f,
    0.01112210099f, 0.0112239169f, 0.01132567506f, 0.01142726559f,
    0.01152857486f, 0.01162947994f, 0.0117298523f, 0.0118295569f,
    0.01192845311f, 0.01202639099f, 0.01212321594f, 0.01221876871f,
    0.01231288072f, 0.01240538247f, 0.01249609515f, 0.01258483995f,
    0.01267143246f, 0.01275568269f, 0.01283740439f, 0.01291640475f,
    0.01299249288f, 0.01306547876f, 0.01313517336f, 0.01320139226f,
    0.01326395292f, 0.01332267933f, 0.01337740291f, 0.01342796069f,
    0.01347420178f, 0.01351598185f, 0.01355317142f, 0.01358565222f,
    0.01361331902f, 0.01363608148f, 0.01365386508f, 0.01366661023f,
    0.01367427502f, 0.01367683243f, 0.01367427502f, 0.01366661023f,
    0.01365386508f, 0.01363608148f, 0.01361331902f, 0.01358565222f,
    0.01355317142f, 0.01351598185f, 0.01347420178f, 0.01342796069f,
    0.01337740291f, 0.01332267933f, 0.01326395292f, 0.01320139226f,
    0.01313517336f, 0.01306547876f, 0.01299249288f, 0.01291640475f,
    0.01283740439f, 0.01275568269f, 0.01267143246f, 0.01258483995f,
    0.01249609515f, 0.01240538247f, 0.01231288072f, 0.01221876871f,
    0.01212321594f, 0.01202639099f, 0.01192845311f, 0.0118295569f,
    0.0117298523f, 0.01162947994f, 0.01152857486f, 0.01142726559f,
    0.01132567506f, 0.0112239169f, 0.01112210099f, 0.01102032885f,
    0.01091869641f, 0.01081729215f, 0.01071619987f, 0.01061549596f,
    0.01051525306f, 0.01041553635f, 0.01031640731f, 0.01021792181f,
    0.01025654469f, 0.01029342785f, 0.01032850612f, 0.01036172081f,
    0.01039301138f, 0.0104223229f, 0.01044960041f, 0.01047479361f,
    0.01049785595f, 0.01051874273f, 0.01053741388f, 0.01055383217f,
    0.01056796685f, 0.01057978906f, 0.01058927551f, 0.01059640758f,
    0.01060117036f, 0.01060355362f, 0.01060355362f, 0.01060117036f,
    0.01059640758f, 0.01058927551f, 0.01057978906f, 0.01056796685f,
    0.01055383217f, 0.01053741388f, 0.01051874273f, 0.01049785595f,
    0.01047479361f, 0.01044960041f, 0.0104223229f, 0.01039301138f,
    0.01036172081f, 0.01032850612f, 0.01029342785f, 0.01025654469f,
    0.01037509646f, 0.01047479361f, 0.01057505608f, 0.01067581866f,
    0.01077701338f, 0.01087856572f, 0.0109803956f, 0.0110824164f,
    0.01118453499f, 0.01128665265f, 0.01138866507f, 0.01149045862f,
    0.01159191411f, 0.01169290766f, 0.0117933061f, 0.01189296879f,
    0.01199175231f, 0.01208950393f, 0.01218606345f, 0.01228126884f,
    0.01237494871f, 0.01246692892f, 0.01255702879f, 0.01264506485f,
    0.01273085084f, 0.01281419583f, 0.0128949089f, 0.0129727982f,
    0.01304767188f, 0.01311933808f, 0.01318760961f, 0.01325230021f,
    0.01331323106f, 0.01337022707f, 0.01342312153f, 0.01347175613f,
    0.01351598185f, 0.01355566178f, 0.01359067019f, 0.0136208944f,
    0.01364623569f, 0.01366661023f, 0.01368195191f, 0.01369220857f,
    0.01369734481f, 0.01369734481f, 0.01369220857f, 0.01368195191f,
    0.01366661023f, 0.01364623569f, 0.0136208944f, 0.01359067019f,
    0.01355566178f, 0.01351598185f, 0.01347175613f, 0.01342312153f,
    0.01337022707f, 0.01331323106f, 0.01325230021f, 0.01318760961f,
    0.01311933808f, 0.01304767188f, 0.0129727982f, 0.0128949089f,
    0.01281419583f, 0.01273085084f, 0.01264506485f, 0.01255702879f,
    0.01246692892f, 0.01237494871f, 0.01228126884f, 0.01218606345f,
    0.01208950393f, 0.01199175231f, 0.01189296879f, 0.0117933061f,
    0.01169290766f, 0.01159191411f, 0.01149045862f, 0.01138866507f,
    0.01128665265f, 0.01118453499f, 0.0110824164f, 0.0109803956f,
    0.01087856572f, 0.01077701338f, 0.01067581866f, 0.01057505608f,
    0.01047479361f, 0.01037509646f, 0.01027602144f, 0.01031640731f,
    0.01035505254f, 0.01039188914f, 0.01042685378f, 0.010459885f,
    0.01049092133f, 0.01051990688f, 0.01054678671f, 0.0105715096f,
    0.01059402898f, 0.01061430015f, 0.01063228305f, 0.01064794231f,
    0.01066124719f, 0.01067216974f, 0.01068068855f, 0.01068678591f,
    0.01069044974f, 0.01069167163f, 0.01069044974f, 0.01068678591f,
    0.01068068855f, 0.01067216974f, 0.01066124719f, 0.01064794231f,
    0.01063228305f, 0.01061430015f, 0.01059402898f, 0.0105715096f,
    0.01054678671f, 0.01051990688f, 0.01049092133f, 0.010459885f,
    0.01042685378f, 0.01039188914f, 0.01035505254f, 0.01031640731f,
    0.01043252647f, 0.01053273678f, 0.01063348539f, 0.01073470619f,
    0.01083632838f, 0.01093827467f, 0.01104046032f, 0.01114279591f,
    0.01124518644f, 0.01134752948f, 0.01144971419f, 0.01155162696f,
    0.01165314391f, 0.0117541356f, 0.01185446698f, 0.0119539937f,
    0.01205256768f, 0.01215003151f, 0.0122462241f, 0.01234097779f,
    0.01243411843f, 0.01252546813f, 0.01261484437f, 0.01270206179f,
    0.0127869295f, 0.01286925655f, 0.01294884924f, 0.01302551571f,
    0.01309906319f, 0.01316929981f, 0.01323603839f, 0.01329909544f,
    0.01335829217f, 0.0134134572f, 0.01346442662f, 0.01351104677f,
    0.01355317142f, 0.01359067019f, 0.01362342201f, 0.01365132071f,
    0.01367427502f, 0.01369220857f, 0.01370506082f, 0.01371278986f,
    0.01371536963f, 0.01371278986f, 0.01370506082f, 0.01369220857f,
    0.01367427502f, 0.01365132071f, 0.01362342201f, 0.01359067019f,
    0.01355317142f, 0.01351104677f, 0.01346442662f, 0.0134134572f,
    0.01335829217f, 0.01329909544f, 0.01323603839f, 0.01316929981f,
    0.01309906319f, 0.01302551571f, 0.01294884924f, 0.01286925655f,
    0.0127869295f, 0.01270206179f, 0.01261484437f, 0.01252546813f,
    0.01243411843f, 0.01234097779f, 0.0122462241f, 0.01215003151f,
    0.01205256768f, 0.0119539937f, 0.01185446698f, 0.0117541356f,
    0.01165314391f, 0.01155162696f, 0.01144971419f, 0.01134752948f,
    0.01124518644f, 0.01114279591f, 0.01104046032f, 0.01093827467f,
    0.01083632838f, 0.01073470619f, 0.01063348539f, 0.01053273678f,
    0.01043252647f, 0.01033291686f, 0.01037509646f, 0.01041553635f,
    0.01045416761f, 0.01049092133f, 0.0105257323f, 0.01055853814f,
    0.01058927551f, 0.01061788946f, 0.01064432319f, 0.01066852547f,
    0.01069044974f, 0.01071005128f, 0.01072729193f, 0.01074213628f,
    0.0107545536f, 0.01076451875f, 0.01077201031f, 0.01077701338f,
    0.0107795177f, 0.0107795177f, 0.01077701338f, 0.01077201031f,
    0.01076451875f, 0.0107545536f, 0.01074213628f, 0.01072729193f,
    0.01071005128f, 0.01069044974f, 0.01066852547f, 0.01064432319f,
    0.01061788946f, 0.01058927551f, 0.01055853814f, 0.0105257323f,
    0.01049092133f, 0.01045416761f, 0.01041553635f, 0.01037509646f,
    0.01048861258f, 0.01058927551f, 0.01069044974f, 0.01079206541f,
    0.01089404803f, 0.01099631656f, 0.01109878626f, 0.01120136213f,
    0.01130394638f, 0.01140643191f, 0.01150870696f, 0.01161065139f,
    0.01171213947f, 0.01181303803f, 0.01191320643f, 0.01201249938f,
    0.01211076323f, 0.01220783778f, 0.01230355818f, 0.01239775307f,
    0.01249024551f, 0.01258085575f, 0.01266939752f, 0.01275568269f,
    0.01283952035f, 0.01292071585f, 0.01299907733f, 0.01307440922f,
    0.01314651966f, 0.01321521774f, 0.01328031812f, 0.01334163733f,
    0.01339900028f, 0.0134522384f, 0.01350119151f, 0.01354570966f,
    0.01358565222f, 0.0136208944f, 0.01365132071f, 0.01367683243f,
    0.01369734481f, 0.01371278986f, 0.01372311637f, 0.013728288f,
    0.013728288f, 0.01372311637f, 0.01371278986f, 0.01369734481f,
    0.01367683243f, 0.01365132071f, 0.0136208944f, 0.01358565222f,
    0.01354570966f, 0.01350119151f, 0.0134522384f, 0.01339900028f,
    0.01334163733f, 0.01328031812f, 0.01321521774f, 0.01314651966f,
    0.01307440922f, 0.01299907733f, 0.01292071585f, 0.01283952035f,
    0.01275568269f, 0.01266939752f, 0.01258085575f, 0.01249024551f,
    0.01239775307f, 0.01230355818f, 0.01220783778f, 0.01211076323f,
    0.01201249938f, 0.01191320643f, 0.01181303803f, 0.01171213947f,
    0.01161065139f, 0.01150870696f, 0.01140643191f, 0.01130394638f,
    0.01120136213f, 0.01109878626f, 0.01099631656f, 0.01089404803f,
    0.01079206541f, 0.01069044974f, 0.01058927551f, 0.01048861258f,
    0.01038852427f, 0.01043252647f, 0.01047479361f, 0.01051525306f,
    0.01055383217f, 0.01059046388f, 0.01062507927f, 0.0106576141f,
    0.01068800688f, 0.01071619987f, 0.01074213628f, 0.01076576579f,
    0.01078704093f, 0.0108059179f, 0.01082235854f, 0.01083632838f,
    0.01084779948f, 0.01085674576f, 0.01086314954f, 0.01086699776f,
    0.01086828113f, 0.01086699776f, 0.01086314954f, 0.01085674576f,
    0.01084779948f, 0.01083632838f, 0.01082235854f, 0.0108059179f,
    0.01078704093f, 0.01076576579f, 0.01074213628f, 0.01071619987f,
    0.01068800688f, 0.0106576141f, 0.01062507927f, 0.01059046388f,
    0.01055383217f, 0.01051525306f, 0.01047479361f, 0.01043252647f,
    0.01054326911f, 0.01064432319f, 0.01074585691f, 0.01084779948f,
    0.01095007174f, 0.01105259173f, 0.01115526911f, 0.01125800703f,
    0.01136070304f, 0.01146324724f, 0.01156552508f, 0.01166741177f,
    0.01176877879f, 0.01186948828f, 0.01196939778f, 0.01206835546f,
    0.01216620672f, 0.01226278674f, 0.01235792786f, 0.01245145593f,
    0.0125431912f, 0.01263295114f, 0.01272054669f, 0.01280578785f,
    0.01288848184f, 0.01296843402f, 0.0130454516f, 0.01311933808f,
    0.01318990346f, 0.01325695775f, 0.01332031563f, 0.01337979734f,
    0.01343523059f, 0.01348644961f, 0.01353329886f, 0.01357563306f,
    0.01361331902f, 0.01364623569f, 0.01367427502f, 0.01369734481f,
    0.01371536963f, 0.013728288f, 0.01373605616f, 0.01373864897f,
    0.01373605616f, 0.013728288f, 0.01371536963f, 0.01369734481f,
    0.01367427502f, 0.01364623569f, 0.01361331902f, 0.01357563306f,
    0.01353329886f, 0.01348644961f, 0.01343523059f, 0.01337979734f,
    0.01332031563f, 0.01325695775f, 0.01318990346f, 0.01311933808f,
    0.0130454516f, 0.01296843402f, 0.01288848184f, 0.01280578785f,
    0.01272054669f, 0.01263295114f, 0.0125431912f, 0.01245145593f,
    0.01235792786f, 0.01226278674f, 0.01216620672f, 0.01206835546f,
    0.01196939778f, 0.01186948828f, 0.01176877879f, 0.01166741177f,
    0.01156552508f, 0.01146324724f, 0.01136070304f, 0.01125800703f,
    0.01115526911f, 0.01105259173f, 0.01095007174f, 0.01084779948f,
    0.01074585691f, 0.01064432319f, 0.01054326911f, 0.01044276077f,
    0.01048861258f, 0.01053273678f, 0.01057505608f, 0.01061549596f,
    0.0106539838f, 0.01069044974f, 0.01072482392f, 0.0107570421f,
    0.01078704093f, 0.01081476174f, 0.01084014867f, 0.01086314954f,
    0.01088371873f, 0.0109018134f, 0.01091739535f, 0.01093043014f,
    0.01094089262f, 0.0109487595f, 0.01095401309f, 0.01095664315f,
    0.01095664315f, 0.01095401309f, 0.0109487595f, 0.01094089262f,
    0.01093043014f, 0.01091739535f, 0.0109018134f, 0.01088371873f,
    0.01086314954f, 0.01084014867f, 0.01081476174f, 0.01078704093f,
    0.0107570421f, 0.01072482392f, 0.01069044974f, 0.0106539838f,
    0.01061549596f, 0.01057505608f, 0.01053273678f, 0.01048861258f,
    0.01059640758f, 0.01069778763f, 0.01079961471f, 0.0109018134f,
    0.01100430358f, 0.01110699773f, 0.01120980456f, 0.01131262258f,
    0.01141534653f, 0.01151786372f, 0.01162005402f, 0.01172179077f,
    0.01182294171f, 0.01192336436f, 0.01202291343f, 0.01212143432f,
    0.01221876871f, 0.01231474802f, 0.01240920182f, 0.01250195317f,
    0.01259282045f, 0.0126816174f, 0.01276815403f, 0.01285223942f,
    0.01293367799f, 0.01301227603f, 0.01308783889f, 0.01316017378f,
    0.013229087f, 0.0132943932f, 0.01335590892f, 0.0134134572f,
    0.01346686855f, 0.01351598185f, 0.01356064621f, 0.01360072289f,
    0.01363608148f, 0.01366661023f, 0.01369220857f, 0.01371278986f,
    0.013728288f, 0.01373864897f, 0.0137438383f, 0.0137438383f,
    0.01373864897f, 0.013728288f, 0.01371278986f, 0.01369220857f,
    0.01366661023f, 0.01363608148f, 0.01360072289f, 0.01356064621f,
    0.01351598185f, 0.01346686855f, 0.0134134572f, 0.01335590892f,
    0.0132943932f, 0.013229087f, 0.01316017378f, 0.01308783889f,
    0.01301227603f, 0.01293367799f, 0.01285223942f, 0.01276815403f,
    0.0126816174f, 0.01259282045f, 0.01250195317f, 0.01240920182f,
    0.01231474802f, 0.01221876871f, 0.01212143432f, 0.01202291343f,
    0.01192336436f, 0.01182294171f, 0.01172179077f, 0.01162005402f,
    0.01151786372f, 0.01141534653f, 0.01131262258f, 0.01120980456f,
    0.01110699773f, 0.01100430358f, 0.0109018134f, 0.01079961471f,
    0.01069778763f, 0.01059640758f, 0.01049554255f, 0.01054326911f,
    0.01058927551f, 0.01063348539f, 0.01067581866f, 0.01071619987f,
    0.0107545536f, 0.01079080813f, 0.01082489453f, 0.01085674576f,
    0.01088629849f, 0.01091349311f, 0.01093827467f, 0.01096059103f,
    0.0109803956f, 0.01099764649f, 0.01101230737f, 0.01102434658f,
    0.01103373803f, 0.01104046032f, 0.01104449946f, 0.01104584709f,
    0.01104449946f, 0.01104046032f, 0.01103373803f, 0.01102434658f,
    0.01101230737f, 0.01099764649f, 0.0109803956f, 0.01096059103f,
    0.01093827467f, 0.01091349311f, 0.01088629849f, 0.01085674576f,
    0.01082489453f, 0.01079080813f, 0.0107545536f, 0.01071619987f,
    0.01067581866f, 0.01063348539f, 0.01058927551f, 0.01054326911f,
    0.01064794231f, 0.01074958127f, 0.01085163094f, 0.01095401309f,
    0.01105664484f, 0.01115943585f, 0.01126228925f, 0.01136510447f,
    0.01146776881f, 0.01157016866f, 0.01167218015f, 0.01177367195f,
    0.01187450811f, 0.0119745452f, 0.01207363233f, 0.01217161212f,
    0.01226832252f, 0.01236359403f, 0.01245725155f, 0.01254911628f,
    0.01263900381f, 0.01272672601f, 0.01281209197f, 0.0128949089f,
    0.01297498215f, 0.01305211708f, 0.01312611811f, 0.01319679338f,
    0.01326395292f, 0.01332741138f, 0.01338698901f, 0.01344251167f,
    0.01349381451f, 0.01354074106f, 0.01358314604f, 0.0136208944f,
    0.01365386508f, 0.01368195191f, 0.01370506082f, 0.01372311637f,
    0.01373605616f, 0.0137438383f, 0.01374643482f, 0.0137438383f,
    0.01373605616f, 0.01372311637f, 0.01370506082f, 0.01368195191f,
    0.01365386508f, 0.0136208944f, 0.01358314604f, 0.01354074106f,
    0.01349381451f, 0.01344251167f, 0.01338698901f, 0.01332741138f,
    0.01326395292f, 0.01319679338f, 0.01312611811f, 0.01305211708f,
    0.01297498215f, 0.0128949089f, 0.01281209197f, 0.01272672601f,
    0.01263900381f, 0.01254911628f, 0.01245725155f, 0.01236359403f,
    0.01226832252f, 0.01217161212f, 0.01207363233f, 0.0119745452f,
    0.01187450811f, 0.01177367195f, 0.01167218015f, 0.01157016866f,
    0.01146776881f, 0.01136510447f, 0.01126228925f, 0.01115943585f,
    0.01105664484f, 0.01095401309f, 0.01085163094f, 0.01074958127f,
    0.01064794231f, 0.01054678671f, 0.01059640758f, 0.01064432319f,
    0.01069044974f, 0.01073470619f, 0.01077701338f, 0.01081729215f,
    0.01085546613f, 0.01089146268f, 0.01092521101f, 0.01095664315f,
    0.01098569483f, 0.01101230737f, 0.0110364249f, 0.01105799619f,
    0.01107697561f, 0.01109332126f, 0.01110699773f, 0.01111797616f,
    0.0111262314f, 0.01113174483f, 0.01113450434f, 0.01113450434f,
    0.01113174483f, 0.0111262314f, 0.01111797616f, 0.01110699773f,
    0.01109332126f, 0.01107697561f, 0.01105799619f, 0.0110364249f,
    0.01101230737f, 0.01098569483f, 0.01095664315f, 0.01092521101f,
    0.01089146268f, 0.01085546613f, 0.01081729215f, 0.01077701338f,
    0.01073470619f, 0.01069044974f, 0.01064432319f, 0.01059640758f,
    0.01069778763f, 0.01079961471f, 0.0109018134f, 0.01100430358f,
    0.01110699773f, 0.01120980456f, 0.01131262258f, 0.01141534653f,
    0.01151786372f, 0.01162005402f, 0.01172179077f, 0.01182294171f,
    0.01192336436f, 0.01202291343f, 0.01212143432f, 0.01221876871f,
    0.01231474802f, 0.01240920182f, 0.01250195317f, 0.01259282045f,
    0.0126816174f, 0.01276815403f, 0.01285223942f, 0.01293367799f,
    0.01301227603f, 0.01308783889f, 0.01316017378f, 0.013229087f,
    0.0132943932f, 0.01335590892f, 0.0134134572f, 0.01346686855f,
    0.01351598185f, 0.01356064621f, 0.01360072289f, 0.01363608148f,
    0.01366661023f, 0.01369220857f, 0.01371278986f, 0.013728288f,
    0.01373864897f, 0.0137438383f, 0.0137438383f, 0.01373864897f,
    0.013728288f, 0.01371278986f, 0.01369220857f, 0.01366661023f,
    0.01363608148f, 0.01360072289f, 0.01356064621f, 0.01351598185f,
    0.01346686855f, 0.0134134572f, 0.01335590892f, 0.0132943932f,
    0.013229087f, 0.01316017378f, 0.01308783889f, 0.01301227603f,
    0.01293367799f, 0.01285223942f, 0.01276815403f, 0.0126816174f,
    0.01259282045f, 0.01250195317f, 0.01240920182f, 0.01231474802f,
    0.01221876871f, 0.01212143432f, 0.01202291343f, 0.01192336436f,
    0.01182294171f, 0.01172179077f, 0.01162005402f, 0.01151786372f,
    0.01141534653f, 0.01131262258f, 0.01120980456f, 0.01110699773f,
    0.01100430358f, 0.0109018134f, 0.01079961471f, 0.01069778763f,
    0.01059640758f, 0.01064794231f, 0.01069778763f, 0.01074585691f,
    0.01079206541f, 0.01083632838f, 0.01087856572f, 0.01091869641f,
    0.01095664315f, 0.01099232957f, 0.01102568675f, 0.01105664484f,
    0.01108513959f, 0.01111111138f, 0.01113450434f, 0.01115526911f,
    0.01117335912f, 0.01118873432f, 0.01120136213f, 0.01121121366f,
    0.01121826563f, 0.01122250315f, 0.0112239169f, 0.01122250315f,
    0.01121826563f, 0.01121121366f, 0.01120136213f, 0.01118873432f,
    0.01117335912f, 0.01115526911f, 0.01113450434f, 0.01111111138f,
    0.01108513959f, 0.01105664484f, 0.01102568675f, 0.01099232957f,
    0.01095664315f, 0.01091869641f, 0.01087856572f, 0.01083632838f,
    0.01079206541f, 0.01074585691f, 0.01069778763f, 0.01064794231f,
    0.01074585691f, 0.01084779948f, 0.01095007174f, 0.01105259173f,
    0.01115526911f, 0.01125800703f, 0.01136070304f, 0.01146324724f,
    0.01156552508f, 0.01166741177f, 0.01176877879f, 0.01186948828f,
    0.01196939778f, 0.01206835546f, 0.01216620672f, 0.01226278674f,
    0.01235792786f, 0.01245145593f, 0.0125431912f, 0.01263295114f,
    0.01272054669f, 0.01280578785f, 0.01288848184f, 0.01296843402f,
    0.0130454516f, 0.01311933808f, 0.01318990346f, 0.01325695775f,
    0.01332031563f, 0.01337979734f, 0.01343523059f, 0.01348644961f,
    0.01353329886f, 0.01357563306f, 0.01361331902f, 0.01364623569f,
    0.01367427502f, 0.01369734481f, 0.01371536963f, 0.013728288f,
    0.01373605616f, 0.01373864897f, 0.01373605616f, 0.013728288f,
    0.01371536963f, 0.01369734481f, 0.01367427502f, 0.01364623569f,
    0.01361331902f, 0.01357563306f, 0.01353329886f, 0.01348644961f,
    0.01343523059f, 0.01337979734f, 0.01332031563f, 0.01325695775f,
    0.01318990346f, 0.01311933808f, 0.0130454516f, 0.01296843402f,
    0.01288848184f, 0.01280578785f, 0.01272054669f, 0.01263295114f,
    0.0125431912f, 0.01245145593f, 0.01235792786f, 0.01226278674f,
    0.01216620672f, 0.01206835546f, 0.01196939778f, 0.01186948828f,
    0.01176877879f, 0.01166741177f, 0.01156552508f, 0.01146324724f,
    0.01136070304f, 0.01125800703f, 0.01115526911f, 0.01105259173f,
    0.01095007174f, 0.01084779948f, 0.01074585691f, 0.01064432319f,
    0.01069778763f, 0.01074958127f, 0.01079961471f, 0.01084779948f,
    0.01089404803f, 0.01093827467f, 0.0109803956f, 0.01102032885f,
    0.01105799619f, 0.01109332126f, 0.0111262314f, 0.01115665678f,
    0.01118453499f, 0.01120980456f, 0.01123241056f, 0.01125230361f,
    0.01126943901f, 0.01128377859f, 0.01129528973f, 0.01130394638f,
    0.01130972803f, 0.01131262258f, 0.01131262258f, 0.01130972803f,
    0.01130394638f, 0.01129528973f, 0.01128377859f, 0.01126943901f,
    0.01125230361f, 0.01123241056f, 0.01120980456f, 0.01118453499f,
    0.01115665678f, 0.0111262314f, 0.01109332126f, 0.01105799619f,
    0.01102032885f, 0.0109803956f, 0.01093827467f, 0.01089404803f,
    0.01084779948f, 0.01079961471f, 0.01074958127f, 0.01069778763f,
    0.01079206541f, 0.01089404803f, 0.01099631656f, 0.01109878626f,
    0.01120136213f, 0.01130394638f, 0.01140643191f, 0.01150870696f,
    0.01161065139f, 0.01171213947f, 0.01181303803f, 0.01191320643f,
    0.01201249938f, 0.01211076323f, 0.01220783778f, 0.01230355818f,
    0.01239775307f, 0.01249024551f, 0.01258085575f, 0.01266939752f,
    0.01275568269f, 0.01283952035f, 0.01292071585f, 0.01299907733f,
    0.01307440922f, 0.01314651966f, 0.01321521774f, 0.01328031812f,
    0.01334163733f, 0.01339900028f, 0.0134522384f, 0.01350119151f,
    0.01354570966f, 0.01358565222f, 0.0136208944f, 0.01365132071f,
    0.01367683243f, 0.01369734481f, 0.01371278986f, 0.01372311637f,
    0.013728288f, 0.013728288f, 0.01372311637f, 0.01371278986f,
    0.01369734481f, 0.01367683243f, 0.01365132071f, 0.0136208944f,
    0.01358565222f, 0.01354570966f, 0.01350119151f, 0.0134522384f,
    0.01339900028f, 0.01334163733f, 0.01328031812f, 0.01321521774f,
    0.01314651966f, 0.01307440922f, 0.01299907733f, 0.01292071585f,
    0.01283952035f, 0.01275568269f, 0.01266939752f, 0.01258085575f,
    0.01249024551f, 0.01239775307f, 0.01230355818f, 0.01220783778f,
    0.01211076323f, 0.01201249938f, 0.01191320643f, 0.01181303803f,
    0.01171213947f, 0.01161065139f, 0.01150870696f, 0.01140643191f,
    0.01130394638f, 0.01120136213f, 0.01109878626f, 0.01099631656f,
    0.01089404803f, 0.01079206541f, 0.01069044974f, 0.01074585691f,
    0.01079961471f, 0.01085163094f, 0.0109018134f, 0.01095007174f,
    0.01099631656f, 0.01104046032f, 0.0110824164f, 0.01112210099f,
    0.01115943585f, 0.01119434182f, 0.01122674625f, 0.01125658024f,
    0.01128377859f, 0.01130828168f, 0.01133003552f, 0.01134899072f,
    0.01136510447f, 0.01137833856f, 0.01138866507f, 0.0113960579f,
    0.01140050031f, 0.01140198205f, 0.01140050031f, 0.0113960579f,
    0.01138866507f, 0.01137833856f, 0.01136510447f, 0.01134899072f,
    0.01133003552f, 0.01130828168f, 0.01128377859f, 0.01125658024f,
    0.01122674625f, 0.01119434182f, 0.01115943585f, 0.01112210099f,
    0.0110824164f, 0.01104046032f, 0.01099631656f, 0.01095007174f,
    0.0109018134f, 0.01085163094f, 0.01079961471f, 0.01074585691f,
    0.01083632838f, 0.01093827467f, 0.01104046032f, 0.01114279591f,
    0.01124518644f, 0.01134752948f, 0.01144971419f, 0.01155162696f,
    0.01165314391f, 0.0117541356f, 0.01185446698f, 0.0119539937f,
    0.01205256768f, 0.01215003151f, 0.0122462241f, 0.01234097779f,
    0.01243411843f, 0.01252546813f, 0.01261484437f, 0.01270206179f,
    0.0127869295f, 0.01286925655f, 0.01294884924f, 0.01302551571f,
    0.01309906319f, 0.01316929981f, 0.01323603839f, 0.01329909544f,
    0.01335829217f, 0.0134134572f, 0.01346442662f, 0.01351104677f,
    0.01355317142f, 0.01359067019f, 0.01362342201f, 0.01365132071f,
    0.01367427502f, 0.01369220857f, 0.01370506082f, 0.01371278986f,
    0.01371536963f, 0.01371278986f, 0.01370506082f, 0.01369220857f,
    0.01367427502f, 0.01365132071f, 0.01362342201f, 0.01359067019f,
    0.01355317142f, 0.01351104677f, 0.01346442662f, 0.0134134572f,
    0.01335829217f, 0.01329909544f, 0.01323603839f, 0.01316929981f,
    0.01309906319f, 0.01302551571f, 0.01294884924f, 0.01286925655f,
    0.0127869295f, 0.01270206179f, 0.01261484437f, 0.01252546813f,
    0.01243411843f, 0.01234097779f, 0.0122462241f, 0.01215003151f,
    0.01205256768f, 0.0119539937f, 0.01185446698f, 0.0117541356f,
    0.01165314391f, 0.01155162696f, 0.01144971419f, 0.01134752948f,
    0.01124518644f, 0.01114279591f, 0.01104046032f, 0.01093827467f,
    0.01083632838f, 0.01073470619f, 0.01079206541f, 0.01084779948f,
    0.0109018134f, 0.01095401309f, 0.01100430358f, 0.01105259173f,
    0.01109878626f, 0.01114279591f, 0.01118453499f, 0.0112239169f,
    0.01126086153f, 0.01129528973f, 0.01132712793f, 0.01135630626f,
    0.01138276048f, 0.01140643191f, 0.01142726559f, 0.01144521404f,
    0.01146023627f, 0.01147229597f, 0.01148136612f, 0.0114874253f,
    0.01149045862f, 0.01149045862f, 0.0114874253f, 0.01148136612f,
    0.01147229597f, 0.01146023627f, 0.01144521404f, 0.01142726559f,
    0.01140643191f, 0.01138276048f, 0.01135630626f, 0.01132712793f,
    0.01129528973f, 0.01126086153f, 0.0112239169f, 0.01118453499f,
    0.01114279591f, 0.01109878626f, 0.01105259173f, 0.01100430358f,
    0.01095401309f, 0.0109018134f, 0.01084779948f, 0.01079206541f,
    0.01087856572f, 0.0109803956f, 0.0110824164f, 0.01118453499f,
    0.01128665265f, 0.01138866507f, 0.01149045862f, 0.01159191411f,
    0.01169290766f, 0.0117933061f, 0.01189296879f, 0.01199175231f,
    0.01208950393f, 0.01218606345f, 0.01228126884f, 0.01237494871f,
    0.01246692892f, 0.01255702879f, 0.01264506485f, 0.01273085084f,
    0.01281419583f, 0.0128949089f, 0.0129727982f, 0.01304767188f,
    0.01311933808f, 0.01318760961f, 0.01325230021f, 0.01331323106f,
    0.01337022707f, 0.01342312153f, 0.01347175613f, 0.01351598185f,
    0.01355566178f, 0.01359067019f, 0.0136208944f, 0.01364623569f,
    0.01366661023f, 0.01368195191f, 0.01369220857f, 0.01369734481f,
    0.01369734481f, 0.01369220857f, 0.01368195191f, 0.01366661023f,
    0.01364623569f, 0.0136208944f, 0.01359067019f, 0.01355566178f,
    0.01351598185f, 0.01347175613f, 0.01342312153f, 0.01337022707f,
    0.01331323106f, 0.01325230021f, 0.01318760961f, 0.01311933808f,
    0.01304767188f, 0.0129727982f, 0.0128949089f, 0.01281419583f,
    0.01273085084f, 0.01264506485f, 0.01255702879f, 0.01246692892f,
    0.01237494871f, 0.01228126884f, 0.01218606345f, 0.01208950393f,
    0.01199175231f, 0.01189296879f, 0.0117933061f, 0.01169290766f,
    0.01159191411f, 0.01149045862f, 0.01138866507f, 0.01128665265f,
    0.01118453499f, 0.0110824164f, 0.0109803956f, 0.01087856572f,
    0.01077701338f, 0.01083632838f, 0.01089404803f, 0.01095007174f,
    0.01100430358f, 0.01105664484f, 0.01110699773f, 0.01115526911f,
    0.01120136213f, 0.01124518644f, 0.01128665265f, 0.01132567506f,
    0.01136216894f, 0.0113960579f, 0.01142726559f, 0.01145572308f,
    0.01148136612f, 0.01150413603f, 0.01152398065f, 0.01154085156f,
    0.0115547115f, 0.01156552508f, 0.0115732681f, 0.01157792099f,
    0.0115794735f, 0.01157792099f, 0.0115732681f, 0.01156552508f,
    0.0115547115f, 0.01154085156f, 0.01152398065f, 0.01150413603f,
    0.01148136612f, 0.01145572308f, 0.01142726559f, 0.0113960579f,
    0.01136216894f, 0.01132567506f, 0.01128665265f, 0.01124518644f,
    0.01120136213f, 0.01115526911f, 0.01110699773f, 0.01105664484f,
    0.01100430358f, 0.01095007174f, 0.01089404803f, 0.01083632838f,
    0.01091869641f, 0.01102032885f, 0.01112210099f, 0.0112239169f,
    0.01132567506f, 0.01142726559f, 0.01152857486f, 0.01162947994f,
    0.0117298523f, 0.0118295569f, 0.01192845311f, 0.01202639099f,
    0.01212321594f, 0.01221876871f, 0.01231288072f, 0.01240538247f,
    0.01249609515f, 0.01258483995f, 0.01267143246f, 0.01275568269f,
    0.01283740439f, 0.01291640475f, 0.01299249288f, 0.01306547876f,
    0.01313517336f, 0.01320139226f, 0.01326395292f, 0.01332267933f,
    0.01337740291f, 0.01342796069f, 0.01347420178f, 0.01351598185f,
    0.01355317142f, 0.01358565222f, 0.01361331902f, 0.01363608148f,
    0.01365386508f, 0.01366661023f, 0.01367427502f, 0.01367683243f,
    0.01367427502f, 0.01366661023f, 0.01365386508f, 0.01363608148f,
    0.01361331902f, 0.01358565222f, 0.01355317142f, 0.01351598185f,
    0.01347420178f, 0.01342796069f, 0.01337740291f, 0.01332267933f,
    0.01326395292f, 0.01320139226f, 0.01313517336f, 0.01306547876f,
    0.01299249288f, 0.01291640475f, 0.01283740439f, 0.01275568269f,
    0.01267143246f, 0.01258483995f, 0.01249609515f, 0.01240538247f,
    0.01231288072f, 0.01221876871f, 0.01212321594f, 0.01202639099f,
    0.01192845311f, 0.0118295569f, 0.0117298523f, 0.01162947994f,
    0.01152857486f, 0.01142726559f, 0.01132567506f, 0.0112239169f,
    0.01112210099f, 0.01102032885f, 0.01091869641f, 0.01081729215f,
    0.01087856572f, 0.01093827467f, 0.01099631656f, 0.01105259173f,
    0.01110699773f, 0.01115943585f, 0.01120980456f, 0.01125800703f,
    0.01130394638f, 0.01134752948f, 0.01138866507f, 0.01142726559f,
    0.01146324724f, 0.01149653178f, 0.01152704284f, 0.0115547115f,
    0.0115794735f, 0.01160127111f, 0.01162005402f, 0.01163577568f,
    0.01164839976f, 0.01165789459f, 0.0116642369f, 0.01166741177f,
    0.01166741177f, 0.0116642369f, 0.01165789459f, 0.01164839976f,
    0.01163577568f, 0.01162005402f, 0.01160127111f, 0.0115794735f,
    0.0115547115f, 0.01152704284f, 0.01149653178f, 0.01146324724f,
    0.01142726559f, 0.01138866507f, 0.01134752948f, 0.01130394638f,
    0.01125800703f, 0.01120980456f, 0.01115943585f, 0.01110699773f,
    0.01105259173f, 0.01099631656f, 0.01093827467f, 0.01087856572f,
    0.01095664315f, 0.01105799619f, 0.01115943585f, 0.01126086153f,
    0.01136216894f, 0.01146324724f, 0.01156397816f, 0.0116642369f,
    0.01176389214f, 0.01186280511f, 0.0119608324f, 0.01205782313f,
    0.0121536199f, 0.0122480616f, 0.01234097779f, 0.01243219618f,
    0.01252153981f, 0.01260882709f, 0.01269387174f, 0.01277648844f,
    0.01285648718f, 0.01293367799f, 0.01300787181f, 0.01307888143f,
    0.01314651966f, 0.0132106049f, 0.01327095926f, 0.01332741138f,
    0.01337979734f, 0.01342796069f, 0.01347175613f, 0.01351104677f,
    0.01354570966f, 0.01357563306f, 0.01360072289f, 0.0136208944f,
    0.01363608148f, 0.01364623569f, 0.01365132071f, 0.01365132071f,
    0.01364623569f, 0.01363608148f, 0.0136208944f, 0.01360072289f,
    0.01357563306f, 0.01354570966f, 0.01351104677f, 0.01347175613f,
    0.01342796069f, 0.01337979734f, 0.01332741138f, 0.01327095926f,
    0.0132106049f, 0.01314651966f, 0.01307888143f, 0.01300787181f,
    0.01293367799f, 0.01285648718f, 0.01277648844f, 0.01269387174f,
    0.01260882709f, 0.01252153981f, 0.01243219618f, 0.01234097779f,
    0.0122480616f, 0.0121536199f, 0.01205782313f, 0.0119608324f,
    0.01186280511f, 0.01176389214f, 0.0116642369f, 0.01156397816f,
    0.01146324724f, 0.01136216894f, 0.01126086153f, 0.01115943585f,
    0.01105799619f, 0.01095664315f, 0.01085546613f, 0.01091869641f,
    0.0109803956f, 0.01104046032f, 0.01109878626f, 0.01115526911f,
    0.01120980456f, 0.01126228925f, 0.01131262258f, 0.01136070304f,
    0.01140643191f, 0.01144971419f, 0.01149045862f, 0.01152857486f,
    0.01156397816f, 0.01159659028f, 0.01162633486f, 0.01165314391f,
    0.01167695317f, 0.01169770677f, 0.0117153544f, 0.0117298523f,
    0.011741166f, 0.01174926758f, 0.0117541356f, 0.01175575983f,
    0.0117541356f, 0.01174926758f, 0.011741166f, 0.0117298523f,
    0.0117153544f, 0.01169770677f, 0.01167695317f, 0.01165314391f,
    0.01162633486f, 0.01159659028f, 0.01156397816f, 0.01152857486f,
    0.01149045862f, 0.01144971419f, 0.01140643191f, 0.01136070304f,
    0.01131262258f, 0.01126228925f, 0.01120980456f, 0.01115526911f,
    0.01109878626f, 0.01104046032f, 0.0109803956f, 0.01091869641f,
    0.01099232957f, 0.01109332126f, 0.01119434182f, 0.01129528973f,
    0.0113960579f, 0.01149653178f, 0.01159659028f, 0.01169610675f,
    0.01179494616f, 0.01189296879f, 0.01199002843f, 0.01208597142f,
    0.0121806385f, 0.01227386575f, 0.01236548461f, 0.01245531905f,
    0.0125431912f, 0.01262892038f, 0.01271232124f, 0.01279320568f,
    0.01287138835f, 0.01294667926f, 0.01301889122f, 0.01308783889f,
    0.01315334067f, 0.01321521774f, 0.01327329688f, 0.01332741138f,
    0.01337740291f, 0.01342312153f, 0.01346442662f, 0.01350119151f,
    0.01353329886f, 0.01356064621f, 0.01358314604f, 0.01360072289f,
    0.01361331902f, 0.0136208944f, 0.01362342201f, 0.0136208944f,
    0.01361331902f, 0.01360072289f, 0.01358314604f, 0.01356064621f,
    0.01353329886f, 0.01350119151f, 0.01346442662f, 0.01342312153f,
    0.01337740291f, 0.01332741138f, 0.01327329688f, 0.01321521774f,
    0.01315334067f, 0.01308783889f, 0.01301889122f, 0.01294667926f,
    0.01287138835f, 0.01279320568f, 0.01271232124f, 0.01262892038f,
    0.0125431912f, 0.01245531905f, 0.01236548461f, 0.01227386575f,
    0.0121806385f, 0.01208597142f, 0.01199002843f, 0.01189296879f,
    0.01179494616f, 0.01169610675f, 0.01159659028f, 0.01149653178f,
    0.0113960579f, 0.01129528973f, 0.01119434182f, 0.01109332126f,
    0.01099232957f, 0.01089146268f, 0.01095664315f, 0.01102032885f,
    0.0110824164f, 0.01114279591f, 0.01120136213f, 0.01125800703f,
    0.01131262258f, 0.01136510447f, 0.01141534653f, 0.01146324724f,
    0.01150870696f, 0.01155162696f, 0.01159191411f, 0.01162947994f,
    0.0116642369f, 0.01169610675f, 0.01172501314f, 0.01175088901f,
    0.01177367195f, 0.0117933061f, 0.01180974208f, 0.01182294171f,
    0.01183286961f, 0.01183950249f, 0.01184282266f, 0.01184282266f,
    0.01183950249f, 0.01183286961f, 0.01182294171f, 0.01180974208f,
    0.0117933061f, 0.01177367195f, 0.01175088901f, 0.01172501314f,
    0.01169610675f, 0.0116642369f, 0.01162947994f, 0.01159191411f,
    0.01155162696f, 0.01150870696f, 0.01146324724f, 0.01141534653f,
    0.01136510447f, 0.01131262258f, 0.01125800703f, 0.01120136213f,
    0.01114279591f, 0.0110824164f, 0.01102032885f, 0.01095664315f,
    0.01102568675f, 0.0111262314f, 0.01122674625f, 0.01132712793f,
    0.01142726559f, 0.01152704284f, 0.01162633486f, 0.01172501314f,
    0.01182294171f, 0.01191997528f, 0.01201596763f, 0.01211076323f,
    0.01220420003f, 0.01229611505f, 0.01238633506f, 0.01247468684f,
    0.01256099064f, 0.01264506485f, 0.01272672601f, 0.01280578785f,
    0.01288206317f, 0.01295536757f, 0.01302551571f, 0.01309232507f,
    0.01315561775f, 0.01321521774f, 0.01327095926f, 0.01332267933f,
    0.01337022707f, 0.0134134572f, 0.0134522384f, 0.01348644961f,
    0.01351598185f, 0.01354074106f, 0.01356064621f, 0.01357563306f,
    0.01358565222f, 0.01359067019f, 0.01359067019f, 0.01358565222f,
    0.01357563306f, 0.01356064621f, 0.01354074106f, 0.01351598185f,
    0.01348644961f, 0.0134522384f, 0.0134134572f, 0.01337022707f,
    0.01332267933f, 0.01327095926f, 0.01321521774f, 0.01315561775f,
    0.01309232507f, 0.01302551571f, 0.01295536757f, 0.01288206317f,
    0.01280578785f, 0.01272672601f, 0.01264506485f, 0.01256099064f,
    0.01247468684f, 0.01238633506f, 0.01229611505f, 0.01220420003f,
    0.01211076323f, 0.01201596763f, 0.01191997528f, 0.01182294171f,
    0.01172501314f, 0.01162633486f, 0.01152704284f, 0.01142726559f,
    0.01132712793f, 0.01122674625f, 0.0111262314f, 0.01102568675f,
    0.01092521101f, 0.01099232957f, 0.01105799619f, 0.01112210099f,
    0.01118453499f, 0.01124518644f, 0.01130394638f, 0.01136070304f,
    0.01141534653f, 0.01146776881f, 0.01151786372f, 0.01156552508f,
    0.01161065139f, 0.01165314391f, 0.01169290766f, 0.0117298523f,
    0.01176389214f, 0.01179494616f, 0.01182294171f, 0.01184780896f,
    0.01186948828f, 0.01188792568f, 0.0119030755f, 0.01191489771f,
    0.01192336436f, 0.01192845311f, 0.01193015091f, 0.01192845311f,
    0.01192336436f, 0.01191489771f, 0.0119030755f, 0.01188792568f,
    0.01186948828f, 0.01184780896f, 0.01182294171f, 0.01179494616f,
    0.01176389214f, 0.0117298523f, 0.01169290766f, 0.01165314391f,
    0.01161065139f, 0.01156552508f, 0.01151786372f, 0.01146776881f,
    0.01141534653f, 0.01136070304f, 0.01130394638f, 0.01124518644f,
    0.01118453499f, 0.01112210099f, 0.01105799619f, 0.01099232957f,
    0.01105664484f, 0.01115665678f, 0.01125658024f, 0.01135630626f,
    0.01145572308f, 0.0115547115f, 0.01165314391f, 0.01175088901f,
    0.01184780896f, 0.01194375753f, 0.01203858573f, 0.01213213522f,
    0.01222424489f, 0.01231474802f, 0.01240347326f, 0.01249024551f,
    0.01257488597f, 0.01265721396f, 0.01273704506f, 0.01281419583f,
    0.01288848184f, 0.0129597187f, 0.01302772667f, 0.01309232507f,
    0.01315334067f, 0.0132106049f, 0.01326395292f, 0.01331323106f,
    0.01335829217f, 0.01339900028f, 0.01343523059f, 0.01346686855f,
    0.01349381451f, 0.01351598185f, 0.01353329886f, 0.01354570966f,
    0.01355317142f, 0.01355566178f, 0.01355317142f, 0.01354570966f,
    0.01353329886f, 0.01351598185f, 0.01349381451f, 0.01346686855f,
    0.01343523059f, 0.01339900028f, 0.01335829217f, 0.01331323106f,
    0.01326395292f, 0.0132106049f, 0.01315334067f, 0.01309232507f,
    0.01302772667f, 0.0129597187f, 0.01288848184f, 0.01281419583f,
    0.01273704506f, 0.01265721396f, 0.01257488597f, 0.01249024551f,
    0.01240347326f, 0.01231474802f, 0.01222424489f, 0.01213213522f,
    0.01203858573f, 0.01194375753f, 0.01184780896f, 0.01175088901f,
    0.01165314391f, 0.0115547115f, 0.01145572308f, 0.01135630626f,
    0.01125658024f, 0.01115665678f, 0.01105664484f, 0.01095664315f,
    0.01102568675f, 0.01109332126f, 0.01115943585f, 0.0112239169f,
    0.01128665265f, 0.01134752948f, 0.01140643191f, 0.01146324724f,
    0.01151786372f, 0.01157016866f, 0.01162005402f, 0.01166741177f,
    0.01171213947f, 0.0117541356f, 0.0117933061f, 0.0118295569f,
    0.01186280511f, 0.01189296879f, 0.01191997528f, 0.01194375753f,
    0.01196425594f, 0.01198141929f, 0.01199520286f, 0.01200557221f,
    0.01201249938f, 0.01201596763f, 0.01201596763f, 0.01201249938f,
    0.01200557221f, 0.01199520286f, 0.01198141929f, 0.01196425594f,
    0.01194375753f, 0.01191997528f, 0.01189296879f, 0.01186280511f,
    0.0118295569f, 0.0117933061f, 0.0117541356f, 0.01171213947f,
    0.01166741177f, 0.01162005402f, 0.01157016866f, 0.01151786372f,
    0.01146324724f, 0.01140643191f, 0.01134752948f, 0.01128665265f,
    0.0112239169f, 0.01115943585f, 0.01109332126f, 0.01102568675f,
    0.01108513959f, 0.01118453499f, 0.01128377859f, 0.01138276048f,
    0.01148136612f, 0.0115794735f, 0.01167695317f, 0.01177367195f,
    0.01186948828f, 0.01196425594f, 0.01205782313f, 0.01215003151f,
    0.01224071812f, 0.01232971624f, 0.01241685264f, 0.01250195317f,
    0.01258483995f, 0.0126653323f, 0.0127432486f, 0.01281840634f,
    0.01289062295f, 0.0129597187f, 0.01302551571f, 0.01308783889f,
    0.01314651966f, 0.01320139226f, 0.01325230021f, 0.01329909544f,
    0.01334163733f, 0.01337979734f, 0.0134134572f, 0.01344251167f,
    0.01346686855f, 0.01348644961f, 0.01350119151f, 0.01351104677f,
    0.01351598185f, 0.01351598185f, 0.01351104677f, 0.01350119151f,
    0.01348644961f, 0.01346686855f, 0.01344251167f, 0.0134134572f,
    0.01337979734f, 0.01334163733f, 0.01329909544f, 0.01325230021f,
    0.01320139226f, 0.01314651966f, 0.01308783889f, 0.01302551571f,
    0.0129597187f, 0.01289062295f, 0.01281840634f, 0.0127432486f,
    0.0126653323f, 0.01258483995f, 0.01250195317f, 0.01241685264f,
    0.01232971624f, 0.01224071812f, 0.01215003151f, 0.01205782313f,
    0.01196425594f, 0.01186948828f, 0.01177367195f, 0.01167695317f,
    0.0115794735f, 0.01148136612f, 0.01138276048f, 0.01128377859f,
    0.01118453499f, 0.01108513959f, 0.01098569483f, 0.01105664484f,
    0.0111262314f, 0.01119434182f, 0.01126086153f, 0.01132567506f,
    0.01138866507f, 0.01144971419f, 0.01150870696f, 0.01156552508f,
    0.01162005402f, 0.01167218015f, 0.01172179077f, 0.01176877879f,
    0.01181303803f, 0.01185446698f, 0.01189296879f, 0.01192845311f,
    0.0119608324f, 0.01199002843f, 0.01201596763f, 0.01203858573f,
    0.01205782313f, 0.01207363233f, 0.01208597142f, 0.01209480781f,
    0.01210011914f, 0.01210189145f, 0.01210011914f, 0.01209480781f,
    0.01208597142f, 0.01207363233f, 0.01205782313f, 0.01203858573f,
    0.01201596763f, 0.01199002843f, 0.0119608324f, 0.01192845311f,
    0.01189296879f, 0.01185446698f, 0.01181303803f, 0.01176877879f,
    0.01172179077f, 0.01167218015f, 0.01162005402f, 0.01156552508f,
    0.01150870696f, 0.01144971419f, 0.01138866507f, 0.01132567506f,
    0.01126086153f, 0.01119434182f, 0.0111262314f, 0.01105664484f,
    0.01111111138f, 0.01120980456f, 0.01130828168f, 0.01140643191f,
    0.01150413603f, 0.01160127111f, 0.01169770677f, 0.0117933061f,
    0.01188792568f, 0.01198141929f, 0.01207363233f, 0.01216440555f,
    0.01225357689f, 0.01234097779f, 0.01242643595f, 0.01250977721f,
    0.0125908237f, 0.01266939752f, 0.01274531893f, 0.01281840634f,
    0.01288848184f, 0.01295536757f, 0.01301889122f, 0.01307888143f,
    0.01313517336f, 0.01318760961f, 0.01323603839f, 0.01328031812f,
    0.01332031563f, 0.01335590892f, 0.01338698901f, 0.0134134572f,
    0.01343523059f, 0.0134522384f, 0.01346442662f, 0.01347175613f,
    0.01347420178f, 0.01347175613f, 0.01346442662f, 0.0134522384f,
    0.01343523059f, 0.0134134572f, 0.01338698901f, 0.01335590892f,
    0.01332031563f, 0.01328031812f, 0.01323603839f, 0.01318760961f,
    0.01313517336f, 0.01307888143f, 0.01301889122f, 0.01295536757f,
    0.01288848184f, 0.01281840634f, 0.01274531893f, 0.01266939752f,
    0.0125908237f, 0.01250977721f, 0.01242643595f, 0.01234097779f,
    0.01225357689f, 0.01216440555f, 0.01207363233f, 0.01198141929f,
    0.01188792568f, 0.0117933061f, 0.01169770677f, 0.01160127111f,
    0.01150413603f, 0.01140643191f, 0.01130828168f, 0.01120980456f,
    0.01111111138f, 0.01101230737f, 0.01108513959f, 0.01115665678f,
    0.01122674625f, 0.01129528973f, 0.01136216894f, 0.01142726559f,
    0.01149045862f, 0.01155162696f, 0.01161065139f, 0.01166741177f,
    0.01172179077f, 0.01177367195f, 0.01182294171f, 0.01186948828f,
    0.01191320643f, 0.0119539937f, 0.01199175231f, 0.01202639099f,
    0.01205782313f, 0.01208597142f, 0.01211076323f, 0.01213213522f,
    0.01215003151f, 0.01216440555f, 0.01217522006f, 0.0121824462f,
    0.01218606345f, 0.01218606345f, 0.0121824462f, 0.01217522006f,
    0.01216440555f, 0.01215003151f, 0.01213213522f, 0.01211076323f,
    0.01208597142f, 0.01205782313f, 0.01202639099f, 0.01199175231f,
    0.0119539937f, 0.01191320643f, 0.01186948828f, 0.01182294171f,
    0.01177367195f, 0.01172179077f, 0.01166741177f, 0.01161065139f,
    0.01155162696f, 0.01149045862f, 0.01142726559f, 0.01136216894f,
    0.01129528973f, 0.01122674625f, 0.01115665678f, 0.01108513959f,
    0.01113450434f, 0.01123241056f, 0.01133003552f, 0.01142726559f,
    0.01152398065f, 0.01162005402f, 0.0117153544f, 0.01180974208f,
    0.0119030755f, 0.01199520286f, 0.01208597142f, 0.01217522006f,
    0.01226278674f, 0.01234850287f, 0.01243219618f, 0.01251369435f,
    0.01259282045f, 0.01266939752f, 0.0127432486f, 0.01281419583f,
    0.01288206317f, 0.01294667926f, 0.01300787181f, 0.01306547876f,
    0.01311933808f, 0.01316929981f, 0.01321521774f, 0.01325695775f,
    0.0132943932f, 0.01332741138f, 0.01335590892f, 0.01337979734f,
    0.01339900028f, 0.0134134572f, 0.01342312153f, 0.01342796069f,
    0.01342796069f, 0.01342312153f, 0.0134134572f, 0.01339900028f,
    0.01337979734f, 0.01335590892f, 0.01332741138f, 0.0132943932f,
    0.01325695775f, 0.01321521774f, 0.01316929981f, 0.01311933808f,
    0.01306547876f, 0.01300787181f, 0.01294667926f, 0.01288206317f,
    0.01281419583f, 0.0127432486f, 0.01266939752f, 0.01259282045f,
    0.01251369435f, 0.01243219618f, 0.01234850287f, 0.01226278674f,
    0.01217522006f, 0.01208597142f, 0.01199520286f, 0.0119030755f,
    0.01180974208f, 0.0117153544f, 0.01162005402f, 0.01152398065f,
    0.01142726559f, 0.01133003552f, 0.01123241056f, 0.01113450434f,
    0.0110364249f, 0.01111111138f, 0.01118453499f, 0.01125658024f,
    0.01132712793f, 0.0113960579f, 0.01146324724f, 0.01152857486f,
    0.01159191411f, 0.01165314391f, 0.01171213947f, 0.01176877879f,
    0.01182294171f, 0.01187450811f, 0.01192336436f, 0.01196939778f,
    0.01201249938f, 0.01205256768f, 0.01208950393f, 0.01212321594f,
    0.0121536199f, 0.0121806385f, 0.01220420003f, 0.01222424489f,
    0.01224071812f, 0.01225357689f, 0.01226278674f, 0.01226832252f,
    0.01227016933f, 0.01226832252f, 0.01226278674f, 0.01225357689f,
    0.01224071812f, 0.01222424489f, 0.01220420003f, 0.0121806385f,
    0.0121536199f, 0.01212321594f, 0.01208950393f, 0.01205256768f,
    0.01201249938f, 0.01196939778f, 0.01192336436f, 0.01187450811f,
    0.01182294171f, 0.01176877879f, 0.01171213947f, 0.01165314391f,
    0.01159191411f, 0.01152857486f, 0.01146324724f, 0.0113960579f,
    0.01132712793f, 0.01125658024f, 0.01118453499f, 0.01111111138f,
    0.01115526911f, 0.01125230361f, 0.01134899072f, 0.01144521404f,
    0.01154085156f, 0.01163577568f, 0.0117298523f, 0.01182294171f,
    0.01191489771f, 0.01200557221f, 0.01209480781f, 0.0121824462f,
    0.01226832252f, 0.01235227007f, 0.01243411843f, 0.01251369435f,
    0.0125908237f, 0.0126653323f, 0.01273704506f, 0.01280578785f,
    0.01287138835f, 0.01293367799f, 0.01299249288f, 0.01304767188f,
    0.01309906319f, 0.01314651966f, 0.01318990346f, 0.013229087f,
    0.01326395292f, 0.0132943932f, 0.01332031563f, 0.01334163733f,
    0.01335829217f, 0.01337022707f, 0.01337740291f, 0.01337979734f,
    0.01337740291f, 0.01337022707f, 0.01335829217f, 0.01334163733f,
    0.01332031563f, 0.0132943932f, 0.01326395292f, 0.013229087f,
    0.01318990346f, 0.01314651966f, 0.01309906319f, 0.01304767188f,
    0.01299249288f, 0.01293367799f, 0.01287138835f, 0.01280578785f,
    0.01273704506f, 0.0126653323f, 0.0125908237f, 0.01251369435f,
    0.01243411843f, 0.01235227007f, 0.01226832252f, 0.0121824462f,
    0.01209480781f, 0.01200557221f, 0.01191489771f, 0.01182294171f,
    0.0117298523f, 0.01163577568f, 0.01154085156f, 0.01144521404f,
    0.01134899072f, 0.01125230361f, 0.01115526911f, 0.01105799619f,
    0.01113450434f, 0.01120980456f, 0.01128377859f, 0.01135630626f,
    0.01142726559f, 0.01149653178f, 0.01156397816f, 0.01162947994f,
    0.01169290766f, 0.0117541356f, 0.01181303803f, 0.01186948828f,
    0.01192336436f, 0.0119745452f, 0.01202291343f, 0.01206835546f,
    0.01211076323f, 0.01215003151f, 0.01218606345f, 0.01221876871f,
    0.0122480616f, 0.01227386575f, 0.01229611505f, 0.01231474802f,
    0.01232971624f, 0.01234097779f, 0.01234850287f, 0.01235227007f,
    0.01235227007f, 0.01234850287f, 0.01234097779f, 0.01232971624f,
    0.01231474802f, 0.01229611505f, 0.01227386575f, 0.0122480616f,
    0.01221876871f, 0.01218606345f, 0.01215003151f, 0.01211076323f,
    0.01206835546f, 0.01202291343f, 0.0119745452f, 0.01192336436f,
    0.01186948828f, 0.01181303803f, 0.0117541356f, 0.01169290766f,
    0.01162947994f, 0.01156397816f, 0.01149653178f, 0.01142726559f,
    0.01135630626f, 0.01128377859f, 0.01120980456f, 0.01113450434f,
    0.01117335912f, 0.01126943901f, 0.01136510447f, 0.01146023627f,
    0.0115547115f, 0.01164839976f, 0.011741166f, 0.01183286961f,
    0.01192336436f, 0.01201249938f, 0.01210011914f, 0.01218606345f,
    0.01227016933f, 0.01235227007f, 0.01243219618f, 0.01250977721f,
    0.01258483995f, 0.01265721396f, 0.01272672601f, 0.01279320568f,
    0.01285648718f, 0.01291640475f, 0.0129727982f, 0.01302551571f,
    0.01307440922f, 0.01311933808f, 0.01316017378f, 0.01319679338f,
    0.013229087f, 0.01325695775f, 0.01328031812f, 0.01329909544f,
    0.01331323106f, 0.01332267933f, 0.01332741138f, 0.01332741138f,
    0.01332267933f, 0.01331323106f, 0.01329909544f, 0.01328031812f,
    0.01325695775f, 0.013229087f, 0.01319679338f, 0.01316017378f,
    0.01311933808f, 0.01307440922f, 0.01302551571f, 0.0129727982f,
    0.01291640475f, 0.01285648718f, 0.01279320568f, 0.01272672601f,
    0.01265721396f, 0.01258483995f, 0.01250977721f, 0.01243219618f,
    0.01235227007f, 0.01227016933f, 0.01218606345f, 0.01210011914f,
    0.01201249938f, 0.01192336436f, 0.01183286961f, 0.011741166f,
    0.01164839976f, 0.0115547115f, 0.01146023627f, 0.01136510447f,
    0.01126943901f, 0.01117335912f, 0.01107697561f, 0.01115526911f,
    0.01123241056f, 0.01130828168f, 0.01138276048f, 0.01145572308f,
    0.01152704284f, 0.01159659028f, 0.0116642369f, 0.0117298523f,
    0.0117933061f, 0.01185446698f, 0.01191320643f, 0.01196939778f,
    0.01202291343f, 0.01207363233f, 0.01212143432f, 0.01216620672f,
    0.01220783778f, 0.0122462241f, 0.01228126884f, 0.01231288072f,
    0.01234097779f, 0.01236548461f, 0.01238633506f, 0.01240347326f,
    0.01241685264f, 0.01242643595f, 0.01243219618f, 0.01243411843f,
    0.01243219618f, 0.01242643595f, 0.01241685264f, 0.01240347326f,
    0.01238633506f, 0.01236548461f, 0.01234097779f, 0.01231288072f,
    0.01228126884f, 0.0122462241f, 0.01220783778f, 0.01216620672f,
    0.01212143432f, 0.01207363233f, 0.01202291343f, 0.01196939778f,
    0.01191320643f, 0.01185446698f, 0.0117933061f, 0.0117298523f,
    0.0116642369f, 0.01159659028f, 0.01152704284f, 0.01145572308f,
    0.01138276048f, 0.01130828168f, 0.01123241056f, 0.01115526911f,
    0.01118873432f, 0.01128377859f, 0.01137833856f, 0.01147229597f,
    0.01156552508f, 0.01165789459f, 0.01174926758f, 0.01183950249f,
    0.01192845311f, 0.01201596763f, 0.01210189145f, 0.01218606345f,
    0.01226832252f, 0.01234850287f, 0.01242643595f, 0.01250195317f,
    0.01257488597f, 0.01264506485f, 0.01271232124f, 0.01277648844f,
    0.01283740439f, 0.0128949089f, 0.01294884924f, 0.01299907733f,
    0.0130454516f, 0.01308783889f, 0.01312611811f, 0.01316017378f,
    0.01318990346f, 0.01321521774f, 0.01323603839f, 0.01325230021f,
    0.01326395292f, 0.01327095926f, 0.01327329688f, 0.01327095926f,
    0.01326395292f, 0.01325230021f, 0.01323603839f, 0.01321521774f,
    0.01318990346f, 0.01316017378f, 0.01312611811f, 0.01308783889f,
    0.0130454516f, 0.01299907733f, 0.01294884924f, 0.0128949089f,
    0.01283740439f, 0.01277648844f, 0.01271232124f, 0.01264506485f,
    0.01257488597f, 0.01250195317f, 0.01242643595f, 0.01234850287f,
    0.01226832252f, 0.01218606345f, 0.01210189145f, 0.01201596763f,
    0.01192845311f, 0.01183950249f, 0.01174926758f, 0.01165789459f,
    0.01156552508f, 0.01147229597f, 0.01137833856f, 0.01128377859f,
    0.01118873432f, 0.01109332126f, 0.01117335912f, 0.01125230361f,
    0.01133003552f, 0.01140643191f, 0.01148136612f, 0.0115547115f,
    0.01162633486f, 0.01169610675f, 0.01176389214f, 0.0118295569f,
    0.01189296879f, 0.0119539937f, 0.01201249938f, 0.01206835546f,
    0.01212143432f, 0.01217161212f, 0.01221876871f, 0.01226278674f,
    0.01230355818f, 0.01234097779f, 0.01237494871f, 0.01240538247f,
    0.01243219618f, 0.01245531905f, 0.01247468684f, 0.01249024551f,
    0.01250195317f, 0.01250977721f, 0.01251369435f, 0.01251369435f,
    0.01250977721f, 0.01250195317f, 0.01249024551f, 0.01247468684f,
    0.01245531905f, 0.01243219618f, 0.01240538247f, 0.01237494871f,
    0.01234097779f, 0.01230355818f, 0.01226278674f, 0.01221876871f,
    0.01217161212f, 0.01212143432f, 0.01206835546f, 0.01201249938f,
    0.0119539937f, 0.01189296879f, 0.0118295569f, 0.01176389214f,
    0.01169610675f, 0.01162633486f, 0.0115547115f, 0.01148136612f,
    0.01140643191f, 0.01133003552f, 0.01125230361f, 0.01117335912f,
    0.01120136213f, 0.01129528973f, 0.01138866507f, 0.01148136612f,
    0.0115732681f, 0.0116642369f, 0.0117541356f, 0.01184282266f,
    0.01193015091f, 0.01201596763f, 0.01210011914f, 0.0121824462f,
    0.01226278674f, 0.01234097779f, 0.01241685264f, 0.01249024551f,
    0.01256099064f, 0.01262892038f, 0.01269387174f, 0.01275568269f,
    0.01281419583f, 0.01286925655f, 0.01292071585f, 0.01296843402f,
    0.01301227603f, 0.01305211708f, 0.01308783889f, 0.01311933808f,
    0.01314651966f, 0.01316929981f, 0.01318760961f, 0.01320139226f,
    0.0132106049f, 0.01321521774f, 0.01321521774f, 0.0132106049f,
    0.01320139226f, 0.01318760961f, 0.01316929981f, 0.01314651966f,
    0.01311933808f, 0.01308783889f, 0.01305211708f, 0.01301227603f,
    0.01296843402f, 0.01292071585f, 0.01286925655f, 0.01281419583f,
    0.01275568269f, 0.01269387174f, 0.01262892038f, 0.01256099064f,
    0.01249024551f, 0.01241685264f, 0.01234097779f, 0.01226278674f,
    0.0121824462f, 0.01210011914f, 0.01201596763f, 0.01193015091f,
    0.01184282266f, 0.0117541356f, 0.0116642369f, 0.0115732681f,
    0.01148136612f, 0.01138866507f, 0.01129528973f, 0.01120136213f,
    0.01110699773f, 0.01118873432f, 0.01126943901f, 0.01134899072f,
    0.01142726559f, 0.01150413603f, 0.0115794735f, 0.01165314391f,
    0.01172501314f, 0.01179494616f, 0.01186280511f, 0.01192845311f,
    0.01199175231f, 0.01205256768f, 0.01211076323f, 0.01216620672f,
    0.01221876871f, 0.01226832252f, 0.01231474802f, 0.01235792786f,
    0.01239775307f, 0.01243411843f, 0.01246692892f, 0.01249609515f,
    0.01252153981f, 0.0125431912f, 0.01256099064f, 0.01257488597f,
    0.01258483995f, 0.0125908237f, 0.01259282045f, 0.0125908237f,
    0.01258483995f, 0.01257488597f, 0.01256099064f, 0.0125431912f,
    0.01252153981f, 0.01249609515f, 0.01246692892f, 0.01243411843f,
    0.01239775307f, 0.01235792786f, 0.01231474802f, 0.01226832252f,
    0.01221876871f, 0.01216620672f, 0.01211076323f, 0.01205256768f,
    0.01199175231f, 0.01192845311f, 0.01186280511f, 0.01179494616f,
    0.01172501314f, 0.01165314391f, 0.0115794735f, 0.01150413603f,
    0.01142726559f, 0.01134899072f, 0.01126943901f, 0.01118873432f,
    0.01121121366f, 0.01130394638f, 0.0113960579f, 0.0114874253f,
    0.01157792099f, 0.01166741177f, 0.01175575983f, 0.01184282266f,
    0.01192845311f, 0.01201249938f, 0.01209480781f, 0.01217522006f,
    0.01225357689f, 0.01232971624f, 0.01240347326f, 0.01247468684f,
    0.0125431912f, 0.01260882709f, 0.01267143246f, 0.01273085084f,
    0.0127869295f, 0.01283952035f, 0.01288848184f, 0.01293367799f,
    0.01297498215f, 0.01301227603f, 0.0130454516f, 0.01307440922f,
    0.01309906319f, 0.01311933808f, 0.01313517336f, 0.01314651966f,
    0.01315334067f, 0.01315561775f, 0.01315334067f, 0.01314651966f,
    0.01313517336f, 0.01311933808f, 0.01309906319f, 0.01307440922f,
    0.0130454516f, 0.01301227603f, 0.01297498215f, 0.01293367799f,
    0.01288848184f, 0.01283952035f, 0.0127869295f, 0.01273085084f,
    0.01267143246f, 0.01260882709f, 0.0125431912f, 0.01247468684f,
    0.01240347326f, 0.01232971624f, 0.01225357689f, 0.01217522006f,
    0.01209480781f, 0.01201249938f, 0.01192845311f, 0.01184282266f,
    0.01175575983f, 0.01166741177f, 0.01157792099f, 0.0114874253f,
    0.0113960579f, 0.01130394638f, 0.01121121366f, 0.01111797616f,
    0.01120136213f, 0.01128377859f, 0.01136510447f, 0.01144521404f,
    0.01152398065f, 0.01160127111f, 0.01167695317f, 0.01175088901f,
    0.01182294171f, 0.01189296879f, 0.0119608324f, 0.01202639099f,
    0.01208950393f, 0.01215003151f, 0.01220783778f, 0.01226278674f,
    0.01231474802f, 0.01236359403f, 0.01240920182f, 0.01245145593f,
    0.01249024551f, 0.01252546813f, 0.01255702879f, 0.01258483995f,
    0.01260882709f, 0.01262892038f, 0.01264506485f, 0.01265721396f,
    0.0126653323f, 0.01266939752f, 0.01266939752f, 0.0126653323f,
    0.01265721396f, 0.01264506485f, 0.01262892038f, 0.01260882709f,
    0.01258483995f, 0.01255702879f, 0.01252546813f, 0.01249024551f,
    0.01245145593f, 0.01240920182f, 0.01236359403f, 0.01231474802f,
    0.01226278674f, 0.01220783778f, 0.01215003151f, 0.01208950393f,
    0.01202639099f, 0.0119608324f, 0.01189296879f, 0.01182294171f,
    0.01175088901f, 0.01167695317f, 0.01160127111f, 0.01152398065f,
    0.01144521404f, 0.01136510447f, 0.01128377859f, 0.01120136213f,
    0.01121826563f, 0.01130972803f, 0.01140050031f, 0.01149045862f,
    0.0115794735f, 0.01166741177f, 0.0117541356f, 0.01183950249f,
    0.01192336436f, 0.01200557221f, 0.01208597142f, 0.01216440555f,
    0.01224071812f, 0.01231474802f, 0.01238633506f, 0.01245531905f,
    0.01252153981f, 0.01258483995f, 0.01264506485f, 0.01270206179f,
    0.01275568269f, 0.01280578785f, 0.01285223942f, 0.0128949089f,
    0.01293367799f, 0.01296843402f, 0.01299907733f, 0.01302551571f,
    0.01304767188f, 0.01306547876f, 0.01307888143f, 0.01308783889f,
    0.01309232507f, 0.01309232507f, 0.01308783889f, 0.01307888143f,
    0.01306547876f, 0.01304767188f, 0.01302551571f, 0.01299907733f,
    0.01296843402f, 0.01293367799f, 0.0128949089f, 0.01285223942f,
    0.01280578785f, 0.01275568269f, 0.01270206179f, 0.01264506485f,
    0.01258483995f, 0.01252153981f, 0.01245531905f, 0.01238633506f,
    0.01231474802f, 0.01224071812f, 0.01216440555f, 0.01208597142f,
    0.01200557221f, 0.01192336436f, 0.01183950249f, 0.0117541356f,
    0.01166741177f, 0.0115794735f, 0.01149045862f, 0.01140050031f,
    0.01130972803f, 0.01121826563f, 0.0111262314f, 0.01121121366f,
    0.01129528973f, 0.01137833856f, 0.01146023627f, 0.01154085156f,
    0.01162005402f, 0.01169770677f, 0.01177367195f, 0.01184780896f,
    0.01191997528f, 0.01199002843f, 0.01205782313f, 0.01212321594f,
    0.01218606345f, 0.0122462241f, 0.01230355818f, 0.01235792786f,
    0.01240920182f, 0.01245725155f, 0.01250195317f, 0.0125431912f,
    0.01258085575f, 0.01261484437f, 0.01264506485f, 0.01267143246f,
    0.01269387174f, 0.01271232124f, 0.01272672601f, 0.01273704506f,
    0.0127432486f, 0.01274531893f, 0.0127432486f, 0.01273704506f,
    0.01272672601f, 0.01271232124f, 0.01269387174f, 0.01267143246f,
    0.01264506485f, 0.01261484437f, 0.01258085575f, 0.0125431912f,
    0.01250195317f, 0.01245725155f, 0.01240920182f, 0.01235792786f,
    0.01230355818f, 0.0122462241f, 0.01218606345f, 0.01212321594f,
    0.01205782313f, 0.01199002843f, 0.01191997528f, 0.01184780896f,
    0.01177367195f, 0.01169770677f, 0.01162005402f, 0.01154085156f,
    0.01146023627f, 0.01137833856f, 0.01129528973f, 0.01121121366f,
    0.01122250315f, 0.01131262258f, 0.01140198205f, 0.01149045862f,
    0.01157792099f, 0.0116642369f, 0.01174926758f, 0.01183286961f,
    0.01191489771f, 0.01199520286f, 0.01207363233f, 0.01215003151f,
    0.01222424489f, 0.01229611505f, 0.01236548461f, 0.01243219618f,
    0.01249609515f, 0.01255702879f, 0.01261484437f, 0.01266939752f,
    0.01272054669f, 0.01276815403f, 0.01281209197f, 0.01285223942f,
    0.01288848184f, 0.01292071585f, 0.01294884924f, 0.0129727982f,
    0.01299249288f, 0.01300787181f, 0.01301889122f, 0.01302551571f,
    0.01302772667f, 0.01302551571f, 0.01301889122f, 0.01300787181f,
    0.01299249288f, 0.0129727982f, 0.01294884924f, 0.01292071585f,
    0.01288848184f, 0.01285223942f, 0.01281209197f, 0.01276815403f,
    0.01272054669f, 0.01266939752f, 0.01261484437f, 0.01255702879f,
    0.01249609515f, 0.01243219618f, 0.01236548461f, 0.01229611505f,
    0.01222424489f, 0.01215003151f, 0.01207363233f, 0.01199520286f,
    0.01191489771f, 0.01183286961f, 0.01174926758f, 0.0116642369f,
    0.01157792099f, 0.01149045862f, 0.01140198205f, 0.01131262258f,
    0.01122250315f, 0.01113174483f, 0.01121826563f, 0.01130394638f,
    0.01138866507f, 0.01147229597f, 0.0115547115f, 0.01163577568f,
    0.0117153544f, 0.0117933061f, 0.01186948828f, 0.01194375753f,
    0.01201596763f, 0.01208597142f, 0.0121536199f, 0.01221876871f,
    0.01228126884f, 0.01234097779f, 0.01239775307f, 0.01245145593f,
    0.01250195317f, 0.01254911628f, 0.01259282045f, 0.01263295114f,
    0.01266939752f, 0.01270206179f, 0.01273085084f, 0.01275568269f,
    0.01277648844f, 0.01279320568f, 0.01280578785f, 0.01281419583f,
    0.01281840634f, 0.01281840634f, 0.01281419583f, 0.01280578785f,
    0.01279320568f, 0.01277648844f, 0.01275568269f, 0.01273085084f,
    0.01270206179f, 0.01266939752f, 0.01263295114f, 0.01259282045f,
    0.01254911628f, 0.01250195317f, 0.01245145593f, 0.01239775307f,
    0.01234097779f, 0.01228126884f, 0.01221876871f, 0.0121536199f,
    0.01208597142f, 0.01201596763f, 0.01194375753f, 0.01186948828f,
    0.0117933061f, 0.0117153544f, 0.01163577568f, 0.0115547115f,
    0.01147229597f, 0.01138866507f, 0.01130394638f, 0.01121826563f,
    0.0112239169f, 0.01131262258f, 0.01140050031f, 0.0114874253f,
    0.0115732681f, 0.01165789459f, 0.011741166f, 0.01182294171f,
    0.0119030755f, 0.01198141929f, 0.01205782313f, 0.01213213522f,
    0.01220420003f, 0.01227386575f, 0.01234097779f, 0.01240538247f,
    0.01246692892f, 0.01252546813f, 0.01258085575f, 0.01263295114f,
    0.0126816174f, 0.01272672601f, 0.01276815403f, 0.01280578785f,
    0.01283952035f, 0.01286925655f, 0.0128949089f, 0.01291640475f,
    0.01293367799f, 0.01294667926f, 0.01295536757f, 0.0129597187f,
    0.0129597187f, 0.01295536757f, 0.01294667926f, 0.01293367799f,
    0.01291640475f, 0.0128949089f, 0.01286925655f, 0.01283952035f,
    0.01280578785f, 0.01276815403f, 0.01272672601f, 0.0126816174f,
    0.01263295114f, 0.01258085575f, 0.01252546813f, 0.01246692892f,
    0.01240538247f, 0.01234097779f, 0.01227386575f, 0.01220420003f,
    0.01213213522f, 0.01205782313f, 0.01198141929f, 0.0119030755f,
    0.01182294171f, 0.011741166f, 0.01165789459f, 0.0115732681f,
    0.0114874253f, 0.01140050031f, 0.01131262258f, 0.0112239169f,
    0.01113450434f, 0.01122250315f, 0.01130972803f, 0.0113960579f,
    0.01148136612f, 0.01156552508f, 0.01164839976f, 0.0117298523f,
    0.01180974208f, 0.01188792568f, 0.01196425594f, 0.01203858573f,
    0.01211076323f, 0.0121806385f, 0.0122480616f, 0.01231288072f,
    0.01237494871f, 0.01243411843f, 0.01249024551f, 0.0125431912f,
    0.01259282045f, 0.01263900381f, 0.0126816174f, 0.01272054669f,
    0.01275568269f, 0.0127869295f, 0.01281419583f, 0.01283740439f,
    0.01285648718f, 0.01287138835f, 0.01288206317f, 0.01288848184f,
    0.01289062295f, 0.01288848184f, 0.01288206317f, 0.01287138835f,
    0.01285648718f, 0.01283740439f, 0.01281419583f, 0.0127869295f,
    0.01275568269f, 0.01272054669f, 0.0126816174f, 0.01263900381f,
    0.01259282045f, 0.0125431912f, 0.01249024551f, 0.01243411843f,
    0.01237494871f, 0.01231288072f, 0.0122480616f, 0.0121806385f,
    0.01211076323f, 0.01203858573f, 0.01196425594f, 0.01188792568f,
    0.01180974208f, 0.0117298523f, 0.01164839976f, 0.01156552508f,
    0.01148136612f, 0.0113960579f, 0.01130972803f, 0.01122250315f
};

} // namespace math
} // namespace OPENVDB_VERSION_NAME
} // namespace openvdb

// Copyright (c) 2012-2018 DreamWorks Animation LLC
// All rights reserved. This software is distributed under the
// Mozilla Public License 2.0 ( http://www.mozilla.org/MPL/2.0/ )
