%define name      libprintsys
%define version   0.6
%define rel       1
%define prefix    /usr

Name: %{name}
Version: %{version}
Release: %{rel}
Summary: Library to provide standard API for print system functions
License: LGPL
Group: System Environment/Libraries
BuildRoot: /tmp/%{name}-root

Source0: %{name}-%{version}.tar.gz

%package devel
Summary: Headers and additional files to develop programs using libprintsys.
Group: Development/Libraries
Requires: libprintsys

%description
Many programs print by execing /usr/bin/lpr, and get printer info by manually
reading in /etc/printcap.  libprintsys provides a standard API for performing
ehese functions.

%description devel
To develop programs based upon the libprintsys library, the system needs to
have these header and object files available for creating the executables.

%prep
%setup

%build
./configure --prefix=%{_prefix} \
            --exec-prefix=%{_exec_prefix} \
            --bindir=%{_bindir} \
            --sbindir=%{_sbindir} \
            --sysconfdir=%{_sysconfdir} \
            --datadir=%{_datadir} \
            --includedir=%{_includedir} \
            --libdir=%{_libdir} \
            --libexecdir=%{_libexecdir} \
            --localstatedir=%{_localstatedir} \
            --sharedstatedir=%{_sharedstatedir} \
            --mandir=%{_mandir} \
            --infodir=%{_infodir}
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{_prefix}
make DESTDIR="$RPM_BUILD_ROOT" install

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-, root, root)
%{_bindir}/pcap
%{_libdir}/*.so.*
%doc README ChangeLog AUTHORS COPYING NEWS TODO new-functions-map

%files devel
%defattr(-, root, root)
%{_libdir}/lib*.so
%{_libdir}/*.a
%{_libdir}/*.la
%{_includedir}/*

%changelog
* Fri Jun 29 2001 Ben Woodard <ben@valinux.com>
- dropped the release down 1 because the version increased

* Thu Jun 28 2001 Ben Woodard <ben@valinux.com>
- Forgot to include pcap.

* Thu May 24 2001 Ben Woodard <ben@valinux.com>
- fixed a typo that made the devel package depend on libppd rather than 
  libprintsys.

* Wed May 23 2001 Nick Moffitt <nick@valinux.com>
- imported libppd spec file into libprintsys.
