/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.NameTest;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.Pattern;
import org.xml.sax.SAXException;

public class NamedNodePattern
extends Pattern {
    private NameTest nameTest;
    private int nodeType;

    public NamedNodePattern(int n, NameTest nameTest) {
        this.nameTest = nameTest;
        this.nodeType = n;
    }

    public boolean matches(NodeInfo nodeInfo, Context context) throws SAXException {
        return nodeInfo.isa(this.nodeType) && this.nameTest.isNameOf(nodeInfo);
    }

    public int getType() {
        return this.nodeType;
    }

    public Name getName() {
        if (this.nameTest instanceof Name) {
            return (Name)this.nameTest;
        }
        return null;
    }

    public String toString() {
        String string;
        switch (this.nodeType) {
            case 2: {
                string = "@" + this.nameTest.toString();
                break;
            }
            case 1: {
                string = this.nameTest.toString();
                break;
            }
            default: {
                string = "???";
            }
        }
        return string;
    }

    public boolean isRelative() {
        return false;
    }

    public double getDefaultPriority() {
        return this.nameTest.getDefaultPriority();
    }
}

