/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import java.io.Writer;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DOMEmitter
implements Emitter {
    protected OutputDetails outputDetails;
    protected Node currentNode;
    protected Document document;
    protected boolean canNormalize = true;
    private String[] namespaces = new String[30];
    private int namespacesSize = 0;
    private int[] namespaceStack = new int[100];
    private int nsStackTop = 0;
    private int nsCount = 0;

    public void setWriter(Writer writer) {
    }

    public void setCharacterSet(CharacterSet characterSet) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        int n = this.namespacesSize - 2;
        while (n >= 0) {
            if (this.namespaces[n] == string) {
                if (this.namespaces[n + 1] != string2) break;
                return;
            }
            n -= 2;
        }
        if (string == "" && string2 == "") {
            boolean bl = false;
            int n2 = this.namespacesSize - 2;
            while (n2 >= 0) {
                if (this.namespaces[n2] == "" && this.namespaces[n2 + 1] != "") {
                    bl = true;
                }
                n2 -= 2;
            }
            if (!bl) {
                return;
            }
        }
        if (this.namespacesSize + 2 >= this.namespaces.length) {
            String[] stringArray = new String[this.namespacesSize * 2];
            System.arraycopy(this.namespaces, 0, stringArray, 0, this.namespacesSize);
            this.namespaces = stringArray;
        }
        this.namespaces[this.namespacesSize++] = string;
        this.namespaces[this.namespacesSize++] = string2;
        ++this.nsCount;
    }

    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        if (name.getPrefix() == "" && name.getURI() == "") {
            this.startPrefixMapping("", "");
        }
        String string = name.getDisplayName();
        try {
            Object object;
            Element element = this.document.createElement(string);
            this.currentNode.appendChild(element);
            this.currentNode = element;
            int n = this.namespacesSize - this.nsCount * 2;
            while (n < this.namespacesSize) {
                object = this.namespaces[n];
                String string2 = this.namespaces[n + 1];
                if (!string2.equals("http://www.w3.org/XML/1998/namespace")) {
                    if (((String)object).equals("")) {
                        element.setAttribute("xmlns", string2);
                    } else {
                        element.setAttribute("xmlns:" + (String)object, string2);
                    }
                }
                n += 2;
            }
            if (this.nsStackTop >= this.namespaceStack.length) {
                object = new int[this.nsStackTop * 2];
                System.arraycopy(this.namespaceStack, 0, object, 0, this.nsStackTop);
                this.namespaceStack = (int[])object;
            }
            this.namespaceStack[this.nsStackTop++] = this.nsCount;
            this.nsCount = 0;
            int n2 = 0;
            while (n2 < attributeCollection.getLength()) {
                element.setAttribute(attributeCollection.getExpandedName(n2).getDisplayName(), attributeCollection.getValue(n2));
                ++n2;
            }
        }
        catch (DOMException dOMException) {
            throw new SAXException(dOMException);
        }
    }

    public void endElement(Name name) throws SAXException {
        if (this.nsStackTop-- == 0) {
            throw new SAXException("Attempt to output end tag with no matching start tag");
        }
        int n = this.namespaceStack[this.nsStackTop];
        this.namespacesSize -= n * 2;
        if (this.canNormalize) {
            try {
                this.currentNode.normalize();
            }
            catch (Throwable throwable) {
                this.canNormalize = false;
            }
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            Text text = this.document.createTextNode(new String(cArray, n, n2));
            this.currentNode.appendChild(text);
        }
        catch (DOMException dOMException) {
            throw new SAXException(dOMException);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        try {
            ProcessingInstruction processingInstruction = this.document.createProcessingInstruction(string, string2);
            this.currentNode.appendChild(processingInstruction);
        }
        catch (DOMException dOMException) {
            throw new SAXException(dOMException);
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        try {
            Comment comment = this.document.createComment(new String(cArray, n, n2));
            this.currentNode.appendChild(comment);
        }
        catch (DOMException dOMException) {
            throw new SAXException(dOMException);
        }
    }

    public void setOutputDetails(OutputDetails outputDetails) {
        this.outputDetails = outputDetails;
        this.currentNode = outputDetails.getDOMNode();
        this.document = this.currentNode instanceof Document ? (Document)this.currentNode : this.currentNode.getOwnerDocument();
    }

    public void setEscaping(boolean bl) {
    }
}

