/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.DecimalFormatManager;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Vector;
import org.xml.sax.SAXException;

public class FormatNumber
extends Function {
    private DecimalFormat decimalFormat = new DecimalFormat();
    private String previousFormat = "[null]";
    private DecimalFormatSymbols previousDFS = null;

    public String getName() {
        return "format-number";
    }

    public int getDataType() {
        return 3;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        DecimalFormatSymbols decimalFormatSymbols;
        int n = this.checkArgumentCount(2, 3);
        Value value = (Value)vector.elementAt(0);
        Value value2 = (Value)vector.elementAt(1);
        double d = value.asNumber();
        String string = value2.asString();
        DecimalFormatManager decimalFormatManager = context.getController().getDecimalFormatManager();
        if (n == 2) {
            decimalFormatSymbols = decimalFormatManager.getDefaultDecimalFormat();
        } else {
            Value value3 = (Value)vector.elementAt(2);
            String string2 = this.getStaticContext().makeName(value3.asString(), false).getAbsoluteName();
            decimalFormatSymbols = decimalFormatManager.getNamedDecimalFormat(string2);
            if (decimalFormatSymbols == null) {
                throw new SAXException("format-number function: decimal-format " + string2 + " not registered");
            }
        }
        return new StringValue(this.formatNumber(d, string, decimalFormatSymbols));
    }

    public String formatNumber(double d, String string, DecimalFormatSymbols decimalFormatSymbols) throws SAXException {
        try {
            DecimalFormat decimalFormat = this.decimalFormat;
            if (decimalFormatSymbols != this.previousDFS || !string.equals(this.previousFormat)) {
                decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
                decimalFormat.applyLocalizedPattern(string);
                this.previousDFS = decimalFormatSymbols;
                this.previousFormat = string;
            }
            return decimalFormat.format(d);
        }
        catch (Exception exception) {
            throw new SAXException("Unable to interpret format pattern " + string + "(" + exception + ")");
        }
    }
}

