/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Bindery;
import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.ParameterSet;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.style.Procedure;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLParam;
import org.xml.sax.SAXException;

public class SAXONFunction
extends StyleElement {
    Name functionName = null;
    Procedure procedure = new Procedure();
    private OutputDetails disallowedOutput = new OutputDetails();

    public void prepareAttributes() throws SAXException {
        this.disallowedOutput.setMethod("saxon:error");
        String[] stringArray = new String[]{"name"};
        this.allowAttributes(stringArray);
        this.functionName = this.getFunctionName();
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
    }

    public void preprocess() throws SAXException {
        this.getPrincipalStyleSheet().allocateLocalSlots(this.procedure.getNumberOfVariables());
    }

    public void process(Context context) throws SAXException {
    }

    public Procedure getProcedure() {
        return this.procedure;
    }

    public Name getFunctionName() throws SAXException {
        if (this.functionName == null) {
            String string = this.attributeList.getValue("name");
            if (string == null) {
                this.reportAbsence("name");
            }
            this.functionName = new Name(string, this, false);
            if (this.functionName.getURI() == "") {
                throw this.styleError("Extension function name must have a non-null namespace URI");
            }
        }
        return this.functionName;
    }

    public String getNthParameter(int n) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        int n2 = 0;
        while (nodeInfo != null) {
            if (nodeInfo instanceof XSLParam) {
                if (n2 == n) {
                    return ((XSLParam)nodeInfo).getVariableName();
                }
                ++n2;
            }
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        return null;
    }

    public Value call(ParameterSet parameterSet, Context context) throws SAXException {
        Object object;
        Bindery bindery = context.getBindery();
        bindery.openStackFrame(parameterSet);
        Controller controller = context.getController();
        controller.setNewOutputDetails(this.disallowedOutput);
        if (controller.isTracing()) {
            object = controller.getTraceListener();
            object.enter(this, context);
            this.processChildren(context);
            object.leave(this, context);
        } else {
            this.processChildren(context);
        }
        controller.resetOutputDetails();
        bindery.closeStackFrame();
        object = context.getReturnValue();
        if (object == null) {
            object = new StringValue("");
        }
        context.setReturnValue(null);
        return object;
    }
}

