// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1992,93,94,95,96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        iv3dvw.h
//
// Purpose:     interface to class HgIv3dViewer
//
// Created:     10 Jul 92   Keith Andrews, IICM (template)
//
// Changed:      5 Jun 96   Michael Pichler
//
// $Id: iv3dvw.h,v 1.6 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#ifndef harmony_scene_iv3dvw_h
#define harmony_scene_iv3dvw_h


#include "hg3dvw.h"


#include <InterViews/enter-scope.h>
class ApplicationWindow;
class Session;


//
// class HgIv3dViewer
//
// InterViews Hyper-G 3d Viewer.
// Used to display 3d documents, stored in sdf format.
//


class HgIv3dViewer: public Hg3dViewer
{
  public:
    HgIv3dViewer (HgViewerManager* manager, Session* session);
    virtual ~HgIv3dViewer ();
  
    // HgViewer
    virtual void load (                            // load document
      const char* doc,                             //   document info
      const char* anchors,                         //   source anchors
      const char* info = 0                         //   feedback for viewer manager
    );

    virtual int loadConnect (                      // load + connect to DocCache (via DcConnect)
      const char* doc, const char* anchors,        // as above
      const char* info
    );

    virtual void setLanguage (HgLanguage::Language);  // set language of user interface

    virtual void browse (                          // browse current document
      const char* dest = 0                         //   optional destination anchor
    );

    virtual void updateTitle ();        // show title in message line
    virtual void getLangField (         // extract language dependent field
      const char* field, const Object& obj, RString& fstring
    );

    virtual void iconify ();                       // window operations
    virtual void deiconify ();                     //   (self explanatory)
    virtual void moveto (float x, float y);
    // virtual void resize (float x, float y);
    virtual void map ();
    virtual void unmap ();
    virtual void raise ();
    virtual void lower ();

    // virtual void saveResources ();              // save X-defaults (not yet supported)

    // local
    void showScene (                               // show loaded scene
      int setsrcanchors = 1                        //   source anchors need not be set again
    );                                             //   when browse () is done without load ()
  
    void readingCompleted ();                      // beeing told that readInput completed
  
  protected:
    enum                                           // communication states
    { s_ready  = 0x0,  // ready
      s_load   = 0x1,  // got load
      s_browse = 0x2,  // got browse
      s_read   = 0x4,  // read data
      s_all    = 0x7   // got all -- show scene, then ready again
    };
    int state_;                                    // communication state

    RString browse_str_;                           // dest. anchors got from browse

    ApplicationWindow* appwin_;
};


#endif
