/*
 * splitdigest.h	Header file for splitdigest.
 * Copyright (c) 1994-1998 by Christopher Heng. All rights reserved.
 * You many not remove or alter any of the copyright notices and/or the
 * conditions for use and distribution.
 * See the file COPYING for additional conditions for use and distribution.
 * COPYING contains the GNU General Public License version 2.
 *
 * $Id: splitdigest.h,v 2.6 1998/03/30 13:18:26 chris Released $
 */

#if !defined(SPLITDIGEST_H_INCLUDED)
#define	SPLITDIGEST_H_INCLUDED

/* warning: you must include <stdio.h> before this file (it uses the	*/
/* FILE pointer)							*/

/* macros for the the configuration file and tables */
#if !defined(MAXCFTABLE)
#define MAXCFTABLE	128	/* should be more than enough */
#endif
#if !defined(DEFCONFIG)
#if defined(WIN32)
#define	DEFCONFIG	"splitdigest.config"
#elif defined(MSDOS)
#define	DEFCONFIG	"sdigest.cfg"
#else	/* UNIX and other systems */
#define DEFCONFIG	"/usr/local/lib/splitdigest.config"
#endif
#endif

/* macros for the compressor to use (obsolete - do not use) */
#if defined(MSDOS) || defined(WIN32)
#define DEFCOMPRESS	"/gzip"
#else	/* UNIX */
#define	DEFCOMPRESS	"/usr/bin/gzip"
#endif
#define	COMPRESSARG	"-9"
#define DEFTOCOMPRESS	0

/* you should not need to modify the items below this */

/* macros for files */
#define TEMPFILELEN	16	/* length of buffer for temp file */
#define TEMPLATE	"./sdXXXXXX"
#define	APPENDMODE	"a"
#define READMODE	"r"
#define WRITEMODE	"w"
#define MAXFILELEN	255	/* yeah, I know, should use the posix */
				/* functions and whatnot, but this IS */
				/* a quick and dirty program, you know. */

/* macro for line buffer */
#define MAXBUFFERLEN	1024	/* we can't cope with longer than this */
				/* (primitive!) */

/* usage message */
#define USAGESTR	"Usage: splitdigest [options] [file...]\n"\
			"Options include\n"\
			"\t-c\t\tCompress output file (obsolete).\n"\
			"\t-d <outdir>\tSpecify output directory.\n"\
			"\t-h\t\tDisplay usage.\n"\
			"\t-l\t\tPreserve Content-Length header.\n"\
			"\t-o <file>\tWrite all output to <file>. -o- write to stdout.\n"\
			"\t-t\t\tDo not compress output file (default - obsolete).\n"\
			"\t-v\t\tVerbose.\n"\
			"\t-C <file>\tSpecify configuration file to use.\n"\
			"\t-V\t\tShow version number and quit.\n"
#define SHUSAGESTR	"Usage: splitdigest [options] [file...]\n"\
			"Type \"splitdigest -h\" for more information.\n"

/* mail stuff */
#define	FROMFIELD	"From "

/* exit codes */
#define	EXIT_SIGINT	2

/* global variables */
extern char * pgmname ;
extern char * configfile ;
extern int compression ;
extern char * infilename ;
extern int kill_contentlen ;	/* 1 = remove Content-Length header */
extern char * output_filename ;
extern int pipe_output ;		/* 1 if the output is to go to stdout */
extern int verbose ;

/* function declarations */
void realcleanup ( void );
void uncatfile ( FILE * file );

#endif	/* SPLITDIGEST_H_INCLUDED */
